/* ------------------------------------------------------------------ */
/* REXXCC.CMD - a tiny REXX "compiler" (c) Bernd Schemmer 1994,1995   */
/*                                                                    */
/* Usage: REXXCC source TO target {WITH copyright} {/IExt} {/IDate}   */
/*               {/IVer} {/Overwrite} {/UseSource} {/LineCount=n}     */
/*                                                                    */
/* Author                                                             */
/*   Bernd Schemmer                                                   */
/*   Baeckerweg 48                                                    */
/*   60316 Frankfurt                                                  */
/*   Germany                                                          */
/*   CompuServe: 100104,613                                           */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/* IMPORTANT:                                                         */
/*                                                                    */
/* This program will only work if the Extended Attributes are OK!!!   */
/*                                                                    */
/* Description:                                                       */
/*                                                                    */
/* REXXCC "compiles" an OS/2 REXX program by substituting the source  */
/* code with any text. This is possible because the OS/2 REXX         */
/* interpreter stores a tokenized copy of each executed REXX program  */
/* in the EAs of the program. If you execute an OS/2 REXX program,    */
/* the OS/2 REXX interpreter first checks, if the tokenized copy in   */
/* the EAs is still valid and, if so, executes the tokenized copy     */
/* and ignores the source code.                                       */
/*                                                                    */
/* Compatiblity                                                       */
/*                                                                    */
/* Tested with OS/2 v2.1, OS/2 v2.1 and the Service Pack,             */
/* OS/2 v2.11, OS/2 v2.99 WARP BETA II, OS/2 Version 3 WARP for       */
/* Windows and OS/2 Version 3 WARP Fullpack.                          */
/* The REXX interpreter version of all of these OS/2 Versions is 4.00.*/
/* If you're using OO REXX, please see the notes in the section       */
/* 'Known limitations' below.                                         */
/*                                                                    */
/* Usage:                                                             */
/*                                                                    */
/* 1. execute your REXX file to get the token image of the            */
/* program                                                            */
/*                                                                    */
/* Note: You may call your program with the switch '//t' (yes, there  */
/*       are two slashes!) to force the creation of the token         */
/*       image of your program without executing it.                  */
/*                                                                    */
/* 2. call REXXCC to "compile" your REXX file.                        */
/* The syntax for REXXCC is:                                          */
/*                                                                    */
/*   REXXCC source TO target {WITH copyrightFile} {option} {voption}  */
/*                                                                    */
/* with:                                                              */
/*   source                                                           */
/*     is the name of the source file                                 */
/*     The extension of the source file must be '.CMD'.               */
/*     If you ommit the extension, REXXCC appends '.CMD' to the       */
/*     name of the source file.                                       */
/*                                                                    */
/*   TO                                                               */
/*     this is a neccessary keyword!                                  */
/*                                                                    */
/*   target                                                           */
/*     is the name of the target file or directory                    */
/*     The extension for the target file must be '.CMD'. If you ommit */
/*     the extension, REXXCC appends '.CMD' to the name of the target */
/*     file. If you enter a directory name for this parameter, REXXCC */
/*     uses the name of the source file as name for the target file.  */
/*                                                                    */
/*   WITH                                                             */
/*     this is a neccessary keyword!                                  */
/*                                                                    */
/*   copyrightfile                                                    */
/*     is the file with the copyright message which replaces the      */
/*     original source code in the "compiled" version of the program. */
/*     If you ommit the parameter copyrightFile, REXXCC uses only its */
/*     copyright message as copyright file. If the copyright file is  */
/*     equal with the source file REXXCC uses only the leading        */
/*     comment lines of the source file as copyright file.            */
/*                                                                    */
/*     Hint: You may use the equal sign (=) as name of the            */
/*           copyright file if you want to use the sourcefile as      */
/*           copyright file.                                          */
/*                                                                    */
/*   options                                                          */
/*     are misc. options for REXXCC. All options are in the format    */
/*                                                                    */
/*       /optionName{=optionValue}                                    */
/*                                                                    */
/*     with optionValue = 1 to turn the option on and optionValue = 0 */
/*     to turn the option off. Any other value for optionValue turns  */
/*     the option on. The default for optionValue is 1 (= turn the    */
/*     option on).                                                    */
/*     You may enter an option at any position in the parameters.     */
/*                                                                    */
/*     Possible options for REXXCC are:                               */
/*       IExt                                                         */
/*         if ON : do NOT check                                       */
/*                   - the extension of the source file               */
/*                   - the extension of the target file               */
/*                   - the format of the source file                  */
/*                 and                                                */
/*                   - the format of the copyright file               */
/*                 (def.: OFF)                                        */
/*       IVer                                                         */
/*         if ON : do NOT check                                       */
/*                   - the version of the REXX interpreter            */
/*                 and                                                */
/*                   - the version of the token image of the source   */
/*                     file                                           */
/*                 (def.: OFF)                                        */
/*       IDate                                                        */
/*         if ON : do not check the date of the source file           */
/*                 (def.: OFF)                                        */
/*                                                                    */
/*       Overwrite                                                    */
/*         if ON : overwrite an existing target file (def.: OFF)      */
/*                                                                    */
/*       UseSource                                                    */
/*         if ON : use the source file as copyright file if the       */
/*                 parameter copyrightfile is missing (def.: OFF)     */
/*                                                                    */
/*       Sound                                                        */
/*         if ON : use sounds in case of an error (def.: OFF)         */
/*                                                                    */
/*   voptions                                                         */
/*     are misc. options for REXXCC. All voptions are in the format   */
/*                                                                    */
/*       /voptionName=voptionValue                                    */
/*                                                                    */
/*     vopitonValue can be any integer value greater or equal 0.      */
/*     You may enter a voption at any position in the parameters.     */
/*                                                                    */
/*     Possible voptions for REXXCC are:                              */
/*       LineCount=n                                                  */
/*         n is the number of leading comment lines of the source     */
/*         file which REXXCC should use as copyright file for the     */
/*         target file. REXXCC ignores this parameter, if you don't   */
/*         use the source file as copyright file.                     */
/*         (def.: use all leading comment lines of the sourcefile)    */
/*         If n is not a whole number or if n is equal 0, REXXCC      */
/*         ignores n. If there are less than n leading comment lines  */
/*         in the source file, REXXCC ignores the value of n.         */
/*         example:                                                   */
/*                                                                    */
/*           REXXCC TEST.CMD TO PROGS\ WITH TEST.CMD /LineCount=50    */
/*           -> compile the file "TEST.CMD" to "PROGS\TEST.CMD" and   */
/*              use the first 50 comment lines of the source file as  */
/*              copyright file.                                       */
/*                                                                    */
/*     You may also set the defaults for the options and voptions in  */
/*     the environment variable "REXXCC", for example:                */
/*                                                                    */
/*       SET REXXCC=/IExt=1 /Overwrite /LineCount=20 /UseSource       */
/*                                                                    */
/*     Options and VOptions in the parameters overwrite the values of */
/*     the environment variable "REXXCC".                             */
/*                                                                    */
/* See also the Notes below.                                          */
/*                                                                    */
/*                                                                    */
/* History                                                            */
/*                                                                    */
/*   V1.00  - 05.07.1994 /bs                                          */
/*     - initial release                                              */
/*   V1.01  - 12.07.1994 /bs                                          */
/*     - added code to check if the temporary path exists             */
/*     - change meaning of the 2nd parameter -- now it can            */
/*       be a directory name or a file name                           */
/*     - added code to check if the source file was changed after the */
/*       last execution                                               */
/*     - added code to check if the current ADDRESS() environment is  */
/*       the CMD                                                      */
/*   V2.00  - 20.08.1994 /bs                                          */
/*     - fixed a bug, where REXXCC did not delete the temporary files */
/*       and the target file if an error occured                      */
/*     - added the parameters -IExt, -IVer and -IDate                 */
/*     - added the support for the envrionment variable REXXCC        */
/*     - added the parameter -LineCount                               */
/*     - added the color support                                      */
/*   V2.01  - 01.10.1994 /bs                                          */
/*     - INTERNAL VERSION                                             */
/*   V2.05  - 18.11.1994 /bs                                          */
/*     - advanced the error handling                                  */
/*     - added the abbreviation '=' for the parameter copyrightfile   */
/*     - added the parameter -Overwrite                               */
/*     - added the parameter -UseSource                               */
/*   v2.10  - 08.04.1995 /bs                                          */
/*     - use TEMPLATE v2.52 as base source (**)                       */
/*     - changed the return codes above 250 to 230+. Added the new    */
/*       returncodes from TEMPLATE v2.52 (see below)                  */
/*     - added sounds                                                 */
/*     - added the parameter -Sound                                   */
/*     - extended the color support                                   */
/*     - expanded the version tests                                   */
/*     - added code to distinguish between batch and REXX programs    */
/*                                                                    */
/* (**) TEMPLATE is a "runtime system" for REXX programs. You         */
/*      You can get TEMPLATE at the same source as this file.         */
/*      The name of the archiv with TEMPLATE is "RXTMPnnn.EXE"        */
/*      or "RXTnnn.EXE" where nnn is the version of TEMPLATE          */
/*      (e.g. "253").                                                 */
/*      TEMPLATE is freeware.                                         */
/*                                                                    */
/* Notes:                                                             */
/*                                                                    */
/* REXXCC can only "compile" files on a read/write medium. So if you  */
/* want to "compile" a REXX file from a read-only medium (a CD ROM    */
/* for example) you MUST copy it to a read/write medium (e.g. a hard  */
/* disk) and execute it there (!) before "compiling" it!              */
/*                                                                    */
/* REXXCC only overwrites existing target files if the option         */
/* '-Overwrite' is set.                                               */
/*                                                                    */
/* The copyright file must begin with a valid REXX comment in line 1  */
/* column 1. You may suppress this check with the parameter '-IExt'.  */
/*                                                                    */
/* The file to "compile" must begin with a valid REXX comment in line */
/* 1, column 1. You may suppress this check with the parameter        */
/* '-IExt'.                                                           */
/*                                                                    */
/* You should not use 'TO' or 'WITH' as name for any of the           */
/* parameters for REXXCC.                                             */
/*                                                                    */
/* REXXCC needs the programs EAUTIL and ATTRIB to be in a directory   */
/* in the environment variable "PATH".                                */
/*                                                                    */
/* Note that you must reExecute a source file after you changed it    */
/* before you can "compile" it. You may suppress this check with the  */
/* parameter '-IDate'.                                                */
/*                                                                    */
/* Set the environment variable 'ANSI' to "0", "NO" or "OFF" if you   */
/* don't want colors.                                                 */
/*                                                                    */
/* Set the environment variable 'SOUND' to "0", "NO" or "OFF" if you  */
/* don't want sounds. You can also use the parameter /Sound=0 to      */
/* supress sounds.                                                    */
/*                                                                    */
/* You should load REXXUTIL before calling REXXCC if you are using    */
/* a CMD window with more or less than 80 columns.                    */
/*                                                                    */
/* REXXCC does not load REXXUTIL but will use it if it's already      */
/* loaded.                                                            */
/*                                                                    */
/* To get a smaller version of REXXCC use the following commands:     */
/*                                                                    */
/*   MD PROGRAM                                                       */
/*   REXXCC REXXCC.CMD to PROGRAM WITH REXCC.CMD /LINECOUNT=15        */
/*                                                                    */
/* Note that you can't change the name of REXXCC. Note also that you  */
/* only get a very short usage description if you use the parameter   */
/* '/?' with the smaller version.                                     */
/* IMPORTANT: YOU MUSTN'T SHARE A CHANGED VERSION OF REXXCC!          */
/*                                                                    */
/* Known limitations:                                                 */
/*                                                                    */
/* You can only "compile" REXX files which are less than 64 K in      */
/* tokenized form. 64 K is the maximum length of the EAs in which the */
/* REXX interpreter stores the token image of REXX programs.          */
/* (Note that the second length shown by the dir command on an HPFS   */
/* drive is the length of the EAs. To get the length of the EAs on an */
/* FAT drive use the switch /N for the OS/2 command "DIR".)           */
/*                                                                    */
/*                                                                    */
/* You should not use the function "SOURCELINE" in a program          */
/* "compiled" by REXXCC because there is no source code anymore :-).  */
/* If you want to use the function "SOURCELINE" (e.g. in an error     */
/* handler) use the following command sequence (this avoids an error  */
/* if you call the function "SOURCELINE" with a not existing line     */
/* number):                                                           */
/*                                                                    */
/*  if sourceLine() >= errorLineNo then                               */
/*  do                                                                */
/*    call charOut, left( " The line reads: ", 80 )                   */
/*    call charOut, left( " *-* " || sourceline( errorLineNo ), 80 )  */
/*  end                                                               */
/*                                                                    */
/* You may use difficult lines in the source file and the copyright   */
/* file to distinguish between the original and the "compiled"        */
/* version using "SOURCELINE" while running your program.             */
/*                                                                    */
/*                                                                    */
/* You can not load a "compiled" program in the REXX macro space.     */
/*                                                                    */
/*                                                                    */
/* You can not distribute a "compiled" program on a CD-ROM because    */
/* the CD ROM filesystem don't support EAs. To distribute a           */
/* "compiled" REXX program on a CD-ROM you can create an archiv with  */
/* the program and the EAs.                                           */
/*                                                                    */
/*                                                                    */
/* You can NOT execute "compiled" programs if you're running the      */
/* OO REXX (tested with the BETA version from DevCon 6).              */
/* It is also impossible to "compile" REXX programs tokenized by the  */
/* OO REXX interpreter.                                               */
/*                                                                    */
/* ------------------------------------------------------------------ */
/* Terms for using this version of REXXCC                             */
/*                                                                    */
/* This version of REXXCC is Freeware. You can use and share it as    */
/* long as you neither delete nor change any file or program in the   */
/* archiv!                                                            */
/* IT IS VERY IMPORTANT THAT YOU SHARE THIS PROGRAM ONLY WITH IT'S    */
/* EXTENDED ATTRIBUTES (EAs) - because without them it will not run!  */
/*                                                                    */
/* IMPORTANT !!! IMPORTANT !!! IMPORTANT !!! IMPORTANT !!! IMPORTANT  */
/*                                                                    */
/* TO DISTRIBUTE REXXCC ON MEDIUMS NOT SUPPORTING EXTENDED ATTRIBUTES */
/* LIKE CD-ROMs, BBS or CompuServe YOU MUST USE THE ARCHIV FILE       */
/* RCnnn.EXE!!!                                                       */
/*                                                                    */
/* IMPORTANT !!! IMPORTANT !!! IMPORTANT !!! IMPORTANT !!! IMPORTANT  */
/*                                                                    */
/* If you find REXXCC useful, your gift in any amount would be        */
/* appreciated.                                                       */
/*                                                                    */
/* Please direct your inquiries, complaints, suggestions, bug lists   */
/* etc. to the adress noted above.                                    */
/*                                                                    */
/* If you like and use REXXCC it would be nice if you send me a       */
/* postcard.                                                          */
/*                                                                    */
/* ------------------------------------------------------------------ */
/* Terms for distributing REXXCC                                      */
/* for vendors, sysops and others 'for-profit' distributors           */
/*                                                                    */
/* I encourage all shareware vendors, BBS sysops and other            */
/* 'for-profit' distributors to copy and distribute this version      */
/* of REXXCC subject to the following restrictions:                   */
/*                                                                    */
/*  The REXXCC freeware package - including all related program files */
/*  and documentation files - cannot be modified in any way (other    */
/*  than that mentioned below) and must be distributed as a complete  */
/*  package, without exception.                                       */
/*                                                                    */
/*  Small additions to the package, such as the introductory or       */
/*  installation batch files used by many shareware disk vendors, are */
/*  acceptable.                                                       */
/*                                                                    */
/*  You may charge a distribution fee for the package, but you must   */
/*  not represent in any way that you are selling the software itself.*/
/*                                                                    */
/*  The disk-based documentation may not be distributed in printed    */
/*  form without the prior written permission of the author.          */
/*                                                                    */
/*  You shall not use, copy, rent, lease, sell, modify, decompile,    */
/*  disassemble, otherwise reverse engineer, or transfer this         */
/*  program except as provided in this agreement. Any such unautho-   */
/*  rized use shall result in immediate and automatic termination of  */
/*  the permission to distribute this program.                        */
/*                                                                    */
/*  I reserve the right to withdraw permission from any vendor to     */
/*  distribute my products at any time and for any reason.            */
/*                                                                    */
/* ------------------------------------------------------------------ */
/* Warranty Disclaimer                                                */
/*                                                                    */
/* Bernd Schemmer makes no warranty of any kind, expressed or         */
/* implied, including without limitation any warranties of            */
/* merchantability and/or fitness for a particular purpose.           */
/*                                                                    */
/* In no event will Bernd Schemmer be liable to you for any           */
/* additional damages, including any lost profits, lost savings, or   */
/* other incidental or consequential damages arising from the use of, */
/* or inability to use, this software and its accompanying documen-   */
/* tation, even if Bernd Schemmer has been advised of the possibility */
/* of such damages.                                                   */
/*                                                                    */
/* ------------------------------------------------------------------ */
/* Copyright                                                          */
/*                                                                    */
/* REXXCC, the documentation for REXXCC and all other related files   */
/* are Copyright 1994,1995 by Bernd Schemmer.                         */
/*                                                                    */
/* All rights reserved.                                               */
/*                                                                    */
/* ------------------------------------------------------------------ */
/* Technical information                                              */
/*                                                                    */
/*                                                                    */
/* Returncodes and error messages                                     */
/*                                                                    */
/* Note: If you get one of the errors marked with a plus (+) in the   */
/*       table below - please contact the author!                     */
/*                                                                    */
/*    RC  Error message                                               */
/*   ---------------------------------------------------------------- */
/*     0  ok, target file successfully created (NO ERROR)             */
/*     1  parameter for help detected, usage shown (NO ERROR)         */
/*     2  Can not find a name for a temporary file (Check the         */
/*        variable "TEMP" or "TMP")                                   */
/*     3  Can not find the program EAUTIL.EXE                         */
/*        (Check the variable "PATH")                                 */
/*     4  Can not find the program ATTRIB.EXE                         */
/*        (Check the variable "PATH")                                 */
/*    11  Parameter missing                                           */
/*    12  The source file "%1" does not exist                         */
/*    13  The extension of the source file must be ".CMD"             */
/*    14  The extension for the target file must be ".CMD"            */
/*    15  The target file "%1" already exist                          */
/*    16  CopyrightFile "%1" does not exist                           */
/*    17  The copyrightFile can not be a device                       */
/*    18  The target file can not be equal with the source file       */
/*    19  The drive %1 is not ready                                   */
/*    31  The CopyrightFile must begin with a REXX comment in         */
/*        line 1 column 1                                             */
/* +  32  OS Error %1 deleting the temporary file "%2"                */
/* +  33  OS Error %1 deleting the existing target file "%2"          */
/* +  34  OS Error %1 compiling the inputfile "%2"                    */
/*    35  You must first execute the inputfile "%1" before            */
/*        compiling it                                                */
/*        Note: If you have already executed the inputfile, your      */
/*              REXX program is to big to fit in the EAs.             */
/*              In this case no "compiling" is possible.              */
/*    36  Can not find a name for a temporary file (Check the         */
/*        environment variable "TEMP" or "TMP")                       */
/* +  37  OS Error %1 creating the outputfile "%2"                    */
/* +  38  OS Error %1 creating the outputfile "%2"                    */
/* +  39  OS Error %1 creating the outputfile "%2"                    */
/* +  40  OS Error %1 creating the outputfile "%2"                    */
/* +  41  OS Error %1 creating the outputfile "%2"                    */
/* +  42  OS Error %1 creating the outputfile "%2"                    */
/*    51  You must first execute the inputfile "%1" before            */
/*        compiling it                                                */
/*        Note: see error number 35.                                  */
/*    52  You must first execute the inputfile "%1" before            */
/*        compiling it                                                */
/*        Note: see error number 35                                   */
/*    53  You must reExecute the source file after every              */
/*        change before you can compile it                            */
/*        Note: See error number 35                                   */
/* +  54  Internal error E1                                           */
/* +  55  Unknown format of the token image                           */
/*    56  Unknown REXX interpreter version (%1)                       */
/*    57  The file "%1" is NOT a REXX program                         */
/*    60  Invalid switches "%1" in the environment variable "REXXCC"! */
/*    61  The string "%1" in the environment variable "REXXCC" is     */
/*        not a valid option                                          */
/*    62  The string "%1" in the parameters is not a valid option     */
/*                                                                    */
/* + 232  This is a patched version of the program. It won't work     */
/* + 233  Invalid REXX interpreter version                            */
/* + 234  Internal error OTFT                                         */
/* + 234  Internal error FTOT                                         */
/* + 234  Internal error ODFD                                         */
/* + 234  Internal error FDOD                                         */
/*   235  You can only execute this program in a CMD session!         */
/*        Note: Try using 'CMD /C REXXCC ...'                         */
/*   254  user break (CTRL-C)                                         */
/*   255  internal runtime system error                               */
/*                                                                    */
/* ------------------------------------------------------------------ */
/* Based on TEMPLATE.CMD v2.52, TEMPLATE is (c) Bernd Schemmer, 1995  */
/* Baeckerweg 48, D-60316 Frankfurt, Germany, CompuServe: 100104,613  */
/*                                                                    */
/**********************************************************************/
/* compiled on 04/08/95 at 17:15:55 with REXXCC V2.10 (c) Bernd Schemmer 1995 */  
