/*****************************************************************************
*                                                                            *
* RAY-TRACER SCENE GENERATOR, V1.3, 28.11.1990                               *
*                                                                            *
* Creates datafiles for raytracers.                                          *
*                                                                            *
* HISTORY                                                                    *
*                                                                            *
* V1.0 16.11.1990  First working version                                     *
* V1.1 19.11.1990  Option -I added                                           *
* V1.2 25.11.1990  Accepts multiple variables with same name                 *
* V1.3 28.11.1990 /N-option added, ScriptGenerator uses user-defined editor  *
*                                                                            *
* BUGS                                                                       *
*                                                                            *
*  Don't use output filenames like "Simple1", end names with letters,        *
*  NOT NUMBERS!!                                                             *
*                                                                            *
*                                                                            *
*****************************************************************************/



#include "rayscene.h"

main(argc,argv)
int argc;
char *argv[];
 {

    char *pth_tmp;
    int pth2=0;
    int check=0;

 script_gen=0;
 comment=0;

 if( argc < 2 ) /* Checking arguments */
  {

   printf("\n                 Ray Tracing Scene Generator, v1.3 1990\n\n");

   printf("Usage: Rayscene (+-/) /Aname /Dname /Ccount /Oname [/Sname /I]\n\n");
   printf("    /Aname  = Filename for Array file, without extension\n");
   printf("    /Dname  = Filename for Data file, without extension\n");
   printf("    /Ccount = Required scene count\n");
   printf("    /Oname  = Filename for output file, without extension\n");
   printf("    /Sname  = Old script file, for ScriptGenerator\n");
   printf("    /NA     = Output-name:name001.dat\n");
   printf("    /NN     = Output-name:name1.dat\n");
   printf("    /I{}    = Do not replace inside comments,{=start letter,}=end letter\n");
   printf("              You can also define raytracer, for example /IDKB,/IVORT,/IQRT\n");

   exit(10);

  }


 for( index = 1; index < argc; index++ )   /* Loop for examining arguments */
 {

  if( ( argv[index][1] == 'D' ) || ( argv[index][1] == 'd' ) )   /* /FILE= */
   {

    sprintf(dat_name,"%s.%s",argv[index]+2,DEF_DATA_EXT);
    printf("Data-name:%s\n",dat_name);

      if( data == 0)  /*  There's no Output name  */
        {

        strcpy(output_name,argv[index]+2);
        data=index;                         /* Now there is output name */

        }
   }                                        /* END OF /FILE= */


  if( ( argv[index][1] == 'A' ) || ( argv[index][1] == 'a' ) )   /* /ARRAY= */
   {
   if( strlen (argv[index]) > 2)
       {
        sprintf(arr_name,"%s.%s",argv[index]+2,DEF_ARR_EXT);
        printf("Arrayfile:%s\n",arr_name);
       }
   }                                        /* END OF /ARRAY= */


  if( ( argv[index][1] == 'C' ) || ( argv[index][1] == 'c' ) )   /* /COUNT= */
    {

    count=atoi(argv[index]+2);
    if ( count == 0)
    {
     printf("Number of scenes cannot be 0 ! Terminating...\n");
     exit(1);
    }
    printf("Number of scenes requested:%d\n",count);
    memset(string, '\0', sizeof(string));
    sprintf(string,"%d", count);
    char_count = strlen(string);
    
    }

  if( ( argv[index][1] == 'O' ) || ( argv[index][1] == 'o' ) )   /* /OUTPUT= */
    {

    sprintf(output_name,"%s",argv[index]+2);
    printf("Output-name:%s\n",output_name);
    data=index;                             /* This replaces default name
                                              which is .dat-name */
    }

  if( ( argv[index][1] == 'S' ) || ( argv[index][1] == 's' ) )   /* /SCRIPT= */
    {

    sprintf(script_name,"%s",argv[index]+2);

    if( strlen(argv[index]) > 2 )
       printf("Script-name:%s.%s\n",script_name,DEF_SCRIPT_EXT);
     else
       printf("No script-name, using STDIN...\n");

    script_gen=1;

    }

  if( ( argv[index][1] == 'I' ) || ( argv[index][1] == 'i' ) )   /* /I */
    {
    comment=1;

    /*
     * Check for DKB/QRT/VORT/MTV/DBW
     *
     */

    if( !(strnicmp(argv[index]+2,"DKB",3))
         || !(strnicmp(argv[index]+2,"QRT",3)) )
      {
      strcpy(comment_start,DKB_COMMENT_START);
      strcpy(comment_end,DKB_COMMENT_END);
      printf("Using DKB comment marks...\n");
      }
    else

    if( !(strnicmp(argv[index]+2,"VOR",3)))
      {
      strcpy(comment_start,VORT_COMMENT_START);
      strcpy(comment_end,VORT_COMMENT_END);
      printf("Using VORT comment marks...\n");
      }
    else
    {
    strcpy(string,argv[index]+2);

    if( strlen(string) )                            /* New characters */
    {
      strncpy(comment_start,string,strlen(string)/2);
      strncpy(comment_end,string+strlen(string)/2,strlen(string)/2);
    }
     else
    {                                               /* No new characters */
      strcpy(comment_start,DEF_COMMENT_START);
      strcpy(comment_end,DEF_COMMENT_END);
      printf("Using default comment marks...\n");
    }

     }
    }

  if( ( argv[index][1] == 'N' ) || ( argv[index][1] == 'n' ) ) /* Name */
    {
     if((argv[index][2] == 'a') || ( argv[index][2] == 'A' ))
       add_null = 2;
      else
       add_null = 1;
    }



  }                                                 /* END OF FOR */
    memset(string,'\0',sizeof(string));

                                                    /* No name for data-file */
    if( strlen(dat_name) != 0 )
     {

        strcpy(file_name,dat_name);
        if( ( stream=fopen(file_name,"r") ) == NULL)         /* Open data-file */
        {
            printf("Cannot open data-file (%s).\nTerminating...\n",file_name);  /* Error occurred */
            fclose(stream);
            exit(10);

        }

      fseek(stream,0L,SEEK_END);                     /* Find last position */
      data_size=ftell(stream);
      buffer= (char *) malloc(data_size);
      fseek(stream,0L,SEEK_SET);                     /* Back to start */

      for( index=0; !feof(stream); index++)          /* Read stuff */
       buffer[index]=fgetc(stream);

       data_size=index;                             /* Real length */

      fclose(stream);                               /* Close data-file */
     }                                              /* END_OF_READ_data */


     if( strlen(arr_name) == 0 )                         /* No ARR-name */
      {

       strcat(arr_name,DEF_ARRAY_NAME);
       strcat(arr_name,".");
       strcat(arr_name,DEF_ARR_EXT);
       printf("Using default array-name:%s\n",arr_name);

      }


     /*
      * Now the fun begins, first, quick scan through buffer to examine how
      * many REPLACE_MARKs there are. Number of variables is then how_many/2
      *
      */

     index = 0;
     index2= 0;

     for( index = 0; index < data_size; index ++)
      {

        if( buffer[index] == comment_start[0] && (comment) )
        {
         if( strlen(comment_start) == 2 && buffer[index+1] != comment_start[1])
          break;
         while( buffer[index] != EOF )
          {
          if (buffer[index] == comment_end[0])
           if ( (strlen( comment_end ) ==2)
             && ( buffer[index+1] == comment_end[1] )
             || ( strlen ( comment_end) == 1))
               {
               index+=strlen(comment_end);
               break;
               }
          index++;
          if ( buffer[index] == EOF )
          {
          printf("Unexpected end of file! Cannot found comment_end mark. Terminating...\n");
          exit(5);
          }

          }
        }


      else
      if( buffer[index] == REPLACE_MARK) index2++;  /* AHA, found one */
      }                                              /* END_OF_FOR */


     if( index2 <= 1)
      {
       printf("No variables or one REPLACE MARK found from data-file...Terminating...\n");
       exit(0);
      }

     printf("%d Variables found from data-file after quick scan...\n",index2/2);
     var_count = index2/2;
                                    /* Space for var. names */
     names = (char *) malloc(var_count * MAX_VAR_LENGTH); 
     memset( names, '\0', var_count * MAX_VAR_LENGTH);
     values = (float *)malloc(var_count * count * sizeof(float));


     /*
      * Start from the beginning of buffer. If found REPLACE_MARK, get current
      * variable name, and move to next REPLACE_MARK
      *
      */

      for( index = 0;index < data_size; index++)
      {
        if( buffer[index] == comment_start[0] && ( comment ))
        {
         if( strlen(comment_start) == 2 && buffer[index+1] != comment_start[1])
          break;
         while( buffer[index] != EOF )
          {
          if (buffer[index] == comment_end[0])
           if ( (strlen( comment_end ) ==2)
             && ( buffer[index+1] == comment_end[1] )
             || ( strlen ( comment_end) == 1))
               {
               index+=strlen(comment_end);
               break;
               }
          index++;

          }
        }
      else
      if( buffer[index] == REPLACE_MARK)
       if( buffer[index+1] == REPLACE_MARK)
       {
       printf("Variables must have name! Terminating...\n");
       exit(8);
       }
       else
       {

       /* Check, if name is already been used. If it is, continue with next
         variable */

        for ( index2 = 1; index2 < (MAX_VAR_LENGTH); index2++)
         if( buffer[index2+index] == REPLACE_MARK)break;


        /*
         * now we have a length of current variable, compare it to names
         */

         for( index3 = 0; index3 < var_count; index3++ )
          if(!( strnicmp(names+(index3*MAX_VAR_LENGTH),buffer+index+1,index2-1)))
            {
            var_count--;
            check=1;
            break;
            }

         if(check)
          {
           check=0;
           index+=index2;
           continue;
          }
         else
         {
          pth_tmp = names + pth2 * (MAX_VAR_LENGTH);
          for ( index2 = 1; index2 < (MAX_VAR_LENGTH); index2++)
          {
                  if( buffer[index2+index] == REPLACE_MARK)
                   break;
                    else
                  *(pth_tmp++) = buffer[index2+index];

          }
          pth2++;

         /* Then move buffer, until var_name ends */

         index++;

         while( buffer[index] != REPLACE_MARK ) index++;
        }
       }
      check=0;
     }


  /*
   * READ VALUES FROM DISK
   *
   */

    printf("%d real variables found from data-file (duplicates not included)\n",
      var_count);
    readval();
    fclose(stream);

  /*
   * First, if current FILE_NAME is too long (there is no space after name
   * for two/three numbers...), remove last two characters.
   *
   */

  strncpy(scene_number,"1",1);   /* First file number */
  memset(file_name,'\0',sizeof(file_name));

  for(; atoi(scene_number)<count+1; sprintf(scene_number,"%d", atoi(scene_number)+1))
   {
   memset(file_name,'\0',sizeof(file_name));
   strncpy(file_name,argv[data]+2,(MAX_NAME_LENGTH-strlen(scene_number)));

   if(add_null == 2)  /* Name001.dat */
    strncat(file_name,"0000000000000", char_count-strlen(scene_number));
 
   strncat(file_name,scene_number,strlen(scene_number));
   strncat(file_name,".",1);
   strncat(file_name,DEF_DATA_EXT,EXT_LENGTH);

   if( ( stream=fopen(file_name,"w+") ) == NULL)         /* Open data-file */
     {
     printf("Cannot open scene-file.\nTerminating...\n");  /* Error occurred */
     fclose(stream);
     exit(10);
     }


   /*
    * Then, replace all variables with right values
    */

     for( index = 0;index < data_size-1; index++)
     {
        if( buffer[index] == comment_start[0] && (comment) )
        {
         if( strlen(comment_start) == 2 && buffer[index+1] != comment_start[1])
          break;
         while( buffer[index] != EOF )
          {
          if (buffer[index] == comment_end[0])
           if ( (strlen( comment_end ) ==2)
             && ( buffer[index+1] == comment_end[1] )
             || ( strlen ( comment_end) == 1))
               {
               fputc(buffer[index],stream);

               if( strlen(comment_end) == 2)
                fputc(buffer[++index],stream);

               index+=strlen(comment_end);
               break;
               }
          fputc(buffer[index],stream);
          index++;
          }
        }

      if( buffer[index] == REPLACE_MARK)
       {

        for ( index2 = 1; index2 < (MAX_VAR_LENGTH); index2++)
         {
         if( buffer[index2+index] == REPLACE_MARK)break;
         }

        /*
         * now we have a length of current variable, compare it to names
         */

         memset(string,'\0', sizeof(string));

         for( index3 = 0; index3 < var_count; index3++ )
          if(!( strnicmp(names+(index3*MAX_VAR_LENGTH),buffer+index+1,index2-1)))
            break;

        /*
         * Now we know current variable, so replace current value to buffer
         */

        sprintf(string,"%.3f",values[atoi(scene_number)+(index3 * count)-1]);
        fputs(string,stream);


        index++;

        while( buffer[index] != REPLACE_MARK ) index++;

       }                                         /* END_OF_REPLACE_MARK */
       else
       fputc(buffer[index],stream);
     }                                              /* END_OF_BUFFER_SEARCH */

     fclose(stream);
  }                                               /* END_OF_SCENE_LOOP */



   /*
    * Release all buffers
    */

   free(buffer);
   free(array);
   free(modified);

   printf("%d datafiles generated.\n",atoi(scene_number)-1);

   if(script_gen)create_script();                 /* Start scriptgenerator */


}
