' Raycaster 3d engine v2.1,
' created by exodus,
' By Logic Mouse.
' cloak@compuserve.com
' press f5 to start...
'
'



DECLARE SUB CreateBackground ()
DECLARE SUB GetKeypress (Keycode%)
CONST UpArrow = -72, DnArrow = -80, LArrow = -75, RArrow = -77
ON ERROR GOTO 5

' Default Settings
ctr% = 0:    '0 = keyboard, 1 = gamepad,joystick.
             'if you want joystick or gamepad, change
             'this to 1 and start. it calibrates
             'itself automatically.
             'press A button to end the game in joystick mode.

snd% = 1:    ' 0 = off, 1 = on (this is sound)



Left% = STICK(0) - 5
Right% = STICK(0) + 5
Down% = STICK(1) - 5
Up% = STICK(1) + 5
CLS


RANDOMIZE TIMER
DIM Grid%(1 TO 12, 1 TO 12)
DIM STable!(0 - 31 TO 360 + 32), CTable!(0 - 31 TO 360 + 32)
COLOR 15, 0
CLS
PRINT "Enter level path name, press enter for default."
LINE INPUT "Level Filename (No ext.): ", file$

lev% = 1'if a file name is entered, use it.
IF file$ = "" THEN lev% = 2 'else, use the default.



start:


PX! = 9: PY! = 11    'the starting coordinates of the player's location
stride! = 3          'the distance covered in one "step" by the player
                     '   by pressing the up or down arrow keys
Heading% = 0         'the heading of the player (in degrees)

Turn% = 5            'number of degrees of rotation produced by
                     '   pressing the right or left arrow keys
SCREEN 7, , 0, 0

COLOR 15, 0
PRINT "Loading Level"
PRINT
PRINT "Reading map..."

IF lev% = 1 THEN
OPEN file$ + ".lev" FOR INPUT AS #1
FOR Y = 1 TO 12
  FOR x = 1 TO 12
    INPUT #1, NUM
    Grid%(x, Y) = NUM
  NEXT
NEXT
GOTO ok
END IF

IF lev% = 2 THEN
FOR Y% = 1 TO 12
  FOR x% = 1 TO 12
    READ Grid%(x%, Y%)
  NEXT
NEXT
GOTO ok
END IF

ok:
Factor! = (ATN(1) * 8) / 360
FOR a% = 0 TO 359
  Angle! = CSNG(a%) * Factor!
  STable!(a%) = SIN(Angle!) * .1
  CTable!(a%) = COS(Angle!) * .1
NEXT
FOR a% = -31 TO -1
  STable!(a%) = STable!(a% + 360)
  CTable!(a%) = CTable!(a% + 360)
NEXT
FOR a% = 360 TO 360 + 32
  STable!(a%) = STable!(a% - 360)
  CTable!(a%) = CTable!(a% - 360)
NEXT


PRINT "Creating background..."
CALL CreateBackground
PRINT "Computing view..."
ViewPg% = 0: WorkPg% = 1: BG1% = 2: BG2% = 3
SCREEN , , WorkPg%, ViewPg%
GOSUB ComputeView




IF ctr% = 1 THEN
DO  'Main Joystick loop

 IF STRIG(1) THEN
 END
 END IF


IF STICK(0) < Left% THEN
Heading% = (Heading% + Turn%) MOD 360
GOSUB ComputeView
END IF
IF STICK(0) > Right% THEN
Heading% = (Heading% + (360 - Turn%)) MOD 360
GOSUB ComputeView
END IF

IF STICK(1) <= Down% THEN
NewPX! = PX! - (STable!(Heading%) * stride!)
NewPY! = PY! - (CTable!(Heading%) * stride!)
IF Grid%(NewPX!, NewPY!) = 0 THEN
PX! = NewPX!: PY! = NewPY!
GOSUB ComputeView

ELSE 'tried to walk through a wall
IF snd% = 1 THEN PLAY "t160O0L32E"
END IF
END IF

IF STICK(1) > Up% THEN
FOR stride2! = stride! TO stride! + 1
NewPX! = PX! + (STable!(Heading%) * stride2!)
NewPY! = PY! + (CTable!(Heading%) * stride2!)
NEXT stride2!
IF Grid%(NewPX!, NewPY!) = 0 THEN
PX! = NewPX!: PY! = NewPY!
GOSUB ComputeView

ELSE 'tried to walk through a wall
IF snd% = 1 THEN PLAY "t160O0L32E"
END IF
END IF
LOOP
SCREEN 0: WIDTH 80, 25
END
END IF


IF ctr% = 0 THEN
DO 'Main keyboard loop

CALL GetKeypress(Keycode%)
' keyboard buffer
DEF SEG = &H40
POKE &H1A, PEEK(&H1C)

SELECT CASE Keycode%
  CASE LArrow
    Heading% = (Heading% + Turn%) MOD 360
    GOSUB ComputeView
  CASE RArrow
    Heading% = (Heading% + (360 - Turn%)) MOD 360
    GOSUB ComputeView
  CASE UpArrow
    FOR stride2! = stride! TO stride! + 1
    NewPX! = PX! - (STable!(Heading%) * stride2!)
    NewPY! = PY! - (CTable!(Heading%) * stride2!)
    NEXT stride2!

    IF Grid%(NewPX!, NewPY!) = 0 THEN
      PX! = NewPX!: PY! = NewPY!
      GOSUB ComputeView
    ELSE 'tried to walk through a wall
      IF snd% = 1 THEN SOUND 80, 1
    END IF
  CASE DnArrow
    NewPX! = PX! + (STable!(Heading%) * stride!)
    NewPY! = PY! + (CTable!(Heading%) * stride!)
    IF Grid%(NewPX!, NewPY!) = 0 THEN
      PX! = NewPX!: PY! = NewPY!
      GOSUB ComputeView
    ELSE 'tried to walk through a wall
      IF snd% = 1 THEN SOUND 80, 1
    END IF
  CASE 27
    EXIT DO
  CASE ELSE
    IF snd% = 1 THEN SOUND 80, 1
  END SELECT
LOOP
SCREEN 0: WIDTH 80, 25
END
END IF



ComputeView:
PCOPY BG1%, WorkPg%: SWAP BG1%, BG2%
x1% = 0
FOR a% = Heading% + 32 TO Heading% - 31 STEP -1
  StepX! = STable!(a%): StepY! = CTable!(a%)
  XX! = PX!: YY! = PY!
  l% = 0
  DO
    XX! = XX! - StepX!: YY! = YY! - StepY!
    l% = l% + 1
    K% = Grid%(XX!, YY!)
  LOOP UNTIL K%
  DD% = 900 \ l%
  h% = DD% + DD%
  dt% = 100 - DD%
 
 
 
  ' basic uni colored walls;
  LINE (x1%, dt%)-STEP(4, h%), K%, BF

 
  ' black outline of the walls
  LINE (x1%, dt%)-(x1% + 4, dt%), 0
  LINE (x1%, dt% + h%)-(x1% + 4, dt% + h%), 0

 

   x1% = x1% + 5
NEXT
SWAP WorkPg%, ViewPg%
SCREEN , , WorkPg%, ViewPg%
RETURN


' level one data
DATA  9,  4,  9,  4,  9,  4,  9,  4,  9,  4,  9,  4
DATA  4,  0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  4
DATA  4,  0,  2, 10,  0,  0,  0,  0,  0, 12,  0,  4
DATA  4,  0, 10,  2,  0,  0,  0,  0,  0,  4,  0,  9
DATA  4,  0,  0,  0,  0,  0,  0,  0,  0, 12,  0,  4
DATA  4,  0,  0,  0,  0,  7,  7,  0,  0,  0,  0,  9
DATA  9,  0,  0,  0,  0,  7,  7,  0,  0,  0,  0,  4
DATA  4,  0, 13,  0,  0,  0,  0,  1,  0,  1,  0,  9
DATA  9,  0,  5,  0,  0,  0,  0,  15,  0, 15, 0,  4
DATA  4,  0, 13,  0,  0,  0,  0,  1,  0,  1,  0,  9
DATA  9,  0,  5,  0,  0,  0,  0,  15,  0, 15, 0,  4
DATA  4,  9,  4,  9,  4,  9,  4,  9,  4,  9,  4,  9
DEFINT A-Z

5
CLS
COLOR 15
PRINT "Bad File Name."
END

DEFSNG A-Z
SUB CreateBackground
SCREEN , , 2, 0: CLS
' Sky
LINE (0, 0)-(319, 99), 3, BF
' Clouds
FOR Cnt% = 1 TO 10
  x% = INT(RND * 320)
  Y% = INT(RND * 80) + 10
  r% = INT(RND * 50)
  AR! = RND / 10
  CIRCLE (x%, Y%), r%, 15, , , AR!: PAINT (x%, Y%), 15
NEXT
' Sun
CIRCLE (50, 30), 10, 14: PAINT (50, 30), 14, 14

' Creates the ground texture.
PCOPY 2, 3
FOR Y% = 100 TO 199
  FOR x% = 0 TO 319
    IF RND AND 1 THEN PSET (x%, Y%), 6
  NEXT
NEXT

SCREEN , , 3, 0
FOR Y% = 100 TO 199
  FOR x% = 0 TO 319
    IF RND AND 1 THEN PSET (x%, Y%), 6
  NEXT
NEXT
'Here ends the ground texture

SCREEN , , 0, 0

END SUB

SUB GetKeypress (Keycode%)
DO: Ky$ = INKEY$
: LOOP UNTIL LEN(Ky$)
Keycode% = ASC(Ky$): IF Keycode% = 0 THEN Keycode% = -ASC(MID$(Ky$, 2, 1))
END SUB

