/* hpux.io    IO porting code  */

#include <stdio.h>
#include <stdlib.h>
#include <curses.h>
#include <term.h>
#include <string.h>
#include <ctype.h>

/*----------------------------------------------------------------------
**                M A C R O S
**----------------------------------------------------------------------
*/

#define io_MAX_VALID_CHARACTER 126

#define io_CTRL_A 1
#define io_CTRL_B 2
#define io_CTRL_C 3
#define io_CTRL_D 4
#define io_CTRL_E 5
#define io_CTRL_F 6
#define io_CTRL_G 7
#define io_CTRL_H 8
#define io_CTRL_I 9
#define io_CTRL_J 10
#define io_CTRL_K 11
#define io_CTRL_L 12
#define io_CTRL_M 13
#define io_CTRL_N 14
#define io_CTRL_O 15
#define io_CTRL_P 16
#define io_CTRL_Q 17
#define io_CTRL_R 18
#define io_CTRL_T 20
#define io_CTRL_U 21
#define io_CTRL_V 22
#define io_CTRL_W 23
#define io_CTRL_X 24
#define io_CTRL_Y 25
#define io_CTRL_Z 26
#define io_ESCAPE 27

#define io_F1 KEY_F(1)
#define io_F2 KEY_F(2)
#define io_F3 KEY_F(3)
#define io_F4 KEY_F(4)
#define io_F5 KEY_F(5)
#define io_F6 KEY_F(6)
#define io_F7 KEY_F(7)
#define io_F8 KEY_F(8)
#define io_F9 KEY_F(9)
#define io_F10 KEY_F(10)

#define io_PAGEUP KEY_PPAGE
#define io_PAGEDOWN KEY_NPAGE
#define io_UP       KEY_UP
#define io_DOWN     KEY_DOWN
#define io_RIGHT    KEY_RIGHT
#define io_LEFT     KEY_LEFT
#define io_BACKSPACE KEY_BACKSPACE
#define io_HOME      KEY_HOME
#define io_END       KEY_DC
#define io_TAB       9
#define io_ENTER     KEY_ENTER


#define io_printf printw
#define io_gotoxy(a,b) move((b)-1,(a)-1)
#define io_clrscr() clear();refresh()
#define io_refresh() refresh()
#define io_inchar() getch()

#define io_flush_keyboard() fflush(stdin)  

char obuf[2000];

void io_init(void);
void io_end(void);

void io_init(void)
{
   int i;

   setbuf(stdout,obuf);

   initscr();
   clear();
   nonl();
   cbreak();
   noecho();
   stdscr->_nodelay = 0;
   stdscr->_use_keypad=1;
   stdscr->_scroll = 0;
}

void io_end(void)
{
   clear();
   refresh();
   endwin();
}

