/* TCC1.IO --- Basic input-output routines for Turbo C++ 1.0  compiler */

#include <conio.h>
#include <mem.h>

#define io_printf           printf
#define io_gotoxy(a,b)      gotoxy(a,b)
#define io_clrscr()         clrscr()
#define io_refresh()
#define io_flush_keyboard() while(io_inkey())
#define io_unlink           unlink
#define io_puts             puts
#define io_putc             putc

#define io_MAX_VALID_CHARACTER 255
#define io_MIN_VALID_CHARACTER   1
#define io_MIXED_CASE_FILENAMES  0

#define io_BACKSPACE    8
#define io_DELETE     -83
#define io_DOWN       -80
#define io_END        -79
#define io_ENTER       13
#define io_ESCAPE      27
#define io_HOME       -71
#define io_INSERT     -82
#define io_LEFT       -75
#define io_PAGEDOWN   -81
#define io_PAGEUP     -73
#define io_RIGHT      -77
#define io_TAB          9
#define io_UP         -72

#define io_SHIFT_TAB  -15
#define io_BACKTAB    -15

#define io_CTRL_A       1
#define io_CTRL_B       2
#define io_CTRL_C       3
#define io_CTRL_D       4
#define io_CTRL_E       5
#define io_CTRL_F       6
#define io_CTRL_G       7
#define io_CTRL_H       8
#define io_CTRL_I       9
#define io_CTRL_J      10
#define io_CTRL_K      11
#define io_CTRL_L      12
#define io_CTRL_M      13
#define io_CTRL_N      14
#define io_CTRL_O      15
#define io_CTRL_P      16
#define io_CTRL_Q      17
#define io_CTRL_R      18
#define io_CTRL_S      19
#define io_CTRL_T      20
#define io_CTRL_U      21
#define io_CTRL_V      22
#define io_CTRL_W      23
#define io_CTRL_X      24
#define io_CTRL_Y      25
#define io_CTRL_Z      26

#define io_F1         -59
#define io_F2         -60
#define io_F3         -61
#define io_F4         -62
#define io_F5         -63
#define io_F6         -64
#define io_F7         -65
#define io_F8         -66
#define io_F9         -67
#define io_F10        -68


short io_inkey(void);
short io_inkey(void)
{
  short return_val=0;
  unsigned char ch;

  if (kbhit())
  {
    ch = getch();
    if (ch)
    {
      return_val = (short)ch;
    }
    else
    {
      ch = getch();
      return_val = -(short)ch;
    }
  }
  else
  {
     return_val = 0;
  }
  return return_val;
}

short io_inchar(void);
short io_inchar(void)
{
   short ch=0;

   while(!ch)
   {
     ch = io_inkey();
   }
   return ch;
}

void io_init(void);
void io_init(void)
{
  clrscr();
}
void io_end(void);
void io_end(void)
{
  io_gotoxy( 80, 24 );
  io_printf( "\n\n" );
  io_refresh();
}
