#define main_type_email           0x0002  /* email by user number          */
#define main_type_post            0x0003  /* post from sub host            */
#define main_type_pre_post        0x0005  /* post to sub host              */
#define main_type_email_name      0x0007  /* email by user name */
#define main_type_new_post        0x001a  /* post by sub name */



typedef struct {
				unsigned short	tosys,					/* destination system */
												touser, 				/* destination user */
												fromsys,				/* originating system */
												fromuser; 			/* originating user */
				unsigned short	main_type,			/* main message type */
												minor_type; 		/* minor message type */
				unsigned short	list_len; 			/* # of entries in system list */
				unsigned long 	daten;					/* date/time sent */
				unsigned long 	length; 				/* # of bytes of msg after header */
				unsigned short	method; 				/* method of compression */
} net_header_rec;

#define append_block(file, memory, size) write(file, memory, size)



/* prototypes */

void convert_packet_to_qwk(char *pname, char *qname);
void put_in_qwk(int qfile, char *fname, char *tname, int sub_num, char *title, net_header_rec *net_header, char *text);
void make_qwk_ready(char *text, char *address);
char *readmessage(int pfile, char *fname, char *tname, int *sub_num, char *title, net_header_rec *net_header);
char * get_line(char *buff, int max_len, long *pos, char *source);

