#include "qwkvars.h"


char *QWKTo = "QWK To: ";       /* If this exists in email, use it instead of the to field */

extern long qwk_ready_max_size;

void convert_qwk_to_wwiv(char *qname, char *pname)
{
  qwk_record *qwk_rec, temp_qwk;
  time_t time_now;
  unsigned diff_time;
  int pfile, qfile;
  char *text, temp[130];
  long packet_size;

  _setcursortype(_NOCURSOR);

  qfile=open(qname, O_RDONLY | O_BINARY);
  if(qfile < 1)
  {
    print_message("Couldn't open %s (QWK source) for reading\r\n", qname);
    return;
  }

  /* Show packet size in info window */
  packet_size = (long)filelength(qfile);
  textattr(YELLOW+(BLUE<<4));
  window(1, 1, 80, 25);
  gotoxy(71,2);
  cprintf("%ldk", packet_size > 1024 ? packet_size / 1024 : 1L);
  /* End of showing packet size */


  pfile=open(pname, O_RDWR | O_BINARY | O_CREAT | O_TRUNC, S_IREAD | S_IWRITE);
  if(pfile < 1)
  {
    print_message("Couldn't open %s (WWIV dest) for writting\r\n", pname);
    close(qfile);
    return;
  }

#ifdef REG
  setvect(3, new_int_3);
#endif


  /* ------------------------------------------------------- */
  /* Skip the first record, is is either copyright, or bbsid */
  /* I REALLY should check to make sure this is a good qwk   */
  /* or REP                                                  */
  /* ------------------------------------------------------- */
  read(qfile, (void *)&temp_qwk, sizeof(qwk_record));


  print_message("\r\n");
  aborted = 0;
  while(!aborted)
  {
    qwk_rec = readqwk(qfile);

    if(!qwk_rec)
      continue;

    put_in_wwiv(pfile, qwk_rec);

/* Update the processed+ignored and current pos window */
    ++processed;
    window(1, 1, 80, 25);
    textattr(YELLOW+(CYAN<<4));
    gotoxy(68, 10);
    cprintf("%ld", processed);
    gotoxy(68, 11);
    cprintf("%ld", ignored);

    textattr(YELLOW+(BLUE<<4));
    gotoxy(71, 3);
    cprintf("%ldk", current_pos > 1024 ? current_pos / 1024 : 1L);
    time_now=time(NULL);
    diff_time=time_now-second_time;
    gotoxy(71, 4);

    if(diff_time)
      cprintf("%-6ld", (long)current_pos / diff_time);

/* End update of processed+ignored and current pos window */

    free(qwk_rec);

    if(registered != REGISTERED && registered != LIMITED_REGISTER)
    {
      if(processed >= MAX_UNREGISTERED_MSGS)
      {
        print_message("Sorry, Unregistered version has reached its max messages!!\r\n");
        aborted = 1;
        delay(2000);
      }
    }
  }
  after_second=time(NULL);
  print_message("Total messages Processed %ld, total ignored %ld\r\n", processed, ignored);

  close(qfile);
  close(pfile);
}




qwk_record *readqwk(int qfile)
{
  qwk_record *qwk_rec, temp_rec;
  long x, blks;
  char block[9];

  x = read(qfile, (void *)&temp_rec, sizeof(qwk_record));

  if(x != sizeof(qwk_record))
  {
    if(x)  /* if x = 0 then we are at end of file, don't print error */
      print_message("Tried to read %u bytes (C), but only read %ld bytes\r\n", sizeof(qwk_record), x);
    aborted = 1;
    return NULL;
  }
  /* We just read in the header, add it to our position */
  current_pos += sizeof(qwk_record);

  strncpy(block, temp_rec.amount_blocks, 8);
  block[8]=0;
  blks = atoi(block);

  if(blks<2)
  {
    print_message("Invalid QWK record, reports less than 2 blocks\r\n");
    ++ignored;
    return NULL;
  }

  qwk_rec=(qwk_record *)malloca((blks+1) * sizeof(qwk_record));

  if(!qwk_rec)
  {
    print_message("Couldn't allocated %ld bytes of memory (AA)\r\n", (long) blks * sizeof(qwk_record));
    ++ignored;
    return NULL;
  }
  qwk_rec[0] = temp_rec;

  x = read(qfile, (void *)&qwk_rec[1], sizeof(qwk_record) * (blks-1));

  if(x != sizeof(qwk_record) * (blks-1))
  {
    print_message("Tried to read %ld bytes (D), but only read %ld bytes\r\n", sizeof(qwk_record) * (blks-1), x);
    aborted = 1;
    free(qwk_rec);
    return NULL;
  }

  /* Add the blocks we read in to our current position */
  current_pos += (sizeof(qwk_record) * (blks-1));

  return(qwk_rec);
}

void put_in_wwiv(int pfile, qwk_record *qwk_rec)
{
  struct tm *time_now;
  net_header_rec net_header;
  char *text, recs[20], *qwk_text, *temp, email_to[201];
  char subtype[30], temp1[50];
  long size=0, textsize=0, cur_pos=0, daten;
  int save_it = 1;

  email_to[0]=0;
  subtype[0]=0;

  memset(&net_header, 0, sizeof(net_header_rec));

  strncpy(recs, qwk_rec->amount_blocks, 8);
  size = (atoi(recs)-1) * sizeof(qwk_record);

  text=(char *)malloca((size) + 4096);
  text[0] = 0;

  qwk_text = (char *)(&qwk_rec[1]);

  qwk_text[size]=0;
  while((qwk_text[size] == 0 || qwk_text[size] == ' ') && size)
  {
    qwk_text[size]=0;
    --size;
  }
  ++size;  /* make size point to null terminator */

  if(qwk_rec->status == '+' || qwk_rec->status == '*')
  {
    if((temp = strstr_nocase(qwk_text, QWKTo)) != NULL)
    {
      int qsize = strlen(QWKTo);

      temp += qsize;

      while(temp[qsize] != '' && temp[qsize] != ' ')
        ++qsize;

      strncpy(email_to, temp, qsize - strlen(QWKTo));
      email_to[qsize-strlen(QWKTo)]=0;

      memmove(temp, temp+qsize+1, strlen(temp+qsize+1) + 1);
      size -= (qsize + 1);
    }
    else
    {
      strncpy(email_to, qwk_rec->to, 25);
      email_to[25]=0;
    }

    strip_string(email_to);
    temp=(char *)strchr(email_to, '@');
    if(temp)
    {
      temp[0]=0;
      ++temp;
      net_header.tosys=atoi(temp);
    }
    else /* if there is no '@', then attack one to find the user on our system */
    {
      if(unknown_user && unknown_sys)
      {
        net_header.tosys=unknown_sys;
        net_header.touser=unknown_user;
      }
      else
        save_it=0;                 /* Don't save unknown email */
    }

    net_header.touser = atoi(email_to);

    if(net_header.touser)
      net_header.main_type = main_type_email;
    else
    {
      net_header.main_type = main_type_email_name;
      strcpy(text, temp);
      textsize += strlen(temp)+1;       /* +1 so that we can save the NULL terminator */
    }
  }
  else    /* it is a post... go figure out subtype and set the stuff up */
  {
    char temp2[51];

    temp2[0] = 0;
    sprintf(temp1, "%u", qwk_rec->conf_num);
    read_ini_string(&ini_info, "Sub Num to Sub Type", temp1, temp2, 50);

    if(temp2[0]==0)
    {
      free(text);
      print_message("Warning: Unknown QWK subnumber %s\r\n", temp1);
      ++ignored;
      --processed;
      return;
    }
    else
    {
      window(1, 1, 80, 25);
      textattr(YELLOW+(CYAN<<4));
      gotoxy(68, 8);
      cprintf("%-8.8s", temp1);
      gotoxy(68, 9);
      cprintf("%-8.8s", temp2);
    }

    strupr(temp2);
    net_header.minor_type = atoi(temp2);

    if(net_header.minor_type)
    {
      /*
         Pre Post is for if you want the packets generated in a way that
         you are treated as the host.  One thing I have found out with this
         though, you must put your system number as a subscriber to this in
         your QWK subcriber list for that sub, the reason being, your node
         number is uses as the 'fromsys', and if your number isn't in there,
         the network software kicks it out as in illegal post.

         Also note, the 'main_type_new_pos' (post by alpha sub type), doesn't
         have this pre-post stuff... but you still must have your node #
         subscribed though.
      */
      if(pre_post)
        net_header.main_type = main_type_post;
      else
        net_header.main_type = main_type_post;
    }
    else
    {
      net_header.main_type = main_type_new_post;
      strcpy(text, temp2);
      textsize += strlen(temp2)+1;       /* +1 so that we can save the NULL terminator */
    }

    net_header.tosys=this_system;
  }


  if(save_it)
  {
    /* Append the Subject to the text */
    strncpy(temp1, qwk_rec->subject, 25);
    temp1[25]=0;
    strip_string(temp1);
    strcpy(text+textsize, temp1);
    textsize += strlen(temp1)+1;        /* +1 so we can save NULL terminator */

    /* Append the From to the text */
    strncpy(temp1, qwk_rec->from, 25);
    temp1[25]=0;
    strip_string(temp1);
    strcat(temp1, "\r\n");
    strcpy(text+textsize, temp1);
    textsize += strlen(temp1);

    /* Append the Date to the text */
    strncpy(temp1, qwk_rec->date, 8);
    temp1[8]=0;
    net_header.daten=date_to_daten(temp1);
    time_now = localtime((long *)&net_header.daten);
    strftime(temp1, 80, "%a %b %d %H:%M:%S %Y\r\n", time_now);
    strncpy(temp1+11, qwk_rec->time, 5);
    strcpy(text+textsize, temp1);
    textsize += strlen(temp1);

    if(textsize > size + 2000)
    {
      print_message("Error, textsize is already greater than size+2000\r\n");
      getch();
    }

    /* Finally append the acutall message text */
    while(cur_pos < size)
    {
      if(qwk_text[cur_pos] == '')
      {
        text[textsize] = '\r';
        text[textsize+1] = '\n';

        textsize+=2;
        ++cur_pos;
      }
      else
      {
        text[textsize]=qwk_text[cur_pos];

        ++textsize;
        ++cur_pos;
      }
    }

    strcpy(text+textsize, tag_string);   /* End of QWKCNVT tagline */
    textsize+=strlen(tag_string);


    text[textsize]=0xE0;     /* Control Z terminate text */

    net_header.list_len = 0;
    net_header.length = textsize;

    if(which_node == NODE_LOCAL)
      net_header.fromsys=this_system;      /* this system is the gate, so put it as the system */
    else /* which_node == NODE_REMOTE */
      net_header.fromsys=remote_system;

    net_header.fromuser=0;

    write(pfile, (void *) &net_header, sizeof(net_header_rec));
    write(pfile, text, textsize);
  }
  free(text);
}

void build_control_dat(void)
{
  FILE *fp;

  int amount=0;
  int cur=0;
  char file[201], temp[20], this_sub[20];
  char date_time[51];
  time_t secs_now;
  struct tm *time_now;

  time(&secs_now);
  time_now=localtime(&secs_now);

  // Creates a string like 'mm-dd-yyyy,hh:mm:ss'
  strftime(date_time, 50, "%m-%d-%Y,%H:%M:%S", time_now);

  sprintf(file, "%sCONTROL.DAT", temp_dir);
  fp=fopen(file, "wb");

  if(!fp)
  {
    print_message("Couldn't open %s (Control file for QWK) for writting\r\n", file);
    return;
  }



  fprintf(fp, "%s\r\n", bbs_name);
  fprintf(fp, "%s\r\n", bbs_address);   // System City and State
  fprintf(fp, "%s\r\n", bbs_phone);
  fprintf(fp, "%s\r\n", bbs_sysop);
  fprintf(fp, "%ld,%s\r\n", reg_number, system_id);
  fprintf(fp, "%s\r\n", date_time);
  fprintf(fp, "%s\r\n", remote_user);
  fprintf(fp, "%s\r\n", "");
  fprintf(fp, "%s\r\n", "0");
  fprintf(fp, "%ld\r\n", processed);

  for(cur=0; cur <= 999; ++cur)
  {
    if(subs_used[cur])
      ++amount;
  }

  fprintf(fp, "%d\r\n", amount-1);   /* Save amount of conferences -1 */


  for(cur=0; cur <= 999; ++cur)
  {
    if(subs_used[cur])
    {
      sprintf(this_sub, "%d", cur);
      temp[0]=0;
      read_ini_string(&ini_info, "Sub Num to Sub Type", this_sub, temp, 20);
      temp[13]=0;

      fprintf(fp, "%d\r\n", cur);
      fprintf(fp, "%s\r\n", temp);
    }
  }
  fclose(fp);
}

void qwk_remove_null(char *memory, int size)
{
  int pos=0;

  while(pos<size)
  {
    if((char *)memory[pos]==0)
      ((char *)memory)[pos]=' ';

    ++pos;
  }
}
int _fieeetomsbin(float *src4, float *dest4)
{
   unsigned char *ieee = (unsigned char *)src4;
   unsigned char *msbin = (unsigned char *)dest4;
   unsigned char sign = 0x00;
   unsigned char msbin_exp = 0x00;
   int i;

   /* See _fmsbintoieee() for details of formats   */
   sign = ieee[3] & 0x80;
   msbin_exp |= ieee[3] << 1;
   msbin_exp |= ieee[2] >> 7;

   /* An ieee exponent of 0xfe overflows in MBF    */
   if (msbin_exp == 0xfe)
    return 1;

   msbin_exp += 2;     /* actually, -127 + 128 + 1 */

   for (i=0; i<4; i++) msbin[i] = 0;

   msbin[3] = msbin_exp;

   msbin[2] |= sign;
   msbin[2] |= ieee[2] & 0x7f;
   msbin[1] = ieee[1];
   msbin[0] = ieee[0];

   return 0;
}

