PROGRAM silence_noisy_programs;
{$M 10480,0,655360}  { 10k reserved for data, remainder allowed for pointers }
{$N-,E- no math support needed}
{$X- function calls may not be discarded}
{$I- disable I/O checking (trap errors by checking IOResult)}

USES DOS;
CONST
  BufSize  = 8192;
TYPE
  BufferType = ARRAY [1..BufSize] OF CHAR;

PROCEDURE ShowHelp (problem : BYTE);
CONST
  NL = #13#10;
VAR
  message : STRING [79];
BEGIN
  WriteLn ('QUIET v1.10 - Free DOS utility: quiets noisy programs.');
  WriteLn ('September 29, 1995. Copyright (c) 1995 by David Daniel Anderson - Reign Ware.'+NL);
  WriteLn ('Usage:  QUIET noisy_prog.ext   {will OVERWRITE the file - use a backup!!!}'+NL);
  IF problem > 0 THEN BEGIN
    CASE problem OF
      1 : message := 'Invalid parameter on command line or parameter missing.';
      7 : message := 'File handling error.  File may have been corrupted or deleted!';
      ELSE  message := 'Unknown error.';
    END;
    WriteLn (#7, 'Error encountered (#', ExitCode, '):'); WriteLn (message);
  END;
  Halt (problem);
END;

PROCEDURE CheckIO;
BEGIN
  IF IOResult <> 0 THEN ShowHelp (7);
END;

FUNCTION IsFile (CONST FileName: PATHSTR): BOOLEAN;
VAR
  Attr  : WORD;
  cFile : FILE;
BEGIN
  Assign (cFile, FileName);
  GetFAttr (cFile, Attr);
  IF (DosError = 0) AND ((Attr AND Directory) <> Directory)
    THEN IsFile := TRUE
    ELSE IsFile := FALSE;
END;

FUNCTION IsDir (CONST FileName: PATHSTR): BOOLEAN;
VAR
  Attr  : WORD;
  cFile : FILE;
BEGIN
  Assign (cFile, FileName);
  GetFAttr (cFile, Attr);
  IF (DosError = 0) AND ((Attr AND Directory) = Directory)
    THEN IsDir := TRUE
    ELSE IsDir := FALSE;
END;

FUNCTION GetFilePath (CONST PSTR: STRING; VAR sDir: DIRSTR): PATHSTR;
VAR
  jPath     : PATHSTR;  { file path,       }
  jDir      : DIRSTR;   {      directory,  }
  jName     : NAMESTR;  {      name,       }
  jExt      : EXTSTR;   {      extension.  }
BEGIN
  jPath := PSTR;
  IF jPath = '' THEN jPath := '*.*';
  IF (NOT (jPath [Length (jPath)] IN [':', '\'])) AND IsDir (jPath) THEN
    jPath := jPath + '\';
  IF (jPath [Length (jPath)] IN [':', '\']) THEN
    jPath := jPath + '*.*';

  FSplit (FExpand (jPath), jDir, jName, jExt);
  jPath := jDir + jName+ jExt;

  sDir := jDir;
  GetFilePath := jPath;
END;

PROCEDURE QuietBuffer (VAR tBuffer : BufferType; Bytes: WORD; VAR NumNoises: WORD);
CONST
  HexE6 = '';
  Hex61 = 'a';
  NopNop : STRING [2] = '';
VAR
  BufIndex : WORD;
BEGIN
  FOR BufIndex := 1 TO (Bytes - 1) DO
    IF ((tBuffer [BufIndex] = HexE6) AND (tBuffer [BufIndex + 1] = Hex61)) THEN
    BEGIN
      Inc (NumNoises);
      Move (NopNop [1], tBuffer [BufIndex], 2);
    END;
END;

FUNCTION QuietFile (VAR infile, outfile : FILE): WORD;
VAR
  qBuffer : BufferType;
  BytesRead,
  BytesToWrite : WORD;
  NumNoises : WORD;
BEGIN
  NumNoises := 0;
  REPEAT
    BlockRead  (infile, qBuffer, BufSize, BytesRead);  CheckIO;
    QuietBuffer (qBuffer, BytesRead, NumNoises);
    BytesToWrite := BytesRead;
    IF BufSize = BytesRead THEN
    BEGIN
      Seek (infile, FilePos (infile) - 1);
      Dec (BytesToWrite);
    END;
    BlockWrite (outfile, qBuffer, BytesToWrite);  CheckIO;
  UNTIL (BytesRead < BufSize);
  QuietFile := NumNoises;
END;

TYPE
  FileList = ^FILEREC;
  FILEREC = RECORD
              Name : STRING [12];
              next : FileList;
            END;

CONST
  outname = 'quiet#$!.out';
  tmpname = 'quiet#$!.tmp';

VAR
  dirinfo : SEARCHREC;
  spath   : PATHSTR;
  sdir    : DIRSTR;
  sfn, dfn, tfn : PATHSTR;
  infile, outfile : FILE;

  anchor, chain : FileList;
  done    : BOOLEAN;
  numdone : WORD;
  NumNoises : WORD;
  FileDateTime : LONGINT;

BEGIN
  IF ParamCount <> 1 THEN ShowHelp (1);
  sPath := GetFilePath (ParamStr (1), sDir);
  dfn := sdir + outname;
  tfn := sdir + tmpname;

  numdone := 0;
  anchor := NIL;

  FindFirst (spath, Archive, dirinfo);

{---- Okay, let's go! ----}

  WHILE DosError = 0 DO
  BEGIN
    sfn := sdir + dirinfo. Name;
    done := FALSE;
    chain := anchor;            { check if file was processed file already }
    WHILE (chain <> NIL) AND (NOT done) DO
      IF (chain^. Name = dirinfo. Name)
        THEN done := TRUE
        ELSE chain := chain^. next;

{---- Only process if not processed before ----}

    IF (NOT done) THEN BEGIN
      Inc (numdone);
      New (chain);
      chain^. Name := dirinfo.Name; { add current name to beginning of list }
      chain^. next := anchor;
      anchor := chain;

{---- Process the file! ----}

      Write ('Quieting ', sfn, ', ');

      Assign (infile, sfn); Reset (infile,1); CheckIO;
      Assign (outfile, dfn); Rewrite (outfile,1); CheckIO;

      NumNoises := QuietFile (infile, outfile);
      WriteLn (NumNoises, ' noises were found.');

      GetFTime (infile, FileDateTime);
      SetFTime (outfile, FileDateTime);

{---- Close files, then find next file to process ----}

      Close (infile);        CheckIO;
      Close (outfile);       CheckIO;
      Rename (infile, tfn);  CheckIO;
      Rename (outfile, sfn); CheckIO;
      Erase (infile);        CheckIO;
    END;
    FindNext (dirinfo);
  END;     { now loop back with name of next file to process }

{---- dispose of pointers - not necessary at end, but good practice ----}

  WHILE chain <> NIL DO BEGIN
    anchor := chain;
    chain := chain^. next;
    Dispose (anchor);
  END;

  WriteLn ('Processed ', numdone, ' file(s).');
END. {main}
