unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls,Testrep,md_rep, ExtCtrls,printers, DBCtrls, DB,
  DBTables;

type
  TTQuickReportDemo = class(TForm)
    PreviewBtn: TButton;
    PrintBtn: TButton;
    PrintDialogChk: TCheckBox;
    Bevel1: TBevel;
    DemoLabel: TLabel;
    Label1: TLabel;
    ExitBtn: TButton;
    GroupBox1: TGroupBox;
    Portrait: TRadioButton;
    Landscape: TRadioButton;
    ReportCombo: TComboBox;
    procedure PreviewBtnClick(Sender: TObject);
    procedure ExitBtnClick(Sender: TObject);
    procedure PortraitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  TQuickReportDemo: TTQuickReportDemo;
  aOrientation : TPrinterOrientation;
implementation

{$R *.DFM}

procedure TTQuickReportDemo.PreviewBtnClick(Sender: TObject);
begin
   case ReportCombo.ItemIndex of
      0 : begin     { Create this report dynamically, just to show how to do it}
            TestReport:=TTestReport.Create(self);
            TestReport.Parent:=Self;
            TestReport.DemoReport.Orientation:=aOrientation;
            TestReport.DemoReport.DisplayPrintDialog:=PrintDialogChk.Checked;
            if Sender=PreviewBtn then
               TestReport.DemoReport.Preview
            else
               TestReport.DemoReport.Print;
            TestReport.Free;
         end;
      1 : begin
             MasterDetailReport.Report.Orientation:=aOrientation;
             MasterDetailReport.Report.DisplayPrintDialog:=PrintDialogChk.Checked;
             if Sender=PreviewBtn then
               MasterDetailReport.Report.Preview
             else
               MasterDetailReport.Report.Print;
          end;
   end;
end;

procedure TTQuickReportDemo.ExitBtnClick(Sender: TObject);
begin
   Close;
end;                            

procedure TTQuickReportDemo.PortraitClick(Sender: TObject);
begin
   if Portrait.Checked then
      aOrientation:=poPortrait
   else
      aOrientation:=poLandscape;
end;

procedure TTQuickReportDemo.FormCreate(Sender: TObject);
begin
   ReportCombo.ItemIndex:=0;
   aOrientation:=poPortrait;
end;

end.
