unit Testrep;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, Quickrep, StdCtrls, DBCtrls, DB, DBTables,
  ToCtrl;

type
  TTestReport = class(TForm)
    DemoReport: TQuickReport;
    DataSource1: TDataSource;
    Customer: TTable;
    Title: TQRBand;
    QRLabel1: TQRLabel;
    PageHeader: TQRBand;
    Group1Header: TQRBand;
    Alphabetic: TQRGroup;
    Letter: TQRLabel;
    CustomerCompany: TStringField;
    CustomerPhone: TStringField;
    CustomerFAX: TStringField;
    CustomerTaxRate: TFloatField;
    CustomerContact: TStringField;
    Detail: TQRBand;
    QRDBText1: TQRDBText;
    Summary: TQRBand;
    QRDBText2: TQRDBText;
    QRDBText3: TQRDBText;
    PageFooter: TQRBand;
    QRLabel2: TQRLabel;
    QRDBText4: TQRDBText;
    QRShape1: TQRShape;
    QRSysData2: TQRSysData;
    QRSysData1: TQRSysData;
    QRSysData3: TQRSysData;
    procedure TitleAfterPrint(Sender: TObject);
    procedure DemoReportBeforePrint(Sender: TObject);
    procedure Group1HeaderBeforePrint(Sender: TObject);
    procedure AlphabeticNeedData(var Value: OpenString);
     private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  TestReport: TTestReport;

implementation

{$R *.DFM}

procedure TTestReport.TitleAfterPrint(Sender: TObject);
begin
   PageHeader.Enabled:=True;                  { Enable page header for page 2+ }
end;

procedure TTestReport.DemoReportBeforePrint(Sender: TObject);
begin
   PageHeader.Enabled:=False;             { Disable page header for first page }
end;

procedure TTestReport.Group1HeaderBeforePrint(Sender: TObject);
begin
   Letter.Caption:=Alphabetic.GroupData;              { Print the first letter }
end;

procedure TTestReport.AlphabeticNeedData(var Value: OpenString);
begin
   Value:=copy(value,1,1);                        { This group is based on first
                                                       letter in customer name }
end;

end.
