COMMENT }
;  NOW.ASM -  display current date/time, along with the command tail to stdout
;  written December 26, 1991 by Dave Angel
;  Copyright 1991 by Dave Angel, All Rights Reserved
;  This program may be used and distributed freely without payment, provided
;  both this source code (which serves as documentation) and the program are
;  distributed together, and without modification.
;  Comments welcome to Dave Angel, Compuserve #  75300,1166 or 71046,1567

Usage:
   By default, this program echoes its command line, followed by today's
   day, date and time.  If you don't want that string at the end of the line,
   just include the flag '$$' wherever you do want it.  And if you want only
   a particular part of the date, use $$1, $$2, or $$3.  Following are examples

C:>NOW I finished that at
 I finished that at Thu 12/26/91 08:43:05
C:>NOW The complete date is $$ and it works
 The complete date is Thu 12/26/91 08:48:22 and it works
C:>NOW On $$1 I went home
 On Thu I went home
C:>NOW Today is $$2, but it's not done
 Today is 12/26/91, but it's not done
C:>NOW It's $$3, do you know where your children are?
 It's 08:44:26, do you know where your children are?
C:>NOW The dates can be ordered $$3 and $$2 and $$1 & repeated $$1
 The dates can be ordered 08:49:15 and 12/26/91 and Thu & repeated Thu

}
code  segment
assume  cs:code, ds:code, es:code

        org      80h
tailsize        db      ?
cmdtail         db      7fh dup (?)
        org 100h

main    proc
        jmp short init
copyright       db      'Copr 1991 by Dave Angel, All Rights Reserved'
version         db      'version 1.0 12-26-91'
days    db      "Sun$Mon$Tue$Wed$Thu$Fri$Sat$"
flag    db      0               ; flag that date not yet printed

init:
        cld
        xor     cx,cx
        mov     cl,tailsize
        jcxz    done
        mov     si,offset cmdtail
loopit:
        lodsb
        cmp     al,'$'
        jne     loop4
        cmp     [si].0,al
        jne     loop4
;  Here if a '$$' is encountered (two in a row)
        inc     si
        dec     cx
        call    writedate
        jmp     short loop5

loop4:
        call    writebyte
loop5:
        loop    loopit

done:
        cmp     flag,0
        jne     done2
        mov     al,' '
        call    writebyte       ; space
        call    writedate       ; if not written yet, do it at end
done2:
        mov     ax,0a0dh
        call    writeword
        mov     ax,4c00h
        int     21h

; Write current date/time to stdout
;   $$1    day of week
;   $$2    date
;   $$3    time
;   $$     all three
writedate:
        mov     flag,'7'

        mov     al,[si]
        cmp     al,'1'
        jb      writedate3
        cmp     al,'3'
        ja      writedate3
        jne     writedate2
        inc     al              ; if it was '3', make it '4'
writedate2:
        inc     si              ; skip past the flag character
        dec     cx
        mov     flag,al
; at this point, flag is '1', '2', or '4', or '7' by default.  Each of bottom
;   three bits flags one of the date types
writedate3:
        push    dx
        push    cx
;writeday:
        test    flag,01         ; check if we're supposed to display day
        jz      writetoday      ; skip if not

        mov     ah,2ah
        int     21h             ; get date
        xor     ah,ah
        add     al,al
        add     al,al           ; multiply day by 4
        mov     dx,offset days
        add     dx,ax
        mov     ah,9
        int     21h             ; display day of week

        cmp     flag,'7'        ; test if we're displaying whole string
        jne     writetime
        mov     al,' '
        call    writebyte       ; if so, put space between

writetoday:
        test    flag,02         ; test if we're supposed to display date
        jz      writetime
        mov     ah,2ah
        int     21h             ; get date
        mov     al,dh
        call    writenum2       ; write two-digit month number
        mov     al,'/'
        call    writebyte
        mov     al,dl
        call    writenum2       ; write two-digit day number
        mov     al,'/'
        call    writebyte
        sub     cx,1900
        mov     al,cl
        call    writenum2       ; write two-digit year number

        cmp     flag,'7'        ; test if we're displaying whole string
        jne     writetime
        mov     al,' '
        call    writebyte       ; if so, put space between

writetime:
        test    flag,04         ; test if we're supposed to write time
        jz      writedate9
        mov     ah,2ch
        int     21h             ; get time
        mov     al,ch
        call    writenum2       ; write hour
        mov     al,':'
        call    writebyte       ; colon
        mov     al,cl
        call    writenum2       ; write minute
        mov     al,':'
        call    writebyte       ; colon
        mov     al,dh
        call    writenum2       ; write second

writedate9:
        pop     cx
        pop     dx
        ret

; Output AL to stdout, formatted as a two digit decimal number
writenum2:
        AAM
        or      ax,3030h
        xchg    ah,al
        call    writeword
        ret

; Output AL to stdout, then AH
writeword:
        push    ax
        call    writebyte
        pop     ax
        xchg    ah,al
;  Output AL to stdout
writebyte:
        push    dx
        mov     dl,al
        mov     ah,02
        int     21h
        pop     dx
        ret

main    endp
code    ends
end     main

