@echo off
echo  *************************************
echo *** QuakeMap Batch for DOS run-time ***
echo  *************************************
echo.

rem ***  Quake root directory is set here : ***
set QUAKE=\QUAKE
set TOOLDIR=.

if "%1"=="" goto Info

if exist qmdosrt~.bat del qmdosrt~.bat

:Loop
if "%1"=="" goto Stop
if "%1"=="/b" goto Rebuild
if "%1"=="/m" goto Macro
if "%1"=="/q" goto Run
if "%1"=="/stop" goto Stop
goto RT

:Rebuild
shift
cd %QUAKE%\QMapExec\maps
if not exist %TOOLDIR%\QBSP.EXE goto BuildError
if not exist %TOOLDIR%\VIS.EXE goto BuildError
if not exist %TOOLDIR%\LIGHT.EXE goto BuildError
%TOOLDIR%\QBSP %1
if not exist %1.bsp goto QBSPError
%TOOLDIR%\VIS %1
%TOOLDIR%\LIGHT -extra %1
shift
goto Loop

:Macro
shift
cd %QUAKE%\QMapExec\maps
if not exist %TOOLDIR%\QBSP.EXE goto BuildError
if not exist %TOOLDIR%\VIS.EXE goto BuildError
if not exist %TOOLDIR%\LIGHT.EXE goto BuildError
rem {
echo This text should not appear on your screen.
rem }
shift
goto Loop

:QBSPError
echo.
echo -----------------------------------------------------------------------------
echo QBSP failed.  Press any key to continue...
pause > nul
goto Stop

:BuildError
echo.
echo Build error : one of the following files do not exist :
echo.
echo  %TOOLDIR%\QBSP.EXE
echo  %TOOLDIR%\VIS.EXE
echo  %TOOLDIR%\LIGHT.EXE
echo.
echo These three files are required to build levels. They can be found at
echo any Quake-related ftp server (including ftp.cdrom.com/pub/idgames2).
echo.
pause
goto Stop

:Run
cd %QUAKE%
if not exist QMapExec\*.* md QMapExec
echo exec default.cfg > QMapExec\quake.rc
echo exec config.cfg >> QMapExec\quake.rc
echo exec autoexec.cfg >> QMapExec\quake.rc
echo exec qmapexec.cfg >> QMapExec\quake.rc
echo stuffcmds >> QMapExec\quake.rc
if exist QMapExec\config.cfg del QMapExec\config.cfg

Quake -game QMapExec %2 %3 %4 %5 %6 %7 %8 %9

goto Stop

:Info
if exists qmdosrt.exe goto InfoRT
echo This batch has two purposes : it is used internally by QuakeMap
echo and it is used to launch the DOS Run-Time version of QuakeMap.
echo.
echo If you are using the full Windows version of QuakeMap, you don't
echo need to run this batch directly. If you want to use the DOS
echo Run-Time, QMDOSRT.EXE, you must put it in the current directory
echo first, and run QM.BAT then.
goto Stop

:InfoRT
echo This batch is used to extract and run a QuakeMap file.
echo It extracts maps, compiles QuakeC patches, uses QBSP to
echo reduild maps, and launches Quake.
echo.
echo Syntax :  QM [filename]
echo  where [filename] is the name of the '.qme' file.
echo.
goto Stop

:RT
echo qmdosrt %1 %2 %3 %4 %5 %6 %7 %8 %9 > qmdosrt~.bat
qmdosrt~

:Stop
set TOOLDIR=
set QUAKE=
