@echo off
echo  *************************************
echo *** QuakeMap Batch for DOS run-time ***
echo  *************************************
echo.

rem ***  Quake root directory is set here : ***
set QUAKE=\QUAKE
set TOOLDIR=.

if "%1"=="" goto Info

if exist qmdosrt~.bat del qmdosrt~.bat

:Loop
if "%1"=="" goto Stop
if "%1"=="/b" goto Rebuild
if "%1"=="/k" goto RebuildQuick
if "%1"=="/1" goto QBSP
if "%1"=="/2" goto VIS
if "%1"=="/3" goto LIGHT
if "%1"=="/q" goto Run
if "%1"=="/stop" goto Stop
goto RT

:Rebuild
shift
cd %QUAKE%\QMapExec\maps
if not exist %TOOLDIR%\QBSP.EXE goto BuildError
if not exist %TOOLDIR%\VIS.EXE goto BuildError
if not exist %TOOLDIR%\LIGHT.EXE goto BuildError
%TOOLDIR%\QBSP %1
if not exist %1.bsp goto QBSPError
%TOOLDIR%\VIS %1
%TOOLDIR%\LIGHT -extra %1
shift
goto Loop

:RebuildQuick
shift
cd %QUAKE%\QMapExec\maps
if not exist %TOOLDIR%\QBSP.EXE goto BuildError
if not exist %TOOLDIR%\LIGHT.EXE goto BuildError
%TOOLDIR%\QBSP %1
if not exist %1.bsp goto QBSPError
%TOOLDIR%\LIGHT %1
shift
goto Loop

:QBSP
shift
cd %QUAKE%\QMapExec\maps
if not exist %TOOLDIR%\QBSP.EXE goto BuildError
%TOOLDIR%\QBSP %1
if not exist %1.bsp goto QBSPError
shift
goto Loop

:VIS
shift
cd %QUAKE%\QMapExec\maps
if not exist %TOOLDIR%\VIS.EXE goto BuildError
%TOOLDIR%\VIS %1
shift
goto Loop

:LIGHT
shift
cd %QUAKE%\QMapExec\maps
if not exist %TOOLDIR%\LIGHT.EXE goto BuildError
%TOOLDIR%\LIGHT %1
shift
goto Loop

:QBSPError
echo.
echo -----------------------------------------------------------------------------
echo QBSP failed.  Press any key to continue...
pause > nul
goto Stop

:BuildError
echo.
echo Build error : one of the following files do not exist :
echo.
echo  %TOOLDIR%\QBSP.EXE
echo  %TOOLDIR%\VIS.EXE
echo  %TOOLDIR%\LIGHT.EXE
echo.
echo These three files are required to build levels. They can be found at
echo any Quake-related ftp server (including ftp.cdrom.com/pub/idgames2).
echo.
pause
goto Stop

:Run
cd %QUAKE%
if not exist QMapExec\*.* md QMapExec
echo exec default.cfg > QMapExec\quake.rc
echo exec config.cfg >> QMapExec\quake.rc
echo exec autoexec.cfg >> QMapExec\quake.rc
echo exec qmapexec.cfg >> QMapExec\quake.rc
echo stuffcmds >> QMapExec\quake.rc
if exist QMapExec\config.cfg del QMapExec\config.cfg

Quake -game QMapExec %2 %3 %4 %5 %6 %7 %8 %9

goto Stop

:Info
echo This batch is used to extract and run a QuakeMap file.
echo It extracts maps, compiles QuakeC patches, uses QBSP to
echo reduild maps, and launches Quake.
echo.
echo Syntax :  QM [filename]
echo  where [filename] is the name of the '.qme' file.
echo.
goto Stop

:RT
echo qmdosrt %1 %2 %3 %4 %5 %6 %7 %8 %9 > qmdosrt~.bat
qmdosrt~

:Stop
set TOOLDIR=
set QUAKE=
