#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <fcntl.h>
#include "qic_02.h"

static char buf1[16384], buf2[16384], pbuf[1024];
static int bufId=0;
static int far *screen = (int far *)0xB8000000;
static int screenLoc = 1920;

void printb(char *str)
{
int i;

   for(i=0; str[i]; i++)
   {
      if(str[i] == '\n')
      {
         for(screenLoc=1920; screenLoc<2000; screenLoc++)
            screen[screenLoc] = 0x0700 | ' ';
         screenLoc = 1920;
      }
      else
      {
         screen[screenLoc++] = 0x0700 | (str[i] & 0xFF);
         if(screenLoc >= 2000)
            screenLoc = 1920;
      }
   }
}

void main(int argc, char **argv)
{
int port, intr, dma, fd, rv, cnt, neg;
char c, fname[128];

   if(argc < 4)
   {
      puts("Usage: qictest <port> <int> <dma> [debug]");
      return;
   }
   if(argc > 4)
      qicDebug = atoi(argv[4]);

   for(cnt=0; cnt<2000; cnt++)
      screen[cnt] = 0x700 | ' ';
   sscanf(argv[1], "0x%X", &port);
   intr = atoi(argv[2]);
   dma = atoi(argv[3]);
   sprintf(pbuf,"Initialising controller at port 0x%X, Int: %d, DMA %d",
      port, intr, dma);
   printb(pbuf);
   sprintf(pbuf,", Returned: %d", rv=qicInit(port, intr, dma, 0));
   printb(pbuf);
   if(rv)
      return;
   for(;;)
   {
      printb(", Enter command (1/2/0/5/e/r/s/f/w/m/q): ");
   again:
      c = getch();
      screen[screenLoc++] = 0x0700 | (c & 0xFF);
      switch(c)
      {
      case '1':
         printb("\nSelecting QIC-11");
         sprintf(pbuf,", Returned: %d", qicSelect(QIC11_FORMAT));
         printb(pbuf);
         break;

      case '2':
         printb("\nSelecting QIC-24");
         sprintf(pbuf,", Returned: %d", qicSelect(QIC24_FORMAT));
         printb(pbuf);
         break;

      case '0':
         printb("\nSelecting QIC-120");
         sprintf(pbuf,", Returned: %d", qicSelect(QIC120_FORMAT));
         printb(pbuf);
         break;

      case '5':
         printb("\nSelecting QIC-150");
         sprintf(pbuf,", Returned: %d", qicSelect(QIC150_FORMAT));
         printb(pbuf);
         break;

      case 'e':
      case 'E':
         printb("\nErasing tape");
         sprintf(pbuf,", Returned %d", qicEraseTape());
         printb(pbuf);
         break;

      case 'r':
      case 'R':
         printb("\nRewinding tape");
         sprintf(pbuf,", Returned: %d", qicRewind());
         printb(pbuf);
         break;

      case 's':
      case 'S':
         printb("\nSkipping file");
         sprintf(pbuf,", Returned: %d", qicSkipFile());
         printb(pbuf);
         break;
      
      case 'q':
      case 'Q':
         printb("\nRewinding tape and exiting");
         sprintf(pbuf,", Returned: %d", qicRewind());
         printb(pbuf);
         qicDeInit();
         return;

      case 'f':
      case 'F':
         printb("\nEnter file name: ");
         cnt = 0;
         while((fname[cnt] = getch()) != '\r')
            screen[screenLoc++] = 0x0700 | (fname[cnt++] & 0xFF);
         fname[cnt] = 0;
         printb("\nReading file");
         if((fd = open(fname, O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0666)) < 0)
         {
            printb(", Unable to create file:");
            printb(fname);
            return;
         }
         bufId=0;
         cnt=32;
         qicReadBlocks(buf1, cnt);
         do {
            rv=qicComplete();
            if(rv > 0)
            {
               qicReadBlocks((bufId) ? buf1 : buf2, cnt);
               write(fd, (bufId) ? buf2 : buf1, rv * 512);
               sprintf(pbuf,",%X", rv*512);
               printb(pbuf);
            }
            bufId=1-bufId;
         } while(rv > 0);
         close(fd);
         printb("Done.");
         break;

      case 'w':
      case 'W':
         printb("\nEnter file name: ");
         cnt = 0;
         while((fname[cnt] = getch()) != '\r')
            screen[screenLoc++] = 0x0700 | (fname[cnt++] & 0xFF);
         fname[cnt] = 0;
         printb("\nWriting file");
         if((fd = open(fname, O_RDONLY | O_BINARY)) < 0)
         {
            printb(", Unable to open file:");
            printb(fname);
            return;
         }
         bufId=0;
         cnt=read(fd, buf1, 16384);
         qicWriteBlocks(buf1, (cnt+511)/512);
         do {
            cnt=read(fd, (bufId) ? buf1 : buf2, 16384);
            rv=qicComplete();
            sprintf(pbuf, ",%X", rv*512);
            printb(pbuf);
            bufId=1-bufId;
            if(cnt > 0)
            {
               qicWriteBlocks((bufId) ? buf2 : buf1, (cnt+511)/512);
            }
         } while(cnt > 0);
         close(fd);
         printb("Done.");
         break;

      case 'm':
      case 'M':
         printb("\nWriting file mark");
         sprintf(pbuf,", Returned %d:", qicWriteFileMark());
         printb(pbuf);
         break;

      default:
         if(c == '-')
         {
            c = getch();
            screen[screenLoc++] = 0x0700 | (c & 0xFF);
            neg = -1;
         }
         else
            neg = 1;
         if(c >= '0' && c <= '9')
            qicDebug = neg * (c - '0');
         else
            fputc('\007',stderr);
      }
   }
}

