UNIT ArcType; {based mostly on a code snippet found in SWAG}
(* A Pascal unit which will determine most of the major archive Types.
   To use this unit, simply call the procedure as follows:
   If GetArcType(FileName.Ext)=ZIP then.... *)

INTERFACE

USES
  DOS;
TYPE
  fileArcType = (FileError, Unknown,
  ARC, ARJ, HAP, LZH, PAK, PKPak, RAR, SQZ, UC2, ZIP, ZOO);
  
FUNCTION GetArcType (FName : STRING) : fileArcType;

IMPLEMENTATION

FUNCTION GetArcType (FName : STRING) : fileArcType;
VAR
  ArcFile : FILE OF BYTE;
  i       : INTEGER;
  Gat     : fileArcType;
  c       : ARRAY [1..5] OF BYTE;
BEGIN
  Assign (ArcFile, FName);
  {$I-}
  Reset (ArcFile);
  {$I+}
  IF IOResult <> 0 THEN
    Gat := FileError
  ELSE
  IF FileSize (ArcFile) < 5 THEN
    Gat := FileError
  ELSE BEGIN
    FOR i := 1 TO 5 DO
      Read (ArcFile, c [i]);
    Close (ArcFile);
    IF ( (c [1] = $1a) AND (c [2] = $08)) THEN
      Gat := ARC
    ELSE
    IF ( (c [1] = $60) AND (c [2] = $EA)) THEN
      Gat := ARJ
    ELSE
    IF ( (c [1] = $91) AND (c [2] = $33) AND (c [3] = $48) AND (c [4] = $46)) THEN
      Gat := HAP
    ELSE
    IF ( (c [4] = $6c) AND (c [5] = $68)) THEN
      Gat := LZH
    ELSE
    IF ( (c [1] = $1a) AND (c [2] = $0b)) THEN
      Gat := PAK
    ELSE
    IF ( (c [1] = $1a) AND (c [2] = $09)) THEN
      Gat := PKPak
    ELSE
    IF ( (c [1] = $52) AND (c [2] = $61) AND (c [3] = $72)) THEN
      Gat := RAR
    ELSE
    IF ( (c [1] = $53) AND (c [2] = $51) AND (c [3] = $57)) THEN
      Gat := SQZ
    ELSE
    IF ( (c [1] = $55) AND (c [2] = $43) AND (c [3] = $32)) THEN
      Gat := UC2
    ELSE
    IF ( (c [1] = $50) AND (c [2] = $4B)) THEN
      Gat := ZIP
    ELSE
    IF ( (c [1] = $5a) AND (c [2] = $4f) AND (c [3] = $4f)) THEN
      Gat := ZOO
    ELSE
   {IF none of the above}
      Gat := Unknown;
  END;

  GetArcType := Gat;
END;

BEGIN
END.

