/*
 * DESQview/X Socket Library. Copyright (c) 1991 Quarterdeck Office Systems.
 */

#ifndef __QDECK_H__
#define __QDECK_H__

#ifndef NO_PROTO

int pif_start(char *args);
/* example:

   pif_start("maze"); 
   pif_start("maze -r"); 
   pif_start("maze -r -display hostname:0"); 
   pif_start("dos");
   pif_start("dos dir /w");
   pif_start("dos dir /w -display hostname:0");

   The first word of "args" must be a file name. If no extension is present a 
   ".dvp" will be added. If no path is present the file will be looked for in
   current directory then in the path.
   
*/

unsigned long NewProc(char *buf,int len);
/* example:

   char dvpbuf[PIFSIZE];
   int ret,buflen;

   buflen = PIFSIZE;

   dvpbuf is a dvp either previous read from disk or one created in memory.
   buflen is the length of the dvp being passed in dvpbuf.

   handle = NewProc(dvpbuf,buflen);

   if (handle == 0) printf("Could not start process\n");
   else printf("Proces handle is %d\n",handle);

*/

FILE *pif_open(char *pifname,char **pathname);
/* example:

   FILE fp;
   char *pathname;

   fp = pif_open("dos.dvp",&pathname);

            ... or ...

   fp = pif_open("dos.dvp",NULL);

   ....

   You may want to use pif_open in conjunction with fread and NewProc 
   if adjustments need to be made to the dvp before it is started. 

   if (fp && pathname)
      free(pathname);

*/

void dvpath(char *); /* Pass buffer, will return "c:\dvx" */
/* example:

   char pathname[MAXPATHLEN];

   dvpath(pathname);

   printf("DESQview/X is installed in %s\n",pathname);

*/

int CanonicalPath(char *inpath, char *outpath);
/*
   Calls DOS INT 21h, Function 60h since D16m does not handle it as of
   Wed  11-20-1991
*/

#else /* NO_PROTO */

int pif_start();
unsigned long NewProc();
FILE *pif_open();
void dvpath();
int CanonicalPath();

#endif /* NO_PROTO */

#endif /* __QDECK_H__ */



