/*
 * DESQview/X Socket Library. Copyright (c) 1991 Quarterdeck Office Systems.
 */

/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

/*
 * Constants and structures defined by the internet system,
 * Per RFC 790, September 1981.
 */

#ifndef __NETINET_IN_H__
#define __NETINET_IN_H__


/* Internet Address structure
*/
struct in_addr {
    union {
        struct { char s_b1,s_b2,s_b3,s_b4; } S_un_b;
        struct { unsigned short s_w1,s_w2; } S_un_w;
        long S_addr;
    } S_un;
#define    s_addr  S_un.S_addr        /* can be used for most tcp & ip code */
#define    s_host  S_un.S_un_b.s_b2   /* host on imp */
#define    s_net   S_un.S_un_b.s_b1   /* network */
#define    s_imp   S_un.S_un_w.s_w2   /* imp */
#define    s_impno S_un.S_un_b.s_b4   /* imp # */
#define    s_lh    S_un.S_un_b.s_b3   /* logical host */
#define    S_baddr S_un.S_un_b
};

#define INADDR_ANY      0x00000000

struct sockaddr_in {
        short		sin_family;
        unsigned short	sin_port;
        struct in_addr	sin_addr;
        char		sin_zero[8];
};

#ifndef NO_PROTO

/* Network and machine order conversion routines */

  unsigned short htons(unsigned short);
  unsigned short ntohs(unsigned short);
  unsigned long  htonl(unsigned long);
  unsigned long  ntohl(unsigned long);

/* Inet C functions    */

  unsigned long  inet_addr(char *);
  unsigned long  inet_network(char *);
  char           *inet_ntoa(struct in_addr);
  struct in_addr inet_makeaddr(long, long);
  unsigned long  inet_lnaof(struct in_addr);
  unsigned long  inet_netof(struct in_addr);

#else /* NO_PROTO */

/* Network and machine order conversion routines */

  unsigned short htons();
  unsigned short ntohs();
  unsigned long  htonl();
  unsigned long  ntohl();

/* Inet C functions    */

  unsigned long  inet_addr();
  unsigned long  inet_network();
  char           *inet_ntoa();
  struct in_addr inet_makeaddr();
  unsigned long  inet_lnaof();
  unsigned long  inet_netof();

#endif /* NO_PROTO */

#endif /* __NETINET_IN_H__ */
