#ifndef __HELPP_H__
#define __HELPP_H__

#include <help.h>

/* INIT FLAGS */

#define HF_NO_FLAGS               0
#define HF_ORPHAN                 (1 << 0)
#define HF_SPAWN                  (1 << 1)
#define HF_NO_CLOSE_ON_TERMINATE  (1 << 2)
#define HF_BREAKOPEN              (1 << 3)

#define HF_FIRST_CALL             (1 << 7) /* internal use only */

/* COMMAND CODES */

#define HC_GOTO         1
#define HC_TERMINATE    2

/* PRIVATE STRUCTURE */

typedef struct _HelpItem {
  void           *previous;
  void           *next;
  unsigned long   signature;
  char           *display_name;
  short           display_name_len;
  Window          group_id;
  char           *win_title;
  short           win_title_len;
  char           *file_name;
  short           file_name_len;
  short           flags;
  char           *help_pif;
  short           start_timeout;
  short           send_timeout;
  Help_callback   callback;
  void           *user_arg;
  } HelpItem;

#endif /* __HELPP_H__ */
