#ifndef __HELP_H__
#define __HELP_H__

/* RETURN CODES */

#define H_OK                  0

#define PAD_NO_MEMORY         1          /* ERROR codes from Help Engine */
#define PAD_NO_FILE           2
#define PAD_BAD_FILE          3
#define PAD_NO_TOPIC          4
#define PAD_BAD_CMD           5
#define PAD_SERVER_NO_MEM     6
#define PAD_NO_CONNECT        8
#define PAD_BAD_VERSION       9

#define H_BAD_ID            128           /* ERROR codes from bindings */
#define H_NO_MEMORY         129

#define H_NO_FILE           140           /* Help_get_sections() */
#define H_BAD_FILE          141
#define H_NO_TOPIC          142
#define H_BAD_DVPFILE       143
#define H_FNAME_TOO_LONG    144

#define H_TIMEOUT           150           /* Help_show() */
#define H_SEND_ERROR        151
#define H_RECEIVE_ERROR     152
#define H_START_ERROR       153

/* CALLBACK */

typedef void (*Help_callback)(void *user_arg);

/* ID */

typedef struct _HelpItem *HelpID;

/* FUNCTIONS */

int Help_initialize (char *display_name, char *win_title, char *file_name,
    int start_timeout, int send_timeout, Help_callback callback,
    void *user_arg, HelpID *id);
int Help_get_sections(HelpID id, int *ntabs, char **tabs[], char **topics[]);
int Help_show(HelpID id, char *topic);
int Help_terminate(HelpID id);

#endif /* __HELP_H__ */
