'
'  This function returns the amount of free extended memory in KB.
'
DEFSNG A-E,G-Z
DEFLNG F
FUNCTION FREEXMS&
DIM AXMS AS LONG,OS AS INTEGER,AX AS INTEGER
'
'  Get what interrupt 15 thinks is available XMS memory.  If this is 0,
' look for presence of HIMEM.SYS.  If driver is present, null result of
' memory query is probably erroneous.  Just set AXMS equal to maximum
' possible value of 31 or 15 MB, depending on whether machine is a 386+ or
' 286.  Otherwise, null result is meaningful.  Leave it as such and set
' global variable DRVEXIST to zero.  (A non-null result that has the same
' effect as a (valid) null result is if the call to interrupt 15 with
' function 87 returns AH as 80h or 86h--which will happen on a machine
' that isn't even a 286, let alone a 386+.)
'
DRVEXIST=0
DEF SEG=VARSEG(MCODE(1))
OS=VARPTR(MCODE(1))
POKE OS+5,&H88 : POKE OS+7,&H15
CALL ABSOLUTE(AX,OS)
AXMS=(CLNG(AX)+65536&) MOD 65536&
'
'  If AXMS > 32767, machine must be less than a 286.  There can't be any
' XMS--or if there is, somehow, QBXMS can't use it.
'
IF AXMS<32768& THEN
IF AXMS=0 THEN
POKE OS+5,&H43 : POKE OS+7,&H2F
CALL ABSOLUTE(AX,OS)
IF (AX AND &HFF)=&H80 THEN
'
'  HIMEM.SYS is loaded.
'
DRVEXIST=1
'
'  Determine whether machine is 286 or 386+.  (Actually, the machine code
' routine only determines whether it's a 386+ or not.  If it's not a 386
' or better, it is just assumed to be a 286.  (If it's less than a 286, a
' previous test should stop this part of the code from executing.)
'
OS=OS+34
CALL ABSOLUTE(AX,OS)
'
'  If AX < 4096, take processor to be 80286.
'
AXMS=15&*1024& : IF AX>4095 THEN AXMS=31&*1024&
END IF
END IF
'
'  The above interrupt call only returns the amount of XMS that the
' computer thinks is available.  It cannot tell that this software has
' put data in XMS.  The memory consumed by that data must be subtracted
' from the output from the interrupt call.
'
MEMUSED=0
IF NARRAY>0 THEN
DATALEN=4
IF TYPEDAT(NARRAY)="INTEGER" THEN DATALEN=2
IF TYPEDAT(NARRAY)="DOUBLE" THEN DATALEN=8
MEMUSED=DATALEN*LENDAT(NARRAY)+ADDRESS(NARRAY)-&H110000&
END IF
'
'  The 64 takes into account the fact that the first 64 KB of XMS isn't
' used in an attempt to preserve the HMA.
'
FREEXMS=AXMS-CLNG(MEMUSED/1024)-64&
ELSE
FREEXMS=0
END IF
DEF SEG
END FUNCTION
DEFSNG F
'
'  This subroutine initializes an extended memory one-dimensional data
' "array."  Currently, it does not support string arrays.  ANAME is a
' string representing the name of the array, N is a 4-byte integer
' giving the number of elements in the array (1-based), and DATATYPE is
' a character string representing the data type:  "LONG", "INTEGER",
' "SINGLE", or "DOUBLE", just as with conventional arrays.  ERRORCODE is
' returned as 1 if there is insufficient extended memory and 0 if the
' dimensionalizing operation was successful.  It is returned as 2 if there
' are already 16 XMS arrays.  If ERRORCODE is *input* as something other
' than zero, DIMXMS will not initialize the array elements to zero.
' Execution will be terminated if you attempt a REDIM operation.
'
SUB DIMXMS(ANAME AS STRING,N AS LONG,DATATYPE AS STRING,ERRORCODE AS SINGLE)
DIM BYTES AS LONG,ADD AS LONG,DATAL AS LONG,SOURCEADD AS LONG,IBYTES AS LONG
DIM SMZ AS LONG,OSZ AS LONG,J AS LONG,EXBYTES AS LONG,ZERO(1 TO 16384) AS LONG
'
'  If number of arrays is already maxed out, return immediately with a
' nonzero error code.
'
IF NARRAY=16 THEN ERRORCODE=2 : EXIT SUB
'
'  Get number of bytes in array ANAME and make sure there's enough
' extended memory.
'
'  If DATATYPE isn't recognizable, "SINGLE" is assumed.
'
DT$=UCASE$(LTRIM$(RTRIM$(DATATYPE)))
IF DT$<>"DOUBLE" AND DT$<>"LONG" AND DT$<>"INTEGER" THEN DT$="SINGLE"
DATAL=4&
IF DT$="INTEGER" THEN DATAL=2&
IF DT$="DOUBLE" THEN DATAL=8&
BYTES=DATAL*N
IF FREEXMS*1024&<BYTES THEN ERRORCODE=1 : EXIT SUB
'
'  Update "Data Allocation Table."  (Look out for REDIM attempt.)
'
NARRAY=NARRAY+1 : NAMEDAT(NARRAY)=UCASE$(LTRIM$(RTRIM$(ANAME)))
LENDAT(NARRAY)=N : TYPEDAT(NARRAY)=DT$
IF NARRAY>1 THEN
FOR I=1 TO NARRAY-1
IF NAMEDAT(I)=UCASE$(LTRIM$(RTRIM$(ANAME))) THEN
PRINT "DIMXMS:  REDIM operation attempted.  (Use REDIMXMS.)"
STOP
END IF
NEXT I
ELSE
ADDRESS(NARRAY)=&H110000&
END IF
'
'  Get address of *next* extended memory array.  (This is why the "17" in
' QBXMS.INC wasn't a typo.)
'
ADDRESS(NARRAY+1)=ADDRESS(NARRAY)+BYTES
'
'  Rest of this is unnecessary if ERRORCODE was input as nonzero.
'
IF ERRORCODE=0 THEN
'
'  Define an array storing 64K worth of zeros and get its linear memory
' location.
'
FOR I=1 TO 16384
ZERO(I)=0
NEXT I
SMZ=VARSEG(ZERO(1)) : OSZ=VARPTR(ZERO(1))
SMZ=(SMZ+65536&) MOD 65536&
OSZ=(OSZ+65536&) MOD 65536&
SOURCEADD=SMZ*16&+OSZ
'
'  Transfer BYTES 0s to extended memory starting at ADD.  This will be
' done in 64K chunks at a time (and then any excess will be transferred).
'
IBYTES=65536&*INT(CDBL(BYTES)/65536&+.001)
EXBYTES=BYTES-IBYTES
ADD=ADDRESS(NARRAY)
IF IBYTES>0 THEN
FOR J=1 TO IBYTES STEP 65536&
'
'  Transfer 65,536 bytes.
'
CALL MEMTRN(SOURCEADD,ADD,65536&)
'
'  Update ADD for next block of zeros.
'
ADD=ADD+65536&
NEXT J
END IF
IF EXBYTES>0 THEN
'
'  Transfer remaining zeros.
'
CALL MEMTRN(SOURCEADD,ADD,EXBYTES)
END IF
END IF
'
'  Presumably, operation was successful.  Set return error code.
'
ERRORCODE=0
END SUB
'
'  This subroutine clears the XMS array ANAME and reallocates its data
' space for reuse by DIMXMS.
'
SUB CLRXMS(ANAME AS STRING)
DIM BYTES AS LONG,ADD AS LONG,DATAL AS LONG,SOURCEADD AS LONG,IBYTES AS LONG
DIM TOPADD AS LONG,OSZ AS LONG,J AS LONG,EXBYTES AS LONG,N AS LONG
'
'  Find ANAME in Data Allocation Table.  If it doesn't exist, there's no
' need to do anything.
'
NCLR=0
FOR I=1 TO NARRAY
IF NAMEDAT(I)=UCASE$(LTRIM$(RTRIM$(ANAME))) THEN NCLR=I : EXIT FOR
NEXT I
IF NCLR=0 THEN EXIT SUB
'
'  If NCLR = NARRAY, all that needs to be done is decrease NARRAY by 1.
' Otherwise, in addition, data in extended memory above ANAME must be
' moved down and arrays in Data Allocation Table updated.
'
IF NCLR<NARRAY THEN
N=UXMS(ANAME,ADD)
N=UXMS(NAMEDAT(NCLR+1),SOURCEADD)
'
'  Get number of bytes starting at SOURCEADD to be moved down.  This will
' be done in 64K chunks at a time (and then any excess will be
' transferred).
'
N=UXMS(NAMEDAT(NARRAY),TOPADD)
DATAL=4&
IF TYPEDAT(NARRAY)="INTEGER" THEN DATAL=2&
IF TYPEDAT(NARRAY)="DOUBLE" THEN DATAL=8&
BYTES=TOPADD-SOURCEADD+N*DATAL
IBYTES=65536&*INT(CDBL(BYTES)/65536&+.001)
EXBYTES=BYTES-IBYTES
IF IBYTES>0 THEN
FOR J=1 TO IBYTES STEP 65536&
'
'  Transfer 65,536 bytes.
'
CALL MEMTRN(SOURCEADD,ADD,65536&)
'
'  Update SOURCEADD and ADD for next block of data.
'
SOURCEADD=SOURCEADD+65536&
ADD=ADD+65536&
NEXT J
END IF
IF EXBYTES>0 THEN
'
'  Transfer remaining data.
'
CALL MEMTRN(SOURCEADD,ADD,EXBYTES)
END IF
'
'  Update Data Allocation Table.
'
FOR I=NCLR TO NARRAY-1
LENDAT(I)=LENDAT(I+1)
NAMEDAT(I)=NAMEDAT(I+1)
TYPEDAT(I)=TYPEDAT(I+1)
NEXT I
'
'  The address table is a little harder.  The base address of the array
' that moves into the original NCLR array's space is the same as the
' address of that original array.  Use it to start the upward iterations
' (after re-obtaining it).
'
ADD=ADDRESS(NCLR)
FOR I=NCLR+1 TO NARRAY-1
DATAL=4&
IF TYPEDAT(I-1)="INTEGER" THEN DATAL=2&
IF TYPEDAT(I-1)="DOUBLE" THEN DATAL=8&
ADD=ADD+LENDAT(I-1)*DATAL
ADDRESS(I)=ADD
NEXT I
END IF
NARRAY=NARRAY-1
END SUB
'
'  This subroutine uses CLRXMS and then DIMXMS to perform a "REDIM"
' operation on an already existing extended memory array.
'
SUB REDIMXMS(ANAME AS STRING,N AS LONG,DATATYPE AS STRING,ERRORCODE AS SINGLE)
CALL CLRXMS(ANAME)
CALL DIMXMS(ANAME,N,DATATYPE,ERRORCODE)
END SUB
'
'  This function returns the value of element N of the XMS SINGLE array
' ANAME.
'
FUNCTION GETSNG!(ANAME AS STRING,N AS LONG)
DIM ADD AS LONG,DESTADD AS LONG,SMV AS LONG,OSV AS LONG
'
'  Find array ANAME in Data Allocation Table.  (Index K tracks position of
' array in table.  It will be zero if ANAME isn't in table.)
'
K=0
FOR I=1 TO NARRAY
IF LTRIM$(RTRIM$(UCASE$(ANAME)))=NAMEDAT(I) THEN K=I : EXIT FOR
NEXT I
'
'  If ANAME couldn't be found, its data type isn't SINGLE, or N exceeds
' array range, terminate with an error message.
'
IF K=0 THEN PRINT "GETSNG:  Bad array name." : STOP
IF TYPEDAT(K)<>"SINGLE" THEN PRINT "GETSNG:  Wrong array type." : STOP
IF N<1 OR N>LENDAT(K) THEN PRINT "GETSNG:  Array limit exceeded." : STOP
'
'  Get linear base address of element N in array ANAME.
'
ADD=ADDRESS(K)+4&*(N-1)
'
'  Set dummy variable to hold 4 bytes transferred from XMS and get its
' memory location.
'
VALUE=0 : SMV=VARSEG(VALUE) : OSV=VARPTR(VALUE)
SMV=(SMV+65536&) MOD 65536&
OSV=(OSV+65536&) MOD 65536&
'
'  Get linear address corresponding to SMV:OSV.
'
DESTADD=SMV*16&+OSV
'
'  Transfer 4 bytes and assign transferred result (in VALUE) to GETSNG.
'
CALL MEMTRN(ADD,DESTADD,4&)
GETSNG=VALUE
END FUNCTION
'
'  This function returns the value of element N of the XMS DOUBLE array
' ANAME.
'
DEFDBL G
FUNCTION GETDBL#(ANAME AS STRING,N AS LONG)
DIM ADD AS LONG,DESTADD AS LONG,VALUE AS DOUBLE,SMV AS LONG,OSV AS LONG
'
'  Find array ANAME in Data Allocation Table.  (Index K tracks position of
' array in table.  It will be zero if ANAME isn't in table.)
'
K=0
FOR I=1 TO NARRAY
IF LTRIM$(RTRIM$(UCASE$(ANAME)))=NAMEDAT(I) THEN K=I : EXIT FOR
NEXT I
'
'  If ANAME couldn't be found, its data type isn't DOUBLE, or N exceeds
' array range, terminate with an error message.
'
IF K=0 THEN PRINT "GETDBL:  Bad array name." : STOP
IF TYPEDAT(K)<>"DOUBLE" THEN PRINT "GETDBL:  Wrong array type." : STOP
IF N<1 OR N>LENDAT(K) THEN PRINT "GETDBL:  Array limit exceeded." : STOP
'
'  Get linear base address of element N in array ANAME.
'
ADD=ADDRESS(K)+8&*(N-1)
'
'  Set dummy variable to hold 8 bytes transferred from XMS and get its
' memory location.
'
VALUE=0 : SMV=VARSEG(VALUE) : OSV=VARPTR(VALUE)
SMV=(SMV+65536&) MOD 65536&
OSV=(OSV+65536&) MOD 65536&
'
'  Get linear address corresponding to SMV:OSV.
'
DESTADD=SMV*16&+OSV
'
'  Transfer 8 bytes and assign transferred result (in VALUE) to GETDBL.
'
CALL MEMTRN(ADD,DESTADD,8&)
GETDBL=VALUE
END FUNCTION
'
'  This function returns the value of element N of the XMS INTEGER array
' ANAME.
'
DEFINT G
FUNCTION GETINT%(ANAME AS STRING,N AS LONG)
DIM ADD AS LONG,DESTADD AS LONG,VALUE AS INTEGER,SMV AS LONG,OSV AS LONG
'
'  Find array ANAME in Data Allocation Table.  (Index K tracks position of
' array in table.  It will be zero if ANAME isn't in table.)
'
K=0
FOR I=1 TO NARRAY
IF LTRIM$(RTRIM$(UCASE$(ANAME)))=NAMEDAT(I) THEN K=I : EXIT FOR
NEXT I
'
'  If ANAME couldn't be found, its data type isn't INTEGER, or N exceeds
' array range, terminate with an error message.
'
IF K=0 THEN PRINT "GETINT:  Bad array name." : STOP
IF TYPEDAT(K)<>"INTEGER" THEN PRINT "GETINT:  Wrong array type." : STOP
IF N<1 OR N>LENDAT(K) THEN PRINT "GETINT:  Array limit exceeded." : STOP
'
'  Get linear base address of element N in array ANAME.
'
ADD=ADDRESS(K)+2&*(N-1)
'
'  Set dummy variable to hold 2 bytes transferred from XMS and get its
' memory location.
'
VALUE=0 : SMV=VARSEG(VALUE) : OSV=VARPTR(VALUE)
SMV=(SMV+65536&) MOD 65536&
OSV=(OSV+65536&) MOD 65536&
'
'  Get linear address corresponding to SMV:OSV.
'
DESTADD=SMV*16&+OSV
'
'  Transfer 2 bytes and assign transferred result (in VALUE) to GETINT.
'
CALL MEMTRN(ADD,DESTADD,2&)
GETINT=VALUE
END FUNCTION
'
'  This function returns the value of element N of the XMS LONG array
' ANAME.
'
DEFLNG G
FUNCTION GETLNG&(ANAME AS STRING,N AS LONG)
DIM ADD AS LONG,DESTADD AS LONG,SMV AS LONG,OSV AS LONG,VALUE AS LONG
'
'  Find array ANAME in Data Allocation Table.  (Index K tracks position of
' array in table.  It will be zero if ANAME isn't in table.)
'
K=0
FOR I=1 TO NARRAY
IF LTRIM$(RTRIM$(UCASE$(ANAME)))=NAMEDAT(I) THEN K=I : EXIT FOR
NEXT I
'
'  If ANAME couldn't be found, its data type isn't LONG, or N exceeds
' array range, terminate with an error message.
'
IF K=0 THEN PRINT "GETLNG:  Bad array name." : STOP
IF TYPEDAT(K)<>"LONG" THEN PRINT "GETLNG:  Wrong array type." : STOP
IF N<1 OR N>LENDAT(K) THEN PRINT "GETLNG:  Array limit exceeded." : STOP
'
'  Get linear base address of element N in array ANAME.
'
ADD=ADDRESS(K)+4&*(N-1)
'
'  Set dummy variable to hold 4 bytes transferred from XMS and get its
' memory location.
'
VALUE=0 : SMV=VARSEG(VALUE) : OSV=VARPTR(VALUE)
SMV=(SMV+65536&) MOD 65536&
OSV=(OSV+65536&) MOD 65536&
'
'  Get linear address corresponding to SMV:OSV.
'
DESTADD=SMV*16&+OSV
'
'  Transfer 4 bytes and assign transferred result (in VALUE) to GETLNG.
'
CALL MEMTRN(ADD,DESTADD,4&)
GETLNG=VALUE
END FUNCTION
DEFSNG G
'
'  This subroutine sets element N of the XMS SINGLE array ANAME equal to
' VALUE.
'
SUB PUTSNG(ANAME AS STRING,N AS LONG,VALUE AS SINGLE)
DIM ADD AS LONG,SOURCEADD AS LONG,SMV AS LONG,OSV AS LONG
'
'  Find array ANAME in Data Allocation Table.  (Index K tracks position of
' array in table.  It will be zero if ANAME isn't in table.)
'
K=0
FOR I=1 TO NARRAY
IF LTRIM$(RTRIM$(UCASE$(ANAME)))=NAMEDAT(I) THEN K=I : EXIT FOR
NEXT I
'
'  If ANAME couldn't be found, its data type isn't SINGLE, or N exceeds
' array range, terminate with an error message.
'
IF K=0 THEN PRINT "PUTSNG:  Bad array name." : STOP
IF TYPEDAT(K)<>"SINGLE" THEN PRINT "PUTSNG:  Wrong array type." : STOP
IF N<1 OR N>LENDAT(K) THEN PRINT "PUTSNG:  Array limit exceeded." : STOP
'
'  Get linear base address of element N in array ANAME.
'
ADD=ADDRESS(K)+4&*(N-1)
'
'  Get memory location of VALUE.
'
SMV=VARSEG(VALUE) : OSV=VARPTR(VALUE)
SMV=(SMV+65536&) MOD 65536&
OSV=(OSV+65536&) MOD 65536&
'
'  Get linear address corresponding to SMV:OSV.
'
SOURCEADD=SMV*16&+OSV
'
'  Transfer 4 bytes.
'
CALL MEMTRN(SOURCEADD,ADD,4&)
END SUB
'
'  This subroutine sets element N of the XMS DOUBLE array ANAME equal to
' VALUE.
'
SUB PUTDBL(ANAME AS STRING,N AS LONG,VALUE AS DOUBLE)
DIM ADD AS LONG,SOURCEADD AS LONG,SMV AS LONG,OSV AS LONG
'
'  Find array ANAME in Data Allocation Table.  (Index K tracks position of
' array in table.  It will be zero if ANAME isn't in table.)
'
K=0
FOR I=1 TO NARRAY
IF LTRIM$(RTRIM$(UCASE$(ANAME)))=NAMEDAT(I) THEN K=I : EXIT FOR
NEXT I
'
'  If ANAME couldn't be found, its data type isn't DOUBLE, or N exceeds
' array range, terminate with an error message.
'
IF K=0 THEN PRINT "PUTDBL:  Bad array name." : STOP
IF TYPEDAT(K)<>"DOUBLE" THEN PRINT "PUTDBL:  Wrong array type." : STOP
IF N<1 OR N>LENDAT(K) THEN PRINT "PUTDBL:  Array limit exceeded." : STOP
'
'  Get linear base address of element N in array ANAME.
'
ADD=ADDRESS(K)+8&*(N-1)
'
'  Get memory location of VALUE.
'
SMV=VARSEG(VALUE) : OSV=VARPTR(VALUE)
SMV=(SMV+65536&) MOD 65536&
OSV=(OSV+65536&) MOD 65536&
'
'  Get linear address corresponding to SMV:OSV.
'
SOURCEADD=SMV*16&+OSV
'
'  Transfer 8 bytes.
'
CALL MEMTRN(SOURCEADD,ADD,8&)
END SUB
'
'  This subroutine sets element N of the XMS INTEGER array ANAME equal to
' VALUE.
'
SUB PUTINT(ANAME AS STRING,N AS LONG,VALUE AS INTEGER)
DIM ADD AS LONG,SOURCEADD AS LONG,SMV AS LONG,OSV AS LONG
'
'  Find array ANAME in Data Allocation Table.  (Index K tracks position of
' array in table.  It will be zero if ANAME isn't in table.)
'
K=0
FOR I=1 TO NARRAY
IF LTRIM$(RTRIM$(UCASE$(ANAME)))=NAMEDAT(I) THEN K=I : EXIT FOR
NEXT I
'
'  If ANAME couldn't be found, its data type isn't INTEGER, or N exceeds
' array range, terminate with an error message.
'
IF K=0 THEN PRINT "PUTINT:  Bad array name." : STOP
IF TYPEDAT(K)<>"INTEGER" THEN PRINT "PUTINT:  Wrong array type." : STOP
IF N<1 OR N>LENDAT(K) THEN PRINT "PUTINT:  Array limit exceeded." : STOP
'
'  Get linear base address of element N in array ANAME.
'
ADD=ADDRESS(K)+2&*(N-1)
'
'  Get memory location of VALUE.
'
SMV=VARSEG(VALUE) : OSV=VARPTR(VALUE)
SMV=(SMV+65536&) MOD 65536&
OSV=(OSV+65536&) MOD 65536&
'
'  Get linear address corresponding to SMV:OSV.
'
SOURCEADD=SMV*16&+OSV
'
'  Transfer 2 bytes.
'
CALL MEMTRN(SOURCEADD,ADD,2&)
END SUB
'
'  This subroutine sets element N of the XMS LONG array ANAME equal to
' VALUE.
'
SUB PUTLNG(ANAME AS STRING,N AS LONG,VALUE AS LONG)
DIM ADD AS LONG,SOURCEADD AS LONG,SMV AS LONG,OSV AS LONG
'
'  Find array ANAME in Data Allocation Table.  (Index K tracks position of
' array in table.  It will be zero if ANAME isn't in table.)
'
K=0
FOR I=1 TO NARRAY
IF LTRIM$(RTRIM$(UCASE$(ANAME)))=NAMEDAT(I) THEN K=I : EXIT FOR
NEXT I
'
'  If ANAME couldn't be found, its data type isn't LONG, or N exceeds
' array range, terminate with an error message.
'
IF K=0 THEN PRINT "PUTLNG:  Bad array name." : STOP
IF TYPEDAT(K)<>"LONG" THEN PRINT "PUTLNG:  Wrong array type." : STOP
IF N<1 OR N>LENDAT(K) THEN PRINT "PUTLNG:  Array limit exceeded." : STOP
'
'  Get linear base address of element N in array ANAME.
'
ADD=ADDRESS(K)+4&*(N-1)
'
'  Get memory location of VALUE.
'
SMV=VARSEG(VALUE) : OSV=VARPTR(VALUE)
SMV=(SMV+65536&) MOD 65536&
OSV=(OSV+65536&) MOD 65536&
'
'  Get linear address corresponding to SMV:OSV.
'
SOURCEADD=SMV*16&+OSV
'
'  Transfer 4 bytes.
'
CALL MEMTRN(SOURCEADD,ADD,4&)
END SUB
'
'  This function is an XMS equivalent of QB's UBOUND function for
' conventional arrays, at least in regard to determining the maximum array
' index.  It returns a LONG integer.  It also returns, via the paramter
' list, the long integer ADD representing the base address in XMS of the
' array.
'
DEFLNG U
FUNCTION UXMS&(ANAME AS STRING,ADD AS LONG)
'
'  Look for array ANAME in Data Allocation Table.
'
K=0
IF NARRAY>0 THEN
FOR I=1 TO NARRAY
IF LTRIM$(RTRIM$(UCASE$(ANAME)))=NAMEDAT(I) THEN K=I : EXIT FOR
NEXT I
END IF
'
'  If array couldn't be found, return zero for array length and
' fictitiously large value for address.
'
UXMS=0 : ADD=32&*1024&^2
IF K>0 THEN UXMS=LENDAT(K) : ADD=ADDRESS(K)
END FUNCTION
DEFSNG U
'
'  This subroutine transfers an even number of BYTES from a memory SOURCE
' location to a memory DEST location.  SOURCE and DEST are huge (linear)
' memory addresses.  MEMTRN will enforce the constraint 2 <= BYTES <=
' 65,536.
'
SUB MEMTRN(SOURCE AS LONG,DEST AS LONG,BYTES AS LONG)
DIM GDT(1 TO 12) AS LONG,BTS AS LONG,OS AS INTEGER
'
'  Make sure BYTES is even and otherwise valid.  (Work with BTS alias.)
'
BTS=2&*INT(CDBL(BYTES)/2+.001)
IF BTS<2 THEN BTS=2&
IF BTS>65536& THEN BTS=65536&
WORDS=BTS/2
IF WORDS>32767 THEN WORDS=WORDS-65536!
'
'  Get address of Global Descriptor Table.
'
SMGDT=VARSEG(GDT(1)) : OSGDT=VARPTR(GDT(1))
'
'  Get four bytes comprising SOURCE and DEST.
'
X1=INT(CDBL(SOURCE)/256+.001)
X2=INT(X1/256+.001)
B4S=INT(X2/256+.001)
B3S=X2-256*B4S
B2S=X1-256*X2
B1S=SOURCE-256*X1
X1=INT(CDBL(DEST)/256+.001)
X2=INT(X1/256+.001)
B4D=INT(X2/256+.001)
B3D=X2-256*B4D
B2D=X1-256*X2
B1D=DEST-256*X1
'
'  Note that B4S and B4D will be zero on 80286 machines due to the 16 MB
' address limit.
'
'  Set up GDT for XMS transfer.
'
DEF SEG=SMGDT
FOR I=0 TO 15
POKE OSGDT+I,0
NEXT I
POKE OSGDT+16,CINT((BTS-1) AND &HFF&)
POKE OSGDT+17,CINT(((BTS-1) AND &HFF00&)/256)
POKE OSGDT+18,B1S
POKE OSGDT+19,B2S
POKE OSGDT+20,B3S
POKE OSGDT+21,&H93
POKE OSGDT+22,0
POKE OSGDT+23,B4S
POKE OSGDT+24,CINT((BTS-1) AND &HFF&)
POKE OSGDT+25,CINT(((BTS-1) AND &HFF00&)/256)
POKE OSGDT+26,B1D
POKE OSGDT+27,B2D
POKE OSGDT+28,B3D
POKE OSGDT+29,&H93
POKE OSGDT+30,0
POKE OSGDT+31,B4D
FOR I=0 TO 15
POKE OSGDT+32+I,0
NEXT I
'
'  Transfer BTS/2 words.
'
DEF SEG=VARSEG(MCODE(1))
OS=VARPTR(MCODE(1))+17
POKE OS+4,CINT(WORDS) AND &HFF
POKE OS+5,(CINT(WORDS) AND &HFF00)/256
POKE OS+7,CINT(OSGDT) AND &HFF
POKE OS+8,(CINT(OSGDT) AND &HFF00)/256
POKE OS+10,CINT(SMGDT) AND &HFF
POKE OS+11,(CINT(SMGDT) AND &HFF00)/256
CALL ABSOLUTE(OS)
DEF SEG
END SUB
'
'  This is an XMS equivalent of QB's BSAVE command.  It inputs the name of
' an INTEGER XMS array storing the data to be saved--ANAME, the (LONG)
' number of BYTES to store in the file, and the name of the file--FILE.
'
SUB XBSAVE(ANAME AS STRING,BYTES AS LONG,FILE AS STRING)
DIM B AS INTEGER,FD AS STRING*1,BL AS STRING*1,BH AS STRING*1,L AS LONG
OPEN FILE FOR BINARY AS #1
'
'  Byte number 1 in the output file is kept the same as in a standard
' BSAVE file.  Bytes 2, 3, and 4 will just be set to "X M S".  Bytes 5, 6,
' and 7 will be used to store BYTES.  (The high byte will be at position
' 5.  The low and middle bytes will be at positions 6 and 7, just like in
' a standard BSAVE file.  Hence, if there are less than 65,536 bytes
' stored in the file, the high byte should be zero and BLOAD should work
' with the file.)
'
'
FD=CHR$(&HFD)
PUT#1,,FD
FD="X"
PUT#1,,FD
FD="M"
PUT#1,,FD
FD="S"
PUT#1,,FD
'
'  Get three bytes constituting BYTES and put them in file.
'
X1=INT(CDBL(BYTES)/256+.001)
B3=INT(X1/256+.001)
B2=X1-256*B3
B1=BYTES-256*X1
FD=CHR$(B3)
PUT#1,,FD
FD=CHR$(B1)
PUT#1,,FD
FD=CHR$(B2)
PUT#1,,FD
L=1
FOR J=1 TO BYTES STEP 2
B=GETINT(ANAME,L)
BL=CHR$(B AND &HFF)
PUT#1,,BL
'
'  Watch out for BYTES being odd; if it is, high byte of last element in
' ANAME isn't meaningful.
'
IF J<BYTES THEN
BH=CHR$(((B AND &HFF00)/256+256) MOD 256)
PUT#1,,BH
END IF
L=L+1
NEXT J
CLOSE #1
END SUB
'
'  This is an XMS equivalent of QB's BLOAD command.  It inputs the name of
' an XMS array (ANAME) to store the data in and the name of the FILE to
' load the data from.  (Generally, the data in FILE was put there by
' XBSAVE.)  There is no need to use DIMXMS to initialize ANAME before
' calling XBLOAD.  ANAME will be initialized by XBLOAD as an INTEGER
' XMS array.
'
SUB XBLOAD(ANAME AS STRING,FILE AS STRING)
DIM B AS STRING*1,SIZE AS LONG,L AS LONG,VALUE AS INTEGER,BYTES AS LONG
OPEN FILE FOR BINARY AS #1
GET#1,,L
GET#1,,B
BYTES=65536&*ASC(B)
GET#1,,B
BYTES=BYTES+ASC(B)
GET#1,,B
BYTES=BYTES+256&*ASC(B)
SIZE=CLNG(CDBL(BYTES+1)/2+.001)
ERRORCODE=1
CALL REDIMXMS(ANAME,SIZE,"INTEGER",ERRORCODE)
IF ERRORCODE<>0 THEN CLOSE #1 : PRINT "XBLOAD:  XMS problem." : STOP
L=1
FOR J=1 TO BYTES STEP 2
GET#1,,B
B1=ASC(B)
'
'  Watch out for BYTES being odd; don't try to read more bytes than are
' in file.
'
B2=0
IF J<BYTES THEN
GET#1,,B
B2=ASC(B)
END IF
B2=B1+256*B2 : IF B2>32767 THEN B2=B2-65536!
VALUE=CINT(B2)
CALL PUTINT(ANAME,L,VALUE)
L=L+1
NEXT J
CLOSE #1
END SUB
