' TREE.BAS
' by Mike Ginger
'
' public domain
' No warranties or guarantees are expressed or implied.
'
' Purpose: Displays files in a dir with information about each file.

'$INCLUDE: 'QB.BI'
DEFINT A-Z
DECLARE FUNCTION CountFiles (Srch$)
DECLARE FUNCTION FInfoDate$ (FDate)
DECLARE FUNCTION FInfoTime$ (FTime)
DECLARE SUB LoadFileInfo (F() AS ANY, N%, Srch$)

TYPE FileInfo
FileName    AS STRING * 12
Size        AS LONG
FDate       AS INTEGER
FTime       AS INTEGER
END TYPE

TYPE DTAType
Drive       AS STRING * 1
Template    AS STRING * 11
Attr        AS STRING * 1
DirEntry    AS INTEGER
DTAPtr      AS LONG
Cluster     AS INTEGER
FileAttb    AS STRING * 1
FileTime    AS INTEGER
FileDate    AS INTEGER
FileSize    AS LONG
FileName    AS STRING * 13
END TYPE

CLS

 N = CountFiles("*.*")
	IF N = 0 THEN
	 PRINT "No files found"
	END
	END IF

REDIM F(1 TO N) AS FileInfo
CALL LoadFileInfo(F(), N, "*.*")
FOR i = 1 TO N
PRINT F(i).FileName; TAB(14);
PRINT USING "##########"; F(i).Size;
PRINT TAB(25); FInfoDate$(F(i).FDate);
PRINT TAB(36); FInfoTime$(F(i).FTime)
mike% = mike% + 1
 IF mike% = 15 THEN
	mike% = 0
	INPUT "Press RETURN to continue"; pause$
 END IF
NEXT

FUNCTION CountFiles (Srch$)
DIM DTA AS DTAType
DIM FileName AS STRING * 65
DIM InRegs AS RegTypeX
DIM OutRegs AS RegTypeX

InRegs.ax = &H2F00
CALL INTERRUPTX(&H21, InRegs, OutRegs)
OldDTASeg = OutRegs.es
OldDTAAdd = OutRegs.bx

InRegs.ax = &H1A00
InRegs.ds = VARSEG(DTA)
InRegs.dx = VARPTR(DTA)
CALL INTERRUPTX(&H21, InRegs, OutRegs)

N = 0
FileName = Srch$ + CHR$(0)
InRegs.ds = VARSEG(FileName)
InRegs.dx = VARPTR(FileName)
InRegs.ax = &H4E00
DO
CALL INTERRUPTX(&H21, InRegs, OutRegs)
InRegs.ax = &H4F00
IF (OutRegs.flags AND 1) = 0 THEN
N = N + 1
ELSE
IF N = 0 THEN PRINT "Error -> "; OutRegs.ax
EXIT DO
END IF
LOOP
InRegs.ax = &H1A00
InRegs.ds = OldDTASeg
InRegs.dx = OldDTAAdd
CALL INTERRUPTX(&H21, InRegs, OutRegs)
CountFiles = N
END FUNCTION

FUNCTION FInfoDate$ (Num)
M = (Num AND 480) \ 32
D = Num AND 31
Y = 1980 + (Num AND 65024) \ 512
M$ = LTRIM$(STR$(M)): DO WHILE LEN(M$) < 2: M$ = "0" + M$: LOOP
D$ = LTRIM$(STR$(D)): DO WHILE LEN(D$) < 2: D$ = "0" + D$: LOOP
Y$ = LTRIM$(STR$(Y)): DO WHILE LEN(Y$) < 4: Y$ = "0" + Y$: LOOP
FInfoDate$ = M$ + "/" + D$ + "/" + Y$
END FUNCTION

FUNCTION FInfoTime$ (Num)
H = (Num AND 63488) \ 2048
M = (Num AND 2016) \ 32
S = (Num AND 31) * 2
H$ = LTRIM$(STR$(H)): DO WHILE LEN(H$) < 2: H$ = "0" + H$: LOOP
M$ = LTRIM$(STR$(M)): DO WHILE LEN(M$) < 2: M$ = "0" + M$: LOOP
S$ = LTRIM$(STR$(S)): DO WHILE LEN(S$) < 2: S$ = "0" + S$: LOOP
FInfoTime$ = H$ + ":" + M$ + ":" + S$
END FUNCTION

SUB LoadFileInfo (F() AS FileInfo, N, Srch$)
DIM FileName AS STRING * 65
DIM DTA AS DTAType
DIM InRegs AS RegTypeX
DIM OutRegs AS RegTypeX

InRegs.ax = &H2F00
CALL INTERRUPTX(&H21, InRegs, OutRegs)
OldDTASeg = OutRegs.es
OldDTAAdd = OutRegs.bx

InRegs.ax = &H1A00
InRegs.ds = VARSEG(DTA)
InRegs.dx = VARPTR(DTA)
CALL INTERRUPTX(&H21, InRegs, OutRegs)

N = 0
FileName = Srch$ + CHR$(0)
InRegs.ds = VARSEG(FileName)
InRegs.dx = VARPTR(FileName)
InRegs.ax = &H4E00
DO
CALL INTERRUPTX(&H21, InRegs, OutRegs)
InRegs.ax = &H4F00
IF (OutRegs.flags AND 1) = 0 THEN
N = N + 1
F(N).FileName = LEFT$(DTA.FileName, INSTR(DTA.FileName, CHR$(0)) - 1)
F(N).FDate = DTA.FileDate
F(N).FTime = DTA.FileTime
F(N).Size = DTA.FileSize
ELSE
EXIT DO
END IF
LOOP
InRegs.ax = &H1A00
InRegs.ds = OldDTASeg
InRegs.dx = OldDTAAdd
CALL INTERRUPTX(&H21, InRegs, OutRegs)
END SUB

