' Phillip Jay Cohen's Outlined Font Routines:
' Demo Program

' Everything appearing here in the main program is just demonstration
' and won't be of any use to any of you (or at least I don't think so)
' Besides, it's not hard to understand what's going on here, it's the
' actual routines that do most of the work. These are just calls, and
' a pretty border to keep us happy.  If you want to use these routines
' you will somewhat need to understand how to call them.  Just run the
' program to find out about the syntax and stuff, or if you are lazy,
' you can check directly in the code, but then you won't know how it
' looks.  The routines will only work in screen mode 13, as I am use-
' ing VGA video memory.  I will be very happy if you distribute these
' routines, and if you think they're useful or maybe you feel warm and
' squooshy inside, then please  E-mail me and tell me.  My email is:
' cohennet@erols.com.  Thanks for taking time to read this. -- P.J.C.

DEFINT A-Z
DECLARE SUB OFont (Text$, X, Y, Fore, Back, FontFlag)   'Main font routine
SCREEN 13    '320x200 VGA and MCGA screen mode

'*** Demo ***
LINE (1, 0)-(318, 0), 4
LINE (0, 1)-(0, 198), 4
LINE (1, 199)-(318, 199), 4
LINE (319, 1)-(319, 198), 4
LINE (1, 1)-(318, 198), 41, B
LINE (2, 2)-(317, 197), 42, B
LINE (3, 3)-(316, 196), 14, B
PAINT (4, 4), 25, 14

OFont "PHILLIP JAY COHEN'S", 0, 10, 2, 144, 1
OFont "OUTLINED FONT", 60, 25, 43, 114, 0
OFont "DEMO PROGRAM", 180, 25, 32, 1, 0
OFont "Syntax:", 0, 50, 15, 8, 1
OFont "OFont Text$, X, Y, Fore, Back", 0, 65, 40, 4, 1
OFont "Where:", 10, 85, 9, 33, 0
OFont "Text$ = The text to be printed", 70, 85, 11, 3, 0
OFont "X = The horizontal coordinate for the", 0, 100, 35, 5, 1
OFont "upper-left hand corner of the text", 0, 110, 35, 5, 1
OFont "Y = The vertical coordinate for the", 10, 125, 42, 41, 0
OFont "upper-left hand corner of the text", 0, 135, 42, 41, 1
OFont "Fore = The text's foreground color", 0, 150, 13, 37, 1
OFont "Back = The text's background color", 0, 165, 44, 6, 1
OFont "PRESS A KEY", 0, 185, 15, 8, 1
GOSUB PressAndClear

OFont "Also Including", 0, 50, 15, 8, 1
OFont "A Fonting routine,", 25, 65, 40, 4, 0
OFont "which has the", 190, 65, 11, 3, 0
OFont "same syntax, except for the X argument", 0, 75, 11, 3, 1
OFont "These routines only work in screen", 0, 90, 35, 5, 1
OFont "mode 13, but have many advantages,", 0, 100, 35, 5, 1
OFont "Including:", 0, 115, 44, 6, 1
OFont "Outlining (obviously), placement at", 0, 130, 42, 41, 1
OFont "exact coordinates (unlike PRINT),", 0, 140, 42, 41, 1
OFont "avoid erasing the background, and", 0, 150, 42, 41, 1
OFont "are relatively FAST for QBasic", 0, 160, 42, 41, 1
OFont "MORE -->", 0, 173, 13, 37, 1
GOSUB PressAndClear

OFont "Please,", 0, 50, 15, 8, 1
OFont "Feel free to distribute these routines", 0, 65, 40, 4, 1
OFont "Try to give me credit when you use", 0, 80, 11, 3, 1
OFont "them, if you can (I don't think that's", 0, 90, 11, 3, 1
OFont "asking too much, do you?)", 0, 100, 11, 3, 1
OFont "Unless you have a lot of programing", 0, 115, 9, 33, 1
OFont "experience, don't try to understand", 0, 125, 9, 33, 1
OFont "the OFont routine; you don't need to", 0, 135, 9, 33, 1
OFont "know how the routine works to use it", 0, 145, 9, 33, 1
OFont "For more info, you can contact me at:", 0, 160, 35, 5, 1
OFont "cohennet@erols.com", 0, 173, 44, 6, 1
GOSUB PressAndClear

SCREEN 0: WIDTH 80: CLS : END
'*** End Demo ***

'*** PressAndClear Subroutine for demo
PressAndClear:
Buffer = &H1A
DEF SEG = &H40
POKE Buffer, PEEK(Buffer + 2)    'Clear keyboard buffer
DEF SEG
DO: LOOP WHILE INKEY$ = ""       'Wait for key press
LINE (4, 45)-(315, 180), 25, BF  'Clear our working area
RETURN
'*** End Subroutine

SUB OFont (Text$, X, Y, Fore, Back, FontFlag)
IF FontFlag <> 0 THEN X = 160 - INT(LEN(Text$) * 4)
DEF SEG = &HFFA6                              'Stores masks for letters
FOR Letter = 1 TO LEN(Text$)                  'Does each letter
Address = (8 * ASC(MID$(Text$, Letter))) + 14 'Address for start of letter
FOR Height = 0 TO 7                       'Each letter is an 8x8 pixel matrix
Mask = PEEK(Address + Height) * 128   'Address for mask of each line of letter
LINE (X + Curntx + 1, Y + Height + 1)-(X + 9 + Curntx, Y + Height + 1), Fore, , Mask
NEXT
Curntx = Curntx + 8                   'Advances X axis by 8 for next letter
NEXT                                  'Continue to next letter
DEF SEG = &HA000                      'Change to video memory
IF Back > 0 THEN                      'Background color can't be color 0
FOR V = Y TO Y + 7                    'Again, they're 8x8 pixels
FOR H = X TO (LEN(Text$) * 8) - 1 + X 'Calculates length of text in pixels
PK0& = PEEK(H + V * 320&)             'Is point at H,V = to foreground color?
PK1& = PEEK(H + 1 + (V + 1) * 320&)   'Is point at H+1, V+1 = to foreground?
PK2& = PEEK(H + 1 + V * 320&)         'Is point at H+1, V = to foreground?
PT& = H + V * 320&                    'Video memory pointer
IF PK0& <> Fore THEN                  'If this is foreground, don't overlap it
IF PK1& = Fore OR PK2& = Fore THEN POKE PT&, Back    'Put pixel into memory
END IF
NEXT H     'Next horizontal
NEXT V     'Next vertical
END IF
DEF SEG    'Put us back where
END SUB    'We started

