' EXECPATH.BAS
' by Joe Negron
'
' public domain
' No warranties or guarantees are expressed or implied.
'
' Purpose: Gets the path and filename of the executable running.
'
'Function Description:
'
'Uses DOS ISR 21H, Function 51H (Get PSP Address) to return the
'name of the currently executing program.  Note that this FUNCTION
'requires DOS 3.0 or >.

DECLARE FUNCTION ExePath$ ()
DEFINT A-Z
'$INCLUDE: 'qb.bi'

E$ = ExePath$
PRINT E$

FUNCTION ExePath$ STATIC
	 DIM Regs AS RegType                       'Allocate space for TYPE
																						 '  RegType
	 Regs.ax = &H5100                          'DOS function 51h
	 INTERRUPT &H21, Regs, Regs                '  Get PSP Address

	 DEF SEG = Regs.bx                         'Regs.bx returns PSP sgmnt.
	 EnvSeg% = PEEK(&H2C) + PEEK(&H2D) * 256   'Get environment address
	 DEF SEG = EnvSeg%                         'Set environment address

	 DO
			Byte% = PEEK(Offset%)                  'Take a byte

			IF Byte% = 0 THEN                      'Items are ASCIIZ
				 Count% = Count% + 1                 '  terminated

				 IF Count% AND EXEFlag% THEN         'EXE also ASCIIZ terminated
						EXIT DO                          'Exit at the end
				 ELSEIF Count% = 2 THEN              'Last entry in env. is
						EXEFlag% = -1                    '  terminated with two
						Offset% = Offset% + 2            '  NULs.  Two bytes ahead
				 END IF                              '  is the EXE file name.
			ELSE                                   'If Byte% <> 0, reset
				 Count% = 0                          '  zero counter

				 IF EXEFlag% THEN                    'If EXE name found,
						Temp$ = Temp$ + CHR$(Byte%)      '  build string
				 END IF
			END IF

			Offset% = Offset% + 1                  'To grab next byte...
	 LOOP                                      'Do it again

	 DEF SEG                                   'Reset default segment
	 ExePath$ = Temp$                          'Return value
	 Temp$ = ""                                'Clean up
END FUNCTION

