DEFINT A-Z

'$INCLUDE: 'qb.bi'

DECLARE FUNCTION FDList$ ()
DECLARE FUNCTION HDList$ (FloppyList$)

'Test Program
CLS
A$ = FDList$
IF A$ <> "A" THEN
	PRINT "Floppy drives are from A to "; A$
ELSE
	PRINT "Floppy Drive A installed."
END IF

B$ = HDList$(FDList$)
PRINT "Hard drives are from C to "; B$


'***********************************************************************
'* FUNCTION FDList$
'*
'* PURPOSE
'*    PEEKs at the BIOS Equipment Word to return a list of floppy
'*    drives installed on the system.
'*
'* CREDIT(S)
'*    Larry Stone, based on a routine published in MicroHelp's BUG
'*    Newsletter, 1/1/90.
'*
'*    Modified to use fixed-length strings.
'***********************************************************************
FUNCTION FDList$ STATIC
	 DEF SEG = 0
	 FD% = PEEK(&H410) \ 64 + 1                'How many FDs installed?
	 DEF SEG                                   'Restore DGROUP
	 FD$ = SPACE$(FD%)

	 FOR N% = 1 TO FD%                         'Place these letters into
			MID$(FD$, N%, 1) = CHR$(64 + N%)       '  FD$
	 NEXT

	 FDList$ = FD$                             'Return value
	 FD$ = ""
END FUNCTION

'***********************************************************************
'* FUNCTION HDList$
'*
'* PURPOSE
'*    Uses DOS ISR 21H, Function 44H, Subfunction 09H (Is Drive Remote)
'*    to return a list of valid, local hard drives.
'*
'* CREDIT(S)
'*    Larry Stone, based on a routine published in MicroHelp's BUG
'*    Newsletter, 1/1/90.
'*
'*    Modified to use fixed-length strings.
'***********************************************************************
FUNCTION HDList$ (FloppyList$)
	 DIM IRegs AS RegType, ORegs AS RegType

	 FloppyList$ = FDList$                     'Get floppy drive list
	 FDs% = LEN(FloppyList$)                   'How many drives found?

	 HD% = FDs% + 1 + ABS(FD% = 1)             'If only 1 FD, first is C:
	 HD$ = SPACE$(HD%)

	 FOR BL% = HD% TO 26                       'Check possible hard drives
			IRegs.ax = &H4409                      'Set up call
			IRegs.bx = BL%                         'Drive letter in BL
			Interrupt &H21, IRegs, ORegs           'Call DOS

			IF (ORegs.flags AND 1) THEN            'Check carry flag
				 EXIT FOR
			END IF

			MID$(HD$, HD%, 1) = CHR$(64 + ORegs.bx)'Add the letter
	 NEXT

	 HDList$ = RIGHT$(HD$, 1)                            'Return value
	 HD$ = ""
END FUNCTION

