'Read CMOS State
'by John Woodgate
'January 13, 1997

'Modified slightly by Tika Carr (t.carr@pobox.com) on June 20, 1997

DEFINT A-Z

DECLARE FUNCTION CMOSBattery% ()
DECLARE FUNCTION BitOn% (Which%, IntVal%)
DECLARE FUNCTION DriveType% (Drv%)
DECLARE FUNCTION Hex2Bin$ (Hcs$)
DECLARE FUNCTION TotalMem% ()

DIM Day$(1 TO 7)
Day$(1) = "Sunday": Day$(2) = "Monday": Day$(3) = "Tuesday"
Day$(4) = "Wednesday": Day$(5) = "Thursday": Day$(6) = "Friday"
Day$(7) = "Saturday"

DIM Month$(1 TO 12)
Month$(1) = "January": Month$(2) = "February": Month$(3) = "March"
Month$(4) = "April": Month$(5) = "May": Month$(6) = "June"
Month$(7) = "July": Month$(8) = "August": Month$(9) = "September"
Month$(10) = "October": Month$(11) = "November": Month$(12) = "December"

CLS

'**** Contents of CMOS (Hex Dump) ****
PRINT "CMOS Contents:"
FOR i = 0 TO &H7F: OUT &H70, i: PRINT USING "\   \"; HEX$(INP(&H71)); : NEXT


'**** CMOS Battery State ****
PRINT " ": PRINT "CMOS Battery State: ";
IF CMOSBattery% THEN PRINT "Good"; :  ELSE PRINT "Battery low";
PRINT

'**** List Floppy Drives Installed ****
FOR c = 1 TO 2
 k = DriveType(c)
 PRINT "Drive " + CHR$(c + 64) + ": ";
 SELECT CASE k
  CASE 0: A$ = "None"
  CASE 1: A$ = "5" + CHR$(172) + " 360K"
  CASE 2: A$ = "5" + CHR$(172) + " 1.2M"
  CASE 3: A$ = "3" + CHR$(171) + " 720K"
  CASE 4: A$ = "3" + CHR$(171) + " 1.44M"
 END SELECT
 PRINT A$
NEXT: PRINT

'**** List Hard Drives Installed ****
PRINT "Hard Disk 0 Type:"; : OUT &H70, &H19: B = INP(&H71)
IF B <> 0 THEN : PRINT B:  ELSE : PRINT " Not Installed"
PRINT "Hard Disk 1 Type:"; : OUT &H70, &H1A: B = INP(&H71)
IF B <> 0 THEN : PRINT B:  ELSE PRINT " Not Installed"
PRINT

'**** Conventional Memory Size ****
OUT &H70, &H15: B = INP(&H71): OUT &H70, &H16: B1 = INP(&H71)
PRINT "Base Memory:"; RTRIM$(STR$(CVI(CHR$(B) + CHR$(B1)))); "K"

'**** Extended Memory Size ****
OUT &H70, &H17: B = INP(&H71): OUT &H70, &H18: B1 = INP(&H71)
PRINT "Extended Memory:"; RTRIM$(STR$(CVI(CHR$(B) + CHR$(B1)))); "K";
PRINT " (~"; VAL(RTRIM$(STR$(CVI(CHR$(B) + CHR$(B1))))) \ 1024; "MB)": PRINT

'**** Total System Memory ****
PRINT "Total System Memory:"; RTRIM$(STR$(TotalMem)); "K";
PRINT "  (~"; VAL(RTRIM$(STR$(TotalMem))) \ 1024; "MB)": PRINT

'**** Date ****
OUT &H70, &H6: A = INP(&H71)
DT$ = Day$(A) + ", " + Month$(VAL(LEFT$(DATE$, 2))) + " "
DT$ = DT$ + MID$(DATE$, 4, 2) + ", " + RIGHT$(DATE$, 4)
PRINT DT$; "  ";

'**** Current Time ****
DO
 OUT &H70, 4: hr = VAL(HEX$(INP(&H71)))
 OUT &H70, 2: mn = VAL(HEX$(INP(&H71)))
 OUT &H70, 0: sc = VAL(HEX$(INP(&H71)))
 LOCATE , 40: IF hr < 12 THEN Ex$ = " AM":  ELSE Ex$ = " PM"
 IF hr = 0 THEN hr = 12
 IF hr > 12 THEN hr = hr - 12
 PRINT USING "##:##:##"; hr; mn; sc; : PRINT Ex$;
LOOP UNTIL LEN(INKEY$)

FUNCTION BitOn (Which, IntVal)

BitOn = 0
SELECT CASE Which
 CASE 1: IF (IntVal AND 128) THEN BitOn = (-1)
 CASE 2: IF (IntVal AND 64) THEN BitOn = (-1)
 CASE 3: IF (IntVal AND 32) THEN BitOn = (-1)
 CASE 4: IF (IntVal AND 16) THEN BitOn = (-1)
 CASE 5: IF (IntVal AND 8) THEN BitOn = (-1)
 CASE 6: IF (IntVal AND 4) THEN BitOn = (-1)
 CASE 7: IF (IntVal AND 2) THEN BitOn = (-1)
 CASE 8: IF (IntVal AND 1) THEN BitOn = (-1)
 CASE 9: IF (IntVal AND (-32768)) THEN BitOn = (-1)
 CASE 10: IF (IntVal AND 16384) THEN BitOn = (-1)
 CASE 11: IF (IntVal AND 8192) THEN BitOn = (-1)
 CASE 12: IF (IntVal AND 4096) THEN BitOn = (-1)
 CASE 13: IF (IntVal AND 2048) THEN BitOn = (-1)
 CASE 14: IF (IntVal AND 1024) THEN BitOn = (-1)
 CASE 15: IF (IntVal AND 512) THEN BitOn = (-1)
 CASE 16: IF (IntVal AND 256) THEN BitOn = (-1)
END SELECT
END FUNCTION

FUNCTION CMOSBattery%

OUT &H70, &HD
B% = INP(&H71)
c = BitOn%(1, B%)
CMOSBattery% = c
END FUNCTION

FUNCTION DriveType% (Drv%)

OUT &H70, &H10
B% = INP(&H71)
IF Drv% = 1 THEN
 t$ = LEFT$(Hex2Bin$(LTRIM$(RTRIM$(HEX$(B%)))), 4)
ELSE
 t$ = MID$(Hex2Bin$(LTRIM$(RTRIM$(HEX$(B%)))), 5, 4)
END IF
IF t$ = "0001" THEN DriveType% = 1
IF t$ = "0010" THEN DriveType% = 2
IF t$ = "0011" THEN DriveType% = 3
IF t$ = "0100" THEN DriveType% = 4
END FUNCTION

FUNCTION Hex2Bin$ (Hcs$)

Hcs$ = UCASE$(Hcs$)
lc = LEN(Hcs$)
FOR x = 1 TO lc
 SELECT CASE MID$(Hcs$, x, 1)
  CASE "0"
   Out$ = Out$ + "0000"
  CASE "1"
   Out$ = Out$ + "0001"
  CASE "2"
   Out$ = Out$ + "0010"
  CASE "3"
   Out$ = Out$ + "0011"
  CASE "4"
   Out$ = Out$ + "0100"
  CASE "5"
   Out$ = Out$ + "0101"
  CASE "6"
   Out$ = Out$ + "0110"
  CASE "7"
   Out$ = Out$ + "0111"
  CASE "8"
   Out$ = Out$ + "1000"
  CASE "9"
   Out$ = Out$ + "1001"
  CASE "A"
   Out$ = Out$ + "1010"
  CASE "B"
   Out$ = Out$ + "1011"
  CASE "C"
   Out$ = Out$ + "1100"
  CASE "D"
   Out$ = Out$ + "1101"
  CASE "E"
   Out$ = Out$ + "1110"
  CASE "F"
   Out$ = Out$ + "1111"
 END SELECT
NEXT
Hex2Bin$ = Out$
END FUNCTION

FUNCTION TotalMem%

OUT &H70, &H15
B% = INP(&H71)
OUT &H70, &H16
B1% = INP(&H71)
a1% = CVI(CHR$(B) + CHR$(B1%))
OUT &H70, &H17
B% = INP(&H71)
OUT &H70, &H18
B1% = INP(&H71)
a2% = CVI(CHR$(B) + CHR$(B1%))
TotalMem% = a1% + a2%
END FUNCTION


