'_|_|_|   BRESNHAM.BAS
'_|_|_|   This program demonstrates the Bresenham Algorithms
'_|_|_|   for the drawing of lines and circles, using PSET.
'_|_|_|   Adapted from BRESNHAM.C in Bob Stout's SNIPPETS.
'_|_|_|   No warrantee or guarantee is implied or given.
'_|_|_|   Released to   PUBLIC DOMAIN   by Kurt Kuzba. (4/16/96)

DECLARE SUB BLine (x%, y%, x2%, y2%, c%)
DECLARE SUB BCircle (x%, y%, r%, c%)

SCREEN 13

CONST HIGH = 200   'The Bresenham Cirlce needs to know the screen dimensions
CONST WIDE = 320

BCircle 159, 99, 65, 77
BLine 0, 0, WIDE, HIGH, 14
pause$ = INPUT$(1)

SCREEN 0, 0, 0, 0: WIDTH 80: COLOR 7, 0: CLS : END

SUB BCircle (xc%, yc%, r%, c%)
'_|_|_|   Bresenham Circle Drawing Algorithm
'_|_|_|   Adapted from BRESNHAM.C in Bob Stout's SNIPPETS.
   x% = 0: d% = 2 * (1 - r%): W% = 2 * WIDE \ HIGH
   WHILE r% >= 0
      PSET (xc% + x%, yc% + r%), c%
      PSET (xc% + x%, yc% - r%), c%
      PSET (xc% - x%, yc% + r%), c%
      PSET (xc% - x%, yc% - r%), c%
      IF (d% + r%) > 0 THEN r% = r% - 1: d% = d% - W% * r% - 1
      IF x% > d% THEN x% = x% + 1: d% = d% + 2 * x% + 1
   WEND
END SUB

SUB BLine (x%, y%, x2%, y2%, c%)
'_|_|_|   Bresenham Line Drawing Algorithm
'_|_|_|   Adapted from BRESNHAM.C in Bob Stout's SNIPPETS.
   i% = 0: steep% = 0: e% = 0
   IF (x2% - x%) > 0 THEN sx% = 1:  ELSE sx% = -1
   dx% = ABS(x2% - x%)
   IF (y2% - y%) > 0 THEN sy% = 1:  ELSE sy% = -1
   dy% = ABS(y2% - y%)
   IF (dy% > dx%) THEN
      steep% = 1
      SWAP x%, y%
      SWAP dx%, dy%
      SWAP sx%, sy%
   END IF
   e% = 2 * dy% - dx%
   FOR i% = 0 TO dx% - 1
      IF steep% = 1 THEN PSET (y%, x%), c%:  ELSE PSET (x%, y%), c%
      WHILE e% >= 0
         y% = y% + sy%: e% = e% - 2 * dx%
      WEND
      x% = x% + sx%: e% = e% + 2 * dy%
   NEXT
   PSET (x2%, y2%), c%
END SUB

