' Font routines written by Luke Molnar

DEFINT A-Z

'*** Font routines
DECLARE SUB Font (Text$, XStart, Ystart, Xscale, Yscale, Style, clr)
DECLARE SUB LoadFont ()
DECLARE SUB FontPal ()

'$STATIC
DIM SHARED FontBuf(0) AS STRING * 10368

'$DYNAMIC

LoadFont

SCREEN 13

FontPal
' Text, xpos, ypos, xscale, yscale, sytle, color
' Font Styles 1 - 4:
'  1 = Pin Stripe
'  2 = Steel Grating
'  3 = Normal Fade
'  4 = Italic Fade
Font "Hello World", 0, 75, 3, 3, 3, 65
P$ = INPUT$(1)

SCREEN 0, 0, 0, 0: WIDTH 80: COLOR 7, 0: CLS : END

REM $STATIC
SUB Font (Text$, XStart, Ystart, Xscale, Yscale, Style, clr)

px = XStart  ' physical x and physical y
py = Ystart

LHeight = Yscale * 8
Optimize = 63 \ LHeight ' Any constant math operations done multipe times
                          ' in the main loop should, well, not be done
                          ' in the main loop.


' Instead of wasting our time with all this MID$ garbage to access bytes in
' font buffer, we'll just take a PEEK directly at them.
DEF SEG = VARSEG(FontBuf(0))

 FOR h = 1 TO LEN(Text$)
  FPtr = 81 * (ASC(MID$(Text$, h, 1)) - 1) - 1
  FOR x = 0 TO 8
   FOR y = 0 TO 8

    col = PEEK(VARPTR(FontBuf(0)) + FPtr)
    FPtr = FPtr + 1
    IF col THEN
     SELECT CASE Style
      ' If you desire a y scale factor greater than 8, you
      ' must change the division to higher precision...very slow.
      ' Or, you could find a way around it.
      CASE 1: PSET (px, py), Optimize * (py - Ystart) + clr
              LINE (px, py)-(px, py + Yscale), Optimize * (py - Ystart) + clr
      ' Notice how this style only uses 54 colors, so you can see the top
      ' of the letters where they would normally be black
      CASE 2: CIRCLE (px, py), Yscale, (54 \ LHeight) * (py - Ystart) + clr + 9, , , 4
      CASE 3:  FOR sty = px TO px + Xscale
                FOR sty2 = py TO py + Yscale
                 PSET (sty, sty2), Optimize * (sty2 - Ystart) + clr
                 IF POINT(sty - 1, sty2) = 0 THEN PSET (sty - 1, sty2), 63 + clr - 1
                 IF POINT(sty, sty2 - 1) = 0 THEN PSET (sty, sty2 - 1), 63 + clr - 1
                NEXT
               NEXT
       CASE 4: FOR sty = px TO px + Xscale
                FOR sty2 = py TO py + Yscale
                 PSET (sty + .4 * sty2, sty2), Optimize * (sty2 - Ystart) + clr
                 IF POINT((sty - 1) + .4 * sty2, sty2) = 0 THEN PSET ((sty - 1) + .4 * sty2, sty2), 63 + clr - 1
                NEXT
               NEXT
       CASE ELSE
            PSET (px, py), clr
     END SELECT
    END IF
    py = py + Yscale
   NEXT
  px = px + Xscale
  py = Ystart
  NEXT
 NEXT h
DEF SEG

END SUB

SUB FontPal
FOR x = 1 TO 63
 OUT &H3C8, x
 OUT &H3C9, x
 OUT &H3C9, 0
 OUT &H3C9, 0
NEXT
FOR x = 64 TO 126
 OUT &H3C8, x
 OUT &H3C9, 0
 OUT &H3C9, x
 OUT &H3C9, 0
NEXT
FOR x = 127 TO Sclr + 189
 OUT &H3C8, x
 OUT &H3C9, 0
 OUT &H3C9, 0
 OUT &H3C9, x
NEXT
FOR x = 190 TO 252
 OUT &H3C8, x
 OUT &H3C9, x
 OUT &H3C9, 0
 OUT &H3C9, x
NEXT
FOR x = 253 TO 255
 OUT &H3C8, x
 OUT &H3C9, x
 OUT &H3C9, x
 OUT &H3C9, x
NEXT
END SUB

SUB LoadFont

   fontfile = FREEFILE

   OPEN "basefont.dat" FOR BINARY AS #fontfile

   IF LOF(fontfile) < 20655 THEN
      SCREEN 0: WIDTH 80, 25
      COLOR 7
      PRINT "Font data file missing or corrupt.  Rebuild it? [(Y)/n]";
      DO
         key$ = UCASE$(INKEY$)
      LOOP UNTIL key$ = "N" OR key$ = "Y"
      CLOSE fontfile
      IF key$ = "N" THEN EXIT SUB
      'MakeFont
      fontfile = FREEFILE

      OPEN "basefont.dat" FOR BINARY AS #fontfile
      ' Hey, change 128 to 255 for the full font.
      CLS
      SCREEN 13
      COLOR 16
      FOR ascii = 1 TO 255
        CLS
        PRINT CHR$(ascii)
        FOR x = 0 TO 8
          FOR y = 0 TO 8
            pnt$ = CHR$(POINT(x, y))
            PUT #fontfile, , pnt$
            pnt$ = ""
          NEXT
        NEXT
      NEXT
      CLOSE
     
      OPEN "basefont.dat" FOR BINARY AS #fontfile
      GET #fontfile, , FontBuf(0)
      CLOSE #fontfile

      fontfile = FREEFILE
      OPEN "basefont.dat" FOR BINARY AS #fontfile
   END IF

   GET #fontfile, , FontBuf(0)
   CLOSE #fontfile
END SUB

