  (****************************************************************************)
  (*  Structures document for QuickBBS version 2.81 Zeta-2.                   *)
  (*                                                                          *)
  (*  This information may be freely copied and used at no charge by any      *)
  (*  party to write utilities and other software which enhances the use of   *)
  (*  the QuickBBS software.                                                  *)
  (*                                                                          *)
  (*  Use of this information in any other BBS program without the permission *)
  (*  Of Matrix Technologies is strictly prohibited.                          *)
  (*                                                                          *)
  (*      Copyright 1991-96 Matrix Technology                                 *)
  (*      All Rights Reserved.                                                *)
  (****************************************************************************)

  (****************************************************************************)
  (*     See the file STRUCTURE.DOC for information on these structures!      *)
  (****************************************************************************)

Const
{$IFDEF GOLDBASE}
  MaxMsgAreas  = 500;
  FileExt = '.DAT';
{$ELSE}
  MaxMsgAreas  = 200;
  FileExt = '.BBS';
{$ENDIF}
{  MaxFileAreas = 200; infinity }
  MaxLanguages = 30;
  MaxEvents    = 30;
  MaxProtocols = 20;

type

  FlagType = array[1..4] of Byte;

  UserIdxRecord = record { USERIDX.BBS or USERIDX.DAT }
                    NameCRC : LongInt;
                    AliasCRC: LongInt;
                  end;

  UserRecord = record { USERS.BBS or USERS.DAT }
                 Name        : String[35];
                 City        : String[25];
                 ReservedZero: Byte; { Reserved, should always be 0 }
                 Language    : Byte;
                 PwdCrc      : Longint;
                 PwdChangeDate,
                 ExpireDate  : Word; { Number of days since 1/1/1900 }
{$IFDEF GOLDBASE}
                 HighMsgRead : LongInt;
{$ELSE}
                 UnusedSpace : LongInt;
{$ENDIF}
                 Attrib2     : Byte;   
                 ExtraSpace  : Byte;
                 DataPhone,
                 HomePhone   : String[12];
                 LastTime    : String[5];
                 LastDate    : String[8];
                 Attrib      : Byte;
                 Flags       : FlagType;
                 Credit,
                 Pending,
{$IFDEF GOLDBASE}
                 TimesPosted : Word;
                 ObsoleteField,
{$ELSE}
                 TimesPosted,
                 HighMsgRead,
{$ENDIF}
                 SecLvl,
                 Times,
                 Ups,
                 Downs,
                 UpK,
                 DownK       : Word;
                 TodayK      : Integer;
                 Elapsed,
                 Len         : Integer;
                 CombinedPtr : Word; (* Record number in COMBINED.BBS *)
                                        (* Note:  0 signifies no combined record assigned *)

                 AliasPtr    : Word; (* Record number in ALIAS.BBS *)
                                      (* Note:  0 signifies no alias record assigned *)
                 Birthday    : Longint; { Number of days since 1/1/1900 }
               end;


(* Attrib:
      Bit 0: Deleted
      Bit 1: Screen Clear Codes
      Bit 2: More Prompt
      Bit 3: ANSI
      Bit 4: No-Kill
      Bit 5: Ignore Download Hours
      Bit 6: ANSI Full Screen Editor
      Bit 7: Sex (0=male, 1=female)
*)
(* Attrib2:
      Bit 0: Guest Account              (No Password Needed)
      Bit 1: SSR Configured On/Off      (False/0 = Unused., True/1 = Activated)
      Bit 2: Not Defined Yet (Should be False/0)
      Bit 3: Not Defined Yet (Should be False/0)
      Bit 4: Not Defined Yet (Should be False/0)
      Bit 5: Not Defined Yet (Should be False/0)
      Bit 6: Not Defined Yet (Should be False/0)
      Bit 7: Not Defined Yet (Should be False/0)
*)

type

  UserActivityType = (InMenu, InDoor, InCallback, 
                      ReadingMessages, WritingMessage,
                      ChattingWithSysop, ChattingWithUsers,
                      AnsweringQuestionaire, ViewingTextFile, 
                      DownloadingFile, UploadingFile, ViewingFileList, 
                      DoingFileSearch, LoggingOn, LoggingOff, WaitingForCall);


  USERONrecord   = record { USERON.BBS }
                     Name           : String[35];
                     Alias          : String[35];
                     Line           : Byte;
                     Baud           : Word;
                     City           : String[25];
                     DoNotDisturb   : Boolean;
                     Conference     : Byte;
                     Activity       : UserActivityType;
                     Language       : Byte;
                     Spare          : Array[2..9] of Byte;
                   end;

  AliasRecord = String[35]; (* for ALIAS.BBS *)
  (* Note: record 0 of ALIAS.BBS is a placeholder only, and contains no
     information. *)

  MsgToIdxRecord = String[35]; { MSGTOIDX.BBS or MSGTOIDX.DAT }

  MsgTxtRecord = String[255]; { MSGTXT.BBS or MSGTXT.DAT }

  { Nodelist Records *************************************************** }

  NodeTypes      = (ntZone, ntRegion, ntNet, ntNode, ntPrefix);

  NodeIdxRecord  = record
                       NodeType       : NodeTypes;
                       Number,
                       Cost           : Word;
                       RawFile        : Byte;
                       RawPos         : LongInt;
                   end;

  FileNameType   = String[12];

  NodeIncRecord  = record
                       FileName       : FileNameType;
                       DateStamp      : LongInt;
                   end;

  { Message Records ******************************************************}

  CombSelectType = array[1..MaxMsgAreas] of Boolean; (* for COMBINED.BBS *)
  (* Note: record 0 of COMBINED.BBS is a placeholder only, and contains no
     information. *)


  InfoRecord = record
{$IFDEF GOLDBASE}
                 LowMsg  : LongInt; { Lowest Message in File }
                 HighMsg : LongInt; { Highest Message in File }

                 TotalActive : LongInt; { Total Active Messages }

                 ActiveMsgs : array[1..MaxMsgAreas] of Word;
{$ELSE}
                 LowMsg  : Integer; { Lowest Message in File }
                 HighMsg : Integer; { Highest Message in File }

                 TotalActive : Integer; { Total Active Messages }

                 ActiveMsgs : array[1..MaxMsgAreas] of Integer;
{$ENDIF}
               end;

  IdxRecord = record { MSGIDX.BBS or MSGIDX.DAT }
{$IFDEF GOLDBASE}
                MsgNum : LongInt;
                Board  : Word;
{$ELSE}
                MsgNum : Integer;
                Board  : Byte;
{$ENDIF}
              end;

  HdrRecord = record { MSGHDR.BBS or MSGHDR.DAT }
{$IFDEF GOLDBASE}
                MsgNum,
                ReplyTo,
                SeeAlsoNum : LongInt;
{$ELSE}
                MsgNum,
                ReplyTo,
                SeeAlsoNum,
{$ENDIF}
                TRead    : Integer;
{$IFDEF GOLDBASE}
                StartRec : LongInt;
{$ELSE}
                StartRec : Word;
{$ENDIF}
                NumRecs,
                DestNet,
                DestNode,
                OrigNet,
                OrigNode : Integer;
                DestZone,
                OrigZone : Byte;
                Cost     : Integer;
                MsgAttr,
                NetAttr, (* NOTE:  MsgAttr and NetAttr are WORD for GOLDBASE *)
{$IFDEF GOLDBASE}
                Board    : Word;
{$ELSE}
                Board    : Byte;
{$ENDIF}
                PostTime : String[5];
                PostDate : String[8];
                WhoTo,
                WhoFrom  : String[35];
                Subj     : String[72];
              end;


(* Msg Attributes:

      Bit 0: Deleted
      Bit 1: Unmoved Outgoing Net Message
      Bit 2: Is a Net Mail Message
      Bit 3: Private
      Bit 4: Received
      Bit 5: Unmoved Outgoing Echo Message
      Bit 6: Local Bit
      Bit 7: Group Message

   Net Attributes:

      Bit 0: Kill Message after it's been sent
      Bit 1: Sent OK
      Bit 2: File(s) Attached
      Bit 3: Crash Priority
      Bit 4: Request Receipt
      Bit 5: Audit Request
      Bit 6: Is a Return Receipt
      Bit 7: Freq

*)

  { Other Stuff *********************************************************** }

  SysInfoRecord = record { SYSINFO.BBS }
                    CallCount        : LongInt;
                    LastCallerName   : String[35];
                    LastCallerAlias  : String[35];
                    ExtraSpace : array[1..92] of Byte;
                  end;

  TodayRecord = record { TODAY.BBS }
                     Name           : String[35];
                     Alias          : String[35];
                     Line           : Byte;
                     City           : String[25];
                     Date           : Longint;
                     Time           : Longint;
                   end;

  TimeLogRecord = record { TIMELOG.BBS }
                    StartDate   : String[8];
                    BusyPerHour : array[0..23] of Integer;
                    BusyPerDay  : array[0..6] of Integer;
                  end;

{$IFDEF GOLDBASE}
  LastReadType = Array[1..MaxMsgAreas] of LongInt; { LASTREAD.DAT }
{$ELSE}
  LastReadType = Array[1..MaxMsgAreas] of Word; { LASTREAD.BBS }
{$ENDIF}

  MenuRecord = record { *.MNU }
                 Typ   : Byte;
                 Sec   : Word;
                 Flags : FlagType;
                 Str   : String[75];
                 Key   : Char;
                 Data  : String[80];
                 Fg,
                 Bg    : Byte;
               end;

  Type
    PhraseRecord=Record { *.LNG }
      TextString : String[80];
      KeyString  : String[10];
      Color      : Byte;
     End;

  { Configuration Information ********************************************** }

  TypeMsgs  = (Standard,Netmail,FMail,EchoMail);
  KindMsgs  = (Both,Private,Public,ROnly);
  EventStat = (Deleted, Enabled, Disabled);
  AskType   = (No, Maybe, Yes);
  ProtocolEnableType = (Never, MNP_Only, Always);
  ProtocolTypes      = (Xmodem, Xmodem1K, Ymodem, YmodemG,
                        Kermit, Zmodem, External);

  SecurityRecord = Record { part of main config record }
    Security : Word;
    Flags    : FlagType;
  End;

  FileAreaRecord = Record (* FILECFG.DAT *)
    AreaName,
    FilePath,
    ListPath    : String[66];
    AllowUploads,
    IgnoreKlimit,
    IgnoreRatio : Boolean;
    DlSec       : SecurityRecord;
    SearchSec   : SecurityRecord;
    TemplateSec : SecurityRecord;
    CheckDupes  : Boolean;
    Group       : Byte;
    Spare       : Array[3..12] of Byte;
  End;

  BoardRecord = record (* MSGCFG.DAT *)
                  Name            : String[40];
                  Typ             : TypeMsgs;
                  Kinds           : KindMsgs;
                  Combined        : Boolean;
                  Aliases         : AskType;
                  Aka             : Byte;
                  OriginLine      : String[58];
                  AllowDelete     : Boolean;
                  KeepCnt,                (* Max # of Msgs to keep *)
                  KillRcvd,               (* Kill received msgs after this many days *)
                  KillOld         : Word; (* Kill msgs after this many days *)
                  ReadSec         : SecurityRecord;
                  WriteSec        : SecurityRecord;
                  TemplateSec     : SecurityRecord;
                  SysopSec        : SecurityRecord;
                  FileArea        : Integer;  (* for Fmail *)
                  Group           : Byte;
                  Spare           : Array[4..12] of Byte;
                end;

   EventRecord = record (* EVENTCFG.DAT *)
                  Status      : EventStat;
                  RunTime     : LongInt;
                  ErrorLevel  : Byte;
                  Days        : Byte;
                  Forced      : Boolean;
                  LastTimeRun : LongInt;
                  Spare       : Array[1..7] of Byte;
                end;

   FileKLimitRecord = record { For limit records }
                        Baud  : Word;
                        Limit : Integer;
                      end;

   LimitRecord = record (* LIMITS.DAT *)
                   Security     : Word;
                   DailyLimit,
                   SessionLimit,
                   DownLimit    : Integer;
                   PwdLife      : Byte;
                   MinBaud      : Word;
                   FileKLimits  : Array[1..8] of FileKLimitRecord;
                   FileKRatio   : Integer;
                   FileRatio    : Integer;
                   ExpireQuest  : String[8];  (* Questionaire to run when
                                               subscription expires *)
                   ExpireText   : String[8];  (* Text File to display when
                                               subscription expires soon *)
                   DaysWarning  : Byte;  (* Number of days before expiration
                                            to start displaying ExpireText *)
                   Description  : String[40];
                   TopMenu      : String[8];
                   UserPurge    : Byte;  (* For UserPack - delete users who
                                            haven't called in this many days *)
                   MoreFileKLimits  : Array[9..12] of FileKLimitRecord;
                   Spare        : Array[18..20] of Byte;
                 end;

   LanguageRecord = record (* LANGUAGE.DAT *)
                      DisplayName : String[20];
                      IEMSIname   : String[5];
                      Available   : Boolean;
                      PhraseFile,
                      MenuPath,
                      TextPath,
                      QuestPath   : String[66];
                      Spare       : Array[1..200] of Byte;
                    end;

  ProtocolRecord = record (* PROTOCOL.DAT *)
                     Name                 : string[25];
                     Key                  : Char;
                     ProtocolType         : ProtocolTypes;
                     LogCharacter         : Char;
                     UploadsAllowed       : ProtocolEnableType;
                     DownloadsAllowed     : ProtocolEnableType;
                     LogFile              : string[66];
                     ControlFile          : string[66];
                     UploadCommand        : string[100];
                     UploadControl        : string[100];
                     DownloadCommand      : string[100];
                     DownloadControl      : string[100];
                     SupportsBatch        : Boolean;
                     FileNamePos          : Byte;
                     UploadKeyword        : string[20];
                     DownloadKeyword      : string[20];
                     SuccessErrorLevel    : Byte;
                     FailureErrorLevel    : Byte;
                     Efficiency           : Byte;
                     Spare                : Array[1..100] of Byte;
                   end;

   ModemTranslationRecord = Record { for main config record }
                   TranslateFrom : String[25];
                   TranslateTo   : Word;
                 End;

   Key4Type = Array[1..4] of Word;
 
   NodeConfigRecord = record  (* NODECFG.DAT *)
                        Node      : Byte;
                       (*  Modem Parameters  *)
                        CommPort      : Integer;
                        InitBaud      : Word;
                        ModemDelay    : Word;
                        InitTimes,
                        AnswerWait    : Integer;
                        ModemInitStr,
                        ModemBusyStr  : String[70];
                        ModemInitResp,
                        ModemBusyResp : String[40];

                        ModemConnectResp :
                          Array[1..20] of ModemTranslationRecord;

                        CBV_CallbackDelay,
                        CBV_WakeupDelay : Word;

                        ARQ_String      : String[8];
                        SendATA         : Boolean;

                        NetPath,
                        NodelistPath,
                        MsgPath,
                        SwapPath,
                        OverlayPath     : String[66];
                        EditorCmdStr,
                        UserEditor      : String[70];
                        OriginLine      : String[58];
                        MinBaud,
                        GraphicsBaud,
                        XferBaud        : Integer;

                       (* Callback verifier *)
                       VerifierInit    : string[35];
                       DialString      : string[15];
                       DialSuffix      : string[15];

                       (*  Default Information for New Users  *)
                       DefaultSec      : SecurityRecord;
                       MinimumSec      : SecurityRecord;
                       DefaultCredit   : Integer;
                       FastLogon       : Boolean;

                       ExtraSpace      : array[2..200] of byte;

                      End;

   ConfigRecord = record  (* QUICKCFG.DAT *)

                   VersionID : Word;

                   WasNodeInfo : Array[1..481] of Byte;
                   (*  System Paths  *)
                   WasEditorCmdStr    : String[70];
                   Stat6Line1,
                   Stat6Line2,
                   WasNetPath,
                   WasNodelistPath,
                   WasMsgPath,
                   WasSwapPath,
                   WasOverlayPath     : String[66];

                   OldPrompts : Array[1..213] of Byte;

                   (* System misc strings *)
                   OldOriginLine      : String[58];
                   QuoteStr        : String[3];

                   (*  User Restrictions *)
                   LowBaudStart,
                   LowBaudEnd,
                   DownloadStart,
                   DownloadEnd     : LongInt;
                   MaxPageTimes,
                   PageBellLen     : Integer;
                   PagingStart,
                   PagingEnd       : LongInt;
                   OldBaudStuff    : Array[1..6] of Byte;

                   (*  Matrix Information  *)
                   MatrixZone,
                   MatrixNet,
                   MatrixNode,
                   MatrixPoint     : array[0..10] of Integer;
                   NetMailBoard    : Integer;

                   OldNewUserInfo : Array[1..14] of Byte;

                   (*  Sysop Security Etc. *)
                   SysopSecurity   : SecurityRecord;
                   SysopName       : String[35];
                   SystemName      : String[40];
                   RegKey          : LongInt;

                   (*  Misc System Parameters  *)

                   TextFileShells,
                   AltJswap,
                   Editorswap,
                   AutoLogonChar,
                   FormerFastLogon,  {Former FastLogon, unused, Moved to Nodecfg}
                   UseLastRead,
                   MonoMode,
                   DirectWrite,
                   SnowCheck,
                   NetEchoExit,
                   OneWordNames,
                   CheckMail,
                   AskHomePhone,
                   AskDataPhone,
                   AskBirthday,
                   AskSex,
                   Use_Xmodem,
                   Use_Xmodem1k,
                   Use_Ymodem      : Boolean;
                   Use_YmodemG     : ProtocolEnableType;
                   Use_Kermit,
                   Use_Zmodem,
                   Inp_Fields,
                   GraphicsAvail,
                   ForceUS_Phone   : Boolean;
                   InactiveTimeOut : Integer;
                   LogonTime       : Integer;
                   DefFgColor      : Integer;
                   DefBgColor      : Integer;
                   PasswordTries   : Integer;
                   EntFldColor     : Byte; (* Color for entry fields *)
                   BorderColor     : Byte; (* Color for menu borders *)
                   WindowColor     : Byte;
                   StatusBarColor  : Byte;
                   UploadCredit    : Integer;
                   ScreenBlank     : Byte;

                   (* Callback verifier *)
                   CBV_Spare       : Array[1..68] of Byte;
                   DupeCheck       : Boolean;
                   NewUserSec,
                   MemberSec       : Word;
                   MemberFlags     : Array[1..4,1..8] of Char;
                   LDcost          : Word;
                   LDenable,
                   ResumeLocal,
                   ResumeLD        : Boolean;
                   LDstart,
                   LDend           : Longint;

                   ForgotPwdBoard  : Byte;
                   WasSendATA      : Boolean;

                   Location        : String[60];

                   ArchiveNetMail  : Boolean;

                   IEMSI,
                   IEMSI_New,
                   AutoAnsi,
                   MultiNode,
                   AutoLogChat     : Boolean;
                   WasUserEditor      : String[70];

                   FileAreaCols,
                   MsgAreaCols     : Byte;

                   NewUserExpiry   : Word;

                   PasswordLength  : Byte;

                   ShowIdle        : Boolean;

                   LocalRipExt     : String[3];

                   Key4            : Key4Type;

                   ExtraSpace      : Array[159..400] of Byte;

                 end;

Type    MenuHelpCfg_Rec = Record
             Description    : String[37]; (* Visible Help Descrpt.           *)
             Options        : String[37] ;(* Visible "Options" For Menu Type *)
             Visible_Line   : String[75] ;(* Menu's Visible Line             *)
             Optional_Data  : String[80]; (* Menu's Optional Data            *)
             ImportOkay     : Boolean; 
             Menu_Type      : Word;       (* Menu Type to be imported        *)
             Security       : SecurityRecord; 
             Hot_Key        : Char;
             ForeGround,
             BackGround     : Byte; 
             Group          : Byte; 
End;


  GosubDataType = array[1..20] of String[8];

  ExitRecord = record (* EXITINFO.BBS *)
                 BaudRate        : Integer;
                 SysInfo         : SysInfoRecord;
                 TimeLogInfo     : TimeLogRecord;
                 UserInfo        : UserRecord;
                 EventInfo       : EventRecord;
                 NetMailEntered  : Boolean;
                 EchoMailEntered : Boolean;
                 LoginTime       : String[5];
                 LoginDate       : String[8];
                 TmLimit         : Integer;
                 LoginSec        : LongInt;
                 Credit          : LongInt;
                 UserRecNum      : Integer;
                 ReadThru        : Word;
                 PageTimes       : Integer;
                 DownLimit       : Integer;
                 WantChat        : Boolean;
                 GosubLevel      : Byte;
                 GosubData       : GosubDataType;
                 Menu            : String[8];
                 ScreenClear     : Boolean;
                 MorePrompts     : Boolean;
                 GraphicsMode    : Boolean;
                 ExternEdit      : Boolean;
                 ScreenLength    : Integer;
                 MNP_Connect     : Boolean;
                 ChatReason      : String[48];
                 ExternLogoff    : Boolean;
                 ANSI_Capable    : Boolean;
                 CurrentLanguage : Byte;
                 RIP_Active      : Boolean;
                 ExtraSpace      : Array[2..200] of Byte;
               end;


