@echo off
echo I am in charge here (call me Al).

rem - this batch file creates a TBBS ".QAF" compiled questionnaire
rem   from a source text file.  The source file consists of a mixture
rem   of TBBS QAL language statements and lines meant to be handled by
rem   a simple variable-naming preprocessor.  This arrangement
rem   essentially allows a lightly extended form of the QAL language to
rem   be compiled properly with one command (see the file MANUAL.DOC for 
rem   details on exactly how variable-naming works)

rem  user needs to supply a filename for processing

if !%1==! goto noargs

rem  we're going to assume that all files are in the TBBS\QA subdirectory,
rem  except that the QAL compiler itself is in the TBBS subdirectory.
rem  Change and/or add to the following as appropriate for your system.

SET TBBS=h:\tbbs

rem we need an intermediate file to hold the preprocessed code.  The
rem TEMP directory is a good place to put it (if there is one on your
rem system).  Future executions of this batch file will overwrite any
rem previous intermediate file.

SET IFIL=%TEMP%\ifile.qal

echo preprocessing...

%TBBS%\qa\qalnames %1 >%IFIL%

echo compiling...

%TBBS%\qal %IFIL%

rem  if all went well we now have a "%1.QAF" file in whatever directory
rem  we're in.  If not, we may want to add a listing directive to the
rem  compile command so we can see what went wrong.

rem  next we'll just clean up the environment variables a bit, since
rem  we're not trying to use them to communicate with other programs
rem  (instead we were just saving a bit of typing, and making things look
rem  a little neater). We could delete the intermediate file while we're at
rem  it, but (a) we may want to look at it (particularly if there's an error
rem  report in it), and (b) on my system TEMP is set to a subdirectory on
rem  a RAM disk, so anything left there will disappear anyway when I turn
rem  the power off.  Change and/or add to as appropriate for your system.

echo cleanup...

SET IFIL=
SET QDIR=
SET TBBS=

goto done

rem - need a filename!

:noargs

echo Useage:  QAL "filename"

rem - all finished

:done
