{ File Map2Uses.pas }
{ 10-Jan-1991 J. K. Welsh }

{ This program reads a .MAP file produced by the Turbo Pascal compiler, and
  creates an optimized Uses list. It also lists all of the "uses" units in
  overlay format, excepting those you specify below. }

{ Activate only one of the following }
{..$Define UseTpro}
{$Define UseOpro}

{.$Define Debug}
{$IfDef Debug}
{$D+}
{$L+}
{$S+}
{$R+}
{$EndIf}

program Map2Uses;

  {$I-}

uses
  Dos,

  {$IfDef UseTpro}
  tpinline,
  tpcrt,
  tpstring,
  tpdos,
  tpasciiz;
  {$Endif}

  {$IfDef UseOpro}
  Opinline,
  Opcrt,
  Opstring,
  Opdos,
  Opasciiz;
  {$Endif}

const
  OutExt              : String[4] = '.USE';
  MapExt              : String[4] = '.MAP';
  Indent1             = '  ';
  Indent2             = '     ';

  MaxUnits            = 400;
  UnitNamePos         = 21;       { Change if the .MAP file format changes }

  { The following are not to be placed in the uses list.
    They must be in lowercase. }
  BadNames            = 'name system data stack heap';

  { The following are not to be overlaid. They will all be combined into a
    single AsciiZ string at the start of the program. This is not a definitive
    list. You should "tune" it based upon your needs. These names must all
    be in lowercase. }

  Lib1NoOverlay       = 'overlay tpinline tpcrt tpstring tpmouse tpcmd tpedit tppick tpentry';
  Lib2NoOverlay       = 'opinline opcrt opstring opmouse opcmd tpedit oppick opentry opxms opexec';
  FilerNoOverlay      = 'filer vrec isamtool browser ';
  PubDomainNoOverlay  = 'shrink extend tpstack';
  My1NoOverlay        = '';
  My2NoOverlay        = '';

  { If you wish mixed upper and lower case names, use these. Lower case only here. }
  UpLib3              = 'tp op oo ap'; { Uppercase the third letter for these }
  UpLib4              = 'lzh zip'; { Uppercase the fourth letter for these }
  UpLib5              = '';       { Uppercase the fifth letter for these }

type
  Str8                = String[8];

var
  UnitNames           : array[1..MaxUnits] of Str8;
  LastName, UnitName  : Str8;
  InFileName, OutFileName : Pathstr;
  InFile, OutFile     : Text;
  Name                : NameStr;
  Finished, OverLayIt,
  UnitNameOk          : Boolean;
  LineCount, UnitCount : LongInt;
  Ext                 : ExtStr;
  Dir                 : DirStr;
  LastChar, ThisChar  : Char;
  s                   : String;
  I, J                : Word;
  Az, Bz              : AsciiZ;
  IoStatus            : Integer;

  { ----- }
  function Up_Case(Un : Str8) : Str8;
    { Just some "pretty printing". Change to suit. }

  var
    s2                  : String[2];
    s3                  : String[3];
    s4                  : String[4];

  begin
    s2 := Copy(Un, 1, 2);
    s3 := Copy(Un, 1, 3);
    s4 := Copy(Un, 1, 4);

    Un[1] := Upcase(Un[1]);       { Always Upcase the first letter }

    if (Pos(s4, UpLib5) > 0) then
      Un[5] := Upcase(Un[5])
    else
      if (Pos(s3, UpLib4) > 0) then
        Un[4] := Upcase(Un[4])
    else
      if (Pos(s2, UpLib3) > 0) then
        Un[3] := Upcase(Un[3]);

    Up_Case := Un;
  end;                            { function Up_Case }

  { ----- }
  procedure Write_Usage;
  begin
    WriteLn('Usage Map2Uses InFileName [OutFileName]');
    Halt
  end;


begin                             { ----- main program Map2Uses ----- }
  ClrScr;

  if ParamCount < 1 then
    Write_Usage;

  InFileName := FExpand(ParamStr(1));
  FsPlit(InFileName, Dir, Name, Ext);

  if Ext = '' then
    begin
      InFileName := InFileName + MapExt;
      FsPlit(InFileName, Dir, Name, Ext);
    end;

  if Ext <> MapExt then
    begin
      WriteLn('Input file must be a ', MapExt, ' file.');
      WriteLn(InFileName);
      Halt;
    end;

  if ParamCount < 2 then
    OutFileName := FExpand(Name + OutExt)
  else
    OutFileName := FExpand(ParamStr(2));

  if not ExistFile(InFileName) then
    Write_Usage;                  { Halt with message }

  WriteLn('Reading from    ', InFileName);
  WriteLn('Writing to      ', OutFileName);
  WriteLn;
  WriteLn;

  FillChar(UnitNames, SizeOf(UnitNames), 0);
  LineCount := 0;
  UnitCount := 0;

  { Take our lists of units that are not to be overlaid and build them into }
  { one AsciiZ array }
  FillChar(Az, SizeOf(Az), 0);
  ConcatStr(Az, Lib1NoOverlay, Bz);
  ConcatStr(Bz, Lib2NoOverlay, Az);
  ConcatStr(Az, FilerNoOverlay, Bz);
  ConcatStr(Bz, PubDomainNoOverlay, Az);
  ConcatStr(Az, My1NoOverlay, Bz);
  ConcatStr(Bz, My2NoOverlay, Az);

  Assign(InFile, InFileName);
  Reset(InFile);
  IoStatus := IoResult;
  if (IoStatus <> 0) then
    begin
      WriteLn('Error #', IoStatus, ' resetting "', InFileName, '".');
      Halt(IoStatus);
    end;

  Assign(OutFile, OutFileName);
  Rewrite(OutFile);
  IoStatus := IoResult;
  if (IoStatus <> 0) then
    begin
      WriteLn('Error #', IoStatus, ' rewriting "', OutFileName, '".');
      Halt(IoStatus);
    end;

  Finished := False;

  repeat                          { Until finished }
    ReadLn(InFile, s);
    Inc(LineCount);

    Finished := EoF(InFile);
    if Finished = False then
      begin
        s := Trim(s);
        { Stop at first blank line after unit name section of map file. }
        if (Length(s) = 0) then
          if LineCount > 4 then
            Finished := True;

        if Finished = False then
          if (Length(s) > 0) then
            begin
              Delete(s, 1, UnitNamePos);
              s := Copy(s, 1, 8);
              s := StLocase(Trim(s)); { Unit name }
              UnitNameOk := (Pos(s, BadNames) = 0); { Searching within a normal turbo string }
              if UnitNameOk then
                begin
                  Inc(UnitCount);
                  UnitNames[UnitCount] := s;
                end;              { if UnitNameOk }
            end;                  { Length(s) > 0 }
      end;                        { if Finished = False }
  until Finished;

  { All unit names read into array }
  { Write out the unit names in reverse order for a Uses list. }

  LastChar := ' ';
  WriteLn(OutFile, Indent1, 'Uses');

  { UnitNames[1] is program name, discard }
  { UnitNames[2] is printed outside of this loop because it has a trailing ; }

  for I := UnitCount downto 3 do
    begin
      UnitName := UnitNames[I];
      ThisChar := Upcase(UnitName[1]);

      if ThisChar <> LastChar then
        WriteLn(OutFile);         { Just for formatting }

      UnitName := Up_Case(UnitName);

      WriteLn(OutFile, Indent2, UnitName, ',');
      WriteLn(Indent2, UnitName, ',');

      LastChar := UnitName[1];
    end;

  WriteLn(OutFile, Indent2, UnitNames[2], ';'); { Last item in list ends with ; }

  WriteLn(OutFile);
  WriteLn(OutFile);

  { Last one is program name }
  { Second last one is first unit }
  for I := UnitCount downto 2 do
    begin
      UnitName := UnitNames[I];
      ThisChar := Upcase(UnitName[1]);

      if ThisChar <> LastChar then
        WriteLn(OutFile);         { Blank line for formatting }

      OverLayIt := (PosStr(UnitName, Az) = NotFound);
      UnitName := Up_Case(UnitName);

      { Usually, the unit immediately following the Overlay unit is a special
        user defined unit for doing special things with the overlay unit. It
        should not be overlaid. Such a special unit is required if any
        overlaid units contain intialization code. }

      if OverLayIt then
        if LastName = 'Overlay' then
          OverLayIt := False;

      if OverLayIt then
        WriteLn(OutFile, Indent2, '{$O ', UnitName, '}')
      else
        WriteLn(OutFile, Indent2, '{.$O ', UnitName, '}');

      LastChar := UnitName[1];
      LastName := UnitName;
    end;

  Close(OutFile);
  Close(InFile);

  {$I+}

end.                              { ----- Program Map2Uses ----- }

