%TITLE  "Error messages"
;-----------------------------------------------------------------------------
;   ERRMSG.ASM (Turbo Assembler 2.0)
;   This file contains the standard error messages for the Turbo Pascal 6.0
;   DosErrorMsg function provided by ERROR.PAS
;-----------------------------------------------------------------------------
;   Compile with TASM only (MASM will fail!)
;-----------------------------------------------------------------------------
;   Revision history:
;       24-Apr-1992 created by hs
;       27-Apr-1992 add header
;-----------------------------------------------------------------------------
;   This file was written by Hans Schleichert.
;   Copyright (c) Hans Schleichert 1992.
;   For distribution policies, see file ERROR.DOC in the same ZIP.
;-----------------------------------------------------------------------------

IDEAL

MODEL   TPASCAL

PUBLIC  GetTable

MACRO   AsciC   Str
        LOCAL   L1, L2
L1:     DB      L2-L1-1, '&Str'
L2:
ENDM    AsciC

MACRO   ErrorMsg Num, Msg
MsgCnt  =   MsgCnt+1
        DW      Num
        AsciC   <Msg>
ENDM    ErrorMsg

CODESEG

MsgCnt  =       0

Msgs:
        ErrorMsg        0, <Successful completion>
        ErrorMsg        1, <Invalid function number>
        ErrorMsg        2, <File not found>
        ErrorMsg        3, <Path not found>
        ErrorMsg        4, <Too many open files>
        ErrorMsg        5, <Access denied>
        ErrorMsg        6, <Invalid handle>
        ErrorMsg        7, <Memory control blocks destroyed>
        ErrorMsg        8, <Insufficient memory>
        ErrorMsg        9, <Invalid memory block address>
        ErrorMsg        10, <Invalid environment>
        ErrorMsg        11, <Invalid format>
        ErrorMsg        12, <Invalid access code>
        ErrorMsg        13, <Invalid data>
        ErrorMsg        15, <Invalid drive number>
        ErrorMsg        16, <Cannot remove current directory>
        ErrorMsg        17, <Not same device>
        ErrorMsg        18, <No more files>
        ErrorMsg        19, <Write-protected diskette>
        ErrorMsg        20, <Unknown unit>
        ErrorMsg        21, <Drive not ready>
        ErrorMsg        22, <Unknown command>
        ErrorMsg        23, <Data error (CRC)>
        ErrorMsg        24, <Bad request structure length>
        ErrorMsg        25, <Seek error>
        ErrorMsg        26, <Unknown media type>
        ErrorMsg        27, <Sector not found>
        ErrorMsg        28, <Printer out of paper>
        ErrorMsg        29, <Write fault>
        ErrorMsg        30, <Read fault>
        ErrorMsg        31, <General failure>
        ErrorMsg        32, <Sharing violation>
        ErrorMsg        33, <Lock violation>
        ErrorMsg        34, <Invalid disk change>
        ErrorMsg        35, <FCB unavailable>
        ErrorMsg        36, <Sharing buffer overflow>
        ErrorMsg        50, <Network request not supported>
        ErrorMsg        51, <Remote computer not listening>
        ErrorMsg        52, <Duplicate name on network>
        ErrorMsg        53, <Network name not found>
        ErrorMsg        54, <Network busy>
        ErrorMsg        55, <Network device no longer exists>
        ErrorMsg        56, <Net BIOS command limit exceeded>
        ErrorMsg        57, <Network adapter hardware error>
        ErrorMsg        58, <Incorrect response from network>
        ErrorMsg        59, <Unexpected network error>
        ErrorMsg        60, <Incompatible remote adapter>
        ErrorMsg        61, <Print queue full>
        ErrorMsg        62, <Not enough space for print file>
        ErrorMsg        63, <Print file was deleted>
        ErrorMsg        64, <Network name was deleted>
        ErrorMsg        65, <Access denied>
        ErrorMsg        66, <Network device type incorrect>
        ErrorMsg        67, <Network name not found>
        ErrorMsg        68, <Network name limit exceeded>
        ErrorMsg        69, <Net BIOS session limit exceeded>
        ErrorMsg        70, <Temporarily paused>
        ErrorMsg        71, <Network request not accepted>
        ErrorMsg        72, <Print or disk redirection is paused>
        ErrorMsg        80, <File exists>
        ErrorMsg        82, <Cannot make directory entry>
        ErrorMsg        83, <Fail on INT 24>
        ErrorMsg        84, <Too many redirections>
        ErrorMsg        85, <Duplicate redirection>
        ErrorMsg        86, <Invalid password>
        ErrorMsg        87, <Invalid parameter>
        ErrorMsg        88, <Network device fault>
        ErrorMsg        100, <Disk read error>
        ErrorMsg        101, <Disk write error>
        ErrorMsg        102, <File not assigned>
        ErrorMsg        103, <File not open>
        ErrorMsg        104, <File not open for input>
        ErrorMsg        105, <File not open for output>
        ErrorMsg        106, <Invalid numeric format>
        ErrorMsg        150, <Disk is write-protected>
        ErrorMsg        151, <Unknown unit>
        ErrorMsg        152, <Drive not ready>
        ErrorMsg        153, <Unknown command>
        ErrorMsg        154, <CRC error in data>
        ErrorMsg        155, <Bad drive request structure length>
        ErrorMsg        156, <Disk seek error>
        ErrorMsg        157, <Unknown media type>
        ErrorMsg        158, <Sector not found>
        ErrorMsg        159, <Printer out of paper>
        ErrorMsg        160, <Device write fault>
        ErrorMsg        161, <Device read fault>
        ErrorMsg        162, <Hardware failure>
        ErrorMsg        200, <Division by zero>
        ErrorMsg        201, <Range check error>
        ErrorMsg        202, <Stack overflow>
        ErrorMsg        203, <Heap overflow>
        ErrorMsg        204, <Invalid pointer operation>
        ErrorMsg        205, <Floating point overflow>
        ErrorMsg        206, <Floating point underflow>
        ErrorMsg        207, <Invalid floating point operation>
        ErrorMsg        208, <Overlay manager not installed>
        ErrorMsg        209, <Overlay file read error>
        ErrorMsg        210, <Object not initialized>
        ErrorMsg        211, <Call to abstract method>
        ErrorMsg        212, <Stream registration error>
        ErrorMsg        213, <Collection index out of range>
        ErrorMsg        214, <Collection overflow error>
        ErrorMsg        255, <Program abort>

GetTable:
        PUSH    CS
        POP     ES
        MOV     DI,OFFSET Msgs
        MOV     CX,MsgCnt
        RETN    0

END