unit SPLASH;

interface

{$R splash.res}

uses WinTypes, WinProcs, WObjects;

const
id_OpenBmp = 'OPENBMP';
timer_ID =1;

type

{Declare TPicWindow, a TWindow descendant }
 PPicWindow = ^TPicWindow;
 TPicWindow = Object(TWindow)
   procedure SetupWindow; virtual;
   procedure WMTimer(var Msg: TMessage);
     virtual wm_First + wm_Timer;
   Constructor Init(AParent: PWindowsObject; AStyle : LongInt);
   Procedure Paint(PaintDC : HDC; Var PaintInfo : TPaintStruct); virtual;
   function GetClassName: PChar; Virtual;
   procedure GetWindowClass(var AWndClass: TWndClass); virtual;
 end;

var
  hOpenBmp : HBitmap;

implementation

{TPicWindow}
Procedure TPicWindow.SetupWindow;
begin
  TWindow.SetupWindow;
  SetTimer(hWindow, timer_ID, 10000, nil);
end;

Constructor TPicWindow.Init(AParent : PWindowsObject; AStyle : LongInt);

Begin
  TWindow.Init(AParent,'');
  with Attr do
  begin
    Style := AStyle;
    X := 110; Y := 100; W := 390; H := 255;
  end;
  hOpenBmp := LoadBitmap(HInstance,id_OpenBmp);
End;

procedure TpicWindow.WMTimer;
Begin
  DeleteObject(hOpenBmp);
  KillTimer(hWindow, timer_ID);
  TWindow.CloseWindow;
End;

function TPicWindow.GetClassName: PChar;
begin
  GetClassName := 'PicWindow';
end;

procedure TPicWindow.GetWindowClass(var AWndClass: TWndClass);
begin
  TWindow.GetWindowClass(AWndClass);
end;

Procedure TPicWindow.Paint(PaintDC : HDC; Var PaintInfo : TPaintStruct);
Var
  OldBitmap : HBitmap;
  MemDC : HDC;
  BitmapSize : TPoint;
  BmpInfo : TBitmap;

Begin
  MemDC := CreateCompatibleDC(PaintDC);
  OldBitmap := SelectObject(MemDC,hOpenBmp);
  GetObject(hOpenBmp,SizeOf(TBitmap),@BmpInfo);
  BitmapSize.x := BmpInfo.bmWidth;
  BitmapSize.y := BmpInfo.bmHeight;
  BitBlt(PaintDC,0,0,BitmapSize.x,BitmapSize.y,MemDC,0,0,srcCopy);
  SelectObject(MemDC,OldBitmap);
  DeleteDC(MemDC);
End;
end.

