
(**********************************************************************)
(* Simple program to demonstrate how to use the FlxKey unit to create *)
(* an encrypted "password" registration-key using one "embedded"      *)
(* encryption-code and one user-entered "password" encryption-code.   *)
(*                                                                    *)
(* NOTE: Before you can compile this program, you must first          *)
(*       compile and run the "RANDCODE.PAS" program to generate       *)
(*       the two "random" encryption-code binary data files. Then     *)
(*       run the "batch" file called "DAT2OBJ.BAT" to convert         *)
(*       these two binary data files to "object" format files.        *)
(**********************************************************************)

program MakeFlxKeyDemo3;
uses
  FlxKey;

type          (* 20 character string definition.                      *)
  st20    = string[20];

              (* 20 character string-pointer definition.              *)
  st20Ptr = ^st20;

var           (* This variable is used to check for errors returned   *)
              (* by CreateFlxKey routine.                             *)
  ErrorCode  : word;

              (* 1 encryption-code string-pointer.                    *)
  Ecode1Ptr   : st20Ptr;

              (* User "password" encryption-code.                     *)
  stPassword : st20;

              (* Full path/filename of the encrypted registration-key *)
              (* file to be created.                                  *)
  RegKeyName  : st79;

              (* This variable is used to pass the user-data to the   *)
              (* CreateFlxKey routine.                                *)
  TempKeyRec : FlxRec;

  {$F+}       (* Declare the following procedure as "FAR".            *)

              (* "Fake" procedure that contains first encryption-code *)
              (* string.                                              *)
  procedure Ecode1Data; external;
  {$L ECODE1.OBJ}

  {$F-}       (* Turn off "FAR" declaration.                          *)

              (* Main program execution block.                        *)
BEGIN
              (* Initialize the encryption-code pointer to it's       *)
              (* string data.                                         *)
  Ecode1ptr := addr(Ecode1Data);

              (* Clear the temporary key-record variable.             *)
  fillchar(TempKeyRec, sizeof(TempKeyRec), 0);

              (* Assign data to temporary key-record.                 *)
  with TempKeyRec do
    begin
              (* 20 char space is available for first-name.           *)
      FirstName := 'John';

              (* 30 char space is available for last-name.            *)
      LastName  := 'Smith';

              (* 30 char space is available for Address1.             *)
      Address1  := '1234 AnyPlace Road,';

              (* 30 char space is available for Address2.             *)
      Address2  := 'BigCity BigPlace,';

              (* 30 char space is available for Address3.             *)
      Address3  := 'BigCountry, BigZip';

              (* 20 char space is available for application-name.     *)
      AppName   := 'Amazing Program';

              (* Version can be assigned any valid word data.         *)
      Version   := 310;

              (* Serial can be assigned any valid longint data.       *)
      Serial    := 1234567890;

              (* Date can be assigned any valid "packed" date/time.   *)
              (* If a value of 0 is assigned to Date, CreateFlxKey    *)
              (* routine will assign the current date/time to this    *)
              (* variable in "packed" date/time format. Use TP's      *)
              (* standard "PackTime" and "UnPackTime" routines to     *)
              (* manipulate this data.                                *)
      Date      := 0;

              (* Access level can be assigned a number from 0..65,535 *)
      Access    := 1234
    end;

              (* Filename for the encrypted registration-key to be    *)
              (* created.                                             *)
  RegKeyName := 'DEMO3.KEY';

              (* Prompt for user "password" encryption-code string.   *)
  writeln;
  write('Enter Password : ');
  readln(stPassword);

              (* Create encrypted registration-key using the data     *)
              (* assigned to TempKeyRec.                              *)
  CreateFlxKey(TempKeyRec, Ecode1Ptr^, stPassword, RegKeyName, ErrorCode);

              (* Move cursor down one line.                           *)
  writeln;

              (* Check for errors.                                    *)
  case (ErrorCode AND $FF) of
     0 : writeln(' Sucessful key creation! No errors.');
     1 : writeln(' Error! One or more encryption-codes are blank.');
     2 : writeln(' Error! Filename for registration-key file is blank.');

              (* I/O error!                                           *)
    16 : begin
           writeln(' I/O error = ', (ErrorCode shr 8));

              (* Standard Turbo Pascal error-codes. See TP manuals,   *)
              (* as there are many types of errors to check for.      *)
           case (ErrorCode shr 8) of
               2 : writeln(' File not found.');
               3 : writeln(' Path not found.');
               4 : writeln(' Too many files open.');
               5 : writeln(' File access denied.');
             101 : writeln(' Disk write error.');
             103 : writeln(' File not open');
             150 : writeln(' Disk is write-protected')
           end  (* case (ErrorCode shr 8) of                          *)
         end
  end         (* case (ErrorCode AND $FF) of                          *)
END.


