#include <windows.h>
#include <string.h>
#include <stdlib.h>
#include "thrdapi.h"

/********************************************************************
 *                     Threads test application                     *
 *                                                                  *
 ********************************************************************
 *       Copyright 1992 Robert Salesas, All Rights Reserved         *
 ********************************************************************
 *       Version: 1.00             Author:  Robert Salesas          *
 *       Date:    30-Jan-1992      Changes: Original                *
 *                                                                  *
 *       Version: 1.00             Author:  Sylvain Tremblay        *
 *       Date:    24-Feb-1992      Changes: Pascal to C convertion  *
 *                                                                  *
 ********************************************************************/

#define APPNAME (LPSTR)"BC++/TC++ Threads"
#define APPFILE "THREADS.EXE"
#define CLASSNAME "Threads"

HANDLE hInst;

FARPROC BallProc,
        LineProc;


/***** Thread functions *****/

VOID FAR PASCAL _export LineThread(PThreadRec Thread,  HWND Wnd, WORD wParam, LONG lParam)
{
  COLORREF Colors[] = { 0x00FF0000,
               0x0000FF00,
               0x000000FF,
               0x00FFFF00,
               0x0000FFFF,
               0x00FF00FF,
               0x00C000C0 };
  HDC DC;
  RECT Rect;
  HPEN Pen,
       OPen;
  int X, Y, ColIndex;
  COLORREF Col;

  GetClientRect(Wnd, &Rect);
  X = random(Rect.right);
  Y = random(Rect.bottom);

  Col = Colors[0];
  Pen = CreatePen(PS_SOLID, 1, Col);

  do {
    DC = GetDC(Wnd);
    if (DC == 0) {
      DeleteObject(Pen);
      ExitThread();
    }

    OPen = SelectObject(DC, Pen);

    GetClientRect(Wnd, &Rect);
    MoveTo(DC, X, Y);
    X = max(0, min(Rect.right, X + random(91) - 45));
    Y = max(0, min(Rect.bottom, Y + random(91) - 45));
    LineTo(DC, X, Y);

    SelectObject(DC, OPen);
    ReleaseDC(Wnd, DC);
  } while (YieldThread() != TM_QUIT);

  DeleteObject(Pen);
  ExitThread();
}


VOID FAR PASCAL _export BallThread(PThreadRec Thread, HWND Wnd, WORD wParam, LONG lParam)
{
  HDC DC;
  RECT Rect;
  int  XDir,
       YDir,
       X, OX,
       Y, OY;
  HICON Ball,
     Erase;

  X = 0;
  Y = 0;
  XDir = 10 + (random(11) - 5);
  YDir = 10 + (random(11) - 5);

  Ball = LoadIcon(hInst, MAKEINTRESOURCE(random(4) + 100));
  Erase = LoadIcon(hInst, "ERASEBALL");

  do {
    DC = GetDC(Wnd);
    if (DC == 0)
     ExitThread();

    GetClientRect(Wnd, &Rect);
    OX = X;
    OY = Y;
    X = X + XDir;
    Y = Y + YDir;

    if (X < 0) {
      X = 0;
      XDir = -(XDir - (random(11) - 5));
      YDir = YDir + (random(11) - 5);
    }
    if (X + 32 > Rect.right) {
      X = Rect.right - 32;
      XDir = -(XDir - (random(11) - 5));
      YDir = YDir + (random(11) - 5);
    }

    if (Y < 0) {
      Y = 0;
      XDir = XDir - (random(11) - 5);
      YDir = -(YDir + (random(11) - 5));
    }
    if (Y + 32 > Rect.bottom) {
      Y = Rect.bottom - 32;
      XDir = XDir + (random(11) - 5);
      YDir = -(YDir + (random(11) - 5));
    }


    if ((XDir <= 0) && (XDir > -6))
     XDir = -6;
    if ((XDir > 0) && (XDir < 6))
     XDir = 6;
    if ((YDir <= 0) && (YDir > -6))
     YDir = -6;
    if ((YDir > 0) && (YDir < 6))
     YDir = 5;
    XDir = max(-20, min(20, XDir));
    YDir = max(-20, min(20, YDir));

    DrawIcon(DC, OX, OY, Erase);
    DrawIcon(DC, X, Y, Ball);
    ReleaseDC(Wnd, DC);

  } while (YieldThread() != TM_QUIT);

  ExitThread();
}


/***** Window function *****/

LONG _export FAR PASCAL MainWndProc(HWND Window, WORD Msg, WORD wParam, DWORD lParam)
{
  char Title[256];
  LONG NumThreads;

  switch (Msg) {
    case WM_CREATE:
      LineProc = MakeProcInstance((FARPROC)LineThread, hInst);
      BallProc = MakeProcInstance((FARPROC)BallThread, hInst);
      break;
    case WM_COMMAND:
      switch(wParam) {
    case 100:
      StartThread(BallProc, 2000, Window, 0, 0);
      NumThreads = GetNumThreads();
      wsprintf(Title, "%s - %d Threads", APPNAME, NumThreads);
      SetWindowText(Window, Title);
      break;
    case 110:
      SetThreadPriority(StartThread((FARPROC)LineProc, 2000, Window, 0, 0), TS_DEFPRIORITY / 2);
      NumThreads = GetNumThreads();
      wsprintf(Title, "%s - %d Threads", APPNAME, NumThreads);
      SetWindowText(Window, Title);
      break;

    case 500:
      InvalidateRect(Window, NULL,TRUE);
      break;
    case 510:
      EndTaskThreads(GetCurrentTask());
      InvalidateRect(Window, NULL,TRUE);
      NumThreads = GetNumThreads();
      wsprintf(Title, "%s - %d Threads", APPNAME, NumThreads);
      SetWindowText(Window, Title);
      break;
     }
    break;

    case WM_DESTROY:
      EndTaskThreads(GetCurrentTask());
      FreeProcInstance(BallProc);
      FreeProcInstance(LineProc);
      PostQuitMessage(0);
      break;

    default:
      return DefWindowProc(Window, Msg, wParam, lParam);
  }
}


int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow)
{
  HWND hWnd;
  MSG msg;
  WNDCLASS wndclass;
  char Title[256];

  if(!hPrevInstance) {
    wndclass.style         = CS_HREDRAW | CS_VREDRAW;
    wndclass.lpfnWndProc   = MainWndProc;
    wndclass.cbClsExtra    = 0;
    wndclass.cbWndExtra    = 0;
    wndclass.hInstance     = 0;
    wndclass.hIcon         = LoadIcon(0, IDI_APPLICATION);
    wndclass.hCursor       = LoadCursor(0, IDC_ARROW);
    wndclass.hbrBackground = GetStockObject(WHITE_BRUSH);
    wndclass.lpszMenuName  = (LPSTR)"APPMENU";
    wndclass.lpszClassName = CLASSNAME;

    if(!RegisterClass(&wndclass)) {
      MessageBox(NULL, "Unable to register window class.", NULL, MB_OK|MB_ICONSTOP);
      return 0;
    }
  }

  hInst = hInstance;

  wsprintf(Title, "%s - 0 Threads", APPNAME);

  hWnd = CreateWindow(CLASSNAME,
                      Title,
                      WS_OVERLAPPEDWINDOW,
                      CW_USEDEFAULT,
                      0,
                      CW_USEDEFAULT,
                      0,
                      0,
                      0,
                      hInstance,
                      NULL);

  ShowWindow(hWnd, nCmdShow);

  while(GetMessage(&msg, NULL, 0, 0)) {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }
  return msg.wParam;
}
