(*
  !---------------------------------------------------------------------------!
  !                                                                           !
  !  ScrollVw/     Version 1.0                                                !
  !                                                                           !
  !  Date Started: 12/02/91     Date Version Completed: 01/22/92              !
  !                                                                           !
  !  Written By:   David D. Cruger/ CopyRight (CR) 1992                       !
  !                CompuServe #72047,2417                                     !
  !                                                                           !
  !  Language:    Turbo Pascal 5.0, 5.5, 6.0                                  !
  !                                                                           !
  !  Requires:    TSR's Made Easy by Turbo Power to recompile.                !
  !                                                                           !
  !  Files Date/Time:   01/22/92  12:00                                       !
  !                                                                           !
  !  See File:    Scrollbk.doc for additional information.                    !
  !                                                                           !
  !  Notes:    This is the main view routine for ScrollBk Version 1.0         !
  !            I have put most of the main functions here in order to         !
  !            conserve on the memory requirements for the TSR.  ScrollBk     !
  !            can view the buffer, it just does not have any buffer          !
  !            management functions.                                          !
  !                                                                           !
  !            There are two commands that are not on the command line when   !
  !            viewing the buffer.                                            !
  !                                                                           !
  !            1) "Ctrl-M" will set the marking function on, this will        !
  !                allow easier marking of large ranges.  As you scroll       !
  !                (arrow up/dn) through the buffer it will mark or           !
  !                unmark what every you scroll over.                         !
  !                                                                           !
  !            2) "C" will display all interrupt counters if ScrollBk is      !
  !                loaded.  This will inform you how many times each          !
  !                interrupt has been called.                                 !
  !                                                                           !
  !---------------------------------------------------------------------------!
*)

  (* A =  align data
     B =  boolean short
     D =  debug on
     E =  emulate 80287
     F =  far calls
     L =  local symbol information
     N =  numeric processing switch
     O =  overlay
     R =  range checking on
     S =  stack-overflow
     V =  var-string checking
  *)

{$a+,b-,d-,e-,f+,l-,n-,o-,r-,s-,v-}                                         {}

{$M 15000,10000,10000}  { Stack, Min/Max heap                                  {}

Program Scrollvw;

uses dos,crt,                (* standard Turbo Pascal units *)
     opinline,opint,optsr;   (* Turbo Power units           *)

const
     TSR_program_name: STRING = 'SCROLLBK';   (* Define TSR name           *)

       ctrl_m=#13+#0;                         (* For Marking               *)
       alt_c=#0+#46;                          (* Clear Log File            *)
       alt_d=#0+#32;                          (* Delete Marked Records     *)
       alt_k=#0+#37;                          (* Keep Marked Records       *)
       alt_l=#0+#38;                          (* Toggle Logging            *)
       alt_s=#0+#31;                          (* Save to Log file          *)
       alt_p=#0+#25;                          (* Print to LPT1             *)
       f2=#0+#60;                             (* Clear all Marked records  *)
       f10=#0+#68;                            (* Unload TSR from memory    *)
       ESC=#27+#0;                            (* ESC/Exit from everything  *)
       SPACE=#32;                             (* SPACE bar/Marking         *)

      (*----------  basic screen keys -----------*)
      home=#0+#71;           uparrow=#0+#72;          pgup=#0+#73;
      eend=#0+#79;         downarrow=#0+#80;          pgdn=#0+#81;
      ctrl_pgup=#0+#132;                              ctrl_pgdn=#0+#118;

type

   st80=string[80];
   st20=string[20];
   st5 =string[05];
   st2 =string[02];

Buffer_Record=Record           (* Basic Record data of 80char *)
      data: st80;              (* and 1 byte to mark record   *)
    marked: boolean;
      end;

Screentype = array[0..4006] of byte;                (* Hold Screen Display             *)

var

prog_ptr       : ifcptr;                           (* pointers to talk with TSR       *)
Regs           : IntRegisters;
OldExitproc    : pointer;                          (* stores pointer to old exit proc *)

ColorScreen    : Screentype absolute $B800:$0000;  (* screen location for mono        *)
MonoScreen     : Screentype absolute $B000:$0000;  (* screen location for color       *)
Hold_Screen    : ^Screentype;                      (* hold screen on heap             *)

log_line       : st80;                             (* holds the line currently on     *)
line1          : Buffer_Record;                    (* display line                    *)
inbuff         : file of Buffer_Record;            (* log file                        *)

log_length     : byte absolute log_line;           (* holds the length of log_line    *)
z              : byte;                             (* dummy interger use for whatever *)

Log_Name,                                          (* file name of buffer log         *)
Buffer_Name,                                       (* file name of buffer save        *)
Path           : st80;                             (* path to program directory       *)

num_on_file,                                       (* total number of lines on file   *)
top,bottom,rec,                                    (* Screen display pointers         *)
middle,span    : longint;                          (* Screen span limits              *)

Is_Log_Open,                                       (* set on if log open              *)
Log_screen_IO,                                     (* the actual screen logging       *)
Hold_Log_Status: boolean;                          (* Hold the status of Screen IO    *)

snum1,snum2    : st5;                              (* for displaying numbers          *)
rs             : st2;                              (* Input from keyboard 2 scancodes *)
file_rec       : searchrec;                        (* Search for ScrollBk.bfr         *)
outp           : text;                             (* Text file for Save/Lpt1         *)

(*------ get kbd strokes ----------*)
function get_kbd_strokes: st2;
begin
  rs[1]:=#0; rs[2]:=#0;
  repeat
    rs[1]:=readkey;
    if (rs[1]=#0) and (keypressed) then rs[2]:=readkey;
  until (rs[1]<>#0) or (rs[2]<>#0);
  get_kbd_strokes:=rs[1]+rs[2];
end; (* end function *)

(*============  buffer left  ============*)
function buffer_left(l:integer; key: st80; ch:char):st80;
var l1: byte absolute key;
begin

(* l = # of pos to buf left *)
if l1<l then
 repeat  key:=key+ch; until l1>=l;
 buffer_left:=key;

(* buffer text left fill right with char *)

end; (* end procedure *)

(*===========  charfill  ====================*)
function charfill(l1:integer; ch:char): st80;
var  key: st80; l: byte absolute key;
begin

key:='';
  if l1>0 then
   for l:=1 to l1 do key[l]:=ch;
charfill:=key;

end; (* end function *)

(*------ replace chars in a string ----------*)
function replace(key: st80; ch1,ch2: char): st80;
var l: byte absolute key;  z: byte;
begin

if l>0 then
 for z:=1 to l do
   if key[z]=ch1 then key[z]:=ch2;

replace:=key;

end; (* end function *)

(*=========  save screen ================*)
Procedure Savescreen(var screen:screentype);
begin

  case lastmode of                       (* based on lastmode/get screen   *)
       bw40 : move(colorscreen,screen,2000);
       co40 : move(colorscreen,screen,2000);
       bw80 : move(colorscreen,screen,4000);
       co80 : move(colorscreen,screen,4000);
       mono : move(monoscreen,screen,4000);
  end; (* case *)

  screen[4000]:=lo(windmin)+1;           (* 4000-4003 are window cords     *)
  screen[4001]:=hi(windmin)+1;
  screen[4002]:=lo(windmax)+1;
  screen[4003]:=hi(windmax)+1;
  screen[4004]:=textattr;                (* 4004 is current text attribute *)
  screen[4005]:=wherex;                  (* 4005-4006 are cursor cords     *)
  screen[4006]:=wherey;

end; (* end procedure *)

(*=========  restore screen  =============*)
Procedure RestoreScreen(var screen:screentype);
begin

  case lastmode of                       (* based on lastmode/restore scrn *)
       bw40 : move(screen,colorscreen,2000);
       co40 : move(screen,colorscreen,2000);
       bw80 : move(screen,colorscreen,4000);
       co80 : move(screen,colorscreen,4000);
       mono : move(screen,monoscreen,4000);
    end; (* case *)

  window(screen[4000],                   (* 4000-4003 are window cords     *)
         screen[4001],
         screen[4002],
         screen[4003]);

  textattr:=screen[4004];                (* 4004 is current text attribute *)
  gotoxy(screen[4005],screen[4006]);     (* 4005-4006 are cursor cords     *)

end; (* end procedure *)

(*------------  clr window ------------*)
procedure clr_window(x,y,x1,y1:byte);
var a,b,a1,b1,px,py: byte;  (* save old window cord *)
begin

   a:=lo(windmin)+1;    (* hold window cords *)
   b:=hi(windmin)+1;
  a1:=lo(windmax)+1;
  b1:=hi(windmax)+1;
  px:=wherex;
  py:=wherey;

  window(x,y,x1,y1);    (* set window        *)
  clrscr;               (* clr window        *)
  window(a,b,a1,b1);    (* reset window      *)
  gotoxy(px,py);        (* goto cursor pos   *)

end; (* end procedure *)

(*--------->>>>  write direct to video buffer  <<<-----------*)
procedure writed(key:st80; x,y: integer);
var n,x1: integer; l: byte absolute key;  (* length of key *)
begin

(* find location in video buffer *)
n:=(x*2)+(y*160)-162;
if odd(n) then inc(n); (* just to be sure *)

(*   check video mode for 40char  *)
  case lastmode of
       bw40 : n:=n div 2;
       co40 : n:=n div 2;
   end; (* case *)

(*  change characters color attribute  *)

x1:=0; (* reset *)
repeat  inc(x1);

     if lastmode=mono then
          memw[$b000:n]:=(textattr shl 8)+ord(key[x1])        (* mono   *)
     else
          memw[$b800:n]:=(textattr shl 8)+ord(key[x1]);       (* color  *)

    inc(n,2); (* push buffer *)

until (x1>=l);

end; (* end procedure *)

(*-----  write center direct  --------------*)
procedure writecd(key:st80; x,y: integer);
var l: byte absolute key;
begin

x:=x-(l DIV 2);  (* center off x *)
if l>0 then (* this will wrap around if it goes off the screen *)
  if (y>0) and (y<26) then writed(key,x,y);

end; (* end procedure *)

(*============  setcolors ============*)
procedure setcolors(bground,fground: byte);
begin
       textbackground(bground); textcolor(fground);
end; (* end procedure *)

(*-------->>> box <<<----------------------*)
procedure box_frame(a,b,a1,b1:byte);
var c: byte;
begin

writed(#201+charfill((a1-a-1),#205)+#187,a,b);
      for c:=b+1 to b1-1 do
         begin
            writed(#186,a,c);  writed(#186,a1,c);
         end;
writed(#200+charfill((a1-a-1),#205)+#188,a,b1);

end;  (* box fram  *)

(*-------  are you sure -------------*)
function are_you_sure(key:st20): boolean;
begin

setcolors(red,white);
box_frame(29,8,51,10);
clr_window(30,9,50,9);
writecd(' Are You Sure Y/N ',40,9);

setcolors(blue,white);
writed(key,31,8);  gotoxy(1,span);

rs:=#0+#0;
repeat   rs:=get_kbd_strokes;
until (upcase(rs[1])='Y') or (upcase(rs[1])='N') or (rs=ESC);

if upcase(rs[1])='Y' then are_you_sure:=true
                     else are_you_sure:=false;

 rs:=#0+#0; (* reset *)

end; (* end function *)

(*------  scrollbk exit routine ------------*)
{$f+} (* set far call on   *)
Procedure ScrollBk_Exit_Routine;
begin

 Exitproc:=Oldexitproc;             (* restore old exit procedure     *)
 dispose(hold_screen);              (* dispose on heap / hold screen  *)

end; (* end procedure *)
{$f-} (* turn off far call *)

(*==========================================================================*)
(*================== BASIC BUFFER  AND SCREEN DISPLAY  =====================*)
(*==========================================================================*)

(*----- error msg ---------*)
function error_msg(ioerror: word; msg: st80): boolean;
begin
  if ioerror<>0 then
    begin
        writeln(msg+' I/O : ',ioerror);  error_msg:=true;
        delay(1000); (* pause *)
    end else error_msg:=false;

end; (* end function *)

(*---  open_buffer_log_file --------*)
procedure open_buffer_log_file;
begin

if NOT Is_log_Open then (* lets open it *)
  begin

    {$i-} (* turn off io log *)
    reset(inbuff);

    if ioresult<>0 then (* else create it *)
      begin
        rewrite(inbuff);
        if NOT error_msg(ioresult,'ERROR [SCROLLBK] during log create'+#7) then
         begin
         line1.data:=charfill(80,' ');
         line1.marked:=false;
         write(inbuff,line1); (* burn zero record *)
         Is_Log_Open:=true;
         end; (* if not error *)
      end; (* ioresult<>0 *)

    Is_Log_Open:=true;
    seek(inbuff,filesize(inbuff)); (* last record *)

  end; (* if open *)

 num_on_file:=filesize(inbuff)-1;

end; (* end procedure *)

(*---- close log file ------*)
procedure close_log_file;
begin

if Is_Log_Open then
{$i-} close(inbuff);
Is_Log_Open:=false;

end; (* end procedure *)

(*------ display action message ---------*)
procedure display_action_message(msg: st80);
begin
  setcolors(white,black);
  writed(charfill(80,' '),1,25);
  writed(msg,1,25);
end; (* end procedure *)

(*------ save log file to ascii ----------*)
procedure save_log_file_to_ascii;
var num: longint;
begin

Buffer_Name:=path+'scrollbk.dmp';

(*-- error checking is week (very) here -----*)
{$i-} (* turn io checking off *)
assign(outp,Buffer_Name);
rewrite(outp); (* create *)

if NOT error_msg(ioresult,'ERROR Creating Log dump: '+Buffer_Name+#7) then
  begin

    num:=0;
    repeat inc(num);
        seek(inbuff,num); read(inbuff,line1);
        if error_msg(ioresult,'ERROR Reading log '+#7) then exit;
        if line1.marked then
          begin
            writeln(outp,line1.data);
            if error_msg(ioresult,'ERROR writing Log dump'+#7) then rs:=esc+#0;
           end; (* if marked *)
       if keypressed then rs:=get_kbd_strokes;
    until (rs[1]=esc) or (num>=num_on_file);

  close(outp);

  if error_msg(ioresult,'ERROR Closing Log dump: '+Buffer_Name+#7) then delay(1000);

 end; (* error creating *)

delay(1000);  rs:=#0+#0;

end; (* end procedure *)

(*------ print log file to lpt1 ----------*)
procedure print_log_file_to_lpt1;
var num: longint;
begin

Buffer_Name:='LPT1';

{$i-} (* turn io checking off *)
assign(outp,Buffer_Name);
rewrite(outp); (* create *)
if NOT error_msg(ioresult,'ERROR Openning LPT1'+#7) then
  begin

    num:=0;
    repeat inc(num);
         seek(inbuff,num); read(inbuff,line1);
         if error_msg(ioresult,'ERROR Reading Log'+#7) then exit;
         if line1.marked then
           begin
             writeln(outp,line1.data);
             if error_msg(ioresult,'ERROR Writing LPT1'+#7) then rs:=esc+#0;
            end; (* if marked *)
         if keypressed then rs:=get_kbd_strokes;
     until (rs[1]=esc) or (num>=num_on_file);

   close(outp);
   if error_msg(ioresult,'ERROR Closing LPT1'+#7) then exit

   end; (* error creating *)

 delay(1000);

end; (* end procedure *)

(*--- display scrollbk headers ----------*)
procedure display_scrollbk_headers(clear: boolean);
begin

setcolors(black,white); window(1,1,80,25);
if clear then clrscr;  setcolors(white,black);
writed(buffer_left(67,' ScrollVw/ CopyRight(CR) 1991/ David D. Cruger/ Ver 1.0/ 12/02/91',' '),1,1);
writed(buffer_left(77,' Alt-(C/lr, D/el, K/eep, L/og, P/rnt, S/ave), SPACE/Mrk, '+#24+#25+', F2/ClrMrks, ESC',' '),1,25);
setcolors(black,white); window(1,2,80,24);

end; (* end procedure *)

(*--- clear all marked records -------*)
procedure clear_all_marked_records;
var z,cleared: longint;
begin
  z:=0;  cleared:=0;
  repeat inc(z);
     seek(inbuff,z); read(inbuff,line1);
     if error_msg(ioresult,'ERROR Reading Mark Clear'+#7) then rs:=esc+#0;

     if line1.marked then
       begin
          line1.marked:=false; inc(cleared);
          seek(inbuff,z); write(inbuff,line1);
          if error_msg(ioresult,'ERROR Reading Writing Clear'+#7) then rs:=esc+#0;
       end; (* if marked *)

    (*---- display record number -------*)
    str(z:5,snum1); str(cleared:5,snum2);
    snum1:=replace(snum1,' ','0');
    snum2:=replace(snum2,' ','0');
    writed('Reading: '+snum1+'  Cleared: '+snum2,40,25);

   if keypressed then rs:=get_kbd_strokes;

  until (z>=num_on_file) or (rs[1]=esc);
  rs:=#0+#0;

end; (* end procedure *)

(*--- process_marked records from log -------*)
procedure process_marked_records_from_log(delete_marked: boolean);
var z,deleted: longint;  outtmp: file of Buffer_Record;
begin

{$i-} (* turn off io checking *)
assign(outtmp,path+'XXXXXXXX.BFR');
rewrite(outtmp);
if NOT error_msg(ioresult,'ERROR Creating Temp Log'+#7) then
  begin

  setcolors(white,black); deleted:=0; z:=-1;  (* copy over record zero *)
  repeat inc(z);
     seek(inbuff,z); read(inbuff,line1);
     if error_msg(ioresult,'ERROR Reading Log'+#7) then rs:=esc+#0;

     if ((delete_marked) and (NOT line1.marked)) or   (* Deleting Marked *)
        ((NOT delete_marked) and (line1.marked)) then (* Keep Marked     *)
       begin
          line1.marked:=false;  (* reset marks *)
          write(outtmp,line1);
          if error_msg(ioresult,'ERROR Writing Temp Log'+#7) then rs:=esc+#0;
       end else inc(deleted); (* if marked *)

    (*---- display record number -------*)
    str(z:5,snum1); str(deleted:5,snum2);
    snum1:=replace(snum1,' ','0');
    snum2:=replace(snum2,' ','0');
    writed('Reading: '+snum1+'  Deleted: '+snum2,40,25);

    if keypressed then rs:=get_kbd_strokes;

  until (z>=num_on_file) or (rs[1]=esc);

  close(outtmp); setcolors(black,white);
  if error_msg(ioresult,'ERROR Close Temp Log'+#7) then rs:=esc+#0;
  rs:=#0+#0;

  if rs[1]<>esc then
    begin
      close_log_file;                           (* close log file             *)
      if error_msg(ioresult,'ERROR Close Main Log'+#7) then rs:=esc+#0;
      erase(inbuff);              (* delete old log file      *)
      if error_msg(ioresult,'ERROR Erase Main Log'+#7) then rs:=esc+#0;
      rename(outtmp,Log_Name);    (* rename new log file      *)
      if error_msg(ioresult,'ERROR Rename Temp Log'+#7) then rs:=esc+#0;
      open_buffer_log_file;       (* now reopen new log file  *)
    end else
    begin
       erase(outtmp);             (* else delete new log file *)
       rs:=esc+#0;              (* cancel                   *)
    end;

 end; (* error creating *)

end; (* end procedure *)

(*--- check top bottom file pointers -------*)
procedure check_top_bottom_file_pointers;
begin

 if top<=0 then
   begin
     bottom:=span;
       top:=1;
         bottom:=span;
           middle:=1;
             rec:=1;
   end; (* top<0 *)

 if bottom>num_on_file then
   begin
     top:=num_on_file-span+1;
       bottom:=num_on_file;
         middle:=span;
           rec:=num_on_file;
   end; (* bottom>num on file *)

end; (* end procedure *)

(*---- figure all file pointers --------*)
procedure figure_all_file_pointers;
begin

if num_on_file<23 then span:=num_on_file
                   else  span:=23;  (* this sets screen span        *)

 bottom:=num_on_file;           (* always start at bottom       *)
 top:=bottom-span+1;            (* set top marker               *)
 rec:=bottom;                   (* set current display rec      *)
 middle:=span;                  (* current or middle position   *)

end; (* end procedure *)

(*------ redisplay scrollbk page ----------*)
procedure redisplay_scrollbk_page(t,b: longint);
var z,y: longint;
begin

  setcolors(black,white);
  y:=1;                                (* set starting position           *)
  for z:=t to b do
    begin inc(y); (* next position *)
      seek(inbuff,z); read(inbuff,line1);    (* set next record                 *)
      if error_msg(ioresult,'ERROR Reading log'+#7) then rs:=esc+#0;
      if line1.marked then setcolors(white,blue) else setcolors(black,white);
      writed(line1.data,1,y);          (* write directory to video memory *)
      setcolors(black,white);
    end; (* z *)
end; (* end procedure *)

(*------ view scrollbk buffer -------------*)
procedure view_scrollbk_buffer;
var  Marking_ON: boolean;
begin

  rs:=PgDn;   Marking_ON:=false;  (* preset                     *)

  repeat (* until esc *)
    if (rs=PgUp) or
       (rs=PgDn) or
       (rs=Ctrl_PgDn) or
       (rs=Ctrl_PgUp) or
       (rs=Eend) or
       (rs=Home) then redisplay_scrollbk_page(top,bottom);

       rs:=#0+#0; (* preset *)
       rec:=top+middle-1; (* set record *)

       (*---- display record number -------*)
       str(rec:5,snum1); str(num_on_file:5,snum2);
       snum1:=replace(snum1,' ','0');
       snum2:=replace(snum2,' ','0');
       line1.data:=' '+snum1+'/'+snum2+' ';
       setcolors(blue,white); writed(line1.data,68,1);

       (*----- display logging status ----*)
       case hold_log_status of
         true:begin
                setcolors(red,white); writed('ON ',78,25);
              end;
        false:begin
                setcolors(blue,white); writed('OFF',78,25);
              end;
           end; (* case *)

       seek(inbuff,rec); read(inbuff,line1); (* set next record *)
       setcolors(red,white);
       writed(line1.data,1,1+middle);           (* display line hightlight    *)
       gotoxy(1,span);                          (* cursor position            *)

       rs:=get_kbd_strokes;                     (* two scan codes             *)

      if rs=ctrl_m then  (* set marking on *)
        begin
          case Marking_ON of
            true:begin
                   Marking_ON:=false;
                   setcolors(white,black);
                   writed('SPACE/Mrk,',47,25);
                 end;
           false:begin
                   Marking_ON:=true;
                   setcolors(red,white);
                   writed('MARKING:ON',47,25);
                   setcolors(black,white);
                 end;
             end;
        end; (* ctrl_m *)

      if (rs[1]=SPACE) or
         ((Marking_ON) and
         ((rs=downarrow) or (rs=uparrow))) then (* toggle marking *)
         begin
           case line1.marked of
              true:line1.marked:=false;
             false:line1.marked:=true;
                end;
             seek(inbuff,rec); write(inbuff,line1);
             if ioresult<>0 then write('ERROR during Write',#7);
         end; (* SPACE *)

       if (rs=uparrow) or (rs=downarrow) then   (* blank line                 *)
         begin
           if line1.marked then setcolors(white,blue) else setcolors(black,white);
           writed(line1.data,1,1+middle);       (* display line no hightlight *)
           setcolors(black,white);
          end;

       if rs=downarrow then
         begin
           if rec<num_on_file then inc(middle);
           if middle>span then
             begin
               middle:=span;  inc(top); inc(bottom);
               check_top_bottom_file_pointers;
               gotoxy(79,span); writeln; (* kick a blank line/scroll up *)
             end; (* if middle>span *)
         end; (* downarrow *)

       if rs=uparrow then
         begin
           if rec>1 then dec(middle);
           if middle<1 then
             begin
               middle:=1; dec(top); dec(bottom);
               check_top_bottom_file_pointers;
               gotoxy(1,1); insline;  (* kick a blank line/scroll down *)
             end; (* if middle<1 *)
         end; (* uparrow   *)

       if rs=pgup then
         begin
            dec(top,span); dec(bottom,span);
            check_top_bottom_file_pointers;
         end; (* page up *)

       if rs=pgdn then
         begin
            inc(top,span); inc(bottom,span);
            check_top_bottom_file_pointers;
         end; (* page down *)

       if rs=ctrl_pgup then
         begin
            dec(top,span*4); dec(bottom,span*4);
            check_top_bottom_file_pointers;
         end; (* ctrl (4) page up *)

       if rs=ctrl_pgdn then
         begin
            inc(top,span*4); inc(bottom,span*4);
            check_top_bottom_file_pointers;
         end; (* ctrl (4) page down *)

       if rs=Home then
         begin
            top:=1; bottom:=span; middle:=1; rec:=1;
            check_top_bottom_file_pointers;
         end; (* home *)

       if rs=Eend then
         begin
            bottom:=num_on_file; top:=bottom-span+1; middle:=span;
            check_top_bottom_file_pointers;
         end; (* eend *)

      if upcase(rs[1])='C' then  (* Interrupt counters *)
        begin
          prog_ptr:=moduleptrbyname(TSR_program_name);
          if prog_ptr<>nil then  (* check to see if program is resident *)
            begin
               (*
               right here will need to check and call TSR to flush/close log
               and to disable logging if needed..this also disables the popups.
               *)
               Regs.AH:=Ord('C');    (* Display Interrupt Counters *)
               EmulateInt(regs,prog_ptr^.CmdEntryPtr);
               rs:=#0+#0;
               redisplay_scrollbk_page(top,bottom);
            end; (* <> nil *)
        end; (* T *)

      if rs=alt_c then (* clear log file *)
        begin
          if are_you_sure(' Clear (Del) Log ') then
            begin
              display_action_message('Deleting SCROLLBK.BFR file');
              close_log_file;               (* close log file   *)
              erase(inbuff);                (* erase file       *)
              open_buffer_log_file;
              top:=1; bottom:=1; middle:=1; span:=1; rec:=1;
              display_scrollbk_headers(false);
              rs:=#27+#0; (* lets get out of here/nothing to view *)
            end else redisplay_scrollbk_page(top,bottom); (* are you sure *)
        end; (* alt_c *)

      if rs=alt_d then  (* delete marked records *)
        begin
          if are_you_sure('Delete Marked') then
            begin
              display_action_message('Deleting all MARKED records');
              process_marked_records_from_log(true);
              if rs[1]<>esc then
              figure_all_file_pointers;      (* set view file pointers       *)
              check_top_bottom_file_pointers;
              display_scrollbk_headers(false);
              rs:=#0+#0;
            end; (* are you sure *)
          redisplay_scrollbk_page(top,bottom);
        end; (* alt_d *)

      if rs=alt_k then  (* keep marked records *)
        begin
          if are_you_sure('Keep Marked') then
            begin
              display_action_message('Keeping all MARKED records');
              process_marked_records_from_log(false);
              if rs[1]<>esc then
              figure_all_file_pointers;      (* set view file pointers       *)
              check_top_bottom_file_pointers;
              display_scrollbk_headers(false);
              rs:=#0+#0;
            end; (* are you sure *)
          redisplay_scrollbk_page(top,bottom)
        end; (* alt_k *)

      if rs=alt_l then (* toggle logging *)
        begin
           case hold_log_status of
               true:begin
                      hold_log_status:=false;
                      if prog_ptr<>nil then  (* check to see if program is resident *)
                        begin
                          Regs.AH:=Ord('L');    (* logging function   *)
                          Regs.AH:=Ord('1');    (* 1=off              *)
                          EmulateInt(regs,prog_ptr^.CmdEntryPtr);
                        end; (* if program resident *)
                    end;  (* true *)
              false:begin
                      hold_log_status:=true;
                      if prog_ptr<>nil then  (* check to see if program is resident *)
                        begin
                          Regs.AH:=Ord('L');    (* logging function   *)
                          Regs.AH:=Ord('0');    (* 1=on               *)
                          EmulateInt(regs,prog_ptr^.CmdEntryPtr);
                        end; (* if program resident *)
                    end; (* false *)
                 end; (* case *)
        end; (* alt_l *)

      if rs=alt_s then (* save to log file *)
        begin
          if are_you_sure('Save Marked') then
            begin
              display_action_message('Saving Marked Records : '+path+'SCROLLBK.DMP');
              save_log_file_to_ascii;
              display_scrollbk_headers(false);
              rs:=#0+#0;
            end; (* are you sure *)
          redisplay_scrollbk_page(top,bottom)
        end; (* alt_s *)

      if rs=alt_p then (* print log file *)
        begin
          if are_you_sure('Print Marked') then
            begin
              display_action_message('Printing Marked Records : LPT1');
              print_log_file_to_lpt1;
              display_scrollbk_headers(false);
              rs:=#0+#0;
            end; (* are you sure *)
          redisplay_scrollbk_page(top,bottom)
        end; (* alt_p *)

      if rs=f2 then
        begin
          if are_you_sure('Clear Marks') then
            begin
              display_action_message('Clearing all Marked records');
              clear_all_marked_records;
              display_scrollbk_headers(false);
              rs:=#0+#0;
            end; (* are you sure *)
          redisplay_scrollbk_page(top,bottom)
        end; (* f2 *)

  until rs=ESC;  (* repeat until rs=ESC *)

end; (* end procedure *)

(*--------  Main POP UP procedure ------------*)
procedure Main_VIEW_Procedure;
begin

(*
 Options:
    AH='C' Display Interrupt Counters
    AH='F' Flush buffer and close file
    AH='G' Get logging status
         AL=1 logging is off
         AL=0 logging if on
    AH='L'
      subfunction
        AL='1' then turn logging off
        AL='0' then turn logging on
    AH='U' Unload TSR
*)

savescreen(hold_screen^);          (* save current screen          *)
log_screen_IO:=false;              (* preset                       *)
Is_Log_Open:=false;                (* preset                       *)

prog_ptr:=moduleptrbyname(TSR_program_name);
if prog_ptr<>nil then  (* check to see if program is resident *)
 begin

   (*
   right here will need to check and call TSR to flush/close log
   and to disable logging if needed..this also disables the popups.
   *)

   Regs.AH:=Ord('G');    (* get logging status *)
   EmulateInt(regs,prog_ptr^.CmdEntryPtr);
   if Regs.AL=0 then log_screen_IO:=true;
   if Regs.AL=1 then log_screen_IO:=false;

   Regs.AH:=Ord('L');    (* logging function    *)
   Regs.AL:=Ord('1');    (* 1=off               *)
   EmulateInt(regs,prog_ptr^.CmdEntryPtr);

   Regs.AH:=Ord('F');    (* open/flush buffer/close *)
   EmulateInt(regs,prog_ptr^.CmdEntryPtr);

 end; (* <>nil *)

   hold_log_status:=log_screen_IO; (* save logging status          *)
   open_buffer_log_file;           (* now open insures all writes  *)

   figure_all_file_pointers;       (* set view file pointers       *)
   display_scrollbk_headers(true); (* create display window        *)
   view_scrollbk_buffer;           (* view the buffer file         *)
   close_log_file;                 (* close log file               *)

prog_ptr:=moduleptrbyname(TSR_program_name);
if prog_ptr<>nil then  (* check to see if program is resident *)
 begin

   (*  No need to reopen..scrollbk will reopen when needed.
       Right here will need to check and call TSR to open log
       and to reinstall logging and popups if needed.
   *)

   Regs.AH:=Ord('L');    (* logging function    *)
   Regs.AL:=Ord('0');    (* 0=on                *)
   EmulateInt(regs,prog_ptr^.CmdEntryPtr);

 end; (* if <> nil *)

restorescreen(hold_screen^);       (* restore current screen       *)

end; (* end procedure *)

(*--------  main program ---------*)
begin

Filemode:=$42;                       (* set everything free for all       *)
{$i-}                                (* turnn off iochecking              *)

OldExitProc:=ExitProc;               (* Save old exit procedure           *)
ExitProc:=@ScrollBk_Exit_Routine;    (* Set our exit routine in place     *)
getdir(0,path); path:=path+'\';      (* get current directory             *)
Log_Name:=path+'scrollbk.bfr';       (* set buffer name (disk)            *)
assign(inbuff,Log_Name);             (* assign file handle file name      *)
new(hold_screen);                    (* create on heap / hold screen      *)
line1.data:=''; log_line:='';        (* preset                            *)

if not moduleinstalled(TSR_program_name) then
  begin
       setcolors(black,white); clrscr;
       writeln('ScrollBk 1.0 is NOT installed....................................');
       writeln('(c) Copyright 1991. by David D. Cruger...........................',#7);
       delay(1000);
  end;

savescreen(hold_screen^);            (* save users screen                 *)

        Main_View_Procedure;         (* this is the main program          *)

restorescreen(hold_screen^);         (* save users screen                 *)

end. (* end of program *)
