PROCEDURE ShowDriveError;
 var ans : char;
 begin
  if DriveError <> 0 then
  begin
   writeln('Error ',DriveError,' detected in UpdateDrives procedure: ');
   if ((DriveError and 01) <> 0) then
      writeln('Wrong DOS version (must be 3.0 or higher)');
   if ((DriveError and 02) <> 0) then
      writeln('Not enough memory to create DRIVES^');
   if ((DriveError and 04) <> 0) then
      writeln('Function 52h returns NULL pointer');
   if ((DriveError and 08) <> 0) then
      writeln('Inconsistency in undocumented function (joined drives)');

   if ((DriveError and 16) <> 0) then
      writeln('Unknown error');

   if ((DriveError and 32) <> 0) then
      writeln('Number of drives exceeds 32');
   if ((DriveError and 64) <> 0) then
      writeln('Inconsistency in undocumented function (network drives)');
   if ((DriveError and 128) <> 0) then
      writeln('$440E failed, bit 6 of device driver attribute set');
   if ((DriveError and 256) <> 0) then
      writeln('INT13 F08h failed for known AT class processor');
   if ((DriveError and 512) <> 0) then
      writeln('INT13 F08h returned 0 in register BL for unknown reasons');
   if ((DriveError and 1024) <> 0) then
      writeln('INT13 F08h returned out-of-range value in register BL');
   if ((DriveError and 2048) <> 0) then
      writeln('$4408 failed, bit 11 of device driver attribute set');
   if ((DriveError and 4096) <> 0) then
      writeln('$440D failed, bit 6 of device driver attribute set');
   if ((DriveError and 8192) <> 0) then
      writeln('Mismatched drive numbers');
   if ((DriveError and 16384) <> 0) then
      writeln('Error counting units in device driver');
   if ((DriveError and 32768) <> 0) then
      writeln('Total devices > 32');
   if ((DriveError and 65536) <> 0) then
      writeln('Totaldevices <> NumBlockDevs');
   if ((DriveError and 131072) <> 0) then
      writeln('Error getting NetWare drive map table');
   if ((DriveError and 262144) <> 0) then
      writeln('DevicesperDriver <> CountDrives');
   if ((DriveError and 524288) <> 0) then
      writeln('J <> numlogicaldrives');
   if ((DriveError and 1048576) <> 0) then
      writeln('Device driver address not found');
   writeln;
   write('Press ''C'' to continue, anything else to quit. ');
   readln(ans);
   if (ans <> 'C') and (ans <> 'c') then halt;
  end;
 end;


function cursorline : byte;
var regs : registers;
begin
  regs.ax := $0F00;
  Intr($10,regs);
  regs.ax := $0300;
  Intr($10,regs);
  cursorline := regs.dh + 1;
end;

procedure writehex(bt : byte);
const
  hexdigits : array[0..15] of char = '0123456789ABCDEF';
var
  bz : byte;
begin
  bz := bt and $0F;
  bt := bt shr 4;
  write(hexdigits[bt],hexdigits[bz]);
end;

procedure positioncursor;
begin
  if cursorline >= 21 then
  begin
    gotoxy(1,24);
    write('==> Press ENTER to continue ');
    readln;
    clrscr;
    writeln;
  end;
end;


procedure openingscreen;
begin
  textcolor(white);
  writeln('DRVDEMO - DRIVExx Demo Program, Copyright (C) 1991, 1992 by NativSoft Computing');
  textcolor(lightgray);
  window(1,2,80,25);
  writeln;

  write(  'Operating System..............................: ');
  if DRDOS then write('DR DOS') else write('MS DOS');
  writeln(' version ',DOSVER:4:2);
  writeln('BIOS Date.....................................: ',BiosDateString);
  write(  'Processor Type................................: ');
  case ProcessorType of
    1 : writeln('8088/8086');
    2 : writeln('80286');
    3 : writeln('80386');
   -3 : writeln('80386SX');
    4 : writeln('80486');
    else writeln('Unknown (',ProcessorType,')');
  end; {case}
  write('Machine ID....................................: ');writehex(MachineID);
    writeln;
  write('Device Driver Chain...........................: ');
    if DevDrvrChainValid then write('Valid') else writeln('Invalid');

  writeln;
  writeln('Valid Logical Drives..........................: ',alllogicaldrives);
  writeln('Bootable Drives...............................: ',bootabledrives);
  writeln;
  writeln('Number of BIOS-driven Internal Floppies.......: ',Internalfloppies);
  writeln('Valid Floppy Drives...........................: ',floppies);
  writeln;
  writeln('Number of Hard Disks Installed................: ',PhysicalFixed);
  writeln('Valid Hard Disk Partitions....................: ',hards);
  writeln;
  if (not NetWareLoaded) then
  writeln('Current default drive and path................: ',CurrentDir(defaultdrive));

  gotoxy(1,24);
  textcolor(white);
  write('Press ENTER to see individual drive characteristics ...');
  textcolor(lightgray);
  readln;clrscr;
end; {openingscreen}


procedure showdpbdata(D : fakedpb);
begin
  with D do 
  begin
    writeln;
    writeln('Unit number within device driver : ',ddunitnum);
    writeln('                Bytes per Sector : ',bytespersex);
    writeln('             Sectors per Cluster : ',sexperclust);
    writeln;
    writeln('                  Number of FATs : ',numFATS);
    writeln('                 Sectors per FAT : ',sexperFAT);
    writeln('                First FAT sector : ',FATStart);
    writeln('Number of root directory entries : ',RootdirEnts);
    writeln('     First root directory sector : ',rootstart);
    writeln('      Sectors per root directory : ',RootdirSex);
    writeln;
    writeln('       First data sector on disk : ',FirstDataSec);
    writeln(' Number of data clusters on disk : ',TotDataclusts);
    writeln('             Number of cylinders : ',cylinders);
    writeln;
    writeln('           Media descriptor byte : ',mediabyte);
    write  ('                     Access flag : ',accessflag);
    if accessflag <> 0 then writeln('  (NOT ACCESSED SINCE BOOTUP)')
                      else writeln;
    writeln('                  DPB data valid : ',dpbdatavalid);
    writeln;
  end;
end;

