
{program to create a Font TSR from FNTIMG.DAT file}
{writen by Michael Day as of 12/02/92 - public domain}

program MAKETSR;

const iname = 'FNTIMG.DAT';    {name of the new font file}
      oname = 'BITFONT.COM';   {name of the resulting COM file}

var f : file;
    Font : array[0..$800] of byte;
    Empty : array[0..256] of byte;
    err : word;

const Header : array[0..63] of byte = (
                 {highcode  equ 1000h     ;temp working code location }
                 {lowcode   equ 0080h     ;font table final location  }
                 {FontTable equ 200h      ;font table current location}
                 {TableEnd  equ 0800h+80h ;end of font table in memory}
                 {      org 100h          ;will be a COM type program }
                 {begin:                                              }
$0E,             {  push cs                                           }
$1F,             {  pop ds                                            }
$BE,$10,$01,     {  mov si,start      ;move the working code          }
$BF,$00,$10,     {  mov di,highcode   ;to high memory                 }
$B9,$31,$00,     {  mov cx,length                                     }
$F3,             {  rep                                               }
$A4,             {  movsb                                             }
$E9,$F0,$0E,     {  jmp highcode      ;then go there to run it        }
                 {                                                    }
                 {start:                                              }
$8E,$06,$2C,$00, {  mov es,[2Ch]      ;release the enviornment        }
$B4,$49,         {  mov ah,49h        ;we don't need it               }
$CD,$21,         {  int 21h                                           }
                 {                                                    }
$0E,             {  push cs                                           }
$07,             {  pop es                                            }
$BE,$00,$02,     {  mov si,FontTable  ;move the font table down       }
$BF,$80,$00,     {  mov di,lowcode    ;to low mem to save memory      }
$B9,$00,$08,     {  mov cx,0800h                                      }
$F3,             {  rep                                               }
$A4,             {  movsb                                             }
                 {                                                    }
$33,$C0,         {  xor ax,ax                                         }
$8E,$C0,         {  mov es,ax                                         }
$BB,$7C,$00,     {  mov bx,1fh*4                                      }
$B8,$00,$04,     {  mov ax,0400h      ;point the vector offset        }
$26,             {  seg es            ;at upper font start adr        }
$89,$07,         {  mov [bx],ax                                       }
$8C,$C8,         {  mov ax,cs         ;point the vector segment       }
$05,$08,$00,     {  add ax,8          ;at font table start            }
$26,             {  seg es                                            }
$89,$47,$02,     {  mov [bx+2],ax                                     }
                 {                                                    }
$BA,$81,$08,     {  mov dx,TableEnd+1 ;terminate this program         }
$CD,$27          {  int 27h           ;but leave it allocated         }
                 {stop:               ;in memory                      }
                 {                                                    }
                 {length equ stop-start+1                             }
      );

{$I-}
begin
   fillchar(empty,sizeof(empty),0);
   assign(f,iname);
   reset(f,1);
   blockread(f,font,sizeof(font),err);
   if IOresult <> 0 then
     writeln('Error could not read font file: ',iname);
   close(f);
   assign(f,oname);
   rewrite(f,1);
   blockwrite(f,header,sizeof(header));
   blockwrite(f,empty,$100-sizeof(header));
   blockwrite(f,font,sizeof(font));
   if IOresult <> 0 then
     writeln('Error could not create font program: ',iname);
   close(f);
end.
