
{}
{							}
{	RUNDLG	      --Public Domain (1992)		}
{							}
{			Randolph Beck			}
{			CIS:  72361,753			}
{							}
{}

Unit RUNDLG;

{$B-,O+,R-,V-,X+ }

interface

uses
    Objects, Drivers, Dialogs, Views, App;

type
    PRunBox	= ^TRunBox;
    PPrnBox	= ^TPrnBox;


    TRunBox	=  OBJECT (TDialog)
	RunFunc		: pointer;
	QuitCmd		: word;
	QuitModal	: boolean;
      constructor Init (var Bounds :TRect; ATitle :TTitleStr; ARunFunc :pointer);
      procedure EndModal (Command : word);  VIRTUAL;
      function  Execute : word;  VIRTUAL;
      procedure HandleEvent (var Event : TEvent);  VIRTUAL;
      procedure Idle;  VIRTUAL;
      function  Running : boolean;  VIRTUAL;
    end;


    TPrnBox	=  OBJECT (TRunBox)
	Pausing		: boolean;
	RunMsg		: pstring;
	PauseMsg	: pstring;
	Msg		: PStaticText;
	PauseBtn	: PButton;
      constructor Init (var Bounds :TRect; ATitle :TTitleStr;
			ARunFunc :pointer; AInitMsg,ARunMsg,APauseMsg :string);
      destructor  Done;  VIRTUAL;
      procedure HandleEvent (var Event : TEvent);  VIRTUAL;
      function  Running : boolean;  VIRTUAL;
    end;


  function  Running : boolean;


implementation

var    RF	: pointer;
const  ExecRun	: PRunBox = nil;
       cmPause  = 4700;


  {  TRunBox  }


constructor TRunBox.Init (var Bounds :TRect; ATitle :TTitleStr; ARunFunc :pointer);
begin
  TDialog.Init (Bounds, ATitle);
  RunFunc := ARunFunc;
  Flags   := 0;
end;


procedure TRunBox.EndModal (Command : word);
begin
  TDialog.EndModal (Command);
  QuitCmd   := Command;
  QuitModal := GetState (sfModal);
end;


function  TRunBox.Execute : word;
var  Result : word;
begin
  Result  := cmCancel;
  QuitCmd := cmCancel;
  ExecRun := @Self;
  If (RunFunc <> nil) then
    begin
    RF	  := RunFunc;
    If not Running then
      QuitModal := TRUE
     else
      asm
	call	RF;
	mov	Result, ax;
	end;
    end;
  ExecRun := nil;
  If QuitModal then Execute := QuitCmd else Execute := Result;
end;


procedure TRunBox.HandleEvent (var Event : TEvent);
var  P : PView;
begin
  TDialog.HandleEvent (Event);
  If (Event.What = evKeyDown) and (Current <> nil) then
    begin
    P := Current;
    Case Event.KeyCode of
      kbUp,kbLeft,kbCtrlLeft:
	begin
	Repeat
	  P := P^.Next;
	Until (P^.Options and ofSelectable <> 0) and P^.GetState (sfVisible);
	end;
      kbDown,kbRight,kbCtrlRight:
	begin
	Repeat
	  P := P^.Prev;
	Until (P^.Options and ofSelectable <> 0) and P^.GetState (sfVisible);
	end;
     else	Exit;
      end;
    P^.Select;
    ClearEvent (Event);
    end;
end;


procedure TRunBox.Idle;
begin
  If (Application <> nil) then Application^.Idle;
end;


function  TRunBox.Running : boolean;
var  E : TEvent;
begin
  If not QuitModal then
    begin
    If not EventAvail then Idle;
    While EventAvail do
      begin
      GetEvent (E);
      HandleEvent (E);
      If (E.What <> evNothing) then EventError (E);
      If QuitModal and not Valid (QuitCmd) then QuitModal := FALSE;
      end;
    end;
  Running := not QuitModal;
end;


  {  TPrnBox  }


constructor TPrnBox.Init (var Bounds :TRect; ATitle :TTitleStr;
			  ARunFunc :pointer;
			  AInitMsg,ARunMsg,APauseMsg :string);
var  R		: TRect;
     col,row	: integer;
begin
  TRunBox.Init (Bounds, ATitle, ARunFunc);
  Pausing := TRUE;
  GetExtent (R);
  R.Grow (-3,-2);
  R.B.Y := Size.Y - 3;
  Msg := New (PStaticText, Init (R, AInitMsg));
  Insert (Msg);
  RunMsg	:= NewStr (ARunMsg);
  PauseMsg	:= NewStr (APauseMsg);
  col := Size.X shr 1;
  row := Size.Y - 3;
  R.Assign (col + 1, row, col + 13, row + 2);
  Insert (New (PButton, Init (R, 'Cancel', cmCancel, bfNormal)));
  R.Assign (col - 13, row, col - 1, row + 2);
  PauseBtn := New (PButton, Init (R, '~S~tart', cmPause, bfDefault));
  Insert (PauseBtn);
end;


destructor TPrnBox.Done;
begin
  DisposeStr (RunMsg);
  DisposeStr (PauseMsg);
  TRunBox.Done;
end;


procedure TPrnBox.HandleEvent (var Event : TEvent);
begin
  TRunBox.HandleEvent (Event);
  If (Event.What = evCommand) and (Event.Command = cmPause) then
    begin
    Pausing := not Pausing;
    DisposeStr (PauseBtn^.Title);
    DisposeStr (Msg^.Text);
    If Pausing then
      begin
      PauseBtn^.Title := NewStr ('~C~ontinue');
      Msg^.Text := NewStr (PauseMsg^);
      end
     else
      begin
      PauseBtn^.Title := NewStr ('~P~ause');
      Msg^.Text := NewStr (RunMsg^);
      end;
    ClearEvent (Event);
    Redraw;
    PauseBtn^.Select;
    end;
end;


function  TPrnBox.Running : boolean;
var  Humm : boolean;
begin
  Repeat
    Humm := TRunBox.Running;
  Until not Pausing or not Humm;
  Running := Humm;
end;


  {  }


function  Running : boolean;
begin
  Running := (ExecRun <> nil) and ExecRun^.Running
end;


  {  }


End.
