{ $D-}  { Disable Debug Information }
{$S-}  { Disable Stack Checking }
{$V-}  { Disable String Checking }

Unit Support;
{ Part of BBS Onliner Interface }
{ Copyright (C) 1990, 1992 Andrew J. Mead
  All Rights Reserved. }

{ original version 9/5/90
  history found in IOLIB.PAS }

INTERFACE

Uses
  boidecl,
  crt,
  dos;

Const
  bois_highscore = true;
  bois_lowscore  = false;
  bois_cash      = true;
  bois_points    = false;

Var
  playerpoints : longint;  { player score variable }

Procedure ABORTGAME(limit : byte);
Procedure DISPLAYTEXT(dt_file : pathstr);
Procedure LINEWRITE(lstr : string; colora, colorb :byte; lcheck : boolean);
Procedure QUERYUSER(querylist : charset);
Function WRITECOPY(askq : boolean) : boolean;
Procedure ENDGAME(playstr : string; isvalid, iscash, gethigh : boolean);

IMPLEMENTATION

Uses
  doorlib,
  key,
  getcmbbs,
  iolib;

Var
  bs_char : char;         { standard input character }
  bs_etemp : boolean;

Procedure ABORTGAME; { notifies user that their "screen" is not large enough }
  begin {* AbortGame *}
    SendString('',true);
    SendString('Your setup shows that your screen only displays ',false);
    SendString(IntStr(boi_pagelength,0) + ' lines.',true);
    SendString
        ('This game requires a minimum of '+IntStr(limit,0)+' lines.',true);
    SendString
    ('Check your BBS settings and make the needed changes before trying again.',
        true);
    SendString
        ('Thank you.  Please press almost any key to return to your BBS. ',
        false);
    ClearBuffers;
    bs_char := ReadPortKey;
    SendString('',true);
    SendString('',true);
    SendString('Please wait... returning to the BBS.',true);
    Halt
  end;  {* AbortGame *}

Procedure DISPLAYTEXT(  { display formatted text file }
    dt_file : pathstr);   { file to be displayed }

  type
    dmode = (send,endb,ende,wind,clr,skip);  { display modes }

  var
    dt_f     : file;    { file handle for determining dt_file's size }
    dt_t     : text;    { text file handle for dt_file }
    dt_fsize : longint; { size of dt_file }
    dt_buff  : pointer; { pointer to dt_file's input buffer }
    buffsize : word;    { size of dt_file's input buffer }

    dt_mode  : dmode;   { current display mode }
    dt_line  : string;  { current input display line }
    dt_idx   : byte;    { index into dt_line }
    dt_quit  : boolean; { user abort indicator }
    endline  : boolean; { current line should be output with newline }

 { The first seven (7) characters of each line of a DisplayText text file    }
 { are reserved for formatting information.  Here is the header layout:      }
 { (Note: Windowing commands (W) don't follow the same format.               }
 {                                                                           }
 { byte  legal values  notes/meaning                                         }
 {   1   + - C E B W   other values indicate comment, line is not processed  }
 {   2      none       blank space                                           }
 {   3      0..F       color value passed to PortBackground(color)           }
 {   4      0..F       color value passed to PortColor(color,monochrome)     }
 {   5      0..F       reserved                                              }
 {   6      0..F       monochrome value passed to PortColor(color,monochrome)}
 {   7      none       blank space                                           }
 {                                                                           }

  Procedure SETVALUES(  { assign mode/endline parameters for current line }
      dm : dmode;         { display mode }
      el : boolean);      { endline indicator }

    begin {* DisplayText,SetValues *}
      dt_mode := dm;
      endline  := el
    end;  {* DisplayText,SetValues *}

  begin {* DisplayText *}
    { find out how large dt_file is }
    Assign(dt_f,dt_file);
    if OpenFile(dt_f,1,denynone + read_only,treset) <> 0 then Exit;
    dt_fsize := FileSize(dt_f);
    Close(dt_f);

    { create text input buffer for dt_file }
    buffsize := MinL(dt_fsize,MinL(65520,MaxAvail));
    GetMem(dt_buff,buffsize); { allocate buffer on heap }

    { open dt_file for processing }
    Assign(dt_t,dt_file);
    if OpenText(dt_t,denywrite + read_only,treset) <> 0 then Exit;
    SetTextBuf(dt_t,dt_buff^,buffsize); { assign text buffer to file handle }
    dt_quit := false;
    repeat { process file }
      begin
        ReadLn(dt_t,dt_line);
        if Length(dt_line) > 0 then
          begin
            case UpCase(dt_line[1]) of       { determine type of processing }
                '+' : SetValues(send, true);   { end-of-line marker }
                '-' : SetValues(send,false);   { line continuation marker }
                'C' : SetValues(clr ,false);   { clear window marker }
                'B' : SetValues(endb,false);   { page break marker }
                'E' : SetValues(ende,false);   { end of file marker }
                'W' : SetValues(wind,false);   { window definition marker }
                else  SetValues(skip,false)    { comment line, ignore }
              end;
            if dt_mode = wind then { determine window coordinates }
              begin { "WF" means "Full Window" }
                if UpCase(dt_line[2]) = 'F' then
                    PortWindow(1,1,80,boi_pagelength)
                else { declare window by coordinates }
                  begin
                    { this section not fleshed out }
                  end
              end
            else if dt_mode <> skip then { if line to be shown, show it! }
              begin
                if (Length(dt_line) >= 3) and (dt_line[3] <> ' ') then
                    PortBackground(Hex(dt_line[3])); { background color }
                if (Length(dt_line) >= 6) and (dt_line[4] <> ' ') and
                    (dt_line[6] <> ' ') then { text color }
                    PortColor(Hex(dt_line[4]),Hex(dt_line[6]));
                if dt_mode = clr then ClrPortScr { clear window }
                else if dt_mode = endb then
                  begin { page break / wait for user }
                    SendString('Press almost any key to continue.',false);
                    ClearBuffers;
                    bs_char := ReadPortKey;
                    if bs_char = #27 then dt_quit := true;
                    PortColumnOne;
                    ClrPortEOL
                  end
                else if dt_mode = ende then
                  begin { end of file / wait for user }
                    SendString('',true);
                    SendString('Press almost any key to continue game.',false);
                    ClearBuffers;
                    bs_char := ReadPortKey
                  end
                else if Length(dt_line) > 7 then
                  { show text one character at a time, allowing user to exit }
                  { by pressing [ESC] or pause by pressing the spacebar. }
                  begin
                    dt_idx := 8; { set index into line }
                    while (dt_idx <= Length(dt_line)) and (not dt_quit) do
                      begin
                        SendString(dt_line[dt_idx],false); { show character }
                        Inc(dt_idx);
                        while (PortKeyPressed) and (not dt_quit) do
                          begin { process incoming key }
                            bs_char := ReadPortKey;
                            if bs_char = #27 then dt_quit := true { exit }
                            else if bs_char = ' ' then { pause }
                              begin
                                ClearBuffers;
                                while not PortKeyPressed do
                                    if not in_dos^ then BOI_Wait;
                                bs_char := ReadPortKey;
                                if bs_char = #27 then dt_quit := true; { exit }
                                ClearBuffers
                              end
                            else ClearBuffers
                          end
                      end
                  end
              end;
            if endline and (not dt_quit) then SendString('',true) { cr/lf }
          end
      end
    until EOF(dt_t) or (dt_mode = ende) or dt_quit ;
    Close(dt_t);
    FreeMem(dt_buff,buffsize) { release buffer space from heap }
  end;  {* DisplayText *}

Procedure LINEWRITE(    { option bar item display routine }
    lstr   : string;      { string to display }
    colora : byte;        { color to use for color modes }
    colorb : byte;        { color to use for monochrome modes }
    lcheck : boolean);    { is item active? }

  begin {* LineWrite *}
    PortColor(colora,colorb);
    SendString(lstr[1],false);
    if lcheck then TextPortColor(white); { Highlight active items }
    SendString(lstr[2],false);
    if lcheck then PortColor(colora,colorb);
    SendString(copy(lstr,3,length(lstr)),false)
  end;  {* LineWrite *}

Procedure QUERYUSER(      { ask user what video mode they want }
    querylist : charset);   { legal video modes }

  Procedure QUERYCHOICE(    { writes out one choice line }
      qchar : char;           { selection character for choice }
      qstr  : string);        { description of choice }

    begin {* QueryUser,QueryChoice *}
      if qchar in querylist then
          SendString('       "' + qchar + '" ' + qstr,true)
    end;  {* QueryUser,QueryChoice *}

  Procedure SETVALUES(     { initialize graphic modes }
      lcolor : boolean;      { local color/mono indicator }
      rcolor : boolean;      { remote color/mono indicator }
      grmode : boi_grmode);  { graphics mode to use }

    begin {* QueryUser,SetValues *}
      boi_l_color := lcolor;
      if not boi_local then
        begin
          boi_r_color := rcolor;
          boi_r_grmode := grmode
        end
      else SetLocalGraphMode(grmode)
    end;  {* QueryUser,SetValues *}


  begin {* QueryUser *}
{$IFDEF BOIDEBUG }
    SendString('',true);
    SendString('Running under '+boi_tstr+' mode.',true);
{$ENDIF BOI DEBUG }
    SendString('',true);
    SendString('Before we get started, please pick a display mode: ',true);
    SendString('',true);
    if boi_local then { add CRT choices for local play }
        querylist := querylist + ['C','M'];
    QueryChoice('Q','None - Exit game now');
    QueryChoice('0','ASCII text');
    QueryChoice('1','ANSI Color');
    QueryChoice('2','ANSI Monochrome');
    QueryChoice('3','AVATAR/1 Color');
    QueryChoice('4','AVATAR/1 Monochrome');
    QueryChoice('C','Direct Video Color');
    QueryChoice('M','Direct Video Monochrome');
    SendString('',true);
    repeat bs_char := UpCase(ReadPortKey)   { scan input stream }
    until bs_char in querylist;             { until valid choice found }
    case bs_char of
        'Q' : Halt;
        '0' : { ASCII mode }
          begin
            if not boi_local then boi_r_grmode := gr_ascii
            else SetLocalGraphMode(gr_ascii)
          end;
        '1' : SetValues(true, true, gr_ansi);  { ANSI color mode }
        '2' : SetValues(false,false,gr_ansi);  { ANSI monochrome mode }
        '3' : SetValues(true, true, gr_avt);   { AVATAR color mode }
        '4' : SetValues(false,false,gr_avt);   { AVATAR monochrome mode }

        'C' : { CRT color mode }
          begin
            boi_r_grmode := gr_none;
            boi_l_grmode := gr_tpcrt;
            boi_l_color := true
          end;
        'M' : { CRT monochrome mode }
          begin
            boi_r_grmode := gr_none;
            boi_l_grmode := gr_tpcrt;
            boi_l_color := false
          end;
      end;
    SendString('',true);
    PortColor(lightgreen,white);
    SendString('Thank you.  Please enjoy the game.',true)
  end;  {* QueryUser *}

Function WRITECOPY;         { Copyright screen }
  begin {* WriteCopy *}
    bs_etemp := boi_echo;
    if not boi_local then boi_echo := true; { force local echo for copyright }
    PortBackground(black);
    PortColor(yellow,white);
    ClrPortScr;
    SendString(DoorName,false);
    PortColor(cyan,lightgray);
    SendString(' version ' + Version + '.',true);
    SendString('Program Copyright (C) 1990,1992 Andrew J. Mead',true);
    SendString('All Rights Reserved.',true);
    SendString('',true);
{* begin required portion *}
    TextPortColor(white);
    SendString('BBS Onliner Interface',false);
    PortColor(cyan,lightgray);
    SendString(' version ' + BOI_Version + '.',true);
    SendString('Copyright(C) 1990,1992 Andrew J. Mead',true);
    SendString('All Rights Reserved.',true);
    SendString('Contact: POB 1155 Chapel Hill, NC 27514-1155',true);
{* end required portion * }
    SendString('',true);
    if key_registered then {* rejoice, rejoice, rejoice *}
      begin
        PortColor(lightblue,white);
        SendString(key_regname,false);
        PortColor(cyan,lightgray);
        SendString(' has registered this game.  SN: '+key_regnum,true);
        PortColor(Random(7) + 9,white); { pick a random bright color }
        SendString(key_regstr,true);
        PortColor(cyan,lightgray);
        SendString('Support your local BBSs that support ShareWare.',true)
      end
    else {* beg like a dog *}
      begin
        SendString('This is an Evaluation Copy of ',false);
        PortColor(yellow,white);
        SendString(DoorName,false);
        PortColor(cyan,lightgray);
        SendString('.',true);
        SendString('If you like it, please help the SysOp register it.',true)
      end;
    GotoPorTXY(1,boi_pagelength);
    PortColor(lightmagenta,lightgray);
    if askq then SendString
        ('Press "I" for instructions, or almost any other key to begin. ',false)
    else SendString('Press almost any key to begin. ',false);
    ClearBuffers;
    bs_char := UpCase(ReadPortKey);
    boi_echo := bs_etemp;  { restore original local echo status }
    WriteCopy := bs_char = 'I'
  end;  {* WriteCopy *}

Procedure ENDGAME(       { standard Hall of Fame }
    playstr  : string;     { -type- of player }
    isvalid  : boolean;    { is score valid for HOF contention? }
    iscash   : boolean;    { is score in cash? (or points) }
    gethigh  : boolean);   { is high (or low) score better }

  type
    str40    = string [40];

    hofrec   = record         { Hall of Fame data file record }
        hname  : str40;         { player name }
        amount : longint;       { player score }
        month  : word;          { month of game }
        date   : word;          { day of month of game }
        year   : word           { year of game }
      end;
    hofarr   = array [1..24] of hofrec;
                             {  1..20 this month's top 20 }
                             { 21..23 last month's top  3 }
                             {     24 all time high score }

  var
    hof_f       : file;      { file handle for data Hall of Fame }
    hof_t       : text;      { file handle for text Hall of Fame }
    hof_hall    : hofarr;    { Hall of Fame }
    hof_old     : boolean;   { Hall of Fame needs to be updated indicator }
    alltimebest : boolean;   { this score is the All Time Best }
    updatetext  : boolean;   { text Hall of Fame needs to be updated }
    nextmonth   : boolean;   { this games starts a new month }
    topten      : boolean;   { this score is in this month's top ten }
    usetemp     : boolean;   { storage for boi_usename value }
    hof_idx     : byte;      { current place in Hall of Fame }
    firstmatch  : byte;      { index to player's lowest score in Hall of Fame }
    totalmatch  : byte;      { number of times this player is in Hall of Fame }

    eloop       : byte;      { temporary looping/counting variable }
    extra       : word;      { temporary variables used for formatting output }
    etemp       : byte;
    enddoor     : string;
    workline    : string;
    tempname    : str40;

  Function HOFCHECK : boolean;  { does this score REALLY belong in HOF? }
    var
      hloop : byte;

    begin {* HofCheck *}
      if boi_usename then
        begin { find out if this score is within limit (/x:n), and what the }
              { worst score this player has posted to the Hall of fame }
          for hloop := 1 to 20 do if boi_username = hof_hall[hloop].hname then
            begin
              Inc(totalmatch); { Increment number of scores by this player }
              if totalmatch = boi_hoflim then firstmatch := hloop
            end;
          HofCheck := (firstmatch = 21) or
              (gethigh and (playerpoints > hof_hall[firstmatch].amount)) or
              ((not gethigh) and (playerpoints < hof_hall[firstmatch].amount))
        end
      else HofCheck := true
    end;  {* HofCheck *}

  Function GOODSCORE : boolean;   { does this score fit in the HOF? }
    begin {* EndGame,fGoodScore *}
      if gethigh then GoodScore := (playerpoints > hof_hall[20].amount)
      else GoodScore := (playerpoints < hof_hall[20].amount) or
          (hof_hall[20].amount = 0)
    end;  {* EndGame,fGoodScore *}

  Function BETTERSCORE : boolean; { where in the HOF does this score fit? }
    begin {* EndGame,fBetterScore *}
      if gethigh then
          BetterScore := (playerpoints > hof_hall[hof_idx - 1].amount)
      else BetterScore := (playerpoints < hof_hall[hof_idx - 1].amount) or
          (hof_hall[hof_idx - 1].amount = 0)
    end;  {* EndGame,fBetterScore *}

  begin {* EndGame *}
    updatetext  := false; { text Hall of Fame is fine the way it is }
    nextmonth   := false; { the Hall of Fame is current for this month }
    hof_old     := false; { the Hall of Fame data is up to date! }
    firstmatch  := 21;    { this player's score doesn't make it in the HOF }
    totalmatch  := 0;     { this player has no scores in the Hall of Fame }
    alltimebest := false; { this score is definitely not the All Time Best }
    usetemp     := boi_usename;  { save current player's name }
    Assign(hof_f,boi_gamedir + DatHOF);
    if Exist(boi_gamedir + DatHOF) then
      begin { read in current Hall of Fame }
        if OpenFile(hof_f,SizeOf(hof_hall),denywrite+read_only,treset) = 0 then;
        BlockRead(hof_f,hof_hall,1);
        Close(hof_f);
        if (hof_hall[1].amount > 0) and
            (boi_startdate[2] <> hof_hall[1].month) then
          begin { this is a new month }
            nextmonth := true;
            updatetext := true;
            Move(hof_hall[1],hof_hall[21],3*SizeOf(hof_hall[1]));
                { move top three scores to "last month'" section }
            for eloop := 1 to 20 do with hof_hall[eloop] do
              begin { reset top twenty for this month }
                hname := '';
                amount := 0;
                month := boi_startdate[2];
                date  := boi_startdate[3];
                year  := boi_startdate[1]
              end;
            if OpenFile(hof_f,SizeOf(hof_hall),denywrite + writeonly,
                trewrite) = 0 then;
            BlockWrite(hof_f,hof_hall,1);
            Close(hof_f)
          end
      end
    else { create brand new Hall of Fame }
      begin
        FillChar(hof_hall,SizeOf(hof_hall),0);
        for eloop := 1 to 24 do with hof_hall[eloop] do
          begin { initialize entries }
            hname := '';
            amount := 0;
            month := boi_startdate[2];
            date  := boi_startdate[3];
            year  := boi_startdate[1]
          end
      end;
    if iscash then { show player their score as cash total }
      begin
        PortColor(brown,lightgray);
        SendString(
            'Your game has ended.  Your final holdings are worth ',false);
        PortColor(yellow,white);
        SendString('$',false);
        PortColor(lightgreen,white);
        SendString(IntStr(playerpoints,0),false);
        PortColor(brown,lightgray);
        SendString('.',true)
      end
    else { show player their score as point total }
      begin
        PortColor(brown,lightgray);
        SendString('Your game has ended. Your final score is ',false);
        PortColor(yellow,white);
        SendString(IntStr(playerpoints,0),false);
        PortColor(brown,lightgray);
        SendString(' points.',true)
      end;
    if GoodScore and isvalid and HofCheck then { score belongs in Hall of Fame }
      begin
        hof_old := true;
        PortColor(red,lightgray);
        SendString('You have qualified for the ',false);
        PortColor(lightred,white);
        SendString('Hall of Fame',false);
        PortColor(red,lightgray);
        if boi_usename then { use player's user name }
          begin
            tempname := boi_username;
            SendString('.',true)
          end
        else { ask player to supply name }
          begin
            SendString(', please enter your name:',true);
            tempname[0] := chr(0);
            PortColor(lightcyan,white);
            GetString(tempname)
          end;
        hof_idx := 21;
        while (hof_idx > 1) and BetterScore do { find out where score belongs }
            Dec(hof_idx);
        Move(hof_hall[hof_idx],               { move worse scores down in HOF }
            hof_hall[hof_idx + 1],
            (Min(firstmatch,20) - hof_idx) * SizeOf(hofrec));
        hof_hall[hof_idx].hname := tempname;      { add player's data to HOF }
        hof_hall[hof_idx].amount := playerpoints;
        GetDate(hof_hall[hof_idx].year,hof_hall[hof_idx].month,
            hof_hall[hof_idx].date,extra)
      end;
    PortWindow(1,1,80,boi_pagelength);
    GotoPortXY(1,Min(24,boi_pagelength));
    PortColor(brown,lightgray);
    SendString('Press almost any key to see the Hall of Fame. ',false);
    ClearBuffers;
    bs_char := ReadPortKey;
    boi_usename := false;
    ClrPortScr;
    PortColor(lightcyan,white);

    { display monthly Hall of Fame to user }
    enddoor := DoorName;
    etemp := Length(enddoor);
    while Length(enddoor) < 50 do enddoor := ' ' + enddoor;
    SendString(enddoor,false);
    PortColor(lightgreen,white);
    SendString(' Hall Of Fame',true);
    Delete(enddoor,1,Length(enddoor) - etemp);
    PortColor(brown,lightgray);
    SendString(PadStr('Player  Rank       Amount    Date',67),true);
    for eloop := 1 to 20 do with hof_hall[eloop] do
        if amount > 0 then { only show legal entries }
      begin { show line of Hall of Fame }
        if hof_old and (eloop = hof_idx) then { highlight current score }
            PortColor(lightblue,white)
        else if eloop = 1 then                { highlight all time best }
            TextPortColor(white)
        else PortColor(green,lightgray);
        SendString(PadStr(hname,40) + IntStr(eloop,5) + IntStr(amount,14) +
            IntStr(month,5) + '/' + IntStr(date,0) +'/' + IntStr(year,0),false);
        if hof_old and (eloop = hof_idx) then SendString(' <--',true)
        else SendString('',true)
      end;
    SendString('',true);

    { update data Hall of Fame }
    if hof_old then
       begin
        if (hof_idx = 1) and
            ((gethigh) and (playerpoints > hof_hall[24].amount)) or
            ((not gethigh) and ((playerpoints < hof_hall[24].amount) or
            (hof_hall[24].amount = 0))) then
          begin { this score is the all time best }
            alltimebest := true;
            Move(hof_hall[hof_idx],hof_hall[24],SizeOf(hof_hall[24]));
            updatetext := true;
          end
        else if hof_idx <= 10 then
          begin { text Hall of Fame needs to be updated }
            topten := true;
            updatetext := true
          end;
        { write data Hall of Fame }
        if OpenFile(hof_f,SizeOf(hof_hall),denywrite+writeonly,trewrite)=0 then;
{xxx}        BlockWrite(hof_f,hof_hall,1);
        Close(hof_f)
      end;

    { update text Hall of Fame }
    if updatetext then
      begin
        Assign(hof_t,boi_texthof);
        if OpenText(hof_t,denywrite + writeonly,trewrite) = 0 then;
        workline := key_regstr + ' - ' + enddoor + ' - Hall Of Fame';
{ 1}    WriteLn(hof_t,workline:Length(workline) div 2 + 40);
{ 2}    WriteLn(hof_t);
        if hof_hall[24].amount > 0 then
          begin
            workline := '- All Time Best Score -';
{ 3}        WriteLn(hof_t,workline:length(workline)div 2 + 45);
{ 4}        WriteLn(hof_t,hof_hall[24].hname:40,' ',hof_hall[24].amount:10,
                ' ',hof_hall[24].month:0,'/',hof_hall[24].date:0,'/',
                hof_hall[24].year:0)
          end;
{ 5}    WriteLn(hof_t);
        if hof_hall[21].amount > 0 then
          begin
            workline := '- Last Month''s Top Three -';
{ 6}        WriteLn(hof_t,workline:length(workline) div 2 + 45);
            for eloop := 21 to 23 do if hof_hall[eloop].amount > 0 then
{ 7- 9}         WriteLn(hof_t,hof_hall[eloop].hname:40,' ',
                hof_hall[eloop].amount:10,' ',hof_hall[eloop].month:0,'/',
                hof_hall[eloop].date:0,'/',hof_hall[eloop].year:0);
{10}         WriteLn(hof_t)
          end;
        workline := '- This Month''s Top ' + playstr + ' -';
{11}    WriteLn(hof_t,workline:length(workline) div 2 + 45);
        for eloop := 1 to 10 do if hof_hall[eloop].amount > 0 then
{12-21}     WriteLn(hof_t,hof_hall[eloop].hname:40,' ',
            hof_hall[eloop].amount:10,' ',hof_hall[eloop].month:0,'/',
            hof_hall[eloop].date:0,'/',hof_hall[eloop].year:0);
        Close(hof_t)
      end;
    SendString('',true);

    if alltimebest then
      begin { tell player about it }
        PortColor(brown,lightgray);
        SendString('Your final amount was the ',false);
        PortColor(yellow,white);
        SendString('ALL-TIME BEST!!!',true)
      end
    else { recap player's score }
      begin
        PortColor(brown,lightgray);
        SendString('Your final amount was ',false);
        PortColor(yellow,white);
        if iscash then { show score as cash value }
          begin
            SendString('$',false);
            PortColor(lightgreen,white);
            SendString(IntStr(playerpoints,0),false);
            PortColor(brown,lightgray);
            SendString('.',true)
          end
        else { show score as points value }
          begin
            SendString(IntStr(playerpoints,0),false);
            PortColor(brown,lightgray);
            SendString(' points.',true)
          end
      end;

    { see if player can, and if player wants to play anther game }
    if boi_replay and ((not boi_usetime) or ((not boi_timexp) and
        (boi_againtime < LeftTime))) then
      begin
        PortColor(brown,lightgray);
        if boi_usetime then { tell player how much time they have left }
          begin
            SendString('You have less than ',false);
            PortColor(yellow,white);
            SendString(IntStr(LeftTime + 1,0),false);
            PortColor(brown,lightgray);
            SendString(' minutes remaining.',true)
          end;
        SendString('Would you like to play again? [Y/N] ',false);
        ClearBuffers;
        TextPortColor(white);
        repeat bs_char := UpCase(ReadPortKey) until bs_char in ['Y','N'];
        if bs_char = 'Y' then SendString('Yes',true) else SendString('No',true);
        if bs_char = 'N' then boi_replay := false else boi_usename := usetemp
      end
    else boi_replay := false;
    if not boi_replay then
      begin { tell player they are about to leave game }
        PortColor(brown,lightgray);
        if key_registered then { tell them the BBS name }
          begin
            SendString('Press almost any key to return to ',false);
            PortColor(random(7) + 1,white);
            SendString(key_regstr,false);
            PortColor(brown,lightgray);
            SendString('.',false)
          end
        else SendString('Press almost any key to return to your BBS.',false);
        ClearBuffers;
        bs_char := ReadPortKey;
        SendString('',true);
        SendString('',true);
        PortColor(brown,lightgray);
        if key_registered then { tell them the BBS name again }
          begin
            SendString('Please wait.  Returning to ',false);
            PortColor(random(7) + 1,white);
            SendString(key_regstr,false);
            PortColor(brown,lightgray);
            SendString('.',true)
           end
         else SendString('Please wait.  Returning to the BBS.',true)
      end
  end;  {* EndGame *}

begin {* uSupport *}
end.  {* uSupport *}
