{ $D-}  { Debug Information Off }
{$S-}  { Stack Checking Off    }
{$V-}  { String Checking Off   }

Unit DoorLib;
{ Part of BBS Onliner Interface }
{ Copyright (C) 1990,1992 Andrew J. Mead
  All Rights Reserved. }

{ original version 5/20/92
  history found in IOLIB.PAS }

INTERFACE

Uses
  dos;

Function INFOFILE : pathstr;
Function TXTHOF   : pathstr;
Function DATHOF   : pathstr;
Function LOGFILE  : pathstr;
Function DOORNAME : string;
Function VERSION  : string;

Function PROGRAMSET(check : char) : boolean;

Procedure DL_SETVALUE(dl_index : byte; dl_new : pathstr);

IMPLEMENTATION

Uses
  IOLib;

Type
  dl_array = array [1..6] of pathstr;

Const
  dl_table : dl_array = (

{$I DOORLIB.DAT}

{  (* Contents of sample DOORLIB.DAT *)
      'HILOINFO.DOC',         (* HiLo documentation filename *)
      'HILOHOF.TXT',          (* HiLo text Hall of Fame filename *)
      'HILOHOF.DAT',          (* HiLo data Hall of Fame filename *)
      'BOI.LOG',              (* activity / error log filename *)
      'HiLo',                 (* game name *)
      '2.00');                (* game version number *)

  dl_progset : set of char = [#00];
                              (* valid additional command line switches *)
{}

Function INFOFILE : pathstr; { filename of document file for installation help }
  begin {* InfoFile *}
    InfoFile := dl_table[1]
  end;  {* InfoFile *}

Function TXTHOF : pathstr; { filename of default text Hall of Fame }
  begin {* TxtHOF *}
    TxtHOF := dl_table[2]
  end;  {* TxtHOF *}

Function DATHOF : pathstr; { filename of data Hall of Fame }
  begin {* DatHOF *}
    DatHOF := dl_table[3]
  end;  {* DatHOF *}

Function LOGFILE : pathstr; { filename of error/activity log }
  begin {* fLogFile *}
    LogFile := dl_table[4]
  end;  {* fLogFile *}

Function DOORNAME : string; { name of the game }
  begin {* fDoorName *}
    DoorName := dl_table[5]
  end;  {* fDoorName *}

Function VERSION : string; { current game version }
  begin {* fVersion *}
    Version := dl_table[6]
  end;  {* fVersion *}

Function PROGRAMSET(          { check to see if character is valid command }
    check : char) : boolean;  { line option. }

  begin {* fProgramSet *}
    ProgramSet := check in dl_progset
  end;  {* fProgramSet *}

Procedure DL_SETVALUE(   { change value in dl_table }
    dl_index : byte;       { index of value to change }
    dl_new   : pathstr);   { new dl_table value }

  begin {* DL_SetValue *}
    if dl_index in [1..6] then { dl_index value is legal }
        dl_table[dl_index] := dl_new { assign new value }
  end;  {* DL_SetValue *}

Procedure CHECKENVIRONMENT;  { process environment variables }
  var
    envtemp : pathstr;

  begin {* CheckEnvironment *}
    envtemp := GetEnv('BOILOG'); { check for environment variable }
    CleanString(envtemp);
    if Length(envtemp) = 0 then Exit; { no enviroment variable found, exit }
    if (Pos('.',envtemp) = 0) then { filepath only }
      begin
        if not (envtemp[Length(envtemp)] in [':','\']) then { incomplete path }
            envtemp := envtemp + '\';
        envtemp := envtemp + dl_table[4] { add default filename to path }
      end;
    envtemp := FExpand(envtemp); { flush out path/filespec }
    if Valid(envtemp) then { if this file is a legal DOS pathfilename then...}
        DL_SetValue(4,envtemp) { replace default value }

    { BOIOPT environment variable will be added in the near future.  Currently}
    { the log is only a fatal error log.  User activity and possibly formatting}
    { options will be added. }
  end;  {* CheckEnvironment *}

begin {* uDoorLib *}
  CheckEnvironment
end.  {* uDoorLib *}
