{****************************************************************}
{                                                                }
{      Unit to select Fonts for Printer or Display               }
{                                                                }
{                                                         	 }
{   The books 'Turbo-Pascal f. Windows - Object Windows'         }
{   from A.Ertl and R.Machholz, Sybex, Duesseldorf, Germany      }
{   and 'Programming Windows' from Ch.Petzold, Microsoft Press   }
{   helped me to develop this unit. I hope, I did not injure     }
{   the copyrights of anyone.                                    }
{   I cannot promise that this unit will work in every situation }
{   and I will not accept any liabilty etc for ANY damage caused }
{   by using this unit or parts of it.                           }
{   I offer this unit free to anyone who can use it.             }
{   I would like to be notified of any bugs or enhancements      }
{   that you may make.                                           }
{                                                                }
{   Kurt Bertram, Compuserve [100031,3373]                       }
{****************************************************************}

UNIT PFonts;

INTERFACE

{$R PFONTS.RES}

USES WObjects, WinTypes;

FUNCTION FontDialog (AParent: PWindowsObject; ADC: HDC;
                     VAR Font: TLogFont; var Grx: Integer): Boolean;

IMPLEMENTATION

USES Strings, WinProcs;

CONST
  id_FontName = 101;
  id_FontSize = 102;

Type

  PFontSizeCollection = ^TFontSizeCollection;
  TFontSizeCollection = OBJECT(TCollection)
    PROCEDURE FreeItem(Item: Pointer); VIRTUAL;
  END;

  PFontNameCollection = ^TFontNameCollection;
  TFontNameCollection = OBJECT(TFontSizeCollection)
  END;

  PData = ^TData;   { needed to transfer Data into Callback-Function 2 }
  TData = Record
    Fontsize:Integer;
    Font    :PLogfont;
  end;

Var FntNamColl: PFontNameCollection; { filled by function EnumFontnames }
    FntSizColl: PFontSizeCollection; { filled by function EnumFontSizes }
    ALogFont  : TLogFont;            { selected LogFont }

PROCEDURE TFontSizeCollection.FreeItem(Item: Pointer);
BEGIN
  StrDispose(PChar(Item));
END;

FUNCTION EnumFontNames(LogFont: TLogFont; TextMetrics: TTextMetric;
  FontType: Integer; Data: PChar): Integer; EXPORT;
  { Fills Collection of FontNames }
BEGIN
  FntNamColl^.Insert(StrNew(LogFont.lfFaceName));
  EnumFontNames := 1;
END;

Function EnumFontSizes(LogFont: TLogFont; TextMetrics: TTextMetric;
  FontType: Integer; Data: PData): Integer; EXPORT;
  { Fills Collection of FontSizes, if FontName ist defined }
const SizeArray: ARRAY[0..9] OF INTEGER =
                   ( 6, 8, 10, 12, 14, 18, 24, 30, 36, 48 );
var Sizestr: String;
    PStr   : array[0..2] of char;
    n	   : byte;
begin
  if Data = NIL then begin        { Adds possible fontsizes to Sizecollection }
    if Odd(FontType) then begin   { This kind of font cant be scaled }
      Str((LogFont.lfHeight-TextMetrics.tmInternalLeading+1) DIV 2:2, SizeStr);
      StrPCopy(PStr,SizeStr);
      FntSizColl^.Insert(StrNew(PStr));
    end
    else FOR N := 0 TO 9 DO BEGIN
      Str(SizeArray[N]:2, SizeStr);  { This kind of font can be scaled }
      StrPCopy(PStr,SizeStr);
      FntSizColl^.Insert(StrNew(PStr));
    end;
    ALogFont:= LogFont;
  end
  else begin                     { Last call of this function to bring
  				   out the selected Logfont }
    IF Odd(FontType) THEN BEGIN
      EnumFontSizes:= 0;
      Data^.Font^ := LogFont;    { Counts until selected size is found
      				   and then returns font }
      IF (LogFont.lfHeight-TextMetrics.tmInternalLeading+1) DIV 2 >= Data^.FontSize THEN Exit
    END
    ELSE BEGIN
      EnumFontSizes:= 0;         { Scales size and then returns new font }
      N := (Data^.FontSize * 2) + TextMetrics.tmInternalLeading - 1;
      LogFont.lfWidth  := (LogFont.lfWidth * N) DIV LogFont.lfHeight;
      LogFont.lfHeight := N;
      Data^.Font^ := LogFont;
      Exit;
    END;
  end;
  EnumFontSizes:= 1;
end;

VAR EnumNameFuncPtr: TFarProc;
    EnumSizeFuncPtr: TFarProc;

TYPE
  PFontDialog = ^TFontDialog;
  TFontDialog = OBJECT(TDialog)
    FontName   : array[0..lf_FaceSize] of char; { Name of selected font }
    FontSize   : Integer;		        { Selected font size    }
    Gr     : Integer;    { only needed, if wanted size is contained in Sizecollection }
    DC: HDC;             			{ PrintDC or ScreenDC }
    CB1,CB2: PCombobox;  			{ CB1 for Name, CB2 for Size }
    CONSTRUCTOR Init (AParent: PWindowsObject; AName: PChar; ADC: HDC);
    Destructor Done; virtual;
    PROCEDURE SetUpWindow; VIRTUAL;
    PROCEDURE idFontName (VAR Msg: TMessage); VIRTUAL id_First + id_FontName;
    PROCEDURE idFontSize (VAR Msg: TMessage); VIRTUAL id_First + id_FontSize;
    PROCEDURE ok(VAR Msg: TMessage); VIRTUAL id_First + id_Ok;
  END;

CONSTRUCTOR TFontDialog.Init ( AParent: PWindowsObject;
                               AName: PChar; ADC: HDC);
  BEGIN
    TDialog.Init(AParent, AName);
    FntNamColl:= New(PFontNameCollection,Init(1,1));
    FntSizColl:= New(PFontSizeCollection,Init(1,1));
    CB1:= New(PComboBox,Initresource(@Self,id_FontName,lf_FaceSize));
    CB2:= New(PComboBox,Initresource(@Self,id_FontSize,3));
    DC := ADC;
    Gr:= 0;   { if normal Size is selected, GR will stay 0 }
  END;

Destructor TFontDialog.Done;
begin
  Dispose(FntNamColl,Done);
  Dispose(FntSizColl,Done);
  TDialog.Done;
end;

PROCEDURE TFontDialog.SetUpWindow;
var S: STRING;
    i,Error: INTEGER;
    FontSze: array[0..10] of char;
  BEGIN
    TDialog.SetUpWindow;

    { Fills Collection of Fontnames }

    EnumNameFuncPtr := MakeProcInstance(@EnumFontNames, HInstance);
    EnumFonts(DC, NIL, EnumNameFuncPtr, FntNamColl);
    FreeProcInstance(EnumNameFuncPtr);

    { Transfers List of names into Combobox1 }

    For i:= 0 to FntNamColl^.Count-1 do begin
      StrCopy(FontName,FntNamColl^.At(i));
      CB1^.Addstring(StrNew(FontName));
    end;

    { Selects first item of list }

    SendDlgItemMsg(id_FontName, cb_SetCurSel, 0, 0);
    SendDlgItemMsg(id_FontName, cb_GetLBText, 0, LONGINT(@FontName));

    { Fills Collection of Fontsizes matching to selected Fontname }

    EnumSizeFuncPtr := MakeProcInstance(@EnumFontSizes, HInstance);
    EnumFonts(DC, FontName, EnumSizeFuncPtr, NIL);
    FreeProcInstance(EnumSizeFuncPtr);

    { Transfers list of names into Combobox2 }

    For i:= 0 to FntSizColl^.Count - 1 do begin
      StrCopy(FontSze,FntSizColl^.At(i));
      CB2^.Addstring(StrNew(FontSze));
    end;

    { Selects first item of Sizelist }

    SendDlgItemMsg(id_FontSize, cb_SetCurSel, 0, 0);
    SendDlgItemMsg(id_FontSize, cb_GetLBtext, 0, LONGINT(@S[1]));
    S[0] := CHR(StrLen(@S[1]));
    Val(S, FontSize, Error);
  END;

PROCEDURE TFontDialog.idFontName(VAR Msg: TMessage);
  VAR i,Error, Index: INTEGER;
      S: STRING;
      FontSze: array[0..10] of char;
  BEGIN
    CASE Msg.LParamHi OF
      cbn_SelChange: BEGIN

        { if Selection of Fontnameslist has changed }

        Index := SendDlgItemMsg(id_FontName, cb_GetCurSel, 0, 0);
        SendDlgItemMsg(id_FontName, cb_GetLBtext, Index, LONGINT(@FontName));

        { Close old list of fontsizes }

        FntSizColl^.FreeAll;
        SendDlgItemMsg(id_FontSize, cb_ResetContent, 0, 0);

        { Fill Collection with sizes matching to new selected Fontname }

        EnumSizeFuncPtr := MakeProcInstance(@EnumFontSizes, HInstance);
        EnumFonts(DC, FontName, EnumSizeFuncPtr, NIL);
        FreeProcInstance(EnumSizeFuncPtr);

        { Transfer new sizes to Combobox2 }

        For i:= 0 to FntSizColl^.Count - 1 do begin
          StrCopy(FontSze,FntSizColl^.At(i));
          CB2^.Addstring(StrNew(FontSze));
        end;

        { Select first item of new sizelist }

        SendDlgItemMsg(id_FontSize, cb_SetCurSel, 0, 0);
        SendDlgItemMsg(id_FontSize, cb_GetLBtext, 0, LONGINT(@S[1]));
        S[0] := CHR(StrLen(@S[1]));
        Val(S, FontSize, Error);
      END;
    END;
  END;

PROCEDURE TFontDialog.idFontSize(VAR Msg: TMessage);
  VAR Error, Index: INTEGER;
      S: STRING;
      Selection: array[0..3] of char;
  BEGIN
    CASE Msg.LParamHi OF
      cbn_Killfocus: begin

                       { Number can differ from all Items in Sizelist
                         if you enter it using your keyboard }

      		       GetDlgItemText(HWindow,id_FontSize,Selection,3);
                       Val(StrPas(Selection),Fontsize,Error);
                     end;
      cbn_SelChange: BEGIN

                       { Number can be selected from Sizelist }

                       Index := SendDlgItemMsg(id_FontSize, cb_GetCurSel, 0, 0);
        	       SendDlgItemMsg(id_FontSize, cb_GetLBtext, Index, LONGINT(@S[1]));
        	       S[0] := CHR(StrLen(@S[1]));
        	       Val(S, FontSize, Error);
      		     END;
    END;
  END;

PROCEDURE TFontDialog.Ok (VAR Msg: TMessage);
var Data: TData;
    tm: ttextmetric;
    fnt: hfont;
  BEGIN
    TDialog.Ok(Msg);

    { Prepare Fontname and Fontsize for transfer into Callback-Function }

    Data.FontSize := FontSize;
    Data.Font:= @ALogFont;

    { Last call of Callback-Function to get back the Logfont and the size }

    EnumSizeFuncPtr := MakeProcInstance(@EnumFontSizes, HInstance);
    EnumFonts(DC, FontName, EnumSizeFuncPtr, @Data);
    ALogFont:= Data.Font^;
    FreeProcInstance(EnumSizeFuncPtr);

    { If you wish a fontsize, that is not in Sizecollection, the calling
      program must know, that a new TLogfont must be created. For this
      GR must differ from 0 }

    IF (Data.Font^.lfHeight+1) DIV 2 < FontSize then begin
      gr:= FontSize * 2;
    end
    else gr:= 0;
  END;

FUNCTION FontDialog (AParent: PWindowsObject; ADC: HDC;
                     VAR Font: TLogFont; var Grx: Integer): Boolean;
  VAR Dialog: PFontDialog;
  BEGIN
    FontDialog := false;
    Dialog := New(PFontDialog, Init(AParent, 'FontDialog', ADC));
    IF Dialog^.Execute = id_Ok THEN BEGIN
      Font := ALogFont;    { TLogfont, that is returned to calling program }
      Grx:= Dialog^.gr;    { Returned size, if size differs from usual sizes }
      FontDialog:= true;
    END;
    Dispose(Dialog, Done);
  END;

END.
