{**********************************************************}
{*                                                        *}
{*  Unit to check Inputs before Saving, TP for Windows    *}
{*                                                        *}
{*  Main idea by Ralph Machholz, Alfred Ertl in their     *}
{*  book 'Turbo Pascal 6.0, Turbo Vision, Addison+Wesley' *}
{*  Transferred to Turbo Pascal for Windows and modified  *}
{*  by Kurt Bertram Compuserve [100031,3373]              *}
{*                                                        *}
{*  All inputs are validated immediately after input.     *)
{*  The Editor's dialog is notified of any changes, so    *}
{*  that the variable ISDIRTY can be changed.             *}
{*                                                        *}
{**********************************************************}

Unit MyInpt;

Interface

uses WObjects,Wintypes;

const
  wm_EditChanged                = 503;
  wm_ShowList			= 504;

type
  PMyRadio = ^TMyRadio;
  TMyRadio = object(TRadioButton)
    procedure BNClicked(var Msg: TMessage); virtual nf_First + bn_Clicked;
  end;

  PMyEdit = ^TMyEdit;
  TMyEdit = object(TEdit)
    procedure wmKillFocus(var Msg: TMessage); virtual wm_First + wm_KillFocus;
  end;

  PCheckEdit = ^TCheckEdit;
  TCheckEdit = object(TMyEdit)
    MinLen: Byte;
    constructor InitResource(AParent: PWindowsObject; ResourceID, AMinLen, ATextLen: Word);
    Function CanClose: Boolean; Virtual;
  end;

  PNameEdit = ^TNameEdit;
  TNameEdit = object(TCheckEdit)
    Function CanClose: Boolean; Virtual;
  end;

  PPlzEdit = ^TPlzEdit;
  TPlzEdit = object(TCheckEdit)
    Procedure wmRButtonDown(var msg:TMessage); virtual wm_First + wm_RButtonDown;
    Procedure wmKeyDown(var msg: TMessage); virtual wm_First + wm_KeyDown;
  end;

  PNumEdit = ^TNumEdit;
  TNumEdit = object(TMyEdit)
    MinValue, MaxValue: Longint;
    constructor Init(AParent: PWindowsObject; AnId: Integer;
      ATitle: PChar; X, Y, W, H: Integer; Digits: Word;
      AMinValue, AMaxValue: Longint);
    constructor InitResource(AParent: PWindowsObject; ResourceID: Word;
      Digits: Word; AMinValue, AMaxValue: Longint);
    function CanClose: Boolean; virtual;
    function Transfer(DataPtr: Pointer; TransferFlag: Word): Word; virtual;
  end;

implementation

uses WinProcs,strings,BWCC;

var Tstr: STring;

{ TMyRadio }

Procedure TMyRadio.BNClicked(var Msg: TMessage);
begin                { if the Button is clicked, the Editdialog will be notified of changes }
  DefWndProc(Msg);   { by sending the wm_editchanged-message.                               }
  SendMessage(Parent^.HWindow,wm_EditChanged,GetId,0);
  Msg.Result:= 1;
end;

{ TMyEdit }

Procedure TMyEdit.WMKillFocus(var Msg: TMessage);
begin
  DefWndProc(Msg);   { if Text has changed, the Editdialog will be notified of changes, as }
  	             { soon as you leave this inputline.                                   }
  if IsModified then SendMessage(Parent^.HWindow,wm_EditChanged,GetId,0);
  Msg.Result:= 1;
end;

{ TCheckEdit }

Constructor TCheckEdit.InitResource(AParent: PWindowsObject; ResourceID, AMinLen, ATextLen: Word);
begin
  TMyEdit.InitResource(AParent,ResourceId,ATextLen);
  MinLen:= AMinLen;
end;

Function TCheckEdit.CanClose: Boolean;
var
  Len  : Integer;
  Text : array[0..255] of Char;
  Valid: Boolean;
begin
  GetText(Text, SizeOf(Text));
  Len := StrLen(Text);           { if your input is shorter than MinLen, }
  Valid:= (Len >= MinLen);       { you can't leave the editor            }
  if not Valid then
  begin
    SetSelection(0, MaxInt);
    SetFocus(HWindow);
  end;
  CanClose := Valid;
end;

{ TNameEdit }

function TNameEdit.CanClose: Boolean;
const
  CharSet = ['a'..'z','A'..'Z','','','','','','','',' ','.','-'];
var
  I, Len: Integer;
  Text: array[0..255] of Char;
  Valid: Boolean;
begin
  GetText(Text, SizeOf(Text));
  I := 0;
  Len := StrLen(Text);            { if your text is shorter than MinLen   }
  Valid := (Len >= MinLen);       { or any digits or characters, that are }
  while Valid and (I < Len) do    { not allowed are found in the text,    }
  begin                           { you can't leave the editor.           }
    Valid := Text[I] in CharSet;
    Inc(I);
  end;
  if not Valid then
  begin
    SetSelection(0, MaxInt);
    SetFocus(HWindow);
  end;
  CanClose := Valid;
end;

{ TPlzEdit }

Procedure TPlzEdit.wmKeyDown(var msg: TMessage);{ not used in this example }
var ts    : array[0..25] of char;
    altstr: string;                 { This function enables you to open a  }
begin                               { Listbox of Cities and City-Numbers   }
  if Msg.wParam = vk_F2 then begin  { if such a Table is implemented.      }
    GetText(ts,TextLen);            { If you press F2 or the right MouseBtn}
    tstr:= StrPas(ts);              { the Edit-dialog will be notified by  }
    altstr:= tstr;                  { wm_Showlist-Message.                 }
    SendMessage(Parent^.HWindow,wm_ShowList,0,0);
    if (length(tstr) > 0) and (tstr <> altstr) then begin
      StrPCopy(ts,Tstr+' ');
      SetText(ts);
      setselection(strlen(ts)-1,strlen(ts));
      Cut;
    end;
    Msg.Result:= 1;
  end
  else DefWndProc(msg);
end;

Procedure TPlzEdit.wmRButtonDown(var msg:TMessage); { see wm_keydown }
var ts    : array[0..25] of char;
    altstr: string;
begin
  SetFocus(HWindow);
  GetText(ts,TextLen);
  Tstr:= strpas(ts);
  altstr:= tstr;
  SendMessage(Parent^.HWindow,wm_ShowList,0,0);
  if (length(tstr) > 0) and (tstr <> altstr) then begin
    StrPCopy(ts,Tstr+' ');
    SetText(ts);
    setselection(strlen(ts)-1,strlen(ts));
    cut;
  end;
end;

{ TNumEdit }

constructor TNumEdit.Init(AParent: PWindowsObject; AnId: Integer;
  ATitle: PChar; X, Y, W, H: Integer; Digits: Word;
  AMinValue, AMaxValue: Longint);
begin
  TMyEdit.Init(AParent, AnId, ATitle, X, Y, W, H, Digits + 1, False);
  MinValue := AMinValue;
  MaxValue := AMaxValue;
end;

constructor TNumEdit.InitResource(AParent: PWindowsObject;
  ResourceID: Word; Digits: Word; AMinValue, AMaxValue: Longint);
begin
  TMyEdit.InitResource(AParent, ResourceID, Digits + 1);
  MinValue := AMinValue;
  MaxValue := AMaxValue;
end;

function TNumEdit.CanClose: Boolean;
var
  Valid: Boolean;
  ValCode: Integer;
  Value: LongInt;
  Text: array[0..15] of Char;
  Msg: array[0..63] of Char;
begin
  GetText(Text, SizeOf(Text));   { if your input is less than MinValue }
  Val(Text, Value, ValCode);     { or greater than MaxValue, you can't }
  Valid := (ValCode = 0) and     { leave the editor.                   }
    (Value >= MinValue) and (Value <= MaxValue);
  if not Valid then
  begin
    WVSPrintF(Msg, 'Digit must be between %ld and %ld .', MinValue);
    BWCCMessageBox(HWindow, Msg, 'NumInput', mb_Ok or mb_IconStop);
    SetSelection(0, MaxInt);
    SetFocus(HWindow);
  end;
  CanClose := Valid;
end;

function TNumEdit.Transfer(DataPtr: Pointer; TransferFlag: Word): Word;
var
  ValCode: Integer;
  Text: array[0..15] of Char;
begin
  case TransferFlag of
    tf_GetData:
      begin
        GetText(Text, SizeOf(Text));
        Val(Text, Longint(DataPtr^), ValCode);
      end;
    tf_SetData:
      begin
        Str(Longint(DataPtr^), Text);
        SetText(Text);
      end;
  end;
  Transfer := SizeOf(Longint);
end;

begin
end.