/*--------------------------------*\
| Additions for UNIX-compatibility |
\*--------------------------------*/
#ifdef __unix__

 #include "7plus.h"

 /*
 * mktime function from GNU C library V1.03; modified:
 * - expanded DEFUN and CONST macros from ansidecl.h
 * - inserted __isleap macro from time.h
 * - inserted __mon_lengths array and __offtime function from offtime.c
 * - inserted gmtime function from gmtime.c
 * - commented out call of localtime function
 * Be aware of the following copyright message for mktime !!!
 */

 /* Copyright (C) 1991 Free Software Foundation, Inc.
 This file is part of the GNU C Library.

 The GNU C Library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License as
 published by the Free Software Foundation; either version 2 of the
 License, or (at your option) any later version.

 The GNU C Library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with the GNU C Library; see the file COPYING.LIB.  If
 not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 Cambridge, MA 02139, USA.  */

 #include <errno.h>
 #include <limits.h>
 #include <time.h>


 /* How many days are in each month.  */
 const unsigned short int __mon_lengths[2][12] =
   {
     /* Normal years.  */
     { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 },
     /* Leap years.  */
     { 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 }
   };

 #define  __isleap(year)  \
   ((year) % 4 == 0 && ((year) % 100 != 0 || (year) % 400 == 0))

 #define  invalid()  return (time_t) -1


 #define  SECS_PER_HOUR  (60 * 60)
 #define  SECS_PER_DAY  (SECS_PER_HOUR * 24)

 /* Returns the `struct tm' representation of *T,
    offset OFFSET seconds east of UCT.  */
 struct tm *
 __offtime (const time_t *t, long int offset)
 {
   static struct tm tbuf;
   register long int days, rem;
   register int y;
   register const unsigned short int *ip;

   if (t == NULL)
     return NULL;

   days = *t / SECS_PER_DAY;
   rem = *t % SECS_PER_DAY;
   rem += offset;
   while (rem < 0)
   {
     rem += SECS_PER_DAY;
     --days;
   }
   while (rem >= SECS_PER_DAY)
   {
     rem -= SECS_PER_DAY;
     ++days;
   }
   tbuf.tm_hour = rem / SECS_PER_HOUR;
   rem %= SECS_PER_HOUR;
   tbuf.tm_min = rem / 60;
   tbuf.tm_sec = rem % 60;
   /* January 1, 1970 was a Thursday.  */
   tbuf.tm_wday = (4 + days) % 7;
   if (tbuf.tm_wday < 0)
     tbuf.tm_wday += 7;
   y = 1970;
   while (days >= (rem = __isleap(y) ? 366 : 365))
   {
     ++y;
     days -= rem;
   }
   while (days < 0)
   {
     --y;
     days += __isleap(y) ? 366 : 365;
   }
   tbuf.tm_year = y - 1900;
   tbuf.tm_yday = days;
   ip = __mon_lengths[__isleap(y)];
   for (y = 0; days >= ip[y]; ++y)
     days -= ip[y];
   tbuf.tm_mon = y;
   tbuf.tm_mday = days + 1;
   tbuf.tm_isdst = -1;

   return &tbuf;
 }


 /* Return the `struct tm' representation of *T in UTC.  */
 struct tm *
 gmtime (const time_t *t)
 {
   return __offtime(t, 0L);
 }


 /* Return the `time_t' representation of TP and normalizes TP.
    Return (time_t) -1 if TP is not representable as a `time_t'.
    Note that 31 Dec 1969 23:59:59 is not representable
    because it is represented as (time_t) -1.  */
 time_t mktime (register struct tm *tp)
 {
   static struct tm min, max;
   static char init = 0;

   register time_t result;
   register time_t t;
   register int i;
   register const unsigned short *l;
   register struct tm *new;
   time_t end;

   if (tp == NULL)
   {
     errno = EINVAL;
     invalid();
   }

   if (!init)
   {
     init = 1;
     end = (time_t) LONG_MIN;
     new = gmtime(&end);
     if (new != NULL)
       min = *new;
     else
       min.tm_sec = min.tm_min = min.tm_hour =
     min.tm_mday = min.tm_mon = min.tm_year = INT_MIN;

     end = (time_t) LONG_MAX;
     new = gmtime(&end);
     if (new != NULL)
       max = *new;
     else
       max.tm_sec = max.tm_min = max.tm_hour =
     max.tm_mday = max.tm_mon = max.tm_year = INT_MAX;
   }

   /* Make all the elements of TP that we pay attention to
      be within the ranges of reasonable values for those things.  */
   #define  normalize(elt, min, max, nextelt)\
   while (tp->elt < min)                     \
   {                                         \
     --tp->nextelt;                          \
     tp->elt += max + 1;                     \
   }                                         \
   while (tp->elt > max)                     \
   {                                         \
     ++tp->nextelt;                          \
     tp->elt -= max + 1;                     \
   }

   normalize (tm_sec, 0, 59, tm_min);
   normalize (tm_min, 0, 59, tm_hour);
   normalize (tm_hour, 0, 24, tm_mday);

   /* Normalize the month first so we can use
      it to figure the range for the day.  */
   normalize (tm_mon, 0, 11, tm_year);
   normalize (tm_mday, 1, __mon_lengths[__isleap (tp->tm_year)][tp->tm_mon],
     tm_mon);

   /* Normalize the month again, since normalizing
      the day may have pushed it out of range.  */
   normalize (tm_mon, 0, 11, tm_year);

   /* Normalize the day again, because normalizing
      the month may have changed the range.  */
   normalize (tm_mday, 1, __mon_lengths[__isleap (tp->tm_year)][tp->tm_mon],
     tm_mon);

  /* Check for out-of-range values.  */
  #define  lowhigh(field, minmax, cmp)  (tp->field cmp minmax.field)
  #define  low(field)                   lowhigh(field, min, <)
  #define  high(field)                  lowhigh(field, max, >)
  #define  oor(field)                   (low(field) || high(field))
  #define  lowbound(field)              (tp->field == min.field)
  #define  highbound(field)             (tp->field == max.field)
  if (oor(tm_year))
    invalid();
  else
    if (lowbound(tm_year))
    {
      if (low(tm_mon))
        invalid();
      else
        if (lowbound(tm_mon))
        {
          if (low(tm_mday))
            invalid();
          else
            if (lowbound(tm_mday))
            {
              if (low(tm_hour))
                invalid();
              else
                if (lowbound(tm_hour))
                {
                  if (low(tm_min))
                    invalid();
                  else
                    if (lowbound(tm_min))
                    {
                      if (low(tm_sec))
                      invalid();
                    }
                }
            }
        }
    }
    else
      if (highbound(tm_year))
      {
        if (high(tm_mon))
          invalid();
        else
          if (highbound(tm_mon))
          {
            if (high(tm_mday))
              invalid();
            else
              if (highbound(tm_mday))
              {
                if (high(tm_hour))
                  invalid();
                else
                  if (highbound(tm_hour))
                  {
                    if (high(tm_min))
                      invalid();
                    else
                      if (highbound(tm_min))
                      {
                        if (high(tm_sec))
                        invalid();
                      }
                  }
              }
          }
      }
   t = 0;
   for (i = 1970; i > 1900 + tp->tm_year; --i)
     t -= __isleap(i) ? 366 : 365;
   for (i = 1970; i < 1900 + tp->tm_year; ++i)
     t += __isleap(i) ? 366 : 365;
   l = __mon_lengths[__isleap(1900 + tp->tm_year)];
   for (i = 0; i < tp->tm_mon; ++i)
     t += l[i];
   t += tp->tm_mday - 1;
   result = ((t * 60 * 60 * 24) +
            (tp->tm_hour * 60 * 60) +
            (tp->tm_min * 60) +
             tp->tm_sec);

   end = result;
  #if 0
   if (tp->tm_isdst < 0)
     new = localtime(&end);
   else
  #endif
     new = gmtime(&end);
   if (new == NULL)
     invalid();
   new->tm_isdst = tp->tm_isdst;
   *tp = *new;

   return result;
 }

 #ifdef __vax__
  char *strdup (const char *s1)
  { char *s;

    s = malloc (strlen(s1) + 1);
    strcpy (s , s1);
    return (s);
  }
 #endif /* __vax__ */

 static int first = 1;

 int my_getch()
 {
   unsigned char c;
   int fd;

   fd = fileno (stdin);
   if (first)
   {
     first = 0;
    #ifdef SYSV
     (void) ioctl(fd, TCGETA, (char *) &sg[OFF]);
    #else
     (void) gtty(fd, &sg[OFF]);
    #endif
     sg[ON] = sg[OFF];

    #ifdef SYSV
     sg[ON].c_lflag &= ~(ICANON|ECHO);
     sg[ON].c_cc[VMIN] = 1;
     sg[ON].c_cc[VTIME] = 0;
    #else
     sg[ON].sg_flags &= ~(ECHO | CRMOD);
     sg[ON].sg_flags |= CBREAK;
    #endif
   }

  #ifdef SYSV
   (void) ioctl(fd, TCSETAW, (char *) &sg[ON]);
  #else
   (void) stty(fd, &sg[ON]);
  #endif

   read(fd, &c, 1);

  #ifdef SYSV
   (void) ioctl(fd, TCSETAW, (char *) &sg[OFF]);
  #else
   (void) stty(fd, &sg[OFF]);
  #endif

   return (int) c;
 }

 #ifdef __i386__
  #define MAXCMD 1024

  int rename (const char *s1, const char *s2)
  {
    char tmp[MAXCMD];

    (void) sprintf(tmp, "mv %s %s", s1, s2);
    return (system(tmp));
  }

  /*
    strstr - public-domain implementation of standard C library function

    last edit:  02-Sep-1990  D A Gwyn

    This is an original implementation based on an idea by D M Sunday,
    essentially the "quick search" algorithm described in CACM V33 N8.
    Unlike Sunday's implementation, this one does not wander past the
    ends of the strings (which can cause malfunctions under certain
    circumstances), nor does it require the length of the searched
    text to be determined in advance.  There are numerous other subtle
    improvements too.  The code is intended to be fully portable, but in
    environments that do not conform to the C standard, you should check
    the sections below marked "configure as required".  There are also
    a few compilation options, as follows:

    #define ROBUST  to obtain sane behavior when invoked with a null
        pointer argument, at a miniscule cost in speed
    #define ZAP  to use memset() to zero the shift[] array; this may
        be faster in some implementations, but could fail on
        unusual architectures
    #define DEBUG  to enable assertions (bug detection)
  */
  #define ROBUST
  #define ZAP

  #ifdef __STDC__
   #include  <limits.h>    /* defines UCHAR_MAX */

   #ifdef ZAP
    typedef void  *pointer;
    extern pointer  memset( pointer, int, size_t );
   #endif

  #else  /* normal UNIX-like C environment assumed; configure as required: */

   typedef unsigned  size_t;  /* type of result of sizeof */

   #ifndef NULL
    #define  NULL    0    /* null pointer constant */
   #endif

   #define  UCHAR_MAX  255    /* largest value of unsigned char */
                              /* 255 @ 8 bits, 65535 @ 16 bits  */

   #ifdef ZAP
    typedef char  *pointer;
    extern pointer  memset();
   #endif

   #define const  /* nothing */

  #endif  /* __STDC__ */

  #ifndef DEBUG
   #define  NDEBUG
  #endif

  #include <assert.h>

  typedef const unsigned char  cuc;  /* char variety used in algorithm */

  #define EOS  '\0'      /* C string terminator */

  char *          /* returns -> leftmost occurrence,
                     or null pointer if not present */
  strstr( s1, s2 )
    const char  *s1;       /* -> string to be searched */
    const char  *s2;       /* -> search-pattern string */
  {
    register cuc  *t;      /* -> text character being tested */
    register cuc  *p;      /* -> pattern char being tested */
    register cuc  *tx;     /* -> possible start of match */
    register size_t  m;    /* -> length of pattern */
    register cuc  *top;    /* -> high water mark in text */
  #if UCHAR_MAX > 255      /* too large for auto allocation */
    static        /* not malloc()ed; that can fail! */
  #endif          /* else allocate shift[] on stack */
      size_t  shift[UCHAR_MAX + 1];  /* pattern shift table */

  #ifdef ROBUST        /* not required by C standard */
    if ( s1 == NULL || s2 == NULL )
      return NULL;    /* certainly, no match is found! */
  #endif

    /* Precompute shift intervals based on the pattern;
       the length of the pattern is determined as a side effect: */

  #ifdef ZAP
    (void)memset( (pointer)&shift[1], 0, UCHAR_MAX * sizeof(size_t) );
  #else
    {
    register unsigned char  c;

    c = UCHAR_MAX;
    do
      shift[c] = 0;
    while ( --c > 0 );
    }
  #endif /* ZAP */
    /* Note: shift[0] is undefined at this point (fixed later). */

    for ( m = 1, p = (cuc *)s2; *p != EOS; ++m, ++p )
      shift[(cuc)*p] = m;

    assert(s2[m - 1] == EOS);

    {
    register unsigned char  c;

    c = UCHAR_MAX;
    do
      shift[c] = m - shift[c];
    while ( --c > 0 );

    /* Note: shift[0] is still undefined at this point. */
    }

    shift[0] = --m;    /* shift[EOS]; important details! */

    assert(s2[m] == EOS);

    /* Try to find the pattern in the text string: */

    for ( top = tx = (cuc *)s1; ; tx += shift[*(top = t)] )
    {
      for ( t = tx, p = (cuc *)s2; ; ++t, ++p )
      {
        if ( *p == EOS )       /* entire pattern matched */
          return (char *)tx;

        if ( *p != *t )
          break;
      }

      if ( t < top )    /* idea due to ado@elsie.nci.nih.gov */
        t = top;  /* already scanned this far for EOS */

      do
      {
        assert(m > 0);
        assert(t - tx < m);

        if ( *t == EOS )
          return NULL;  /* no match */
      }
      while ( ++t - tx != m );  /* < */
    }
  }
 #endif /* __i386__ */
#endif /* __unix__ */
