VERSION 2.00
Begin Form PZDemo 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Demo of Pizazz 1.5 Custom Control"
   ClientHeight    =   4680
   ClientLeft      =   2025
   ClientTop       =   3780
   ClientWidth     =   8025
   FillStyle       =   0  'Solid
   Height          =   5085
   Left            =   1965
   LinkTopic       =   "Form2"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4680
   ScaleWidth      =   8025
   Top             =   3435
   Width           =   8145
   Begin PZPanel MainPan 
      BackColor       =   &H00FF0000&
      BevelOuter      =   1  'Inset
      BevelOuterShading=   3  'Frame
      BevelOuterWidth =   1
      ButtonUp        =   -1  'True
      GradientStyle   =   1  'Vertical
      Height          =   3945
      Left            =   0
      Picture         =   PZDEMO.FRX:0000
      TabIndex        =   0
      Top             =   0
      Width           =   8085
      Begin PZPanel BigPan 
         Alignment       =   6  'Center - TOP
         BackColor       =   &H00808080&
         BevelInner      =   2  'Raised
         BevelOuter      =   1  'Inset
         BorderOuter     =   1  'Solid
         ButtonUp        =   -1  'True
         Caption         =   "Make controls with gradients or textures"
         CornerBackColor =   &H00800000&
         Font3D          =   2  'Block Right
         Font3DColor     =   &H00404040&
         Font3DSize      =   2
         FontBold        =   -1  'True
         FontItalic      =   0   'False
         FontName        =   "Times New Roman"
         FontSize        =   17.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         ForeColor       =   &H00C0C0C0&
         GradientColor   =   &H000080FF&
         GradientStyle   =   5  'Vertical Centered
         Height          =   3765
         Icon            =   PZDEMO.FRX:043E
         IconLeft        =   148
         IconTop         =   122
         Left            =   90
         Picture         =   PZDEMO.FRX:0740
         TabIndex        =   19
         Top             =   10060
         Width           =   7845
         WordWrap        =   -1  'True
         Begin PZLabel PZLabel1 
            Alignment       =   0  'Left Justify - TOP
            BackStyle       =   0  'Transparent
            ButtonUp        =   -1  'True
            Caption         =   "Click here to change panel settings ........"
            FontBold        =   -1  'True
            FontItalic      =   -1  'True
            FontName        =   "MS Sans Serif"
            FontSize        =   8.25
            FontStrikethru  =   0   'False
            FontUnderline   =   0   'False
            ForeColor       =   &H00FF0000&
            Height          =   405
            Left            =   390
            TabIndex        =   21
            Top             =   1950
            Width           =   1875
            WordWrap        =   -1  'True
         End
         Begin PZLabel PZBut 
            BackColor       =   &H00C0C0C0&
            BevelInner      =   1  'Inset
            BevelInnerWidth =   1
            BevelOuter      =   2  'Raised
            BevelOuterWidth =   3
            BorderInner     =   1  'Solid
            BorderInnerColor=   &H00C0C000&
            BorderInnerWidth=   4
            BorderOuter     =   1  'Solid
            BorderOuterColor=   &H00404040&
            BorderOuterWidth=   2
            ButtonUp        =   -1  'True
            Caption         =   "and tabs"
            CornerSize      =   4
            Font3D          =   1  'Block Left
            Font3DSize      =   2
            FontBold        =   -1  'True
            FontItalic      =   0   'False
            FontName        =   "Times New Roman"
            FontSize        =   15
            FontStrikethru  =   0   'False
            FontUnderline   =   0   'False
            ForeColor       =   &H00800000&
            Height          =   675
            Index           =   1
            Left            =   2850
            PictureStyle    =   3  'Tiled
            TabIndex        =   2
            TabStyle        =   3  'Bottom Tab
            Top             =   1800
            Width           =   2115
            WordWrap        =   -1  'True
         End
         Begin PZLabel PZBut 
            Alignment       =   9  'Center Offset - TOP
            BackColor       =   &H00C0C0C0&
            BevelInner      =   1  'Inset
            BevelInnerWidth =   1
            BevelOuter      =   2  'Raised
            BevelOuterWidth =   3
            BorderInner     =   1  'Solid
            BorderInnerColor=   &H00C0C000&
            BorderInnerWidth=   4
            BorderOuter     =   3  'Shadow
            BorderOuterColor=   &H00404040&
            BorderOuterWidth=   4
            ButtonUp        =   -1  'True
            Caption         =   "Make buttons with labels"
            CaptionMargin   =   10
            CornerSize      =   4
            Font3D          =   1  'Block Left
            Font3DSize      =   2
            FontBold        =   -1  'True
            FontItalic      =   0   'False
            FontName        =   "Times New Roman"
            FontSize        =   22.5
            FontStrikethru  =   0   'False
            FontUnderline   =   0   'False
            ForeColor       =   &H00800000&
            Height          =   1395
            Index           =   0
            Left            =   2160
            Picture         =   PZDEMO.FRX:0B7E
            PictureStyle    =   3  'Tiled
            TabIndex        =   1
            Top             =   510
            Width           =   3390
            WordWrap        =   -1  'True
         End
         Begin PZLabel SignLab 
            BackColor       =   &H0000FFFF&
            BevelInner      =   2  'Raised
            BevelOuter      =   2  'Raised
            BevelOuterShading=   2  'Dark
            BevelOuterWidth =   1
            ButtonUp        =   -1  'True
            Caption         =   " MAKE SIGNS"
            CornerSize      =   45
            FontBold        =   -1  'True
            FontItalic      =   0   'False
            FontName        =   "Times New Roman"
            FontSize        =   12
            FontStrikethru  =   0   'False
            FontUnderline   =   0   'False
            ForeColor       =   &H00004000&
            Height          =   1365
            Index           =   0
            Left            =   420
            TabIndex        =   3
            Top             =   570
            Width           =   1395
            WordWrap        =   -1  'True
         End
         Begin PZLabel SignLab 
            Alignment       =   10  'Center Offset - MIDDLE
            BackColor       =   &H000000FF&
            BevelInner      =   2  'Raised
            BevelOuter      =   2  'Raised
            BevelOuterShading=   2  'Dark
            BevelOuterWidth =   1
            ButtonUp        =   -1  'True
            Caption         =   "DON'T STOP!"
            CaptionMargin   =   8
            CornerSize      =   24
            FontBold        =   -1  'True
            FontItalic      =   0   'False
            FontName        =   "MS Sans Serif"
            FontSize        =   13.5
            FontStrikethru  =   0   'False
            FontUnderline   =   0   'False
            ForeColor       =   &H00FFFFFF&
            Height          =   1305
            Index           =   1
            Left            =   6000
            TabIndex        =   4
            Top             =   570
            Width           =   1395
            WordWrap        =   -1  'True
         End
         Begin PZLabel VCRLab 
            Alignment       =   6  'Center - TOP
            BackColor       =   &H00C0C0C0&
            BevelInner      =   2  'Raised
            BevelOuter      =   2  'Raised
            BevelOuterShading=   1  'Light
            BevelOuterWidth =   3
            BorderInner     =   1  'Solid
            BorderInnerWidth=   2
            BorderOuter     =   1  'Solid
            ButtonUp        =   -1  'True
            Caption         =   "Groups"
            CornerSize      =   4
            Font3D          =   4  'Drop Right
            FontBold        =   -1  'True
            FontItalic      =   0   'False
            FontName        =   "MS Sans Serif"
            FontSize        =   9.75
            FontStrikethru  =   0   'False
            FontUnderline   =   0   'False
            ForeColor       =   &H00800080&
            Height          =   915
            Icon            =   PZDEMO.FRX:1170
            IconLeft        =   22
            IconTop         =   10
            Index           =   1
            Left            =   2580
            PictureStyle    =   3  'Tiled
            TabIndex        =   6
            TabStyle        =   9  'No Horz. Side
            Top             =   2610
            Width           =   1335
         End
         Begin PZLabel VCRLab 
            Alignment       =   6  'Center - TOP
            BackColor       =   &H00C0C0C0&
            BevelInner      =   2  'Raised
            BevelOuter      =   2  'Raised
            BevelOuterShading=   1  'Light
            BevelOuterWidth =   3
            BorderInner     =   1  'Solid
            BorderInnerWidth=   2
            BorderOuter     =   1  'Solid
            ButtonUp        =   -1  'True
            Caption         =   "Make"
            CornerSize      =   4
            Font3D          =   4  'Drop Right
            FontBold        =   -1  'True
            FontItalic      =   0   'False
            FontName        =   "MS Sans Serif"
            FontSize        =   9.75
            FontStrikethru  =   0   'False
            FontUnderline   =   0   'False
            ForeColor       =   &H00800080&
            Height          =   915
            Icon            =   PZDEMO.FRX:1472
            IconLeft        =   20
            IconTop         =   10
            Index           =   0
            Left            =   1260
            PictureStyle    =   3  'Tiled
            TabIndex        =   10
            TabStyle        =   8  'Left Button
            Top             =   2610
            Width           =   1335
         End
         Begin PZLabel VCRLab 
            Alignment       =   6  'Center - TOP
            BackColor       =   &H00C0C0C0&
            BevelInner      =   2  'Raised
            BevelOuter      =   2  'Raised
            BevelOuterShading=   1  'Light
            BevelOuterWidth =   3
            BorderInner     =   1  'Solid
            BorderInnerWidth=   2
            BorderOuter     =   1  'Solid
            ButtonUp        =   -1  'True
            Caption         =   "of"
            CornerSize      =   4
            Font3D          =   4  'Drop Right
            FontBold        =   -1  'True
            FontItalic      =   0   'False
            FontName        =   "MS Sans Serif"
            FontSize        =   9.75
            FontStrikethru  =   0   'False
            FontUnderline   =   0   'False
            ForeColor       =   &H00800080&
            Height          =   915
            Icon            =   PZDEMO.FRX:1774
            IconLeft        =   20
            IconTop         =   10
            Index           =   2
            Left            =   3900
            PictureStyle    =   3  'Tiled
            TabIndex        =   11
            TabStyle        =   9  'No Horz. Side
            Top             =   2610
            Width           =   1335
         End
         Begin PZLabel VCRLab 
            Alignment       =   6  'Center - TOP
            BackColor       =   &H00C0C0C0&
            BevelInner      =   2  'Raised
            BevelOuter      =   2  'Raised
            BevelOuterShading=   1  'Light
            BevelOuterWidth =   3
            BorderInner     =   1  'Solid
            BorderInnerWidth=   2
            BorderOuter     =   1  'Solid
            ButtonUp        =   -1  'True
            Caption         =   "Buttons"
            CornerSize      =   4
            Font3D          =   4  'Drop Right
            FontBold        =   -1  'True
            FontItalic      =   0   'False
            FontName        =   "MS Sans Serif"
            FontSize        =   9.75
            FontStrikethru  =   0   'False
            FontUnderline   =   0   'False
            ForeColor       =   &H00800080&
            Height          =   915
            Icon            =   PZDEMO.FRX:1A76
            IconLeft        =   20
            IconTop         =   10
            Index           =   3
            Left            =   5220
            PictureStyle    =   3  'Tiled
            TabIndex        =   12
            TabStyle        =   6  'Right Button
            Top             =   2610
            Width           =   1335
         End
      End
      Begin PZLabel SubLab 
         AutoSize        =   -1  'True
         BackStyle       =   0  'Transparent
         ButtonUp        =   -1  'True
         Caption         =   "(Click here for more info...)"
         FontBold        =   -1  'True
         FontItalic      =   -1  'True
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         ForeColor       =   &H00C00000&
         Height          =   195
         Left            =   2070
         TabIndex        =   20
         Top             =   960
         Width           =   2385
      End
      Begin PZLabel TabLab 
         BackColor       =   &H00C0C0C0&
         BevelInner      =   2  'Raised
         BevelOuter      =   2  'Raised
         BevelOuterShading=   2  'Dark
         BevelOuterWidth =   1
         BorderOuterWidth=   2
         ButtonUp        =   -1  'True
         Caption         =   "Click here..."
         CornerSize      =   4
         Font3D          =   4  'Drop Right
         FontBold        =   -1  'True
         FontItalic      =   0   'False
         FontName        =   "Times New Roman"
         FontSize        =   9.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         ForeColor       =   &H00800000&
         Height          =   555
         Index           =   0
         Left            =   495
         PictureStyle    =   3  'Tiled
         TabIndex        =   18
         TabStyle        =   1  'Top Tab
         Top             =   1560
         Width           =   1275
         WordWrap        =   -1  'True
      End
      Begin PZLabel TapeLab 
         Alignment       =   1  'Left Justify - MIDDLE
         BackColor       =   &H00400000&
         BevelInnerWidth =   3
         BevelOuter      =   1  'Inset
         BorderInner     =   1  'Solid
         ButtonUp        =   -1  'True
         Caption         =   "You'll really like adjustable margins"
         CaptionMargin   =   300
         CornerSize      =   4
         FontBold        =   -1  'True
         FontItalic      =   0   'False
         FontName        =   "Times New Roman"
         FontSize        =   24
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         ForeColor       =   &H0000FF00&
         Height          =   795
         Icon            =   PZDEMO.FRX:1D78
         IconLeft        =   -50
         IconTop         =   8
         Left            =   3750
         TabIndex        =   7
         Top             =   2820
         Width           =   4095
      End
      Begin PZLabel FlickLab 
         Alignment       =   1  'Left Justify - MIDDLE
         BackColor       =   &H00E0FFFF&
         BevelInnerWidth =   3
         BevelOuter      =   1  'Inset
         BorderInner     =   1  'Solid
         ButtonUp        =   -1  'True
         Caption         =   "Without Flicker:"
         CaptionMargin   =   10
         CornerSize      =   4
         FontBold        =   -1  'True
         FontItalic      =   0   'False
         FontName        =   "Times New Roman"
         FontSize        =   22.5
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         ForeColor       =   &H00800000&
         Height          =   795
         Left            =   3720
         TabIndex        =   8
         Top             =   1770
         Width           =   4095
      End
      Begin PZLabel TitleLab 
         Alignment       =   6  'Center - TOP
         BackColor       =   &H0080C0FF&
         BevelInner      =   1  'Inset
         BevelInnerWidth =   1
         BevelOuter      =   2  'Raised
         BevelOuterWidth =   4
         BorderInner     =   1  'Solid
         BorderInnerColor=   &H00C0C0C0&
         BorderInnerWidth=   4
         BorderOuter     =   3  'Shadow
         BorderOuterColor=   &H00400000&
         BorderOuterWidth=   8
         ButtonUp        =   -1  'True
         Caption         =   " Introducing Pizazz 1.5"
         CaptionMargin   =   30
         CornerSize      =   4
         Font3D          =   4  'Drop Right
         Font3DColor     =   &H00800000&
         Font3DSize      =   3
         FontBold        =   -1  'True
         FontItalic      =   0   'False
         FontName        =   "Times New Roman"
         FontSize        =   27.75
         FontStrikethru  =   0   'False
         FontUnderline   =   -1  'True
         ForeColor       =   &H00FF00FF&
         GradientColor   =   &H00C0C0C0&
         GradientStyle   =   5  'Vertical Centered
         Height          =   1305
         Left            =   510
         TabIndex        =   17
         Top             =   120
         Width           =   7080
      End
      Begin PZLabel TabsLab 
         BackColor       =   &H00C0C0C0&
         BevelInner      =   2  'Raised
         BevelOuter      =   2  'Raised
         BevelOuterShading=   2  'Dark
         BevelOuterWidth =   1
         BorderInnerWidth=   2
         BorderOuterWidth=   2
         ButtonUp        =   -1  'True
         Caption         =   "An amazing variety of 3D effects..."
         CaptionMargin   =   10
         CornerSize      =   8
         Font3D          =   4  'Drop Right
         FontBold        =   -1  'True
         FontItalic      =   0   'False
         FontName        =   "Times New Roman"
         FontSize        =   24
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         ForeColor       =   &H00800000&
         Height          =   1755
         Icon            =   PZDEMO.FRX:207A
         IconLeft        =   160
         IconTop         =   74
         Left            =   210
         Picture         =   PZDEMO.FRX:237C
         PictureStyle    =   3  'Tiled
         TabIndex        =   9
         Top             =   2040
         Width           =   3315
         WordWrap        =   -1  'True
      End
      Begin PZLabel TabLab 
         BackColor       =   &H00C0C0C0&
         BevelInner      =   2  'Raised
         BevelOuter      =   2  'Raised
         BevelOuterShading=   2  'Dark
         BevelOuterWidth =   1
         BorderOuterWidth=   2
         ButtonUp        =   -1  'True
         Caption         =   "Or here."
         CornerSize      =   4
         Font3D          =   4  'Drop Right
         FontBold        =   -1  'True
         FontItalic      =   0   'False
         FontName        =   "Times New Roman"
         FontSize        =   9.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         ForeColor       =   &H00800000&
         Height          =   555
         Index           =   1
         Left            =   1770
         PictureStyle    =   3  'Tiled
         TabIndex        =   5
         TabStyle        =   1  'Top Tab
         Top             =   1560
         Width           =   1275
         WordWrap        =   -1  'True
      End
   End
   Begin Timer Timer1 
      Enabled         =   0   'False
      Interval        =   50
      Left            =   30
      Top             =   30
   End
   Begin PZLabel MoreBut 
      Alignment       =   4  'Right Justify - MIDDLE
      BackColor       =   &H00808080&
      BackStyle       =   2  'Opaque (paint corners)
      BevelInnerShading=   3  'Frame
      BevelInnerWidth =   1
      BevelOuter      =   2  'Raised
      BevelOuterWidth =   3
      BorderInnerWidth=   4
      BorderOuter     =   1  'Solid
      BorderOuterWidth=   2
      ButtonUp        =   -1  'True
      Caption         =   "Blah Blah"
      CaptionMargin   =   46
      CornerBackColor =   &H00C0C0C0&
      CornerSize      =   2
      Font3D          =   2  'Block Right
      ForeColor       =   &H00000080&
      GradientColor   =   &H00C0C0C0&
      GradientStyle   =   1  'Vertical
      Height          =   645
      IconLeft        =   60
      IconTop         =   2
      Left            =   6360
      TabIndex        =   13
      Top             =   3990
      Width           =   1605
      WordWrap        =   -1  'True
   End
   Begin PZLabel ComboLab 
      BackColor       =   &H00808080&
      BevelInner      =   2  'Raised
      BevelInnerWidth =   1
      BevelOuter      =   1  'Inset
      BevelOuterShading=   3  'Frame
      BevelOuterWidth =   1
      BorderInner     =   2  'Filled
      BorderInnerWidth=   5
      ButtonUp        =   -1  'True
      Caption         =   "three Pizazz labels"
      Font3D          =   2  'Block Right
      Font3DColor     =   &H00E0E0E0&
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00000080&
      GradientColor   =   &H00C0C0C0&
      GradientStyle   =   1  'Vertical
      Height          =   645
      Index           =   2
      Left            =   4020
      TabIndex        =   14
      TabStyle        =   2  'Right Tab
      Top             =   3990
      Width           =   2265
   End
   Begin PZLabel ComboLab 
      BackColor       =   &H00808080&
      BevelInner      =   2  'Raised
      BevelInnerWidth =   1
      BevelOuter      =   1  'Inset
      BevelOuterShading=   3  'Frame
      BevelOuterWidth =   1
      BorderInner     =   2  'Filled
      BorderInnerWidth=   5
      ButtonUp        =   -1  'True
      Caption         =   "using just"
      Font3D          =   2  'Block Right
      Font3DColor     =   &H00E0E0E0&
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00000080&
      GradientColor   =   &H00C0C0C0&
      GradientStyle   =   1  'Vertical
      Height          =   645
      Index           =   1
      Left            =   2370
      TabIndex        =   15
      TabStyle        =   9  'No Horz. Side
      Top             =   3990
      Width           =   1695
   End
   Begin PZLabel ComboLab 
      BackColor       =   &H00808080&
      BevelInner      =   2  'Raised
      BevelInnerWidth =   1
      BevelOuter      =   1  'Inset
      BevelOuterShading=   3  'Frame
      BevelOuterWidth =   1
      BorderInner     =   2  'Filled
      BorderInnerWidth=   5
      ButtonUp        =   -1  'True
      Caption         =   "This panel made"
      Font3D          =   2  'Block Right
      Font3DColor     =   &H00E0E0E0&
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00000080&
      GradientColor   =   &H00C0C0C0&
      GradientStyle   =   1  'Vertical
      Height          =   645
      Index           =   0
      Left            =   60
      TabIndex        =   16
      TabStyle        =   4  'Left Tab
      Top             =   3990
      Width           =   2355
   End
End
Option Explicit
'*******************************************************
'*                                                     *
'*   Demo program for Pizazz 1.5 Custom Control.       *
'*   Written by Visual Bits                            *
'*   Copyright  1995                                  *
'*                                                     *
'*   This software and documentation are supplied      *
'*   "AS IS".  The author makes no warranty of any     *
'*   kind, either express or implied, with respect to  *
'*   this software and accompanying documentation.  In *
'*   no event shall the author of this software be     *
'*   liable for any damages arising out of the use of  *
'*   this product. Your use of this software indicates *
'*   that you have read and agreed to these terms.     *
'*                                                     *
'*   Other then that, you may use this demo program    *
'*   source code in any way you find useful.           *
'*                                                     *
'*                                                     *
'*******************************************************

' form wide variables
Dim ticks As Integer
Dim Cap As String
Dim ColorShift As Long

Sub Form_Load ()
    Dim i As Integer
    Dim s As String

    ' center the form
    CenterForm Me
    CenterForm GradientFrm
    
    MainPan.Move 0, 0, scalewidth
    BigPan.Move 60, 60

    ' spread around the texture bitmaps
    PZBut(1).Picture = PZBut(0).Picture

    For i = 0 To 3
        VCRLab(i).Picture = PZBut(0).Picture
    Next i

    ' set PZBut(1) to clip PZBut(0) - this makes the
    ' two buttons appear as one unit
    PZBut(1).ClipCtl = PZBut(0).hCtl

    ' clip out these controls so painting the background
    ' avoids the dreaded flash
    FlickLab.ClipCtl = MainPan.hCtl
    TapeLab.ClipCtl = MainPan.hCtl

    Cap = FlickLab.Caption
    TabLab(0).Tag = TabsLab.Caption
    TabLab(1).Tag = "At your finger" & Chr$(13) & Chr$(10) & "tips!"
    TabLab(0).Picture = TabsLab.Picture
    TabLab(1).Picture = TabsLab.Picture
    
    ' if this is a 256 color system then we can load
    ' into any controls that have a gradient
    ' a bmp with a specail palette so the gradients look better
    ' *NOTE* this is optional (but works real nice)!
    If GetDeviceCaps(hDC, BITSPIXEL) = 8 Then
        s = "Hi there!  Your system currently displays 256 colors. "
        s = s & "Pizazz can do gradient fills which look terrific "
        s = s & "on systems that support more colors. "
        s = s & "You might try running this demo with a setup "
        s = s & "that supports more colors just to see how it looks. "
        s = s & "But even with only 256 colors available Pizazz can "
        s = s & "load palettes to improve the look dramatically.  "
        s = s & "I'll do that now..."
        MsgBox s, 64
        For i = 0 To 2
            GradientFrm!GradLab(i).Picture = GradientFrm!GradPan.Picture
            ComboLab(i).Picture = MainPan.Picture
        Next
        TitleLab.Picture = GradientFrm!GradPan.Picture
        MoreBut.Picture = MainPan.Picture
        ' don't change the colors
        ColorShift = 1
    Else
        ' Palettes? We don't need no stinking palattes!
        ' (this isn't necessary, I'm doing it to save some trivial
        '  amount of memory and show that it can be done)
        GradientFrm!GradPan.Picture = LoadPicture("")
        MainPan.Picture = LoadPicture("")
        ColorShift = 8
    End If
    
    ' setup MoreBut
    MoreBut_MouseUp 1, 0, 0, 0

    GradientFrm.Show 1
End Sub

Sub MoreBut_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button <> 1 Then Exit Sub
    MoreBut.BevelOuter = 1
End Sub

Sub MoreBut_MouseUp (Button As Integer, Shift As Integer, X As Single, Y As Single)
    ' this routine demonstrates some techniques to reduce flicker while
    ' using graphical PZLabel controls
    If Button <> 1 Then Exit Sub
    MoreBut.BevelOuter = 2
    If Timer1.Enabled Then
        MoreBut.Caption = "  Go Back"
        MoreBut.Alignment = 1
        MoreBut.Icon = TabsLab.Icon
        MoreBut.IconLeft = 10
        
        BigPan.Visible = True
        
        Timer1.Enabled = False
    Else
        MoreBut.Caption = "There's More!"
        MoreBut.Alignment = 4
        MoreBut.Icon = BigPan.Icon
        MoreBut.IconLeft = 60
        
        BigPan.Visible = False
        
        Timer1.Enabled = True
    End If
End Sub

Sub PZBut_MouseDown (index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
    PZBut(index).BevelOuter = 1
    PZBut(index Xor 1).BevelOuter = 1
End Sub

Sub PZBut_MouseUp (index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
    PZBut(index).BevelOuter = 2
    PZBut(index Xor 1).BevelOuter = 2
    ShowBevelOptFrm
End Sub

Function ShiftGradientColor (ByVal color As Long) As Long
    ' shift around the colors
    color = color * ColorShift
    ' take the byte the shifts off the end of the color and rotate
    ' it back into the low byte
    ShiftGradientColor = (color Or ((color And &HF000000) \ &H1000000)) And &HFFFFFF

End Function

Function ShiftGradientStyle (ByVal style As Integer) As Integer
    Dim centered As Integer
    centered = style And 4
    style = style + 1 And 3
    If style = 0 Then style = 1
    ShiftGradientStyle = style Or centered
End Function

Sub ShowBevelOptFrm ()
'*******************************************************
'*                                                     *
'*   Now for something completely different.  Show a   *
'*   dialog box that is almost entirely created out of *
'*   PZLabels and has tabs, spinners, and option       *
'*   buttons.                                          *
'*                                                     *
'*******************************************************
    
    Dim F As Form, T As PZPanel
    Dim i As Integer
    
    ' use object variables to make my typing easier!
    Set F = BevelOptFrm
    Set T = BigPan
    
    CenterForm F
    
    ' Load the gradient palette
    F!TabPan.Picture = MainPan.Picture
    For i = 0 To 2
        F!PanCmd(i).Picture = MainPan.Picture
    Next

    ' pass properties using tags
    ShowBevelOptions F, T
    F.Show 1

    If Trim$(F.Tag) = "2" Then
        ' OK was pressed
        SetBevelOptions F, T
    End If

    Unload BevelOptFrm
End Sub

Sub SubLab_Click ()
    TitleLab_Click
End Sub

Sub TabLab_Click (index As Integer)
    If TabsLab.Caption = TabLab(index).Tag Then Exit Sub

    ' avoid unneeded background painting
    ' (VB always paints the background form or
    ' control when a graphical zorder changes)
    MainPan.EnablePainting = False
    ' disable titlelab painting when this is a palette
    ' display so the palette changing caused by the
    ' zorder method doesn't repaint it
    If TitleLab.Picture Then TitleLab.EnablePainting = False
    
    ' make the tabs act like real tabs
    TabLab(index).ZOrder
    TabLab(index Xor 1).ZOrder 1
    TabsLab.Caption = TabLab(index).Tag
    TabsLab.IconTop = 74 \ (index + 1)
    
    ' update everything then restore normal painting
    DoEvents
    TitleLab.EnablePainting = True
    MainPan.EnablePainting = True
End Sub

Sub Timer1_Timer ()
    Dim i As Integer, j As Integer, secs As Integer
    Dim clr As Long
    
    secs = ticks Mod 20
    If Me.Visible Then
        ' update the counter and the moving caption
        i = TapeLab.CaptionMargin
        If i < -500 Then i = 300
        TapeLab.CaptionMargin = i - 3
        TapeLab.IconLeft = i - 40
        
        secs = ticks Mod 20
        If secs = 0 Then
            FlickLab.Caption = Cap & Str$(ticks \ 20)
        End If
    ElseIf GradientFrm.Visible And secs = 0 Then
        ' do something fancy
        FlashWindow GradientFrm.hWnd, True
        GradientFrm!GradPan.BackColor = ShiftGradientColor(GradientFrm!GradPan.BackColor)
        For i = 0 To 2
            ' change the colors in the gradients
            clr = ShiftGradientColor(GradientFrm!GradLab(i).BackColor)
            GradientFrm!GradLab(i).BackColor = GradientFrm!GradLab(i).GradientColor
            GradientFrm!GradLab(i).GradientColor = clr
            ' also change the gradient style for better effect
            If ticks Mod 40 Then
                GradientFrm!GradLab(i).GradientStyle = ShiftGradientStyle(GradientFrm!GradLab(i).GradientStyle)
            End If
        Next
    End If
        
    ticks = ticks + 1
    If ticks = 2000 Then ticks = 0
End Sub

Sub TitleLab_Click ()
    ' This should fire up help for topic context ID #1
    WinHelp hWnd, App.Path & "\" & "pizazz.hlp", 1, 3
End Sub

Sub VCRLab_Click (index As Integer)
    Static i As Integer
    If index <> i And VCRLab(i).BevelInner = 1 Then
        VCRLab(i).BevelInner = 2
        VCRLab(i).ForeColor = &H800080
    End If
    VCRLab(index).BevelInner = VCRLab(index).BevelInner Xor 3
    VCRLab(index).ForeColor = VCRLab(index).ForeColor Xor &H800040
    i = index
End Sub

