/* Rexx program to install PWMgr */
'echo off'

call rxfuncadd 'sysloadfuncs','rexxutil','sysloadfuncs'
call sysloadfuncs

parse arg parms

if parms = ""
    Then
        Do
            'CLS'
            Say ''
            Say ''
            Say 'ERROR!'
            Say 'Incorrect or missing parameters'
            Say 'Correct syntax is:  '
            Say '     PWMInst PWMgr_directory'
            Return
        End

parse var parms pwmDir

if right(pwmDir,1) <> '\'
    Then pwmDir = pwmDir||'\'

/* Let's do the disclaimer stuff */
'CLS'
Say ''
Say ''
Say 'By using this program, you are agreeing to accept'
Say 'all risk for use of this program.'
Say ''
Say 'This means that YOU and YOU ALONE are responsible for'
Say 'any and all problems that may arise from use of this software.'
Say ''
Say 'Do you agree to these terms? (Y/N):'
pull agree

if agree <> 'Y'
    Then Exit


Say 'Do you really want to install PWMgr into 'pwmDir' (Y/N) ?'
pull response

if response = 'Y'
    Then
        Do
            'echo y|xcopy *.* '||pwmDir||'>NUL'

           call SysCreateObject 'WPProgram', 'Password^Manager', '<WP_DESKTOP>',';EXENAME='||pwmDir||'\PWMgr.Exe;STARTUPDIR='||pwmDir||';PROGTYPE=PM;OBJECTID=<PWMgr>',REPLACE
        End

Say 'Installation completed successfully.'

Say 'Do you wish to read the PWMgr.Doc file now?'
pull response

if response = 'Y'
    Then
        'type PWMgr.Doc|more'

Say 'Do you wish to print the PWMgr.Doc file now?'
pull response

if response = 'Y'
    Then
        'print PWMgr.doc'
