//////////////////////////////////////////////////////////////////////////////
//  This file is a collection of custom POV 2.x textures...                 // 
//                                                                          //
//  If you add your own textures to this file, add the texture name to the  //
//  file "textures.pv2" so they'll appear in the texture list in POVCAD.    //
//////////////////////////////////////////////////////////////////////////////

/*************************************
  Metal textures by Dan Farmer '94:
     Soft_Silver
     New_Penny
     Tinny_Brass
     Gold_Nugget
     Aluminum
     Bright_Bronze
*************************************/

#declare Soft_Silver = texture {
  pigment { color red 0.94 green 0.93 blue 0.83 }
  finish {
    specular 0.85
    roughness 0.01
    ambient 0.2
    diffuse 0.35
    reflection 0.45
    metallic
    brilliance 1.5
  }
}

#declare New_Penny = texture {
  pigment { color rgb <0.6, 0.45, 0.4> }
  finish {
    specular 0.85
    roughness 0.01
    ambient 0.1
    diffuse 0.65
    reflection 0.45
    metallic
    brilliance 1.5
  }
}

#declare Tinny_Brass = texture {
  pigment { color red 0.70  green 0.56  blue 0.37 }
  finish {
    specular 0.85
    roughness 0.01
    ambient 0.1
    diffuse 0.65
    reflection 0.45
    metallic
    brilliance 1.5
  }
}

#declare Gold_Nugget = texture {
  pigment { color rgb <0.5, 0.35, 0.25> }
  finish {
    specular 0.85
    roughness 0.01
    ambient 0.1
    diffuse 0.65
    reflection 0.45
    metallic
    brilliance 1.5
  }
}

#declare Aluminum  = texture {
  pigment { color rgb <0.55, 0.5, 0.45> }
  finish {
    specular 0.85
    roughness 0.01
    ambient 0.1
    diffuse 0.65
    reflection 0.45
    metallic
    brilliance 1.5
  }
}

#declare Bright_Bronze = texture {
  pigment { color rgb <0.36, 0.28, 0.20> }
  finish {
    specular 0.85
    roughness 0.01
    ambient 0.1
    diffuse 0.65
    reflection 0.45
    metallic
    brilliance 1.5
  }
}

// End of Dans's metal textures

/************************
      Misc. textures
*************************/

////////////////////////////////////////////////////////////////////////
// A plastic white texture
//

#declare Phong_White = 
texture {
  pigment { color White }
  finish {
    ambient 0.25
    diffuse 0.35
    phong 0.5
    phong_size 20.0
  }
} // End Texture

////////////////////////////////////////////////////////////////////////
// A nice shiny black texture
//

#declare Shiny_Black = 
texture {
  pigment { color rgb <0, 0, 0> }
  finish {
    ambient 0.2
    diffuse 0.75
    specular 0.65
    roughness 0.01
  }
} // End Texture

////////////////////////////////////////////////////////////////////////
// Texture: Clouds1
//

#declare Clouds1 =
texture {
  pigment {
    bozo
    turbulence 0.5
    color_map {
       [0, 0.6 color Clear color Clear]
       [0.6, 0.8 color Clear color White]
       [0.8, 1.001 color White color red 0.8 green 0.8 blue 0.8]
    }
    quick_color red 0.7 green 0.7 blue 0.7
    scale <100, 20, 100>
  }
  finish {ambient 0.7 diffuse 0}
  scale <1.25, 1.5,1>
  rotate <0, 75, 0>
}

////////////////////////////////////////////////////////////////////////
// Finish: Matte1
//

#declare Matte1 =
finish {
  ambient    0.25
  diffuse    0.6
  phong      0.05
  phong_size 1.5
}

////////////////////////////////////////////////////////////////////////
// Normal: Rocky1
//

#declare Rocky1 =
normal {
  bumps 0.4
  turbulence 0.5
  octaves 4
  lambda 4.0
}

////////////////////////////////////////////////////////////////////////
// Texture: Dark_Chrome
//

#declare Dark_Chrome = 
texture {
  pigment { color Gray20 }
  finish {
    reflection 1.0
    crand 0.02
    phong 50.0
    phong_size 25.0
  }
} 

