                     MEMBER('DEMO.clw')           ! This is a MEMBER module
                     
                     MAP
                       BrowseAdvanced:Update7(LONG,LONG,<LONG>)
                       BrowseAdvanced:Update10(LONG,LONG)
                     END
                     


BrowseAdvanced       PROCEDURE

!--------------------------------------------------------------------------------------------------!
! Declarations                                                                                     !
!--------------------------------------------------------------------------------------------------!
LocalRequest         LONG,AUTO
LocalResponse        LONG,AUTO
WindowOpened         LONG
Search               STRING(40)
MarkStatus           STRING(15)
Search2              STRING(20)
Search4              STRING(20)
MarkStatus4          STRING(1)
MainRcpDsp           STRING(5)
SideRcpDsp           STRING(5)
DessertRcpDsp        STRING(5)
WinWidth             LONG                                  ! Save Window Width for Resizing
WinHeight            LONG                                  ! Save Window Height for Resizing

BQ1:FORMAT:Order1    EQUATE('10L(1)|_#1#~~@S1@84L(1)|_#2#~Name~@S20@24L(1)|_#3#~Code~@S20@')
BQ1:FORMAT:Order2    EQUATE('10L(1)|_#1#~~@S1@24L(1)|_#3#~Code~@S5@84L(1)|_#2#~Name~@S20@')

SQ1:SortOrder        BYTE                                  !Current Sort Order for the List Box
SAXTabOrderQ1        QUEUE,PRE(SQ1)                        !Queue Use to Store Sort Order Info
OrderName              STRING(60)                          !  Description shown in drop box
SearchPicture          STRING(30)                          !  Picture Clause for Search Field
OrderFormat            STRING(500)                         !  Format String for the List Box
                     END                                   !End Queue Declaration

BQ7:FORMAT:Order1    EQUATE('60L(1)|_#1#~Ingredient~@S15@32L(1)|_#2#~Measure~@S8@24L(1)|_#3#~Qty~@S5@')
BQ7:FORMAT:Order2    EQUATE('32L(1)|_#2#~Measure~@S8@24L(1)|_#3#~Qty~@S5@60L(1)|_#1#~Ingredient~@S15@')

SQ7:SortOrder        BYTE                                  !Current Sort Order for the List Box
SAXTabOrderQ7        QUEUE,PRE(SQ7)                        !Queue Use to Store Sort Order Info
OrderName              STRING(60)                          !  Description shown in drop box
SearchPicture          STRING(30)                          !  Picture Clause for Search Field
OrderFormat            STRING(500)                         !  Format String for the List Box
                     END                                   !End Queue Declaration

MarkAllFlag          BYTE                                  !Flag Indicating All Records Marked
MarkQueue            QUEUE,PRE(MQ1)                        !Queue Used to Store Marked Records
RecipeNo               LIKE(RCP:RecipeNo)                  !  Unique Record Id for the File
                     END                                   !End Queue Declaration

MarkAllFlag4         BYTE                                  !Flag Indicating All Records Marked
MarkQueue4           QUEUE,PRE(MQ11)                       !Queue Used to Store Marked Records
Date                   LIKE(MEN:Date)                      !  Unique Record Id for the File
                     END                                   !End Queue Declaration

hBrowse1             BYTE                                  !Handle to Identify the Browse List
BrowseQueue1         QUEUE,PRE(BQ1)                        !Queue Used by List when Browsing Records
MarkStatus             LIKE(MarkStatus)                    !  Queue Display field
Name                   LIKE(RCP:Name)                      !  Queue Display field
Code                   LIKE(RCP:Code)                      !  Queue Display field
RecipeNo               LIKE(RCP:RecipeNo)                  !  Queue Display field
Position               STRING(255)                         !  Queue POSITION information
                     END                                   !End Queue Declaration

hBrowse7             BYTE                                  !Handle to Identify the Browse List
BrowseQueue2         QUEUE,PRE(BQ7)                        !Queue Used by List when Browsing Records
Ingredient             LIKE(ING:Ingredient)                !  Queue Display field
Measure                LIKE(ING:Measure)                   !  Queue Display field
Quantity               LIKE(ING:Quantity)                  !  Queue Display field
Position               STRING(255)                         !  Queue POSITION information
                     END                                   !End Queue Declaration

hBrowse10            BYTE                                  !Handle to Identify the Browse List
BrowseQueue3         QUEUE,PRE(BQ10)                       !Queue Used by List when Browsing Records
Step                   LIKE(INS:Step)                      !  Queue Display field
Instruction            LIKE(INS:Instruction)               !  Queue Display field
Position               STRING(255)                         !  Queue POSITION information
                     END                                   !End Queue Declaration

hBrowse11            BYTE                                  !Handle to Identify the Browse List
BrowseQueue4         QUEUE,PRE(BQ11)                       !Queue Used by List when Browsing Records
MarkStatus4            LIKE(MarkStatus4)                   !  Queue Display field
Date                   LIKE(MEN:Date)                      !  Queue Display field
MainRcpDsp             LIKE(MainRcpDsp)                    !  Queue Display field
SideRcpDsp             LIKE(SideRcpDsp)                    !  Queue Display field
DessertRcpDsp          LIKE(DessertRcpDsp)                 !  Queue Display field
Position               STRING(255)                         !  Queue POSITION information
                     END                                   !End Queue Declaration

Screen               WINDOW('Advanced Browse Exercise'),AT(,,315,190),CENTER,HLP('~AdvancedExample'),STATUS,SYSTEM,GRAY,MAX,RESIZE,MASK,MDI
                       LIST,AT(6,19,160,98),MSG('Browsing Records'),ALRT(CtrlEnter),ALRT(InsertKey),ALRT(DeleteKey),ALRT(SpaceKey),ALRT(ShiftSpace),USE(?List1),IMM,HVSCROLL,VCR,FROM(BrowseQueue1)
                       PROMPT('Search:'),AT(7,5,25,10),USE(?Search:Prompt)
                       ENTRY(@S40),AT(34,5,80,10),MSG('Enter Search Criteria'),USE(Search)
                       CUSTOM('Tab 0|Tab 1|Tab 2|Tab 3'),AT(6,117,160,15),USE(?ChangeOrder1),CLASS('SAXTABS.VBX','SaxTab'),'ActiveTabColor'('65280'),'BackColor'('12632256'),'InactiveTabColor'('8421504')
                       LIST,AT(175,19,135,41),MSG('Browsing Records'),ALRT(CtrlEnter),ALRT(InsertKey),ALRT(DeleteKey),USE(?List2),IMM,NOBAR,VSCROLL,FROM(BrowseQueue2)
                       PROMPT('Search:'),AT(175,5,25,10),USE(?Search:Prompt:1)
                       ENTRY(@S40),AT(202,5,80,10),MSG('Enter Search Criteria'),USE(Search2)
                       LIST,AT(175,77,135,41),MSG('Browsing Records'),ALRT(CtrlEnter),ALRT(InsertKey),ALRT(DeleteKey),USE(?List3),IMM,NOBAR,VSCROLL,FORMAT('18L(1)|_~Step~@N2@80L(1)|_~Instruction~@S20@'),FROM(BrowseQueue3)
                       LIST,AT(175,137,135,49),MSG('Browsing Records'),ALRT(CtrlEnter),ALRT(InsertKey),ALRT(DeleteKey),ALRT(SpaceKey),ALRT(ShiftSpace),USE(?List4),IMM,NOBAR,HVSCROLL,VCR,FORMAT('10L(1)|_@s1@37L(1)|_~Date~@D1@24L(1)|_~Main~@s5@24L(1)|_~Side~@s5@28L(1)|_~Desse' &|
         'rt~@s5@'),FROM(BrowseQueue4)
                       PROMPT('Search:'),AT(176,126,25,10),USE(?Search:Prompt:2)
                       ENTRY(@D1),AT(203,125,80,10),MSG('Enter Search Criteria'),USE(Search4)
                       BUTTON('Insert'),AT(4,176,40,10),USE(?Insert)
                       BUTTON('Change'),AT(44,176,40,10),USE(?Change)
                       BUTTON('Delete'),AT(84,176,40,10),USE(?Delete)
                       BUTTON('Close'),AT(124,176,40,10),USE(?Close)
                       BUTTON('&Mark'),AT(1,26,40,10),USE(?Mark),HIDE
                       BUTTON('&Unmark'),AT(1,37,40,10),USE(?Unmark),HIDE
                       BUTTON('Mark &All'),AT(1,47,40,10),USE(?MarkAll),HIDE
                       BUTTON('&Clear All'),AT(1,58,40,10),USE(?UnmarkAll),HIDE
                       CUSTOM('Tab 0|Tab 1|Tab 2|Tab 3'),AT(175,60,135,15),USE(?ChangeOrder2),CLASS('SAXTABS.VBX','SaxTab'),'ActiveTabColor'('65280'),'BackColor'('12632256'),'InactiveTabColor'('8421504')
                       PROMPT('&Recipe#:'),AT(10,145,,),USE(?RCP:RecipeNo:Prompt)
                       BUTTON('&Mark'),AT(178,142,40,10),USE(?Mark:1),HIDE
                       BUTTON('&Unmark'),AT(178,150,40,10),USE(?Unmark:1),HIDE
                       BUTTON('Mark &All'),AT(178,159,40,10),USE(?MarkAll:1),HIDE
                       BUTTON('&Clear All'),AT(178,166,40,10),USE(?UnmarkAll:1),HIDE
                       ENTRY(@N_5),AT(44,144,,),USE(RCP:RecipeNo),READONLY
                       PROMPT('&Name:'),AT(17,161,,),USE(?RCP:Name:Prompt)
                       ENTRY(@S20),AT(44,160,,),USE(RCP:Name),READONLY
                     END

!--------------------------------------------------------------------------------------------------!
! Code Section                                                                                     !
!--------------------------------------------------------------------------------------------------!
  CODE

  LocalRequest = GlobalRequest
  LocalResponse = RequestCancelled
  CLEAR(GlobalRequest)
  CLEAR(GlobalResponse)

  IF INGREDIENT::Used = 0
    CheckOpen(INGREDIENT,1)
  END
  INGREDIENT::Used += 1
  IF INSTRUCTION::Used = 0
    CheckOpen(INSTRUCTION,1)
  END
  INSTRUCTION::Used += 1
  IF MENU::Used = 0
    CheckOpen(MENU,1)
  END
  MENU::Used += 1
  IF RECIPE::Used = 0
    CheckOpen(RECIPE,1)
  END
  RECIPE::Used += 1

  OPEN(Screen)                                             !Open the Window
  Screen{PROP:Imm} = 0                                     !Disable Posting of Initial Resize Event
  WinWidth = Screen{PROP:Width}                            !Save Current Window Width
  WinHeight = Screen{PROP:Height}                          !Save Current Window Height
  INIRestoreWindow('BrowseAdvanced','PTDEMO.INI')          !Restore Window Position and Size
  TC:RSZ:SetTabWidth = 1                                   !Keep Tab Control Same Width as List
  TC:RSZ:TabControl = ?ChangeOrder1                        !Tell Resize About Tab Control
  TC_ResizeWin(?List1,WinWidth,WinHeight,?List3)           !Reset Window Size
  WinWidth = Screen{PROP:Width}                            !Save Current Window Width
  WinHeight = Screen{PROP:Height}                          !Save Current Window Height
  Screen{PROP:Imm} = 1                                     !Allow Resize Events to be Posted

  DO LoadSortOrders1 
  DO LoadSortOrders7 
  SELECT(FIRSTFIELD())
  

  ACCEPT                                                   !Begin Processing Event Loop
                                                           !
    CASE EVENT()                                           !Process Events for the Window
    OF EVENT:OpenWindow
      WindowOpened = True
      DO BrowseList1                                       !Fill Browse Area
      DO BrowseList11                                      !Fill Browse Area
      SELECT(FIRSTFIELD())
    OF EVENT:GainFocus
      DO BrowseList1                                       !Fill Browse Area
      DO BrowseList11                                      !Fill Browse Area
    OF EVENT:Sized
      TC:RSZ:SetTabWidth = 1                               !Keep Tab Control Same Width as List
      TC:RSZ:TabControl = ?ChangeOrder1                    !Tell Resize About Tab Control
      TC_ResizeWin(?List1,WinWidth,WinHeight,?List3)       !Reset Window Size
      WinWidth = Screen{PROP:Width}                        !Save Current Window Width
      WinHeight = Screen{PROP:Height}                      !Save Current Window Height
      TC:BRW:Rows[hBrowse10] = ?List3{PROP:Items}          !Tell Browse to Redisplay
      FREE(BrowseQueue3)                                   !  Clear the Secondary List Box Before Redisplay
      TC:BRW:Rows[hBrowse1] = ?List1{PROP:Items}           !Reset Number of Rows in List Box
      TC:BRW:Action[hBrowse1] = 0                          !Tell Browse to start redisplay with a search by key
      IF TC:BRW:CurItem[hBrowse1] > TC:BRW:Rows[hBrowse1]  !If the Current Line Item Not Visible
        GET(BrowseQueue1,TC:BRW:CurItem[hBrowse1])         !  Reread Current Record Position
        REGET(RECIPE,BQ1:Position)                         !  Load the Record
        TC:BRW:SetToKey[hBrowse1] = 1                      !  Set Redisplay to start with current record
        FREE(BrowseQueue1)                                 !  Clear the List Box Before Redisplay
      ELSE                                                 !Otherwise
        TC:BRW:SetToItem[hBrowse1] = 1                     !  Set Redisplay to start with selected item
      END                                                  !End If
      DISPLAY                                              !Force List Boxes to Redisplay
      DO BrowseList1                                       !Fill Browse Area
    END                                                    !End Events for Window

    CASE FIELD()                                           !Process Events for Controls
    OF ?List1                              
      IF EVENT() = EVENT:AlertKey                          !If Alert Key Pressed
        CASE KEYCODE()                                     !  Process Alert Keys
        OF SpaceKey                                        !  On Mark/Unmark Key
          GET(BrowseQueue1,CHOICE(?List1))                 !    Reget Current Record ID
          MQ1:RecipeNo = BQ1:RecipeNo                      !    Prepare to Search for Marked Record
          GET(MarkQueue,MQ1:RecipeNo)                      !    See if Record is Marked
          IF (ERROR() AND NOT MarkAllFlag) OR |            !
             (NOT ERROR() AND MarkAllFlag)                 !    IF Record is Not Marked
            POST(EVENT:Accepted,?Mark)                     !      Mark the Record
          ELSE                                             !    Otherwise
            POST(EVENT:Accepted,?Unmark)                   !      Unmark the Record
          END                                              !    End If
          CYCLE                                            !    Cycle to Top of Event Loop
        OF ShiftSpace                                      !  On MarkAll/UnMarkAll Key
          IF NOT MarkAllFlag                               !    If Not All Records Marked Before
            POST(EVENT:Accepted,?MarkAll)                  !      Mark All Records
          ELSE                                             !    Otherwise
            POST(EVENT:Accepted,?UnmarkAll)                !      Unmark All Records
          END                                              !    End If
          CYCLE                                            !    Cycle to Top of Event Loop
        ELSE                                               !  On Other Keys Process Skip Search
          IF (INRANGE(KEYCODE(),Key0,ZKey) OR |            !    If Key is a lower case 0-Z Key
             INRANGE(KEYCODE(),Shift0,ShiftZ))             !    or it's a upper case 0-Z Key
            EXECUTE SQ1:SortOrder                          !      Setup Locator for Current Sort Order
              RCP:Name = CHR(KEYCODE())                    !        Move character into locator
              RCP:Code = CHR(KEYCODE())                    !        Move character into locator
            END                                            !      End Execute
            TC:BRW:Action[hBrowse1] = 0                    !      Tell Browse to Redisplay
            TC:BRW:SetToKey[hBrowse1] = 1                  !      Redisplay after searching by key
          END                                              !    End If
        END                                                !  End Case
      END                                                  !End If
      DO BrowseList1                                       !Fill Browse Area
    OF ?Search                              
      CASE EVENT()                           
      OF EVENT:Accepted                 
        CASE SQ1:SortOrder                                 !Setup Search for Current Sort Order
        OF 1                                               !For Current Sort Order
          RCP:Name = Search                                !  Fill Search Key
        OF 2                                               !For Current Sort Order
          RCP:Code = Search                                !  Fill Search Key
        END                                                !End Case
        Search = ''                                        !Clear Search Input Field
        DISPLAY(?Search)                                   !
        TC:BRW:Action[hBrowse1]   = 0                      !Tell Browse to Redisplay
        TC:BRW:SetToKey[hBrowse1] = 1                      !Redisplay after searching by key
        SELECT(?List1)                                     !Reselect Main List Box
      END                                    
    OF ?ChangeOrder1                              
      CASE EVENT()                           
      OF EVENT:VBXevent                 
        Choice# = ?ChangeOrder1{'ActiveTab','Get'} + 1     !Read Choice Made for Tab Control
        GET(SAXTabOrderQ1,Choice#)                         !Get Order settings from Sort Orders Queue
        IF NOT ERROR()                                     !IF Valid Choice was Selected
          SQ1:SortOrder = Choice#                          !  Set sort order
          ?Search{PROP:Text} = SQ1:SearchPicture           !  Set Picture for Search Field
          ?List1{PROP:Format} = SQ1:OrderFormat            !  Set number of rows in list box
          TC:BRW:Rows[hBrowse1] = ?List1{PROP:Items}       !  Tell Browse to Redisplay
          TC:BRW:Action[hBrowse1] = 0                      !  Tell Browse to start redisplay with a search by key
          TC:BRW:SetToPosition[hBrowse1] = 2               !  Set Redisplay at Current Position
          DO BrowseList1                                   !  Call BrowseList and Execute Redisplay
        END                                                !End
      END                                    
    OF ?List2                              
      IF EVENT() = EVENT:AlertKey                          !If Alert Key Pressed
        CASE KEYCODE()                                     !  Process Alert Keys
        ELSE                                               !  On Other Keys Process Skip Search
          IF (INRANGE(KEYCODE(),Key0,ZKey) OR |            !    If Key is a lower case 0-Z Key
             INRANGE(KEYCODE(),Shift0,ShiftZ))             !    or it's a upper case 0-Z Key
            EXECUTE SQ7:SortOrder                          !      Setup Locator for Current Sort Order
              ING:Ingredient = CHR(KEYCODE())              !        Move character into locator
              ING:Measure = CHR(KEYCODE())                 !        Move character into locator
            END                                            !      End Execute
            TC:BRW:Action[hBrowse7] = 0                    !      Tell Browse to Redisplay
            TC:BRW:SetToKey[hBrowse7] = 1                  !      Redisplay after searching by key
          END                                              !    End If
        END                                                !  End Case
      END                                                  !End If
      DO BrowseList7                                       !Fill Browse Area
    OF ?Search2                              
      CASE EVENT()                           
      OF EVENT:Accepted                 
        CASE SQ7:SortOrder                                 !Setup Search for Current Sort Order
        OF 1                                               !For Current Sort Order
          ING:Ingredient = Search2                         !  Fill Search Key
        OF 2                                               !For Current Sort Order
          ING:Measure = Search2                            !  Fill Search Key
        END                                                !End Case
        Search2 = ''                                       !Clear Search Input Field
        DISPLAY(?Search2)                                  !
        TC:BRW:Action[hBrowse7]   = 0                      !Tell Browse to Redisplay
        TC:BRW:SetToKey[hBrowse7] = 1                      !Redisplay after searching by key
        SELECT(?List2)                                     !Reselect Main List Box
      END                                    
    OF ?List3                              
      IF EVENT() = EVENT:AlertKey                          !If Alert Key Pressed
        CASE KEYCODE()                                     !  Process Alert Keys
        ELSE                                               !  On Other Keys Process Skip Search
          IF (INRANGE(KEYCODE(),Key0,ZKey) OR |            !    If Key is a lower case 0-Z Key
             INRANGE(KEYCODE(),Shift0,ShiftZ))             !    or it's a upper case 0-Z Key
            INS:Step = CHR(KEYCODE())                      !      Move character into locator
            TC:BRW:Action[hBrowse10] = 0                   !      Tell Browse to Redisplay
            TC:BRW:SetToKey[hBrowse10] = 1                 !      Redisplay after searching by key
          END                                              !    End If
        END                                                !  End Case
      END                                                  !End If
      DO BrowseList10                                      !Fill Browse Area
    OF ?List4                              
      IF EVENT() = EVENT:AlertKey                          !If Alert Key Pressed
        CASE KEYCODE()                                     !  Process Alert Keys
        OF SpaceKey                                        !  On Mark/Unmark Key
          GET(BrowseQueue4,CHOICE(?List4))                 !    Reget Current Record ID
          MQ11:Date = BQ11:Date                            !    Prepare to Search for Marked Record
          GET(MarkQueue4,MQ11:Date)                        !    See if Record is Marked
          IF (ERROR() AND NOT MarkAllFlag4) OR |           !
             (NOT ERROR() AND MarkAllFlag4)                !    IF Record is Not Marked
            POST(EVENT:Accepted,?Mark:1)                   !      Mark the Record
          ELSE                                             !    Otherwise
            POST(EVENT:Accepted,?Unmark:1)                 !      Unmark the Record
          END                                              !    End If
          CYCLE                                            !    Cycle to Top of Event Loop
        OF ShiftSpace                                      !  On MarkAll/UnMarkAll Key
          IF NOT MarkAllFlag4                              !    If Not All Records Marked Before
            POST(EVENT:Accepted,?MarkAll:1)                !      Mark All Records
          ELSE                                             !    Otherwise
            POST(EVENT:Accepted,?UnmarkAll:1)              !      Unmark All Records
          END                                              !    End If
          CYCLE                                            !    Cycle to Top of Event Loop
        ELSE                                               !  On Other Keys Process Skip Search
          IF (INRANGE(KEYCODE(),Key0,ZKey) OR |            !    If Key is a lower case 0-Z Key
             INRANGE(KEYCODE(),Shift0,ShiftZ))             !    or it's a upper case 0-Z Key
            MEN:Date = CHR(KEYCODE())                      !      Move character into locator
            TC:BRW:Action[hBrowse11] = 0                   !      Tell Browse to Redisplay
            TC:BRW:SetToKey[hBrowse11] = 1                 !      Redisplay after searching by key
          END                                              !    End If
        END                                                !  End Case
      END                                                  !End If
      DO BrowseList11                                      !Fill Browse Area
    OF ?Search4                              
      CASE EVENT()                           
      OF EVENT:Accepted                 
        MEN:Date = Search4                                 !Fill Search key
        Search4 = ''                                       !Clear Search Input Field
        DISPLAY(?Search4)                                  !
        TC:BRW:Action[hBrowse11]   = 0                     !Tell Browse to Redisplay
        TC:BRW:SetToKey[hBrowse11] = 1                     !Redisplay after searching by key
        SELECT(?List4)                                     !Reselect Main List Box
      END                                    
    OF ?Insert                              
      CASE EVENT()                           
      OF EVENT:Accepted                 
        POST(TCEVENT:InsertRecord,TC:BRW:ActiveList)       !Send Insert Message to List Box
      END                                    
    OF ?Change                              
      CASE EVENT()                           
      OF EVENT:Accepted                 
        POST(TCEVENT:ChangeRecord,TC:BRW:ActiveList)       !Send Change Message to List Box
      END                                    
    OF ?Delete                              
      CASE EVENT()                           
      OF EVENT:Accepted                 
        POST(TCEVENT:DeleteRecord,TC:BRW:ActiveList)       !Send Delete Message to List Box
      END                                    
    OF ?Close                              
      CASE EVENT()                           
      OF EVENT:Accepted                 
        LocalResponse = RequestCancelled
        POST(Event:CloseWindow)
      END                                    
    OF ?Mark                              
      CASE EVENT()                           
      OF EVENT:Accepted                 
        GET(BrowseQueue1,CHOICE(?List1))                   !Reget Current Record ID
        MQ1:RecipeNo = BQ1:RecipeNo                        !Prepare to Search for Marked Record
        GET(MarkQueue,MQ1:RecipeNo)                        !See if Record is Marked
        IF NOT MarkAllFlag                                 !If Not Marking All Exceptions
          IF ERROR()                                       !  If Record Not Marked
            BQ1:MarkStatus = 'X'                           !    Show Record as Marked in the List Box
            MQ1:RecipeNo = BQ1:RecipeNo                    !    Set up to Add Record to the Mark Queue
            ADD(MarkQueue,MQ1:RecipeNo)                    !    Add the Record to the Mark Queue
            PUT(BrowseQueue1)                              !    Update the Changes to the List Box
          END                                              !  End If
        ELSE                                               !Otherwise Mark Table is an Exception List
          IF NOT ERROR()                                   !  If Record Not Marked
            BQ1:MarkStatus = 'X'                           !    Show Record as Marked in the List Box
            DELETE(MarkQueue)                              !    Delete the Record from the Mark Queue
            PUT(BrowseQueue1)                              !    Update the Changes to the List Box
          END                                              !  End If
        END                                                !End If
        POST(EVENT:ScrollDown,?List1)                      !Go Back to List and Move Down 1 Record
      END                                    
    OF ?Unmark                              
      CASE EVENT()                           
      OF EVENT:Accepted                 
        GET(BrowseQueue1,CHOICE(?List1))                   !Reget Current Record ID
        MQ1:RecipeNo = BQ1:RecipeNo                        !Prepare to Search for Marked Record
        GET(MarkQueue,MQ1:RecipeNo)                        !See if Record is Marked
        IF NOT MarkAllFlag                                 !If Not Marking All Exceptions
          IF NOT ERROR()                                   !  If Record is Marked
            BQ1:MarkStatus = ''                            !    Show Record as Not Marked in the List Box
            DELETE(MarkQueue)                              !    Delete the Record from the Mark Queue
            PUT(BrowseQueue1)                              !    Update the Changes to the List Box
          END                                              !  End If
        ELSE                                               !Otherwise Mark Table is an Exception List
          IF ERROR()                                       !  If Record is Marked
            BQ1:MarkStatus = ''                            !    Show Record as Not Marked in the List Box
            MQ1:RecipeNo = BQ1:RecipeNo                    !    Set up to Add Record to the Mark Queue
            ADD(MarkQueue,MQ1:RecipeNo)                    !    Add the Record to the Mark Queue
            PUT(BrowseQueue1)                              !    Update the Changes to the List Box
          END                                              !  End If
        END                                                !End If
        POST(EVENT:ScrollDown,?List1)                      !Go Back to List and Move Down 1 Record
      END                                    
    OF ?MarkAll                              
      CASE EVENT()                           
      OF EVENT:Accepted                 
        MarkAllFlag = 1                                    !Mark Queue is Now an Exception List
        FREE(MarkQueue)                                    !Mark All Records
        LOOP Rec# = 1 TO RECORDS(BrowseQueue1)             !Loop Through the List Boxes Records
          GET(BrowseQueue1,Rec#)                           !  Read the Queue Record
          BQ1:MarkStatus = 'X'                             !  Show Record as Marked in the List Box
          PUT(BrowseQueue1)                                !  Update the Changes to the List Box
        END                                                !End Loop
        SELECT(?List1)                                     !Go Back to List Box After Button Press
      END                                    
    OF ?UnmarkAll                              
      CASE EVENT()                           
      OF EVENT:Accepted                 
        MarkAllFlag = 0                                    !Mark Queue is Now a List of Marked Records
        FREE(MarkQueue)                                    !UnMark All Records
        LOOP Rec# = 1 TO RECORDS(BrowseQueue1)             !Loop Through the List Boxes Records
          GET(BrowseQueue1,Rec#)                           !  Read the Queue Record
          BQ1:MarkStatus = ''                              !  Show Record as Not Marked in the List Box
          PUT(BrowseQueue1)                                !  Update the Changes to the List Box
        END                                                !End Loop
        SELECT(?List1)                                     !Go Back to List Box After Button Press
      END                                    
    OF ?ChangeOrder2                              
      CASE EVENT()                           
      OF EVENT:VBXevent                 
        Choice# = ?ChangeOrder2{'ActiveTab','Get'} + 1     !Read Choice Made for Tab Control
        GET(SAXTabOrderQ7,Choice#)                         !Get Order settings from Sort Orders Queue
        IF NOT ERROR()                                     !IF Valid Choice was Selected
          SQ7:SortOrder = Choice#                          !  Set sort order
          ?Search2{PROP:Text} = SQ7:SearchPicture          !  Set Picture for Search Field
          ?List2{PROP:Format} = SQ7:OrderFormat            !  Set number of rows in list box
          TC:BRW:Rows[hBrowse7] = ?List2{PROP:Items}       !  Tell Browse to Redisplay
          TC:BRW:Action[hBrowse7] = 0                      !  Tell Browse to start redisplay with a search by key
          TC:BRW:SetToPosition[hBrowse7] = 2               !  Set Redisplay at Current Position
          DO BrowseList7                                   !  Call BrowseList and Execute Redisplay
        END                                                !End
      END                                    
    OF ?Mark:1                              
      CASE EVENT()                           
      OF EVENT:Accepted                 
        GET(BrowseQueue4,CHOICE(?List4))                   !Reget Current Record ID
        MQ11:Date = BQ11:Date                              !Prepare to Search for Marked Record
        GET(MarkQueue4,MQ11:Date)                          !See if Record is Marked
        IF NOT MarkAllFlag4                                !If Not Marking All Exceptions
          IF ERROR()                                       !  If Record Not Marked
            BQ11:MarkStatus4 = 'X'                         !    Show Record as Marked in the List Box
            MQ11:Date = BQ11:Date                          !    Set up to Add Record to the Mark Queue
            ADD(MarkQueue4,MQ11:Date)                      !    Add the Record to the Mark Queue
            PUT(BrowseQueue4)                              !    Update the Changes to the List Box
          END                                              !  End If
        ELSE                                               !Otherwise Mark Table is an Exception List
          IF NOT ERROR()                                   !  If Record Not Marked
            BQ11:MarkStatus4 = 'X'                         !    Show Record as Marked in the List Box
            DELETE(MarkQueue4)                             !    Delete the Record from the Mark Queue
            PUT(BrowseQueue4)                              !    Update the Changes to the List Box
          END                                              !  End If
        END                                                !End If
        POST(EVENT:ScrollDown,?List4)                      !Go Back to List and Move Down 1 Record
      END                                    
    OF ?Unmark:1                              
      CASE EVENT()                           
      OF EVENT:Accepted                 
        GET(BrowseQueue4,CHOICE(?List4))                   !Reget Current Record ID
        MQ11:Date = BQ11:Date                              !Prepare to Search for Marked Record
        GET(MarkQueue4,MQ11:Date)                          !See if Record is Marked
        IF NOT MarkAllFlag4                                !If Not Marking All Exceptions
          IF NOT ERROR()                                   !  If Record is Marked
            BQ11:MarkStatus4 = ''                          !    Show Record as Not Marked in the List Box
            DELETE(MarkQueue4)                             !    Delete the Record from the Mark Queue
            PUT(BrowseQueue4)                              !    Update the Changes to the List Box
          END                                              !  End If
        ELSE                                               !Otherwise Mark Table is an Exception List
          IF ERROR()                                       !  If Record is Marked
            BQ11:MarkStatus4 = ''                          !    Show Record as Not Marked in the List Box
            MQ11:Date = BQ11:Date                          !    Set up to Add Record to the Mark Queue
            ADD(MarkQueue4,MQ11:Date)                      !    Add the Record to the Mark Queue
            PUT(BrowseQueue4)                              !    Update the Changes to the List Box
          END                                              !  End If
        END                                                !End If
        POST(EVENT:ScrollDown,?List4)                      !Go Back to List and Move Down 1 Record
      END                                    
    OF ?MarkAll:1                              
      CASE EVENT()                           
      OF EVENT:Accepted                 
        MarkAllFlag4 = 1                                   !Mark Queue is Now an Exception List
        FREE(MarkQueue4)                                   !Mark All Records
        LOOP Rec# = 1 TO RECORDS(BrowseQueue4)             !Loop Through the List Boxes Records
          GET(BrowseQueue4,Rec#)                           !  Read the Queue Record
          BQ11:MarkStatus4 = 'X'                           !  Show Record as Marked in the List Box
          PUT(BrowseQueue4)                                !  Update the Changes to the List Box
        END                                                !End Loop
        SELECT(?List4)                                     !Go Back to List Box After Button Press
      END                                    
    OF ?UnmarkAll:1                              
      CASE EVENT()                           
      OF EVENT:Accepted                 
        MarkAllFlag4 = 0                                   !Mark Queue is Now a List of Marked Records
        FREE(MarkQueue4)                                   !UnMark All Records
        LOOP Rec# = 1 TO RECORDS(BrowseQueue4)             !Loop Through the List Boxes Records
          GET(BrowseQueue4,Rec#)                           !  Read the Queue Record
          BQ11:MarkStatus4 = ''                            !  Show Record as Not Marked in the List Box
          PUT(BrowseQueue4)                                !  Update the Changes to the List Box
        END                                                !End Loop
        SELECT(?List4)                                     !Go Back to List Box After Button Press
      END                                    
    END                                                    !End Events for Controls
  END                                                      !End Event Loop
                                                           !
  DO WrapUp                                                !Cleanup and Exit the Procedure



!--------------------------------------------------------------------------------------------------!
! BrowseList1 Routine                                                                              !
!                                                                                                  !
! This routine calls the browser to do a page-loaded display from a file.                          !
!--------------------------------------------------------------------------------------------------!
BrowseList1          ROUTINE

  IF NOT WindowOpened THEN EXIT.                           !If Window Not Open Exit Browse.
                                                           !
  IF NOT hBrowse1                                          !If Browse Not Initialized
    hBrowse1 = TC_InitBrowse(?List1,THREAD())              !  Initialize Browse Processing for List Box
    IF LocalRequest = SelectRecord                         !  If Browse Procedure Called as a Lookup
      TC:BRW:SelectRecord[hBrowse1] = True                 !    Set Double Click to Select Record
    END                                                    !  End If
  END                                                      !End If
                                                           !
  LOOP                                                     !Process File Browse Loop
    CASE SQ1:SortOrder                                     !Browse for Current Sort Order
    OF 1                                                   !Sort Order Is By Name
      TC_Browse(hBrowse1             ,|                    !  Browse Handle
                RECIPE               ,|                    !  File Name
                RCP:RECORD           ,|                    !  Record Area
                RCP:Key_Name         ,|                    !  Key Order for Display
                BrowseQueue1         ,|                    !  Queue Name for List
                BQ1:Position         )                     !  Record Position in Key Order
    OF 2                                                   !Sort Order Is By Code
      TC_Browse(hBrowse1             ,|                    !  Browse Handle
                RECIPE               ,|                    !  File Name
                RCP:RECORD           ,|                    !  Record Area
                RCP:Key_Code         ,|                    !  Key Order for Display
                BrowseQueue1         ,|                    !  Queue Name for List
                BQ1:Position         )                     !  Record Position in Key Order
    END                                                    !End Case On Sort Orders

    CASE TC:BRW:Action[hBrowse1]                           !Process Browse Actions
    OF TCACTION:FillQueue                                  !Fill List Queue Action
      MQ1:RecipeNo = RCP:RecipeNo                          !  Prepare to Search for Marked Record
      GET(MarkQueue,MQ1:RecipeNo)                          !  See if Record is Marked
      IF (NOT MarkAllFlag AND NOT ERROR()) OR |            !  If Record is Marked
          (MarkAllFlag AND ERROR())                        !
        MarkStatus = 'X'                                   !    Show Record as Marked
      ELSE                                                 !  Otherwise
        MarkStatus = ''                                    !    Show Record as Not Marked
      END                                                  !  End If
      MQ11:Date = MEN:Date                                 !  Prepare to Search for Marked Record
      GET(MarkQueue4,MQ11:Date)                            !  See if Record is Marked
      IF (NOT MarkAllFlag4 AND NOT ERROR()) OR |           !  If Record is Marked
          (MarkAllFlag4 AND ERROR())                       !
        MarkStatus4 = 'X'                                  !    Show Record as Marked
      ELSE                                                 !  Otherwise
        MarkStatus4 = ''                                   !    Show Record as Not Marked
      END                                                  !  End If
      BQ1:MarkStatus = MarkStatus                          !  Move Data to Queue
      BQ1:Name = RCP:Name                                  !  Move Data to Queue
      BQ1:Code = RCP:Code                                  !  Move Data to Queue
      BQ1:RecipeNo = RCP:RecipeNo                          !  Move Data to Queue
                                                           !
    OF TCACTION:InsertRecord                               !Insert Record Action
      GET(RECIPE,0)                                        !  Clear Pending Record
      CLEAR(RCP:RECORD)                                    !  Clear Record Area
      GlobalRequest = InsertRecord                         !  Tell Form To Insert Record
      UpdateRecipe                                         !  Insert Record
      IF GlobalResponse = RequestCompleted                 !  If Record Added
        TC:BRW:Action[hBrowse1] = 0                        !    Tell Browse to Redisplay
        TC:BRW:SetToPosition[hBrowse1] = 1                 !    Record at the Current Positon
      END                                                  !  End If
                                                           !
    OF TCACTION:ChangeRecord                               !Change Record Action
      GlobalRequest = ChangeRecord                         !  Tell Form To Change Record
      UpdateRecipe                                         !  Change Record
      IF GlobalResponse = RequestCompleted                 !  If Record Added
        TC:BRW:Action[hBrowse1] = 0                        !    Tell Browse to Redisplay
        TC:BRW:SetToPosition[hBrowse1] = 1                 !    Record at the Current Positon
      END                                                  !  End If
      IF GlobalResponse = RequestCompleted
        POST(TCEVENT:SamePage,?List4)
        TC:BRW:DontSelect[hBrowse11] = 1
      END
                                                           !
    OF TCACTION:DeleteRecord                               !Delete Record Action
      TC:BRW:AbortDel[hBrowse1] = 1                        !  Tell Browse Not To Handle Delete
      GlobalRequest = DeleteRecord                         !  Tell Form To Delete Record
      UpdateRecipe                                         !  Delete Record
      IF GlobalResponse = RequestCompleted                 !  If Record Deleted
        TC:BRW:Action[hBrowse1] = 0                        !    Tell Browse to Redisplay
        TC:BRW:SetToItem[hBrowse1] = 1                     !    Record at the Current Item
      END                                                  !  End If
                                                           !
    OF TCACTION:SelectRecord                               !Select Record Action
      LocalResponse = RequestCompleted                     !  Lookup was completed
      POST(Event:CloseWindow)                              !  Return Selected Record to Caller
                                                           !
    OF TCACTION:ExitBrowse                                 !Exit Browse Action
      BREAK                                                !  
    END                                                    !End Process Browse Actions
  END                                                      !End Process File Browse Loop
                                                           !
  IF RECORDS(BrowseQueue1)                                 !If Records Available for Display
    GET(BrowseQueue1,TC:BRW:CurItem[hBrowse1])             !  Load Positon of Record From Queue
    EXECUTE SQ1:SortOrder                                  !  Reread for Current Sort Order
      REGET(RCP:Key_Name,BQ1:Position)                     !    Reread Record for HOT Display
      REGET(RCP:Key_Code,BQ1:Position)                     !    Reread Record for HOT Display
    END                                                    !  End Execute
  END                                                      !End If
  DO DisplayHotLists1                                      !Redisplay Child List Boxes
  TC:BRW:ActiveList = ?List1                               !Reset List Box as Being Active
  DISPLAY()                                                !Display All Fields



!--------------------------------------------------------------------------------------------------!
! LoadSortOrders1 Routine                                                                          !
!                                                                                                  !
! This routine loads the available sort options into the SAXTabOrderQ1                             !
!--------------------------------------------------------------------------------------------------!
LoadSortOrders1      ROUTINE

  FREE(SAXTabOrderQ1)                                      !Make sure queue is empty

  SQ1:SearchPicture = '@S20'                               !Set Picture for Search Field
  SQ1:OrderName = 'By Name'                                !Set Name of Sort Order
  SQ1:OrderFormat = BQ1:FORMAT:Order1                      !Set Format String for Sort Order
  ADD(SAXTabOrderQ1)                                       !Add the option

  SQ1:SearchPicture = '@S5'                                !Set Picture for Search Field
  SQ1:OrderName = 'By Code'                                !Set Name of Sort Order
  SQ1:OrderFormat = BQ1:FORMAT:Order2                      !Set Format String for Sort Order
  ADD(SAXTabOrderQ1)                                       !Add the option

  SQ1:SortOrder = 1                                        !Default to Sort Order #1
  GET(SAXTabOrderQ1,SQ1:SortOrder)                         !Get Sort Order Entry from Queue
  SELECT(?ChangeOrder1,SQ1:SortOrder)                      !Set Initial Sort Order for Drop Box
  ?Search{PROP:Text} = SQ1:SearchPicture                   !Set Initial Picture for Search Field
  ?List1{PROP:Format} = SQ1:OrderFormat                    !Set Initial Format for List Box
  ?ChangeOrder1{PROP:Text} = 'By Name|By Code'



!--------------------------------------------------------------------------------------------------!
! BrowseList7 Routine                                                                              !
!                                                                                                  !
! This routine calls the browser to do a page-loaded display from a file.                          !
!--------------------------------------------------------------------------------------------------!
BrowseList7          ROUTINE

  IF NOT WindowOpened THEN EXIT.                           !If Window Not Open Exit Browse.
                                                           !
  IF NOT hBrowse7                                          !If Browse Not Initialized
    hBrowse7 = TC_InitBrowse(?List2,THREAD())              !  Initialize Browse Processing for List Box
    IF LocalRequest = SelectRecord                         !  If Browse Procedure Called as a Lookup
      TC:BRW:SelectRecord[hBrowse7] = True                 !    Set Double Click to Select Record
    END                                                    !  End If
  END                                                      !End If
                                                           !
  LOOP                                                     !Process File Browse Loop
    CASE SQ7:SortOrder                                     !Browse for Current Sort Order
    OF 1                                                   !Sort Order Is By Ingredient
      TC_Browse(hBrowse7             ,|                    !  Browse Handle
                INGREDIENT           ,|                    !  File Name
                ING:RECORD           ,|                    !  Record Area
                ING:Key_Ingredient   ,|                    !  Key Order for Display
                BrowseQueue2         ,|                    !  Queue Name for List
                BQ7:Position         ,|                    !  Record Position in Key Order
                ING:RecipeNo         ,|                    !  Range Field
                RCP:RecipeNo         ,|                    !  Match Range - Low Value
                RCP:RecipeNo         )                     !  Match Range - High Value
    OF 2                                                   !Sort Order Is By Measure
      TC_Browse(hBrowse7             ,|                    !  Browse Handle
                INGREDIENT           ,|                    !  File Name
                ING:RECORD           ,|                    !  Record Area
                ING:Key_Measure      ,|                    !  Key Order for Display
                BrowseQueue2         ,|                    !  Queue Name for List
                BQ7:Position         ,|                    !  Record Position in Key Order
                ING:RecipeNo         ,|                    !  Range Field
                RCP:RecipeNo         ,|                    !  Match Range - Low Value
                RCP:RecipeNo         )                     !  Match Range - High Value
    END                                                    !End Case On Sort Orders

    CASE TC:BRW:Action[hBrowse7]                           !Process Browse Actions
    OF TCACTION:FillQueue                                  !Fill List Queue Action
      MQ1:RecipeNo = RCP:RecipeNo                          !  Prepare to Search for Marked Record
      GET(MarkQueue,MQ1:RecipeNo)                          !  See if Record is Marked
      IF (NOT MarkAllFlag AND NOT ERROR()) OR |            !  If Record is Marked
          (MarkAllFlag AND ERROR())                        !
        MarkStatus = 'X'                                   !    Show Record as Marked
      ELSE                                                 !  Otherwise
        MarkStatus = ''                                    !    Show Record as Not Marked
      END                                                  !  End If
      MQ11:Date = MEN:Date                                 !  Prepare to Search for Marked Record
      GET(MarkQueue4,MQ11:Date)                            !  See if Record is Marked
      IF (NOT MarkAllFlag4 AND NOT ERROR()) OR |           !  If Record is Marked
          (MarkAllFlag4 AND ERROR())                       !
        MarkStatus4 = 'X'                                  !    Show Record as Marked
      ELSE                                                 !  Otherwise
        MarkStatus4 = ''                                   !    Show Record as Not Marked
      END                                                  !  End If
      BQ7:Ingredient = ING:Ingredient                      !  Move Data to Queue
      BQ7:Measure = ING:Measure                            !  Move Data to Queue
      BQ7:Quantity = ING:Quantity                          !  Move Data to Queue
                                                           !
    OF TCACTION:InsertRecord                               !Insert Record Action
      GET(INGREDIENT,0)                                    !  Clear Pending Record
      CLEAR(ING:RECORD)                                    !  Clear Record Area
      SELECT(?List2,1)                                     !  Insert Record On Top Line
      BrowseAdvanced:Update7(?List2,TCACTION:InsertRecord,SQ7:SortOrder) !  Call In-Line Update Procedure
      TC:BRW:Action[hBrowse7] = 0                          !  Tell Browse to Redisplay
      TC:BRW:SetToKey[hBrowse7] = 1                        !  Record at the current positon
                                                           !
    OF TCACTION:ChangeRecord                               !Change Record Action
      BrowseAdvanced:Update7(?List2,TCACTION:ChangeRecord,SQ7:SortOrder) !  Call In-Line Update Procedure
      GET(BrowseQueue2,TC:BRW:CurItem[hBrowse7])           !  Reread Queue Entry
      EXECUTE SQ7:SortOrder                                !  Set Key Positon for Current Sort Order
        BQ7:Position = POSITION(ING:Key_Ingredient)        !    Update Position for the Record
        BQ7:Position = POSITION(ING:Key_Measure)           !    Update Position for the Record
      END                                                  !  End Execute
      PUT(BrowseQueue2)                                    !  Save the Update to Position
      TC:BRW:Action[hBrowse7] = 0                          !  Tell Browse to Redisplay
      TC:BRW:SetToItem[hBrowse7] = 1                       !  Record at the current positon
                                                           !
    OF TCACTION:DeleteRecord                               !Delete Record Action
      TC:BRW:AbortDel[hBrowse7] = 1                        !  Tell Browse Not To Handle Delete
      BrowseAdvanced:Update7(?List2,TCACTION:DeleteRecord,SQ7:SortOrder) !  Call In-Line Update Procedure
      TC:BRW:Action[hBrowse7] = 0                          !  Tell Browse to Redisplay
      TC:BRW:SetToItem[hBrowse7] = 1                       !  Record at the current positon
                                                           !
    OF TCACTION:SelectRecord                               !Select Record Action
      LocalResponse = RequestCompleted                     !  Lookup was completed
      POST(Event:CloseWindow)                              !  Return Selected Record to Caller
                                                           !
    OF TCACTION:ExitBrowse                                 !Exit Browse Action
      BREAK                                                !  
    END                                                    !End Process Browse Actions
  END                                                      !End Process File Browse Loop



!--------------------------------------------------------------------------------------------------!
! LoadSortOrders7 Routine                                                                          !
!                                                                                                  !
! This routine loads the available sort options into the SAXTabOrderQ7                             !
!--------------------------------------------------------------------------------------------------!
LoadSortOrders7      ROUTINE

  FREE(SAXTabOrderQ7)                                      !Make sure queue is empty

  SQ7:SearchPicture = '@S15'                               !Set Picture for Search Field
  SQ7:OrderName = 'By Ingredient'                          !Set Name of Sort Order
  SQ7:OrderFormat = BQ7:FORMAT:Order1                      !Set Format String for Sort Order
  ADD(SAXTabOrderQ7)                                       !Add the option

  SQ7:SearchPicture = '@S15'                               !Set Picture for Search Field
  SQ7:OrderName = 'By Measure'                             !Set Name of Sort Order
  SQ7:OrderFormat = BQ7:FORMAT:Order2                      !Set Format String for Sort Order
  ADD(SAXTabOrderQ7)                                       !Add the option

  SQ7:SortOrder = 1                                        !Default to Sort Order #1
  GET(SAXTabOrderQ7,SQ7:SortOrder)                         !Get Sort Order Entry from Queue
  SELECT(?ChangeOrder2,SQ7:SortOrder)                      !Set Initial Sort Order for Drop Box
  ?Search2{PROP:Text} = SQ7:SearchPicture                  !Set Initial Picture for Search Field
  ?List2{PROP:Format} = SQ7:OrderFormat                    !Set Initial Format for List Box
  ?ChangeOrder2{PROP:Text} = 'By Ingredient|By Measure'



!--------------------------------------------------------------------------------------------------!
! BrowseList10 Routine                                                                             !
!                                                                                                  !
! This routine calls the browser to do a page-loaded display from a file.                          !
!--------------------------------------------------------------------------------------------------!
BrowseList10         ROUTINE

  IF NOT WindowOpened THEN EXIT.                           !If Window Not Open Exit Browse.
                                                           !
  IF NOT hBrowse10                                         !If Browse Not Initialized
    hBrowse10 = TC_InitBrowse(?List3,THREAD())             !  Initialize Browse Processing for List Box
    IF LocalRequest = SelectRecord                         !  If Browse Procedure Called as a Lookup
      TC:BRW:SelectRecord[hBrowse10] = True                !    Set Double Click to Select Record
    END                                                    !  End If
  END                                                      !End If
                                                           !
  LOOP                                                     !Process File Browse Loop
    TC_Browse(hBrowse10            ,|                      !  Browse Handle
              INSTRUCTION          ,|                      !  File Name
              INS:RECORD           ,|                      !  Record Area
              INS:Key_Step         ,|                      !  Key Order for Display
              BrowseQueue3         ,|                      !  Queue Name for List
              BQ10:Position        ,|                      !  Record Position in Key Order
              INS:RecipeNo         ,|                      !  Range Field
              RCP:RecipeNo         ,|                      !  Match Range - Low Value
              RCP:RecipeNo         )                       !  Match Range - High Value

    CASE TC:BRW:Action[hBrowse10]                          !Process Browse Actions
    OF TCACTION:FillQueue                                  !Fill List Queue Action
      MQ1:RecipeNo = RCP:RecipeNo                          !  Prepare to Search for Marked Record
      GET(MarkQueue,MQ1:RecipeNo)                          !  See if Record is Marked
      IF (NOT MarkAllFlag AND NOT ERROR()) OR |            !  If Record is Marked
          (MarkAllFlag AND ERROR())                        !
        MarkStatus = 'X'                                   !    Show Record as Marked
      ELSE                                                 !  Otherwise
        MarkStatus = ''                                    !    Show Record as Not Marked
      END                                                  !  End If
      MQ11:Date = MEN:Date                                 !  Prepare to Search for Marked Record
      GET(MarkQueue4,MQ11:Date)                            !  See if Record is Marked
      IF (NOT MarkAllFlag4 AND NOT ERROR()) OR |           !  If Record is Marked
          (MarkAllFlag4 AND ERROR())                       !
        MarkStatus4 = 'X'                                  !    Show Record as Marked
      ELSE                                                 !  Otherwise
        MarkStatus4 = ''                                   !    Show Record as Not Marked
      END                                                  !  End If
      BQ10:Step = INS:Step                                 !  Move Data to Queue
      BQ10:Instruction = INS:Instruction                   !  Move Data to Queue
                                                           !
    OF TCACTION:InsertRecord                               !Insert Record Action
      GET(INSTRUCTION,0)                                   !  Clear Pending Record
      CLEAR(INS:RECORD)                                    !  Clear Record Area
      SELECT(?List3,1)                                     !  Insert Record On Top Line
      BrowseAdvanced:Update10(?List3,TCACTION:InsertRecord) !  Call In-Line Update Procedure
      TC:BRW:Action[hBrowse10] = 0                         !  Tell Browse to Redisplay
      TC:BRW:SetToKey[hBrowse10] = 1                       !  Record at the current positon
                                                           !
    OF TCACTION:ChangeRecord                               !Change Record Action
      BrowseAdvanced:Update10(?List3,TCACTION:ChangeRecord) !  Call In-Line Update Procedure
      GET(BrowseQueue3,TC:BRW:CurItem[hBrowse10])          !  Reread Queue Entry
      BQ10:Position = POSITION(INS:Key_Step)               !  Update Position for the Record
      PUT(BrowseQueue3)                                    !  Save the Update to Position
      TC:BRW:Action[hBrowse10] = 0                         !  Tell Browse to Redisplay
      TC:BRW:SetToItem[hBrowse10] = 1                      !  Record at the current positon
                                                           !
    OF TCACTION:DeleteRecord                               !Delete Record Action
      TC:BRW:AbortDel[hBrowse10] = 1                       !  Tell Browse Not To Handle Delete
      BrowseAdvanced:Update10(?List3,TCACTION:DeleteRecord) !  Call In-Line Update Procedure
      TC:BRW:Action[hBrowse10] = 0                         !  Tell Browse to Redisplay
      TC:BRW:SetToItem[hBrowse10] = 1                      !  Record at the current positon
                                                           !
    OF TCACTION:SelectRecord                               !Select Record Action
      LocalResponse = RequestCompleted                     !  Lookup was completed
      POST(Event:CloseWindow)                              !  Return Selected Record to Caller
                                                           !
    OF TCACTION:ExitBrowse                                 !Exit Browse Action
      BREAK                                                !  
    END                                                    !End Process Browse Actions
  END                                                      !End Process File Browse Loop



!--------------------------------------------------------------------------------------------------!
! BrowseList11 Routine                                                                             !
!                                                                                                  !
! This routine calls the browser to do a page-loaded display from a file.                          !
!--------------------------------------------------------------------------------------------------!
BrowseList11         ROUTINE

  IF NOT WindowOpened THEN EXIT.                           !If Window Not Open Exit Browse.
                                                           !
  IF NOT hBrowse11                                         !If Browse Not Initialized
    hBrowse11 = TC_InitBrowse(?List4,THREAD())             !  Initialize Browse Processing for List Box
    IF LocalRequest = SelectRecord                         !  If Browse Procedure Called as a Lookup
      TC:BRW:SelectRecord[hBrowse11] = True                !    Set Double Click to Select Record
    END                                                    !  End If
  END                                                      !End If
                                                           !
  LOOP                                                     !Process File Browse Loop
    TC_Browse(hBrowse11            ,|                      !  Browse Handle
              MENU                 ,|                      !  File Name
              MEN:RECORD           ,|                      !  Record Area
              MEN:Key_Date         ,|                      !  Key Order for Display
              BrowseQueue4         ,|                      !  Queue Name for List
              BQ11:Position        )                       !  Record Position in Key Order

    CASE TC:BRW:Action[hBrowse11]                          !Process Browse Actions
    OF TCACTION:FillQueue                                  !Fill List Queue Action
      MQ1:RecipeNo = RCP:RecipeNo                          !  Prepare to Search for Marked Record
      GET(MarkQueue,MQ1:RecipeNo)                          !  See if Record is Marked
      IF (NOT MarkAllFlag AND NOT ERROR()) OR |            !  If Record is Marked
          (MarkAllFlag AND ERROR())                        !
        MarkStatus = 'X'                                   !    Show Record as Marked
      ELSE                                                 !  Otherwise
        MarkStatus = ''                                    !    Show Record as Not Marked
      END                                                  !  End If
      MQ11:Date = MEN:Date                                 !  Prepare to Search for Marked Record
      GET(MarkQueue4,MQ11:Date)                            !  See if Record is Marked
      IF (NOT MarkAllFlag4 AND NOT ERROR()) OR |           !  If Record is Marked
          (MarkAllFlag4 AND ERROR())                       !
        MarkStatus4 = 'X'                                  !    Show Record as Marked
      ELSE                                                 !  Otherwise
        MarkStatus4 = ''                                   !    Show Record as Not Marked
      END                                                  !  End If
      CLEAR(RCP:RECORD)
      RCP:RecipeNo = MEN:MainRcpNo
      GET(RECIPE,RCP:Key_RecipeNo)
      MainRcpDsp = RCP:Code
      
      CLEAR(RCP:RECORD)
      RCP:RecipeNo = MEN:SideRcpNo
      GET(RECIPE,RCP:Key_RecipeNo)
      SideRcpDsp = RCP:Code
      
      CLEAR(RCP:RECORD)
      RCP:RecipeNo = MEN:DessertRcpNo
      GET(RECIPE,RCP:Key_RecipeNo)
      DessertRcpDsp = RCP:Code
      
            BQ11:MarkStatus4 = MarkStatus4                 !  Move Data to Queue
      BQ11:Date = MEN:Date                                 !  Move Data to Queue
      BQ11:MainRcpDsp = MainRcpDsp                         !  Move Data to Queue
      BQ11:SideRcpDsp = SideRcpDsp                         !  Move Data to Queue
      BQ11:DessertRcpDsp = DessertRcpDsp                   !  Move Data to Queue
                                                           !
    OF TCACTION:InsertRecord                               !Insert Record Action
      GET(MENU,0)                                          !  Clear Pending Record
      CLEAR(MEN:RECORD)                                    !  Clear Record Area
      GlobalRequest = InsertRecord                         !  Tell Form To Insert Record
      UpdateMenu                                           !  Insert Record
      IF GlobalResponse = RequestCompleted                 !  If Record Added
        TC:BRW:Action[hBrowse11] = 0                       !    Tell Browse to Redisplay
        TC:BRW:SetToPosition[hBrowse11] = 1                !    Record at the Current Positon
      END                                                  !  End If
                                                           !
    OF TCACTION:ChangeRecord                               !Change Record Action
      GlobalRequest = ChangeRecord                         !  Tell Form To Change Record
      UpdateMenu                                           !  Change Record
      IF GlobalResponse = RequestCompleted                 !  If Record Added
        TC:BRW:Action[hBrowse11] = 0                       !    Tell Browse to Redisplay
        TC:BRW:SetToPosition[hBrowse11] = 1                !    Record at the Current Positon
      END                                                  !  End If
                                                           !
    OF TCACTION:DeleteRecord                               !Delete Record Action
      TC:BRW:AbortDel[hBrowse11] = 1                       !  Tell Browse Not To Handle Delete
      GlobalRequest = DeleteRecord                         !  Tell Form To Delete Record
      UpdateMenu                                           !  Delete Record
      IF GlobalResponse = RequestCompleted                 !  If Record Deleted
        TC:BRW:Action[hBrowse11] = 0                       !    Tell Browse to Redisplay
        TC:BRW:SetToItem[hBrowse11] = 1                    !    Record at the Current Item
      END                                                  !  End If
                                                           !
    OF TCACTION:SelectRecord                               !Select Record Action
      LocalResponse = RequestCompleted                     !  Lookup was completed
      POST(Event:CloseWindow)                              !  Return Selected Record to Caller
                                                           !
    OF TCACTION:ExitBrowse                                 !Exit Browse Action
      BREAK                                                !  
    END                                                    !End Process Browse Actions
  END                                                      !End Process File Browse Loop



!--------------------------------------------------------------------------------------------------!
! Display Hot Lists Routine                                                                        !
!                                                                                                  !
! Redisplays Hot Lists Boxes for the Parent List Box.                                              !
!--------------------------------------------------------------------------------------------------!
DisplayHotLists1     ROUTINE
  
  TC:BRW:Action[hBrowse7] = 0                              !Tell Browse to Redisplay
  TC:BRW:DontSelect[hBrowse7] = 1                          !Tell Browse not to Select the List Box
  DO BrowseList7                                           !Call Browse Routine for the List Box
  TC:BRW:Action[hBrowse10] = 0                             !Tell Browse to Redisplay
  TC:BRW:DontSelect[hBrowse10] = 1                         !Tell Browse not to Select the List Box
  DO BrowseList10                                          !Call Browse Routine for the List Box
  
  
  
!--------------------------------------------------------------------------------------------------!
! WrapUp Routine                                                                                   !
!                                                                                                  !
! End of procedure cleanup and exit.                                                               !
!--------------------------------------------------------------------------------------------------!
WrapUp             ROUTINE

  INGREDIENT::Used -= 1
  IF INGREDIENT::Used = 0 THEN CLOSE(INGREDIENT).
  INSTRUCTION::Used -= 1
  IF INSTRUCTION::Used = 0 THEN CLOSE(INSTRUCTION).
  MENU::Used -= 1
  IF MENU::Used = 0 THEN CLOSE(MENU).
  RECIPE::Used -= 1
  IF RECIPE::Used = 0 THEN CLOSE(RECIPE).

  IF WindowOpened
    INISaveWindow('BrowseAdvanced','PTDEMO.INI')
    CLOSE(Screen)
  END

  TC_EndBrowse(hBrowse1)                                   !Terminate Browse
  FREE(SAXTabOrderQ1)                                      !Release Memory use by SortOrder Queue
  FREE(BrowseQueue1)                                       !Release Memory use by Browse Queue
  TC_EndBrowse(hBrowse7)                                   !Terminate Browse
  FREE(SAXTabOrderQ7)                                      !Release Memory use by SortOrder Queue
  FREE(BrowseQueue2)                                       !Release Memory use by Browse Queue
  TC_EndBrowse(hBrowse10)                                  !Terminate Browse
  FREE(BrowseQueue3)                                       !Release Memory use by Browse Queue
  TC_EndBrowse(hBrowse11)                                  !Terminate Browse
  FREE(BrowseQueue4)                                       !Release Memory use by Browse Queue
  FREE(MarkQueue)                                          !Release Memory use by Mark Records Queue
  FREE(MarkQueue4)                                         !Release Memory use by Mark Records Queue

  GlobalResponse = LocalResponse
  RETURN




!==================================================================================================!
!                                                                                                  !
! BrowseAdvanced:Update7 Procedure                                                                 !
! ------------------------------------                                                             !
! FILE NAME   : INGREDIENT                                                                         !
! LIST CONTROL: ?List2                                                                             !
! FROM QUEUE  : BrowseQueue2                                                                       !
!                                                                                                  !
!==================================================================================================!
BrowseAdvanced:Update7 PROCEDURE(ListControl,UpdateAction,SortOrder)

FieldOrder1          EQUATE('1,2,3')                       !Field Order for Sort Order 1
FieldOrder2          EQUATE('2,3,1')                       !Field Order for Sort Order 2

?ING:Ingredient      EQUATE(101)                           !Set Field Number for ?ING:Ingredient 
?ING:Measure         EQUATE(102)                           !Set Field Number for ?ING:Measure 
?ING:Quantity        EQUATE(103)                           !Set Field Number for ?ING:Quantity 

InLineFieldSetup     GROUP
                       LONG(CREATE:Entry)                  !Control Type for ?ING:Ingredient
                       LONG(CREATE:DropList)               !Control Type for ?ING:Measure
                       LONG(CREATE:Spin)                   !Control Type for ?ING:Quantity
                     END
InLineFields         LONG,DIM(3),OVER(InLineFieldSetup)

SAVE:NoBar           BYTE
SAVE:ING:RECORD      STRING(SIZE(ING:RECORD))



!--------------------------------------------------------------------------------------------------!
! Code Section                                                                                     !
!--------------------------------------------------------------------------------------------------!
  CODE

  CASE UpdateAction                                        !Process Setup for Update Actions
  OF TCACTION:InsertRecord                                 !On Insert New Record
    ING:RecipeNo = RCP:RecipeNo
    ING:Quantity = 1                                       !  Prime Field
    SAVE:ING:RECORD = ING:RECORD                           !  Save the Current Record
                                                           !
  OF TCACTION:ChangeRecord                                 !On Change Record
    SAVE:ING:RECORD = ING:RECORD                           !  Save the Current Record
                                                           !
  OF TCACTION:DeleteRecord                                 !On Delete Record
    DO DeleteRecord                                        !  Delete the Record
    RETURN                                                 !  Exit Update Procedure
  END                                                      !End Case
                                                           !
  SAVE:NoBar = ListControl{PROP:NoBar}                     !Save Point Bar Hide Selection Setting
  ListControl{PROP:NoBar} = 1                              !Turn Off Point Bar
                                                           !
  LOOP                                                     !Process InLine Actions
    TC:INL:AbortKey = EscKey                               !Set Abort Key
    TC:INL:FirstField = ?ING:Ingredient                    !Set First Field Number
    EXECUTE SortOrder                                      !Edit by Sort Order
      TC_InLine(ListControl,InLineFields[],FieldOrder1)    !Call InLine Editing
      TC_InLine(ListControl,InLineFields[],FieldOrder2)    !Call InLine Editing
    END                                                    !End Execute
                                                           !
    CASE TC:INL:Action                                     !Process InLine Actions
    OF TCACTION:SetFields                                  !Set Field Properties Action
      !--------- ?ING:Ingredient ---------
      ?ING:Ingredient{PROP:Use} = ING:Ingredient
      ?ING:Ingredient{PROP:Msg} = 'Enter an Ingredient'

      !--------- ?ING:Measure ---------
      ?ING:Measure{PROP:Use} = ING:Measure
      ?ING:Measure{PROP:Msg} = 'Select a Measure'
      ?ING:Measure{PROP:Drop} = 7  
      ?ING:Measure{PROP:From} = 'cup|gallon|lb|ounce|pint|Tbl|tsp'
      ?ING:Measure{PROP:Format} = '32L@S8@'

      !--------- ?ING:Quantity ---------
      ?ING:Quantity{PROP:Use} = ING:Quantity
      ?ING:Quantity{PROP:Msg} = 'Select a Quantity'
      ?ING:Quantity{PROP:RangeHigh} = 99
      ?ING:Quantity{PROP:RangeLow} = 1
      ?ING:Quantity{PROP:Step} = 1

    
    OF TCACTION:FieldEdits                                 !Process Field Edits Action
      CASE FIELD()
      OF ?ING:Measure
        IF NOT ING:Measure
          BEEP
          SELECT(?ING:Measure)
        END
      
            END
    
    OF TCACTION:UpdateRecord                               !Update Record Action
      LOOP                                                 !Attempt to Update Until Done or Canceled
        SETCURSOR(Cursor:Wait)                             !  Show Hour-Glass Cursor
        IF UpdateAction = TCACTION:InsertRecord            !  If Inserting a New Record
          ADD(INGREDIENT)                                  !    Add the Record
          Error# = ERRORCODE()                             !    Set Error Flag
        ELSE                                               !  Otherwise on Updating a Record
          Error# = RIUpdate:INGREDIENT(SAVE:ING:RECORD)    !    Call RI Update and Set Error Flag
        END                                                !  End If
        IF Error#                                          !  If Error Updating
          SETCURSOR()                                      !    Reset to Normal Cursor
          CASE StandardWarning(Warn:UpdateError)           !    Ask If User Wants to Try Saving Again
          OF Button:Yes                                    !    On YES Button
             CYCLE                                         !      Retry Update Operation
          OF Button:No                                     !    On NO Button
            BREAK                                          !      Exit without Updating Record
          OF Button:Cancel                                 !    On Cancel Button
            TC:INL:AbortUpdate = True                      !      Tell Inline to Cancel Update Request
            BREAK                                          !      Go back to editing record
          END                                              !    End Case
        END                                                !  End If
        SETCURSOR()                                        !  Reset to Normal Cursor
        BREAK                                              !  Exit Update Loop
      END                                                  !End Loop
                                                           !
    OF TCACTION:AbortUpdate                                !Abort Update Action
      IF TC:INL:ResizeWindow THEN CYCLE.                   !Always abort changes on resize
      IF SAVE:ING:RECORD <> ING:RECORD                     !If the Record was Changed
        CASE StandardWarning(Warn:ConfirmCancel)           !  Display Standard Confirm Window
        OF Button:Yes                                      !  On YES Button
          TC:INL:AbortUpdate = False                       !    Cancel the Request to Abort
          SELECT(ListControl)                              !    Exit Editing and Save Changes
        OF Button:No                                       !  On NO Button
          TC:INL:AbortUpdate = True                        !    Go Ahead and Abandon the Changes
        OF BUTTON:Cancel                                   !  On Cancel Button
          TC:INL:AbortUpdate = False                       !    Cancel the Request and Continue
        END                                                !  End Case
      END                                                  !End If
      IF UpdateAction = TCACTION:InsertRecord              !If Adding a New Record
        IF TC:INL:AbortUpdate = True                       !  If Record Add was Aborted
          DELETE(INGREDIENT)                               !    Delete the New Record from the File
        END                                                !  End If
      END                                                  !End If
                                                           !
    OF TCACTION:ExitInLine                                 !Exit InLine Action
      BREAK                                                !
    END                                                    !End Case on Actions
  END                                                      !End Loop
                                                           !
  ListControl{PROP:NoBar} = SAVE:NoBar                     !Restore Hide Selection Setting




!--------------------------------------------------------------------------------------------------!
! Delete Record Routine                                                                            !
!                                                                                                  !
! This routine Deletes the Record.                                                                 !
!--------------------------------------------------------------------------------------------------!
DeleteRecord         ROUTINE

  Confirm# = MESSAGE('Delete the selected record?',,|      !Display Message Requesting Confirmation
                     ICON:Question,Button:Yes+Button:No,|  !
                     Button:Yes,0)                         !
                                                           !
  IF Confirm# = Button:No                                  !If User Did Not Confirm Delete
    EXIT                                                   !  Abort Delete
  END                                                      !End If
  LOOP                                                     !Attempt to Delete Until Done or Canceled
    SETCURSOR(Cursor:Wait)                                 !  Show Hour-Glass Cursor
    IF RIDelete:INGREDIENT()                               !  If Error Deleting
      SETCURSOR()                                          !    Reset to Normal Cursor
      CASE StandardWarning(Warn:DeleteError)               !    Ask If User Wants to Try Deleting Again
      OF Button:Yes                                        !    On YES Button
        CYCLE                                              !      Retry Delete Operation
      OF Button:No                                         !    On NO Button
      OROF Button:Cancel                                   !    Or On Cancel Button
        BREAK                                              !      Exit without Deleting Record
      END                                                  !    End Case
    END                                                    !  End If
    SETCURSOR()                                            !  Reset to Normal Cursor
    BREAK                                                  !  Exit Delete Loop
  END                                                      !End Loop




!==================================================================================================!
!                                                                                                  !
! BrowseAdvanced:Update10 Procedure                                                                !
! ------------------------------------                                                             !
! FILE NAME   : INSTRUCTION                                                                        !
! LIST CONTROL: ?List3                                                                             !
! FROM QUEUE  : BrowseQueue3                                                                       !
!                                                                                                  !
!==================================================================================================!
BrowseAdvanced:Update10 PROCEDURE(ListControl,UpdateAction)

FieldOrder           EQUATE('1,2')                         !Field Order for Sort Order 

?INS:Step            EQUATE(104)                           !Set Field Number for ?INS:Step 
?INS:Instruction     EQUATE(105)                           !Set Field Number for ?INS:Instruction 

InLineFieldSetup     GROUP
                       LONG(CREATE:Spin)                   !Control Type for ?INS:Step
                       LONG(CREATE:Entry)                  !Control Type for ?INS:Instruction
                     END
InLineFields         LONG,DIM(2),OVER(InLineFieldSetup)

SAVE:NoBar           BYTE
SAVE:INS:RECORD      STRING(SIZE(INS:RECORD))



!--------------------------------------------------------------------------------------------------!
! Code Section                                                                                     !
!--------------------------------------------------------------------------------------------------!
  CODE

  CASE UpdateAction                                        !Process Setup for Update Actions
  OF TCACTION:InsertRecord                                 !On Insert New Record
    INS:RecipeNo = RCP:RecipeNo
    SAVE:INS:RECORD = INS:RECORD                           !  Save the Current Record
                                                           !
  OF TCACTION:ChangeRecord                                 !On Change Record
    SAVE:INS:RECORD = INS:RECORD                           !  Save the Current Record
                                                           !
  OF TCACTION:DeleteRecord                                 !On Delete Record
    DO DeleteRecord                                        !  Delete the Record
    RETURN                                                 !  Exit Update Procedure
  END                                                      !End Case
                                                           !
  SAVE:NoBar = ListControl{PROP:NoBar}                     !Save Point Bar Hide Selection Setting
  ListControl{PROP:NoBar} = 1                              !Turn Off Point Bar
                                                           !
  LOOP                                                     !Process InLine Actions
    TC:INL:AbortKey = EscKey                               !Set Abort Key
    TC:INL:FirstField = ?INS:Step                          !Set First Field Number
    TC_InLine(ListControl,InLineFields[],FieldOrder)       !Call InLine Editing
                                                           !
    CASE TC:INL:Action                                     !Process InLine Actions
    OF TCACTION:SetFields                                  !Set Field Properties Action
      !--------- ?INS:Step ---------
      ?INS:Step{PROP:Use} = INS:Step
      ?INS:Step{PROP:Msg} = 'Select the Step Number'
      ?INS:Step{PROP:RangeHigh} = 99
      ?INS:Step{PROP:RangeLow} = 1
      ?INS:Step{PROP:Step} = 1

      !--------- ?INS:Instruction ---------
      ?INS:Instruction{PROP:Use} = INS:Instruction
      ?INS:Instruction{PROP:Msg} = 'Enter Instructions for this step'

    OF TCACTION:UpdateRecord                               !Update Record Action
      LOOP                                                 !Attempt to Update Until Done or Canceled
        SETCURSOR(Cursor:Wait)                             !  Show Hour-Glass Cursor
        IF UpdateAction = TCACTION:InsertRecord            !  If Inserting a New Record
          ADD(INSTRUCTION)                                 !    Add the Record
          Error# = ERRORCODE()                             !    Set Error Flag
        ELSE                                               !  Otherwise on Updating a Record
          Error# = RIUpdate:INSTRUCTION(SAVE:INS:RECORD)   !    Call RI Update and Set Error Flag
        END                                                !  End If
        IF Error#                                          !  If Error Updating
          SETCURSOR()                                      !    Reset to Normal Cursor
          CASE StandardWarning(Warn:UpdateError)           !    Ask If User Wants to Try Saving Again
          OF Button:Yes                                    !    On YES Button
             CYCLE                                         !      Retry Update Operation
          OF Button:No                                     !    On NO Button
            BREAK                                          !      Exit without Updating Record
          OF Button:Cancel                                 !    On Cancel Button
            TC:INL:AbortUpdate = True                      !      Tell Inline to Cancel Update Request
            BREAK                                          !      Go back to editing record
          END                                              !    End Case
        END                                                !  End If
        SETCURSOR()                                        !  Reset to Normal Cursor
        BREAK                                              !  Exit Update Loop
      END                                                  !End Loop
                                                           !
    OF TCACTION:AbortUpdate                                !Abort Update Action
      IF TC:INL:ResizeWindow THEN CYCLE.                   !Always abort changes on resize
      IF SAVE:INS:RECORD <> INS:RECORD                     !If the Record was Changed
        CASE StandardWarning(Warn:ConfirmCancel)           !  Display Standard Confirm Window
        OF Button:Yes                                      !  On YES Button
          TC:INL:AbortUpdate = False                       !    Cancel the Request to Abort
          SELECT(ListControl)                              !    Exit Editing and Save Changes
        OF Button:No                                       !  On NO Button
          TC:INL:AbortUpdate = True                        !    Go Ahead and Abandon the Changes
        OF BUTTON:Cancel                                   !  On Cancel Button
          TC:INL:AbortUpdate = False                       !    Cancel the Request and Continue
        END                                                !  End Case
      END                                                  !End If
      IF UpdateAction = TCACTION:InsertRecord              !If Adding a New Record
        IF TC:INL:AbortUpdate = True                       !  If Record Add was Aborted
          DELETE(INSTRUCTION)                              !    Delete the New Record from the File
        END                                                !  End If
      END                                                  !End If
                                                           !
    OF TCACTION:ExitInLine                                 !Exit InLine Action
      BREAK                                                !
    END                                                    !End Case on Actions
  END                                                      !End Loop
                                                           !
  ListControl{PROP:NoBar} = SAVE:NoBar                     !Restore Hide Selection Setting




!--------------------------------------------------------------------------------------------------!
! Delete Record Routine                                                                            !
!                                                                                                  !
! This routine Deletes the Record.                                                                 !
!--------------------------------------------------------------------------------------------------!
DeleteRecord         ROUTINE

  Confirm# = MESSAGE('Delete the selected record?',,|      !Display Message Requesting Confirmation
                     ICON:Question,Button:Yes+Button:No,|  !
                     Button:Yes,0)                         !
                                                           !
  IF Confirm# = Button:No                                  !If User Did Not Confirm Delete
    EXIT                                                   !  Abort Delete
  END                                                      !End If
  LOOP                                                     !Attempt to Delete Until Done or Canceled
    SETCURSOR(Cursor:Wait)                                 !  Show Hour-Glass Cursor
    IF RIDelete:INSTRUCTION()                              !  If Error Deleting
      SETCURSOR()                                          !    Reset to Normal Cursor
      CASE StandardWarning(Warn:DeleteError)               !    Ask If User Wants to Try Deleting Again
      OF Button:Yes                                        !    On YES Button
        CYCLE                                              !      Retry Delete Operation
      OF Button:No                                         !    On NO Button
      OROF Button:Cancel                                   !    Or On Cancel Button
        BREAK                                              !      Exit without Deleting Record
      END                                                  !    End Case
    END                                                    !  End If
    SETCURSOR()                                            !  Reset to Normal Cursor
    BREAK                                                  !  Exit Delete Loop
  END                                                      !End Loop




