
{ General structure of MAREA.DAT and FAREA.DAT:

   MAREA_ID or FAREA_ID
   _msgarea
       _ovride ...
       zstr heap
   _msgarea
       _ovride ...
       zstr heap
   eof
}


{* This key is present at the beginning of an area file.  MAREA_ID is
 * used for the message data file and FAREA_ID is used for the
 * file data file.
 *}

Const MAREA_ID      =$1a49023f;
      FAREA_ID      =$1a01953a;

      ADATA_START   =4;          { The area data info starts at offset 4 }

type POverride=^Override;
     Override=Record
  {* Only one of 'opt' or 'name' should be used.  If opt==0, use name.  If  *
   * name==0, use opt.                                                      *}

  opt:option;           { Type of menu option to override     ...OR...     }
  name:Char;            { First letter of command to override              }
  rsvd1:Byte;           { Reserved for future use                          }
  acs:zstr;             { New ACS required to access option                }
  menuname:zstr;        { Use this access level on the given menu only     }
  end;

{ Bit masks for the ma.attribs field }

Const MA_PVT      =$0001;  { Private msgs allowed }
      MA_PUB      =$0002;  { Public msgs allowed }
      MA_HIBIT    =$0004;  { High bit msgs allowed }

      MA_NET      =$0008;  { Netmail area }
      MA_ECHO     =$0010;  { Echomail area }
      MA_CONF     =$0020;  { Conference area }

      MA_ANON     =$0040;  { Anonymous messages are OK }
      MA_NORNK    =$0080;  { Don't use the REALNAME kludge for this area }
      MA_REAL     =$0100;  { Force  use of       real name for this area }
      MA_ALIAS    =$0200;  { Force  use of alias      name for this area }
      MA_AUDIT    =$0400;  { Use auditing (msg tracking) controls in area}
      MA_READONLY =$0800;  { Area is read-only                           }
      MA_HIDDN    =$1000;  { Area does not display on normal area list   }
      MA_ATTACH   =$2000;  { Area allows local file attaches             }
      MA_DIVBEGIN =$4000;  { A message area division, not a real area    }
      MA_DIVEND   =$8000;  { End of the message area division            }

      MA2_NOMCHK  =$0001;  { Don't do personal mail check in this area   }

      MA_SHARED   =MA_ECHO Or MA_CONF;


{ Bit masks for fa.attribs }

      FA_SLOW     =$0001;  { Slow-access medium: skip existence checks }
      FA_STAGED   =$0002;  { Used staged transfer area for downloads }
      FA_NONEW    =$0004;  { Permanent storage - skip for new file checks }
      FA_HIDDN    =$0008;  { Area does not display on normal area list }
      FA_DIVBEGIN =$4000;  { A file area division, not a real area }
      FA_DIVEND   =$8000;  { End of file area division }
      FA_AUTODATE =$0010;  { Auto-date override }
      FA_MANDATE  =$0020;  { Manual date override }
      FA_LISTDATE =$0040;  { List-date override }
      FA_FREETIME =$0100;  { Free download time for all files }
      FA_FREESIZE =$0200;  { Free download bytes for all files }
      FA_NOINDEX  =$0400;  { Don't add this area to maxfiles.idx }

      FA_CDROM    =(FA_SLOW or FA_STAGED or FA_NONEW);
      FA_FREEALL  =(FA_FREETIME or FA_FREESIZE);

{ this is the first bit of the file/msg area record. It's common to
  both types and is defined here for use by common internal load/save
  area routines.
}
Type PAreaCommon=^AreaCommon;
     AreaCommon=Record
         cbArea:Word;          { Length of THIS INDIVIDUAL RECORD                0}
         num_override:Word;    { Number of overrides following this record       2}
         cbHeap:Word;          { Length of the zstr heap following the overrides 4}
         division:Word;        { Reserved for future use                         6}
         end;

type marea=Record
  cbArea:Word;          { Length of THIS INDIVIDUAL RECORD                0}
  num_override:Word;    { Number of overrides following this record       2}
  cbHeap:Word;          { Length of the zstr heap following the overrides 4}
  division:Word;        { Reserved for future use                         6}
  name:ZStr;            { String format of area's name.                   8}
  acs:ZStr;             { Access control string for this area            10}
  path:ZStr;            { Path to messages (but for MA_DIVBEGIN only,    12*
                         * used instead as name of custom .bbs file).       }
  echo_tag:ZStr;        { The 'tag' of the area, for use in ECHOTOSS.LOG 14}
  descript:ZStr;        { The DIR.BBS-like description for msg section   16}
  origin:ZStr;          { The ORIGIN line for this area                  18}
  menuname:ZStr;        { Custom menu name                               20}
  menureplace:ZStr;     { Replace this menu name with menuname from above22}

  attribs:Word;         { Attributes for this area                       24}

  primary:NetAddr;      { Use as primary address for this area           26}
  seenby:NetAddr;       { Use as address in seen-bys                     34}
  attribs_2:Word;       { More attributes                                42}
  atype:Word;           { Message base type.  MSGTYPE_SDM = *.MSG.       44*
                         * MSGTYPE_SQUISH = SquishMail.  (Constants are     *
                         * in MSGAPI.H)                                     }
  killbyage:Word;       { Make sure msgs are less than X days old        46}
  killbynum:Word;       { Make sure there are less than X msgs           48}
  killskip:Word;        { Exempt the first X msgs from this processing   50}
  barricade:ZStr;       { Barricade file                                 52}
  barricademenu:ZStr;   { Apply barricade priv while using this menu     54}
  cbPrior:sdword;       { Seek offset from start of this area to get back56*
                         * to prior area.                                   }
  attachpath:ZStr;      { Reserved for future use                        58}
  rsvd4:Longint;                                                        {60}
  End;                                                                  {64}


type farea=Record
  cbArea:Word;          { Length of THIS INDIVIDUAL RECORD                0}
  num_override:Word;    { Number of overrides following this record       2}
  cbHeap:Word;          { Length of the zstr heap following the overrides 4}
  division:Word;        { Reserved for future use                         6}

  acs:ZStr;             { Access control string for this area             8}
  name:ZStr;            { String format of area's name.                  10}
  downpath:ZStr;        { Path for downloads.                            12}
  uppath:ZStr;          { Path for uploads                               14}
  filesbbs:ZStr;        { Path to FILES.BBS-like catalog for this area   16*
                         * (For FA_DIVBEGIN only, also used as name of      *
                         * custom .bbs display file.)                       }
  descript:ZStr;        { The DIR.BBS-like description for file section  18}
  menuname:ZStr;        { Custom menu for this file area                 20}
  menureplace:ZStr;     { Replace this menu name with menuname from above22}
  barricade:ZStr;       { Barricade file                                 24}
  barricademenu:ZStr;   { Barricade file                                 26}
  cbPrior:sdword;       { Offset to prior area                           28}
  attribs:Word;         { Attributes for this file area                  32}
  date_style:sword;     { Date style override for this area              34}
  rsvd1:Array[1..28] of byte;  { Reserved by Maximus for future use      36}
  end;                                                                  {64}


type barinfo=Record
  use_barpriv:Int;            { Use the privs in this structure? }
  priv:Word;                  { New priv level to use while in this area }
  keys:Longint;               { New keys to use while in this area }
  End;

{ In-memory handles for accessing message and file areas }

Const MaxOverrides=65520 div Sizeof(Override);
Type  POverrideList=^OverrideList;
      OverrideList =Array[0..MaxOverrides] of Override;
                   { only enough of this structure is allocated to hold
                     the overrides in the particular area. (ie the size
                     could be 0 or more - see xAH.xA.num_override for the
                     true size).
                   }

type P_AH=^_AH;                 { common denominator area handle }
     _AH=Record                 { Load/Save internal use only!   }
         ov:POverrideList;
         heap:PChar;
         heap_size:Int;
         bi:BARINFO;
         a:AreaCommon;
         end;


type PMAH=^MAH;
     MAH=Record
         ov:POverrideList;
         heap:PChar;
         heap_size:Int;
         bi:BARINFO;
         ma:MAREA;
         end;

Type PFAH=^FAH;
     FAH=Record
         ov:POverrideList;
         heap:PChar;
         heap_size:Int;
         bi:BARINFO;
         fa:FAREA;
         end;


{ Index structure for message/file areas }

type mfidx=Record
     name:Array[0..15] of Char;        { First 15 chars of area name   }
     name_hash:LongInt;                { SquishHash of full area name  }
     ofs:LongInt;                      { Offset within data file       }
     End;

{ End of NewArea.PAS }
