{*# name=Main Maximus header file
*}

{$I Prog}

{***************************************************************************
                          Miscellanious Macros
 ***************************************************************************}
{
#ifdef __TURBOC__
      isupsp(c) (_ctype[(c) + 1] & (_IS_UPP | _IS_SP))
#else
      isupsp(c) (isupper(c) || isspace(c))
#endif

      MNU(m,o)            (((m).menuheap)+(m).o)
      MsgAreaHasLock(a,l) ((a).msglock & (1L << (dword)(l)))
      FileAreaHasLock(a,l)((a).filelock & (1L << (dword)(l)))
      GEPriv(p1,p2)       ((word)(p1) >= (word)(p2))
      LEPriv(p1,p2)       ((word)(p1) <= (word)(p2))
}
{***************************************************************************
                            Constants
 ***************************************************************************}


Const FFLAG_TAG         =$0001;  {* File was T)agged                     *}
      FFLAG_THIS1       =$0002;  {* Selected during THIS wcard expansion *}
      FFLAG_NOTIME      =$0004;  {* Don't debit time for this file       *}
      FFLAG_NOBYTES     =$0008;  {* Don't debit DL bytes for this file   *}
      FFLAG_EXP         =$0010;  {* Filename was expanded from wildcard  *}
      FFLAG_NOENT       =$0020;  {* This file is not on disk             *}
      FFLAG_OK          =$0040;  {* This file previously verified for DL *}
      FFLAG_NOLIST      =$0080;  {* File is not in FILES.BBS             *}
      FFLAG_GOT         =$0100;  {* This file was uploaded               *}
      FFLAG_SENT        =$0200;  {* This file was downloaded             *}
      FFLAG_STAGE       =$0400;  {* Copy file to staging area before xfer*}
      FFLAG_SLOW        =$0800;  {* File is from from an FA_SLOW area    *}
      FFLAG_DUPE        =$8000;  {* File is a dupe                       *}

      CMSG_PAGE       =$00;  {* "You're being paged by another user!"     *}
      CMSG_ENQ        =$01;  {* "Are you on this chat channel?"           *}
      CMSG_ACK        =$02;  {* "Yes, I AM on this channel!"              *}
      CMSG_EOT        =$03;  {* "I'm leaving this chat channel!"          *}
      CMSG_CDATA      =$04;  {* Text typed by user while in chat          *}
      CMSG_HEY_DUDE   =$05;  {* A normal messge.  Always displayed.       *}
      CMSG_DISPLAY    =$06;  {* Display a file to the user                *}

      MAX_MENUNAME =PATHLEN;  {* Max. length of menuname[].               *}
      RST_VER            =3;  {* Version number of RESTARxx.BBS           *}
      MAX_LINE         =255;  {* Max. length of a .CTL file line!         *}
      PREREGISTERED  =$fffe;  {* Priv. value that means let no new        *
                                 * callers on the system.                   *}
      RESTART_MENU      =$00; {* If restarting at a menu                *}
      RESTART_DOTBBS    =$01; {* If restarting in middle of .BBS file   *}

      NUM_MENU          =256; {* Max. # of options in a menu file       *}


{* Defines for *.MNU: *}

      AREATYPE_LOCAL    =$01; {* Tells which type (and which type ONLY)  *}
      AREATYPE_MATRIX   =$02; {* that command can be used in.            *}
      AREATYPE_ECHO     =$04;
      AREATYPE_CONF     =$08;

      AREATYPE_ALL      =(AREATYPE_LOCAL or AREATYPE_MATRIX or
                           AREATYPE_ECHO or AREATYPE_CONF);

      HEADER_NONE       =$00; {* The header type for each menu.          *}
      HEADER_MESSAGE    =$01;
      HEADER_FILE       =$02;
      HEADER_CHANGE     =$03;
      HEADER_CHAT       =$04;

      OFLAG_NODSP       =$0001;{* Don't display menu option on MENU, but *}
                               {* accept it as a command.                *}
      OFLAG_CTL         =$0002;{* Produce a .CTL file for this xtern cmd *}
      OFLAG_NOCLS       =$0004;{* Don't do a CLS for this display_menu   *}
      OFLAG_THEN        =$0008;{* Do only if last IF equation was true   *}
      OFLAG_ELSE        =$0010;{* Do only if last IF equation was FALSE  *}
      OFLAG_ULOCAL      =$0020;{* Only display for local users           *}
      OFLAG_UREMOTE     =$0040;{* Only display for remote useres         *}
      OFLAG_REREAD      =$0080;{* Re-read LASTUSER.BBS upon re-entry     *}
      OFLAG_STAY        =$0100;{* Don't perform menu clean-up operations *}
      OFLAG_RIP         =$0200;{* Available for RIP callers only         *}
      OFLAG_NORIP       =$0400;{* Available for non-RIP callers only     *}

{***************************************************************************
                       Structure Definitions
 ***************************************************************************}

type NETADDR=Record
             Zone,Net,Node,Point:Word;
             end;

Type _maxcol=Record
     status_bar,       {* black on white *}
     status_cht,       {* blinking black on white *}
     status_key,       {* blinking black on white *}

     pop_text,         {* white on blue *}
     pop_border,       {* yellow on blue *}
     pop_high,         {* yellow on blue *}
     pop_list,         {* black on grey *}
     pop_lselect,      {* grey on red *}

     wfc_stat,         {* white on blue *}
     wfc_stat_bor,     {* yellow on blue *}
     wfc_modem,        {* gray on blue *}
     wfc_modem_bor,    {* lgreen on blue *}
     wfc_keys,         {* yellow on blue *}
     wfc_keys_bor,     {* white on blue *}
     wfc_activ,        {* white on blue *}
     wfc_activ_bor,    {* lcyan on blue *}
     wfc_name,         {* yellow on black *}
     wfc_line:Byte;   {* white on black *}
     end;



{* Typedefs *}

type zstr=Word;     {* Offset of string within area heap *}

{$I uclass}
{$I max_u}       {* USER.BBS structure *}
{$I option}      {* Menu option enumeration *}
{$I callinfo}    {* Caller information log *}

{* An individual menu option.  There are many of these contained in one    *
 * _menu file, following the _menu data header, optionally with some       *
 * NULL-terminated strings between each _opt structure, for the argument.  *}

Type _opt=Record
     atype:Option;  {* What this menu option does                              *}
     priv :zstr;    {* Priv level required to execute this command             *}
     rsvd :dword;   {* Bit-field locks for this particular menu option         *}
     flag :Word;    {* See the OFLAG_xxx contants for more info.               *}
     name :ZStr;    {* The menu option, as it appears to user                  *}
     keypoke:ZStr;  {* Auto-keypoke string                                     *}
     arg  :ZStr;    {* The argument for this menu option                       *}
     areatype:Byte; {* If this particular option can only be used if the user  *
                     * is in a certain message-area type.                      *}
     fill1:Byte;    {* Reserved by Maximus for future use                      *}

     rsvd2:Array[1..8] of byte; {* Reserved for future uses *}
     End;

Const DEFAULT_OPT_WIDTH=20;

Type _menu=Record
     header,        {* What to display when the user enters menu, such as  *
                     * "The MESSAGE Section", "The CHG SETUP Section", etc *}
     num_options,   {* Total number of options (struct _opt's) in menu     *}
     menu_length,   {* Number of lines long the .?BS menu file is!         *}
     opt_width:Word;{* Option width override                               *}

     hot_colour:sword; {* What colour to display if a user uses hotkeys to    *
                        * bypass a .?BS menu display, before displaying the   *
                        * key.  -1 == display nothing.                        *}

     title:Word;    {* Length of the title string, not counting \0.        *}
     headfile:Word; {* Length of the header filename, not counting \0      *}
     dspfile:Word;  {* Name of file to display for menu, instead of        *
                     * generating menu from .Mnu file.                     *}
     flag:Word;     {* See MFLAG_XXX in MAX.H.                             *}
     End;



{* Menu structure used INTERNALLY within Max itself *}

type PAmenu=^AMenu;
     amenu=Record
           M:_menu;
           opt:^_opt;
           menuheap:PChar;
           end;


Const   MFLAG_MF_NOVICE   =$0001; {* MenuFile for these levels only *}
        MFLAG_MF_REGULAR  =$0002;
        MFLAG_MF_EXPERT   =$0004;
        MFLAG_MF_RIP      =$0400;
        MFLAG_MF_ALL      =(MFLAG_MF_NOVICE or MFLAG_MF_REGULAR or
                            MFLAG_MF_EXPERT {*or MFLAG_MF_HOTFLASH*});

        MFLAG_HF_NOVICE   =$0010; {* HeaderFile for these levels only *}
        MFLAG_HF_REGULAR  =$0020;
        MFLAG_HF_EXPERT   =$0040;
        MFLAG_HF_RIP      =$0800;

        MFLAG_HF_ALL      =(MFLAG_HF_NOVICE or MFLAG_HF_REGULAR or
                            MFLAG_HF_EXPERT {*or MFLAG_HF_HOTFLASH*});

        MFLAG_SILENT      =$0100; {* Silent menuheader option *}
        MFLAG_RESET       =$0200; {* Reset term size on display *}




      STATS_VER           =1;  {* Version number of the BBSTATxx.BBS file *}

Type _bbs_stats=Record
          version      :Byte;     {* Version number of BBSTATxx.BBS file *}
          num_callers,
          quote_pos,
          msgs_written :dword;
          online_date  :time_t;
          total_dl,
          total_ul     :dword;
          today_callers:sword;
          date         :stamp_combo;
          lastuser     :array[0..35] of char;
          end;



{* Structure for entries in PROTOCOL.MAX *}
Const   P_ISPROTO =$01;  {* This bit always set                            *}
        P_BATCH   =$02;  {* Can handle batch transfers                     *}
        P_OPUS    =$04;  {* Write an Opus-style .CTL file                  *}
        P_ERL     =$08;  {* Exit with xtern_erlvl                          *}
        P_BI      =$10;  {* Bidirectional transfer                         *}

Type _proto=Record
            flag:Word;
            desc:char40;
            log,
            ctl,
            dlcmd,
            ulcmd:CharPL;
            dlstr,
            ulstr,
            dlkey,
            ulkey:Char40;

            fnamword:Word;
            descword:Word;
            end;


{ $I prm}  {* MAX.PRM structure *}
{$I newarea}


{* IPCxx.BBS header structure *}

Type _cstat=Record
     avail:Word;

     username:Array[0..35] of Char;
     status  :Char80;

     msgs_waiting:Word;

     next_msgofs:dword;
     new_msgofs:dword;
     end;

Type mcp_cstat=Record
     avail:Word;

     username:Array[0..35] of Char;
     status  :Char80;
     end;



{* Data element in IPCxx.BBS file (see MAX_CHAT.C) *}

Type _cdat=Record
     tid,
     atype,
     len   :Word;

     rsvd1   :dword;
     rsvd2   :word;
     end;

Type mcp_cdat=Record
     tid,
     atype,
     len   :Word;

     dest_tid:Word;
     rsvd1   :dword;
     end;

{* Handle for saving CHAT status.  Mainly used internally, but also        *
 * in RESTARxx.BBS.                                                        *}

Type _css=Record
     avail:Word;
     status:Char80;
     end;


{* NOTE: The following structure is not completely stable.  Unless         *
 * rst.rst_ver is equal to RST_VER, then the ONLY items you're guaranteed  *
 * to be able to read are those marked with "*STABLE*".  Those items       *
 * are guaranteed to be stored at those offsets for all future versions    *
 * of Maximus, regardless of the version number.  However, everything      *
 * else is likely to change at a moment's notice.                          *}

Type _restart=Record
     rst_ver:Byte; {* Version number of restart data                 *STABLE* *}

     timeon:sdword;  {* Date user got on system, seconds since 1970  *STABLE* *}
     timeoff:sdword; {* Date user must be OFF system, secs since '70 *STABLE* *}
     restart_offset:sdword; {* Offset in .BBS file to restart at     *STABLE* *}

     baud:dword;            {* User's baud rate                   *STABLE*   *}
     max_time:dword;        {* Max time, as given by '-t' param   *STABLE*   *}

     port:sdword;           {* Current COM port, 0=COM1, 1=COM2,  *STABLE*   *}

     written_echomail:Byte; {* 0=user HASN'T written echomail     *STABLE*   *}
     written_matrix:Byte;   {* 0=user HASN'T entered matrix msg   *STABLE*   *}
     local:Byte;            {* 0=NOT local                        *STABLE*   *}

     laston:_stamp;         {* Time the user was last on system   *STABLE*   *}

     steady_baud:Word;      {* Locked baud rate of user           *STABLE*   *}

     starttime:sdword;      {* Start time, for external protocol             *}
     timestart:sdword;      {* Time when MAX.EXE was started                 *}
     ultoday:sdword;        {* KB's the user has uploaded today              *}

     next_ludate:stamp_combo;

     restart_type:Byte;     {* 1 if started via .BBS file, 0 otherwise       *}
     restart_name:CharPL;   {* Name of .BBS file to restart in               *}
     menupath:CharPL;       {* The current menu path                         *}
     firstname:Array[0..35] of Char; {* The user's first name                *}
     last_onexit:CharPL;    {* The 'onexit' filename for current .BBS file   *}
     parm:CharPL;           {* Parms for external program, if any            *}
     fix_menupath:CharPL;   {* Readjust menu name                            *}

     lastmenu:Char;         {* Last ^oR menu choice                          *}
     snoop:Char;            {* If snoop is currently on or off               *}

     locked:Char;           {* If priv is locked via keyboard 'L' command    *}

     keyboard:Char;         {* If the Sysop's keyboard is turned on          *}
     protocol_letter:Char;  {* Letter representing current protocol choice   *}

     chatreq:Char;          {* If user wanted to chat with SysOp             *}
     mn_dirty:Char;         {* If menuname buf is dirty                      *}

     barricade_ok:Char;     {* If current barricade area is OK               *}
     no_zmodem:Char;        {* If zmodem not allowed                         *}

     usr_time:sword;        {* User's usr.time value                         *}
     rsvdxx1:sword;         {* reserved for future use                       *}
     lockpriv:sword;        {* If rst.locked (above), then this is real priv *}
     ctltype:sword;         {* Control-file type (for xternal protocol)      *}

     current_baud:Word;     {* User's baud rate, as a mask for mdm_baud() *}

     {* Bit flags for ECHOTOSS.LOG *}
     rsvd :Array[0..Trunc((1296/CHAR_BITS))] of Byte;
     rsvd2:Array[0..1119] of Byte; {* old area data structure *}
     css:_css;

     log_name:Char80;

     origusr:_usr;  {* User record as it was at log-on *}

     event_num:Byte;
     rsvd3    :Byte;

     last_protocol:sword;
     getoff       :Long;
     returning    :CharPL;
     steady_baud_l:Long;            {* Locked baud rate (as integer) *}
     date_newfile :SCOMBO;          {* User's last newfiles date *}
     End;


{***************************************************************************
                      Global Variables and Constant Strings
 ***************************************************************************}

Const PROTOCOL_NONE        =-1; {* Protocol to use for sending/receiving   *}
      PROTOCOL_XMODEM      =-2; {* files.  If we're using an EXTERNAL      *}
      PROTOCOL_YMODEM      =-3; {* protocol, `protocol' will have a value  *}
      PROTOCOL_XMODEM1K    =-4; {* >= 0.                                   *}
      PROTOCOL_SEALINK     =-5;
      PROTOCOL_ZMODEM      =-6;
      PROTOCOL_YMODEMG     =-7;

      EXPERT               =$02;
      REGULAR              =$04;
      NOVICE               =$06;

{End}
