
Const  MAX_SEARCH_DAT    =32;
       DMP_BUF_SIZE      =2048;

       FF_FILE     =$01; { Entry is a filename }
       FF_OFFLINE  =$02; { Entry is deleted }
       FF_DELETED  =$04; { File/comment is deleted }
       FF_COMMENT  =$08; { This is a comment (currently unused) }
       FF_NOTIME   =$10; { Don't deduct file from user's time limit }
       FF_NOBYTES  =$20; { Don't deduce file from user's DL bytes limit }
       FF_DLCTR    =$40; { Had a blank download counter }


{ Structure for FILES.IDX - each file is just a big array of these.  This  *
* is also the structure used for the master MAXFILES.IDX.                  }

type fidx=Record
  { Filename (NO TERMINATING NUL!) }
  name:Array[0..MAX_FN_LEN-1] of Char;

  { Record number in AREAS.DAT that this file area occupies }
  anum:Word;

  { Offset into FILES.DAT (number of _fdat structs) that file occupies }
  fpos:Word;
  end;



{ Structure for FILES.DAT in each file directory }

type fdat=Record
  name:Array[0..MAX_FN_LEN] of Char;    { Name of the file                 }
  struct_len:Byte;            { Length of this structure.  USE THIS!       }

  flag:Word;                  { See FF_XXXX definitions, above             }

  acs:DWord;                  { Offset to ACS in FILES.DMP                 }
  rsvd1:Word;

  times_dl:Word;              { # of times this file has been DLed         }

  fdate:stamp_combo;          { Date of actual file (creation)             }
  udate:stamp_combo;          { Date of upload (modification)              }

  fsize:DWord;                { File's size, in bytes                      }

  { Offsets in FILES.DMP }

  uploader:DWord;             { Uploader's name                            }
  desc:DWord;                 { File description (or comment if no file)   }
  path:DWord;                 { Path of file - 0 if in normal file dir     }
  pwd:DWord;                  { Password for file                          }

  rsvd:Array[1..10] of byte;              { Reserved by Maximus for future use         }
  End;

{End}
